--- 
authors:
- lucy
redirect_from: /2012/05/GIFT-report-released/
title: Technology for Transparent and Accountable Public Finance
---

In early March, we embarked on a project to map out projects which use [technology to further the aims of fiscal transparency, accountability and participation](http://openspending.org/blog/2012/03/12/technology-for-fiscal-transparency-where-next.html). Today, we are happy to announce the official release of the resulting report, Technology for Transparent and Accountable Public Finance. Preliminary findings were presented at last month's [GIFT](http://fiscaltransparency.net/) meeting in Brasilia. Since then, we've been building on the comments, follow-up questions and feedback from the session. 

Looking at government revenue, expenditure and off-budget information - we have attempted to identify projects from both governments and civil society which use innovative approaches to: 

* Publish more or better data related to fiscal processes (aid, revenues, budgets, audits, etc. -- see below),
* Help understand this data through the creation of better visualisation and data analysis tools,
* Educate citizens about fiscal processes, and assist civil society organisations promoting accountable governance,
* Facilitate direct participation in fiscal matters through participatory budgeting, citizen auditing and the like,
* Provide policymakers with complete and reliable data relevant to their work, enabling them to make better decisions.

We focussed in particular on the question: 'Who are the users?'. We examined their motivations for getting involved, the scalability and applicability of given solutions to other contexts. The report also aims to highlight gaps that prevent users from taking up these tools.

### Report now available online

Today, the first edition of the report is published on [OpenSpending.org](http://openspending.org/resources/gift/index.html). It is also available for [download as a PDF](http://content.openspending.org/resources/gift/pdf/ttapf_report_20120530.pdf). Accompanying the report is a [project database - bit.ly/TTAPF-projects ](https://bit.ly/TTAPF-projects) which contains many more projects that publish, analyse and demystify fiscal data. 

The section on participatory budgeting deserves special mention. We discovered so many projects that they merited their own listing, which can be found [here](https://docs.google.com/spreadsheet/ccc?key=0AvoV_cBqwo28dE9fZy02NEt2UGxPTnRQMTEzaUhTOGc#gid=4). As we go through, we are building up a catalog of government finance portals in [the 'finance' group of datacatalogs.org](http://datacatalogs.org/group/finance). There's still a lot of work to be done there, but the group already contains the portals mentioned in the report. 

As our work continues, we'd love to maintain these connections and hear updates from the projects and learn about new projects. If you have come across an interesting project and think we should feature it, [please let us know](mailto:gift-report@okfn.org)! 

### Key Findings

We have tried to highlight specific roles which GIFT could play in promoting the good practice requirements of the report. The slides from the session can be found below:

<div style="width:620px" id="__ss_12607771"> <strong style="display:block;margin:12px 0 4px"><a href="http://www.slideshare.net/lucyfedia/gift-presentation-12607771" title="Gift presentation" target="_blank">Gift presentation</a></strong> <iframe src="http://www.slideshare.net/slideshow/embed_code/12607771" width="620" height="517" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" allowfullscreen></iframe></div><br/>

Read about the highlights in context in the [Highlights, Gaps and Recommendations section](http://openspending.org/resources/gift/chapter1-3.html)

### Read the report

See below for a quick overview of the contents: 

* [Chapter 1 - Introduction and Methodology](http://openspending.org/resources/gift/chapter1.html)
* [Chapter 2 - Publishing Fiscal Data: Government Perspectives](http://openspending.org/resources/gift/chapter2-intro.html)
* [Chapter 3 - Using Fiscal Data: Civil Society Perspectives](http://openspending.org/resources/gift/chapter3-intro.html)
* [Chapter 4 - Standards for Fiscal Data:  Towards an international framework](http://openspending.org/resources/gift/chapter4-intro.html)
* [Chapter 5 - Case Studies - Where Does the Money Come From?](http://openspending.org/resources/gift/chapter5-intro.html)
* [Chapter 6 - Case Studies - Where Does the Money Go?](http://openspending.org/resources/gift/chapter6-intro.html)
* [Chapter 7 - Case Studies - The Invisible Money](http://openspending.org/resources/gift/chapter7-intro.html)
* [Chapter 8 - Putting the Parts Together, OpenSpending and Publish What You Fund](http://openspending.org/resources/gift/chapter8-intro.html)
* [Final Observations and Review](http://openspending.org/resources/gift/chapter9-intro.html)
* [Further Resources](http://openspending.org/resources/gift/bibliography.html)
* [Appendix](http://openspending.org/resources/gift/chapter10-intro.html)

### Get involved in the next edition

This release is version one, and we hope that the research will be ongoing as the OpenSpending community grows and the tools and network develop. As this happens, we'd really love your input. Some suggestions: 

1. Feedback - let us know what you thought of the report and suggest improvements, particularly feedback for GIFT, what role would you like to see them play in this important field? 
2. Keep your eyes peeled for interesting projects. We're hoping to feature information about new projects in the blog, so drop a line to the [mailing list](http://lists.okfn.org/mailman/listinfo/openspending) if you know of any we should feature. 
3. Help us build up the [finance group on datacatalogs.org](http://datacatalogs.org/group/finance) and review the sites for their usefulness. Ever tried to get fiscal information out of a portal? Did you get what you were after? And importantly, could you use it once you had it? Let us know [here](https://docs.google.com/spreadsheet/viewform?formkey=dGNXNVFXdDlPNlRDaXB2bXc0aGR5UVE6MQ#gid=0).

Follow up posts on the findings in detail coming soon!