--- 
authors:
- lucy
redirect_from: /2012/02/how-spending-stories-fact-checks-big-brother-the-wiretappers-ball/
title: How Spending Stories Fact Checks Big Brother, the Wiretappers' Ball
tags: 
- big brother
- Data Journalism
- pbs
- privacy international
- Spending Stories
- spending stories
- surveillance
---
**This piece was co-written with Eric King of [Privacy International](https://www.privacyinternational.org/) and comes as Privacy International launches a huge new data release about companies selling surveillance technologies. It is cross-posted on the [MediaShift PBS IDEA LAB](http://www.pbs.org/idealab/)**

Today, the global surveillance industry is estimated at around $5 billion a year. But which companies are selling? Which governments are buying? And why should we care? 

We show how the [OpenSpending platform](http://openspending.org/) can be used to speed up fact checking, showing which of these companies have government contracts, and, most interestingly, with which departments... 

## The Background

Big Brother is now indisputably big business, yet until recently the international trade in surveillance technologies remained largely under the radar of regulators and civil society. Buyers and suppliers meet, mingle and transact at secretive trade conferences around the world, and the details of their dealings are often shielded from public scrutiny by the ubiquitous defence of 'national security'. Perhaps unsurprisingly, this environment has bred a widespread disregard for ethics and a culture in which the single-minded pursuit of profit is commonplace. 

<img alt="" src="http://farm8.staticflickr.com/7179/6780224656_976bcdee9a_z.jpg" title="Big Brother Inc" class="alignnone" width="640" height="390" />

For years, European and American companies have been quietly selling surveillance equipment and software to dictatorships across the Middle East and North Africa - products that have allowed these regimes to maintain a stranglehold over free expression, smother the flames of political dissent and target individuals for arrest, torture and execution. 

They include devices that intercept mobile phone calls and text messages in real time on a mass scale, malware and spyware that gives the purchaser complete control over a target's computer and trojans that allow the camera and microphone on a laptop or mobile phone to be remotely switched on and operated. These technologies are also being bought by Western law enforcement, including small police departments in which the ability of officers to understand the legal parameters, levels of accuracy and limits of acceptability is highly questionable.  

The data that has just been released on the [Privacy International Website](https://www.privacyinternational.org/big-brother-incorporated/countries) included the following:

 1.  An updated list of companies selling surveillance technology, and
 2. Naming all the government agencies attending an international surveillance trade show known as the wiretappers ball. 

Some names are predictable enough: [the FBI](https://www.privacyinternational.org/big-brother-incorporated/countries/United%20States/US_Federal_Bureau_of_Investigation_FBI_-_OTD), the [US Drug Enforcement Administration](https://www.privacyinternational.org/big-brother-incorporated/countries/United%20States/US_Drug_Enforcement_Administration_DEA_-_ONSI), the [UK Serious Organized Crime Agency](https://www.privacyinternational.org/big-brother-incorporated/countries/United%20Kingdom/UK_Serious_Organised_Crime_Agency_SOCA_) and [Interpol](https://www.privacyinternational.org/big-brother-incorporated/countries/International/Interpol), for example. The presence of others is deeply disturbing: the national security agencies of [Bahrain](https://www.privacyinternational.org/big-brother-incorporated/countries/Bahrain/Bahrain_National_Security_Agency) and [Yemen](https://www.privacyinternational.org/big-brother-incorporated/countries/Yemen/Yemen_National_Security_Agency), the embassies of [Belarus](https://www.privacyinternational.org/big-brother-incorporated/countries/Belarus/Belarus_Embassy) and the [Democratic Republic of Congo](https://www.privacyinternational.org/big-brother-incorporated/countries/Belarus/Belarus_Embassy) and the [Kenyan intelligence agency](https://www.privacyinternational.org/big-brother-incorporated/countries/Kenya/Kenya_National_Security_Intelligence_Service), to name but a few. A few are downright baffling, like the [US department of Commerce](https://www.privacyinternational.org/big-brother-incorporated/countries/United%20States/US_Department_of_Commerce) or the [US Fish & Wildlife Service](https://www.privacyinternational.org/big-brother-incorporated/countries/United%20States/US_Fish_%2526_Wildlife_Service) and [Clark County School District Police Department](https://www.privacyinternational.org/big-brother-incorporated/countries/United%20States/Clark_County_School_District_Police_Department). 

Now, with the aid of OpenSpending, anyone can cross reference which contracts these companies hold with governments around the world. The investigation continues... 

## Using OpenSpending to speed up fact-checking

Privacy International approached the Spending Stories team to ask for a search widget to be able to search across all of the government spending datasets for contracts held between governments and these companies (until this point, it had only been possible to search one database at a time). 

The Spending Browser is now live at <http://opendatalabs.org/spendbrowser>. And, as the URLs correspond to the queries, individual searches can be passed on for further examination and, importantly, embedded in articles directly. [Try it yourself](http://openspending.org/) against the list of companies listed in [the Surveillance Section of the Privacy International Site](https://www.privacyinternational.org/big-brother-incorporated/countries) (Just enter a company e.g. 'Endace Accelerated' into the search bar). 

The Spending Browser will become increasingly more powerful as ever more data is loaded into the system. 

Want to help make this tool even more powerful? [Get involved](http://openspending.org/getinvolved) and help to build up the data bank. 

## Coverage

You can read more about the background to these stories on the Privacy International Site and recent coverage by the International Media: 

* [Privacy International investigates the sale of surveillance technology](https://www.privacyinternational.org/big-brother-incorporated)
* Guardian [Surveillance trade shows: which government agencies attend?](http://www.guardian.co.uk/news/datablog/2012/feb/07/surveillance-shows-attendees-iss-world)
* Wall Street Journal [High-Tech Surveillance Comes to Small Towns](http://blogs.wsj.com/digits/2012/02/06/high-tech-surveillance-comes-to-small-towns/?KEYWORDS=privacy)
