--- 
authors:
- lucy
redirect_from: /2012/01/civil-society-and-spending-data-who-is-mapping-the-money/
title: "Civil Society and Spending Data: Who is mapping the money?"
tags: 
- Contribute
- OSF
---
**This post is by [Lucy Chambers](http://okfn.org/members/lucychambers), Community Coordinator on the OpenSpending project at the Open Knowledge Foundation. The post is cross-posted on the [Open Knowledge Foundation blog](http://blog.okfn.org/2012/01/12/civil-society-and-spending-data-who-is-mapping-the-money/).**

We're excited to announce that, thanks to the generous support of the Open Society Foundations, OKFN's activities around financial transparency will expand to include a second pillar: next to the OpenSpending platform, we have just started a 6 month project to map the technology needs of Civil Society Organisations in relation to public spending and budget information. 

## We're going to be working on...

* **Identifying CSOs around the world who are interested in working with spending data** - building on the existing network of contacts from the OpenSpending.org project. 

* **Connecting these CSOs with each other**, with open data communities and with other key stakeholders to exchange knowledge, experiences and best practices in relation to spending data

* **Establishing how CSOs currently work with spending data**, how they would like to use it, and what they would like to achieve - including:
 	1. what existing tools are being used
	2. what current technical needs are unmet
	3. what would be required to meet these needs and how feasible is it to tackle them

* **Creating a registry of spending datasets**, from official and unofficial sources in theDataHub.org
* **A Spending Data Manual** - A wiki-like, community driven manual on acquiring, working with, publishing and archiving spending data, based on input and exchanges with CSOs we talk to.This will augment and reference existing publications from numerous organisations as well as channelling the results of our research into two areas:
 * **A section to help CSO’s clarify their demands towards governments:** e.g. guidance on open licensing and structured data formats, applicable for spending data. 
 * **A section focused on best practice for CSOs when using and reusing spending data:** for example collaborative processes such as data-sharing.
&nbsp;
* **Running Spending Analysis Sessions with CSOs**, both in person and virtually. We’re interested in learning from about what data people are trying to acquire / having difficulty in doing so, how they plan to use the data to further their mission and learning what barriers, legal, technical and otherwise could be removed to make their jobs easier. 


* **Getting Spending Data from numerous countries loaded into OpenSpending.org** - with the support of CSOs, OKFN developers, and volunteers from the open data community. We we're interested in are using the OpenSpending.org tools, and collect input from them on how these could be improved to meet their needs. 

<img alt="" src="http://farm7.staticflickr.com/6166/6270108254_5875c8a7ed_z.jpg" title="Kaitlin Lee talking at Open Government Data Camp" class="alignnone" width="640" height="426" />

## Vision: Improved Spending Data Literacy, Sharing and Re-use amongst CSOs around the world

We are very keen to help more groups and individuals around the world to use and work with spending data more effectively to do the things they care about - whether this is investigative journalism, evidence based policy-making, political campaigning, budgeting or creating new useful applications and services.

In particular, we would like to document and spread best practices in the legal and technical aspects of reusing public information, and enabling re-use and better collaboration around this material. 

### Ultimately we would like to:
* **Build stronger, broader communities** of groups and individuals who work together to acquire, use, and openly share spending data
* **Increase ‘literacy’ around spending data** - enabling more CSOs to understand and work with large and complex spending datasets to help them to pursue their objectives
* **Encourage more CSOs to publish datasets which they acquire**, use or create in machine readable formats, under open licenses, to avoid duplication of effort and enable CSOs to build on each others’ work, to harness external expertise more effectively and to facilitate stronger collaboration between different organisations who are interested in spending information

## How can I get involved? 

* **Join the Working Group on Spending Data**. The working group will bring together data experts and CSOs who will help to weave a community of best practice around spending data, collect and provide feedback on material for the manual and help to develop the network of those collaborating around and sharing spending data. More details about the working group can be found on this [wiki page](http://wiki.openspending.org/Working_Group).  

* **Write for the [Spending Data Blog](http://blog.openspending.org)** - we're interested in posts by and about CSOs who work with spending data, observations on the current status quo on releasing data in your area. Anything from short comment pieces to full proposals for what could be done, legal, technical or otherwise, to improve the situation in the sphere where you work. Contact details as above. 

**If you would like to get started, or know of organisations we should extend the invitation to: drop us an email via the [mailing list](http://lists.okfn.org/mailman/listinfo/openspending) or contact me directly via info [at] openspending.org. **
