---
section: about
lead: true
title: Steering Group
redirect_from:
  - "/about/governance/members-of-the-steering-group/index.html"
  - "/about/governance/members-of-the-steering-group/"
---

The steering group oversees the project and represents its major stakeholders. This group takes responsibility for maintaining the integrity of the project, setting project policies, representing the project in relation to third parties etc.

The steering group's specific responsibilities include:

* **Finances**: overseeing and managing (where relevant) any project finances and resources.
* **Branding**. Overseeing Twitter account, website, etc.
* **Recognition** of satellite sites as part of the OpenSpending community and use of the OpenSpending name.
* **Partnerships** and collaborations with other communities and projects.
* **Setting policy** for data licensing and other matters, as necessary.
* **Advocacy guidelines**, as appropriate.
* **Legal matters**: for example, removal of datasets

## Meetings

The Steering Group meets approximately once a quarter via an online conference call.

The [living minutes of the OpenSpending Steering Group are online](https://docs.google.com/a/okfn.org/document/d/1jCB-RquGYeW9mm466ViucMRjggbCxa0pGZDH5JThcRc/edit).

## Appointment of the Steering Group

Anyone who has contributed to the OpenSpending project (whether in code, data, or content) may put themselves forward for membership in the steering group. The existing steering group members will consider the application and decide whether or not to accept. In the future, once the concept of OpenSpending membership is better established, this decision may be made by a vote among OpenSpending members.

Membership in the steering group is for a term of two years. Multiple consecutive terms are permitted. If members resign during their two-year term, nominations for a replacement will be solicited from the community.

## Members

### Anna Alberts, Open Knowledge Germany, Chair

Based in Berlin, Anna Alberts works as a Project Manager for the EU
research project OpenBudgets.eu at Open Knowledge Foundation Germany.

Anna studied International Development and International Relations,
and worked as a policy officer for the Strategy Unit at the Ministry
of Foreign Affairs in the Netherlands, focusing on geopolitics and
(open) data.

### Justin Arenstein, International Center for Journalists
{: .person-name}

![Justin Arenstein](http://www.icfj.org/sites/default/files/imagecache/medium/JustinWebsite_0.JPG)
{: .person-photo}

Justin Arenstein is a Knight International Journalism Fellow who is
helping the African Media Initiative (AMI) to establish a digital
innovation program that supports experimentation in newsrooms across
Africa. AMI, the continent's largest association of media owners and
executives, is working with more than 600 of the most influential
media companies in both northern and sub-Saharan Africa.

### Júlia Keserű, Sunlight Foundation
{: .person-name}

Júlia Keserű is the International Policy Manager at the Sunlight
Foundation and oversees its international work. Coming from the
Hungarian transparency community, Júlia has been an advocate for open
government and an expert on open data issues with a special focus on
political finance and corruption. She has spoken internationally on
technology and transparency and regularly writes about the challenges
and the potential of the global open government movement. Júlia holds
a Masters degree from International Studies and studied political
sciences, international law, sociology and philosophy at Corvinus
University Budapest, Free University Berlin and the College for Social
Theories in Budapest.

### Elena Mondo, International Budget Partnership
{: .person-name}

![Elena Mondo, IBP]({{ site.baseurl }}/img/blog/2014/04/Elena-pic-223x300.jpg)
{: .person-photo}

Elena joined the International Budget Partnership (IBP) in 2007. She
manages the Open Budget Survey, the only independent, comparative, and
regular measure of budget transparency and accountability around the
world. Prior to joining the IBP, she worked as a consultant for the
Organization for Economic Cooperation and Development (OECD),
coordinating research on budget practices and procedures in the OECD
and Latin American countries. Mondo holds a BA in international
economics and management from Bocconi University, and an MPA in public
and economic policy from the London School of Economics.

### Oluseun Onigbinde, BudgIT
{: .person-name}

![Oluseun Onigbinde](http://under40preneur.com/wp-content/uploads/2013/02/Seun-Onigbinde.jpg)
{: .person-photo}

Oluseun Onigbinde is the Co-Founder of BudgIT, a Nigerian public data
visualisation startup. He is an Ashoka Fellow and Open Knowledge
Ambassador for Nigeria.

### Anders Pedersen, Natural Resource Governance Institute
{: .person-name}

Anders Pedersen is Open Data Program Officer at the Natural Resource Governance
Institute. He holds an MA degree in Political Science from University of
Copenhagen, and has worked in development and financial data journalism.

### Federico Ramírez, Fundar
{: .person-name}

[bio coming here]

### Adam Stiles, Open Budget Oakland
{: .person-name}

Adam is co-creator of <a
href="http://openbudgetoakland.org/">openbudgetoakland.org</a> and a
member of the City of Oakland's budget advisory committee. He's also a
news editor, builder, and outdoor preschool founder.

### Mark Brough, Publish What You Fund
{: .person-name}

### Cecile Le Guen, Open Knowledge
{: .person-name}

Cecile Le Guen is Project Manager at Open Knowledge, involved in different fiscal open data projects.
