---
section: about
lead: true
title: 'OpenSpending: first steps'
authors:
- Neil Ashton
redirect_from:
- "/openspending-first-steps"
---
<section class="slide shout">
<div>
<h2>Welcome to OpenSpending</h2>
</div>
</section>
<div id="content">
<section class="slide osimage">
<div class="well">
<div class="row-fluid">
<div class="span4">
<a title="00-visualize by okfn, on Flickr" href="http://openspending.org/datasets/new"><img src="//farm4.staticflickr.com/3669/9575045401_5a752545b0_n.jpg" class="img-rounded" alt="00-visualize"/></a>
</div>
<div class="span8">
<h2>Upload and visualize data</h2>
<a href="http://openspending.org/datasets/new">Upload</a> any kind of financial data to OpenSpending and explore it with our built-in interactive visualizations. Users publish <a href="http://openspending.org/budgetmarocain">budgets</a>, <a href="http://openspending.org/marches-publics-senegal/views/liste-des-attributaires">procurements</a>, <a href="http://openspending.org/ukgov-25k-spending">spending data</a> and even <a href="http://openspending.org/senadofederal/entries">public employee salaries</a>.

Use our <a href="http://www.pbs.org/idealab/2013/03/how-to-embed-open-spending-visualizations-in-your-own-website078">widgets</a> to embed your visualization on your own website.

<a href="http://openspending.org/datasets/new" class="btn btn-success btn-large" title="Create a dataset">Upload a dataset</a>

</div>
</div>
</div>
</section>
<section class="slide osimage">
<div class="well">
<div class="row-fluid">
<div class="span4">
<a title="01-explore by okfn, on Flickr" href="http://openspending.org/search"><img src="//farm4.staticflickr.com/3670/9575044337_71d0e520ae_n.jpg" class="img-rounded" alt="01-explore"/></a>
</div>
<div class="span8">
<h2>Explore the database</h2>
OpenSpending holds nearly 16 mio. transactions from more than 300 datasets across more than 70 countries.

Browse the <a href="http://openspending.org/datasets">list of datasets</a> and learn about public finances from around the world, or browse <a href="http://apps.openspending.org/maps/">our map of cities</a> on OpenSpending.

<a href="http://openspending.org/search" class="btn btn-success btn-large" title="Search the datasets">Search transactions</a> <small>or <a href="http://openspending.org/datasets/" title="List of datasets">look at the datasets</a></small>

</div>
</div>
</div>
</section>
<section class="slide osimage">
<div class="well">
<div class="row-fluid">
<div class="span4">
<a title="02-extend by okfn, on Flickr" href="http://blog.openspending.org/help/api/"><img src="//farm6.staticflickr.com/5549/9577836924_378752d5f3_n.jpg" class="img-rounded" alt="02-extend"/></a>
</div>
<div class="span8">
<h2>Create your own dataviz with our API</h2>
Create your own visualizations with the <a href="http://blog.openspending.org/help/api/aggregate/">OpenSpending API</a> using libraries like <a href="http://blog.openspending.org/2013/08/20/okfb-inesc/">D3.js</a>, jit and Raphael.

You can even create a satellite site while still using OpenSpending as a backend.

<a href="http://blog.openspending.org/help/api/" class="btn btn-success btn-large" title="API documentation">Look at the API</a>

</div>
</div>
</div>
</section>
<section class="slide osimage">
<div class="well">
<div class="row-fluid">
<div class="span4">
<a title="03-community by okfn, on Flickr" href="http://blog.openspending.org/get-involved/community/"><img src="//farm6.staticflickr.com/5475/9575044189_f4de292c78_n.jpg" class="img-rounded" alt="03-community"/></a>
</div>
<div class="span8">
<h2>Join the community!</h2>
OpenSpending is <a href="https://github.com/openspending">open source software</a> built and run by a community of volunteers.

<a href="http://lists.okfn.org/mailman/listinfo/openspending">Join our mailing list</a> and share what you are creating with OpenSpending!

<a href="http://blog.openspending.org/get-involved/community/" class="btn btn-success" title="Community introduction">Join the spending community</a> <small>or</small> <a href="http://openspending.org/help/hacking.html" class="btn btn-success" title="Howto hack">Become a developer</a>

</div>
</div>
</div>
</section>
</div>
<style>
    .osimage img {
      width: 100%;
      margin: auto auto auto auto;
    }
    .row-fluid .span4 {
       display:inline-block;
       width: 31.914893614%;
    }
    .row-fluid .span8 {
       display:inline-block;
       width: 65.95744680199999%;
    }
</style>
