---
title: The Fiscal Data Package
redirect_from:
  - "/about/governance/"
---

The Fiscal Data Package is a lightweight and user-oriented format for publishing and consuming fiscal data. Fiscal data packages are made of simple and universal components. They can be produced from ordinary spreadsheet software and used in any environment.

The motivation behind the fiscal data package was to create a specification which is open by nature - based on other open standards, supported by open tools and software, modular, extensible and promoted transparently by a large community.

It is designed to be simple to use - providing a small but flexible set of features, based on real-world requirements and not theoretical ones. All the while, the built-in extensibility allows this spec to adapt to many different use cases and domains. It is also possible to gradually use more and more part of this specification - thus making it easier to implement this spec with existing data while slowly improving the data quality.

A main concern of this specification is the ability to work with data as it is currently exists, without forcing publishers to modify the contents or structure of their current data files in order to "adapt" them to the specification.

#### The Open Fiscal Data Package serves two main purposes:
Standardizing the structure and the content of fiscal data so that tools and services can be built over it for visualization, analysis or comparison;
Driving data quality by providing a solid framework of publication.

So the Open Fiscal Data Package specifies the form for fiscal data and offers a standardized framework for the content.

- Read the [Fiscal Data Package specification](https://frictionlessdata.io/specs/fiscal-data-package/) on the Frictionless Data website
- Meet the [OpenSpending tools](/about/tools)
- Read about 
