---
section: about
lead: true
title: Frequently Asked Questions
authors:
- Neil Ashton
---
#### What is OpenSpending?

OpenSpending is about Mapping the Money.

The aim is to help track every (public) government and corporate financial transaction across the world and present it in useful and engaging forms for everyone from a schoolchild to a data geek.

What [OpenStreetMap](http://www.openstreetmap.org/) does for geography, OpenSpending does for money. OpenStreetMap has mapped the world in unprecedented levels of detail, harnessing the power of thousands of volunteers who each contribute data for their little corner of the world. However, as far as we know, there is no 'global atlas' of spending, no integrated, searchable database which would be a valuable resource for policy-makers and civil society alike. We want anyone to be able to go to their local council or national government, request the data, upload, understand and visualize it and contribute to this 'spending commons', which anyone can benefit from.

#### What is the relationship to Where Does My Money Go?

Simply put, OpenSpending is the international version of [Where Does My Money Go?](http://wheredoesmymoneygo.org/) (WDMMG). WDMMG used interactive 'bubble trees' to show the UK Taxpayer which spending sectors their tax money is put towards as well as having an interactive tax calculator to let users see for their level of income, how much they contribute to various spending areas through their taxes.

##### Platform vs. project

After the success of [the original project](http://jonathangray.org/2007/04/02/where-does-my-money-go-project-proposal/), it became clear that there was need for an international platform to allow people to build such sites at scale. Where Does My Money Go? was remodelled to become an instance of OpenSpending: the data is stored in the central OpenSpending database, and a custom frontend was developed using the OpenSpending API. Anyone can create one just like it, with their own branding at their own URL.

#### Can anyone contribute?

Yes!  Whether you are interested in international, national or local data, you can contribute, work with and visualize it. See [How can I get involved?](../../help/development/volunteer) for the various ways you can get involved.

#### How can I get involved?

The team has worked hard to make it possible to load and visualize your own data, translate the software and even build your own custom front-end sites like [Where Does My Money Go?](http://wheredoesmymoneygo.org/)

Whether you are technical or non-technical, whether your aims are advocacy, journalism, better policy-making or just making pretty bubbles to help people understand your country's budget, there are plenty of ways to get involved. And don't be shy - if you spot a way to get involved that we haven't thought of, please don't hesitate to let us know.

See the [get involved](../../help/development/volunteer) page for more information.

#### What kind of language support do you offer?

We currently provide language versions of the OpenSpending platform in Greek, Indonesian and Italian. We expect to enable French as well as other languages in the near future.
You can help translate OpenSpending into another language at our [Transifex page](https://www.transifex.com/projects/p/openspending/).

#### How are you funded?

OpenSpending is a community-run project, but it would not be able to exist without the generous support of many organizations. See [this page](../funders/) for more information.
