---
section: about
lead: true
title: Contributors
authors:
- Anders Pedersen
---

There are many contributors to OpenSpending. There are thousands of registered OpenSpending users contributing data and analysis.

It is impossible to adequately acknowledge the many individuals and organizations who have contributed.

This page then is necessarily partial and is focused (though not limited to) those who have made special efforts to contribute through their participation in specific teams, in donating data or in other significant ways.

If you'd like to be added as a contributor to this page please [get in touch]({{ site.baseurl }}/about/contact/).

## Teams

### News and Website Team

#### News Editors - Descriptions

These guys run the blog and manage our social media presence. We are
still recruiting News Editor volunteers so if you'd like to join the
team <a
href="http://community.openspending.org/contribute/web/#Sign_up">apply
here</a>.

<strong>Burite Joseph</strong>, <a href="https://twitter.com/BuriteJoseph">@BuriteJoseph</a>

Independent media practitioner and entrepreneur with over five years
of journalism and research experience, Burite runs ZHENOBIA, a media
integration and multimedia content aggregation company. She also
consults for <a href="http://www.smsmedia.ug">SMS Media Uganda</a>,
Ultimate Media Uganda, <a href="http://www.busiweek.com">East African
Business Week</a> and <a href="http://www.dailymonitor.co.ug">Daily
Monitor</a>.

<blockquote>
Working with data is my new passion. I am a quick learner and teamwork is my steroid.
</blockquote>

<strong>Anna Flagg</strong>, <a href="http://www.annaflagg.com">www.annaflagg.com</a>

Data journalist at the Center for Responsive Politics, Anna has a background in computer science, data visualization, design and data-storytelling.

<blockquote>
I like working on projects that create awareness of issues important to the public. I'm excited to work with and learn from the Open Spending community.

</blockquote>
<strong>Laura S. García</strong>,<a href="https://twitter.com/Laura_S_Garcia">@laura_s_garcia</a>

An experienced journalist, Laura has worked for more than ten years as a multi-media journalist in Spain. She has also taught Geography and History to high-school students. Laura speaks Spanish, Galician, English and a little Swedish.

<blockquote>
I’m looking to improve my knowledge of open data, as I’ve always thought this to be the best way to offer a good journalism and a good education as well.

</blockquote>
<strong>Karen Brzezinska</strong>, <a href="https://twitter.com/westofwarsaw">@westofwarsaw</a>

Also a professional journalist, Karen (Kati) worked for international news services specialising in equity, commodity and currency markets. Her background is in PoliSci (East European studies), and, while originally from midwestern US, her life experience lists Italy, Hungary (1989-1992) and The Netherlands (since 1992) as home-countries. Kati is fluent in English (US) and Dutch.

<blockquote>
I'm interested in learning how open data can be used to enhance governance and education.

</blockquote>
<strong>Dominic Kornu</strong>, <a href="https://twitter.com/Qaphui">@qaphui</a>

An IT and Maths tutor from Ghana, with an interest in web and social media technologies, Dominic blogs at <a href="http://dominicmary.blogspot.com">Qaphui’s Cafe</a> and volunteers in his free time.

<blockquote>
I am interested in learning how open data can be used to enhance governance and education.

</blockquote>
<strong>Mehmet Koksal</strong>, <a href="https://twitter.com/mehmetkoksal">@mehmetkoksal</a>

Freelance journalist based in Brussels (Belgium) and conference interpreter, Mehmet also works as a fixer for the international press, including the French weekly <a href="http://www.courrierinternational.com/">Courrier int.</a>. In his free time he volunteers for <a href="http://www.ajp.be/">AJP</a> and acts as a campaign manager for the <a href="http://europe.ifj.org/en/pages/turkey-campaign-set-journalists-free">EFJ</a>.

<strong>Teodora Beleaga</strong>, <a href="https://twitter.com/t30d0ra">@t30d0ra</a>

A digital analyst and freelance data journalist based in London, <a href="http://teodorabeleaga.com">Teodora </a>is an alumna of City University’s Interactive Journalism MA and has completed work experience with <a href="http://www.theguardian.com/profile/teodora-beleaga">The Guardian</a>.

<blockquote>
I joined the Open Spending project to share my data analysis skills and expand my understanding of fiscal transparency and government spending.

</blockquote>
<strong>Miriam Ruhenstroth</strong>

A Science and technology freelance journalist based in Berlin (Germany), Miriam has a background in biological sciences. In 2011 she attended a summer school for data journalism (organized by Initiative Wissenschaftsjournalismus).

<blockquote>
I found the field of data storytelling thrilling and joined OpenSpending, to learn more about it and participate for good.

</blockquote>

### Data Team


#### Data Wranglers - Descriptions

The Data Wranglers work to add, clean and visualise data in OpenSpending. They help community members who need assistance. Some data wranglers focus on cleaning and analysing data whereas others work to visualise data using the OpenSpending API. We are still recruiting Data Wrangler volunteers so if you'd like to join the team <a href="http://community.openspending.org/contribute/data/#Official_sign_up">apply here</a>.

<strong>Concha Catalan</strong>, <a href="https://twitter.com/conchacatalan">@conchacatalan</a>

An English teacher and freelance journalist based in Barcelona (Spain), Concha is currently working on a project to open the autonomous government of Catalonia (opengov.cat). She also blogs at <a href="http://barcelonalittleshell.blogspot.com.es">http://barcelonalittleshell.blogspot.com.es</a>.

<blockquote>
I would like to add the data set of the autonomous government of Catalonia budget to OpenSpending. I am coming to terms with lots of new concepts.

</blockquote>
<strong>Prakash Neupane</strong>, <a href="https://twitter.com/nprkshn">@nprkshn</a>

OKFN Ambassador in Nepal and FOSS Enthusiastic, Prakash is working in social development empowering individuals and communities by using technology. He is an Open Data Researcher and Nepali Wikimedian, responsible for Wikimedia Education Program in Nepal. Find out more  about him <a href="http://www.prakashneupane.com.np/about-me">here</a>.

<strong>Pierre Chrzanowski</strong>, @piezanowski

A member of the French OKFN working in the field of Open Government Data, Pierre says he is really interested to work on Tax Heaven, Public Procurement and Aid Data.

<blockquote>
I want to learn more about tools to analyse the data sets and how best to do storytelling.

</blockquote>
<strong>Samuel S. Lee</strong>, <a href="https://twitter.com/OpenNotion">@OpenNotion</a>

Currently based in Washington DC, Samuel is a member of the <a href="https://finances.worldbank.org">World Bank Group Open Finances</a> team. He loves data, innovation, transparency, photography and college football.

<blockquote>
I am passionate about “open” and its potential to transform civic engagement, international development, and the world. I am particularly interested in realizing the potential of open financial information.

</blockquote>
<strong>Adriana Homolova</strong>

A data journalism student with a passion for open culture, Adriana is a member of the <a href="http://soit.sk">Society for Open Information Technologies</a>.

<strong>Sipos Zoltán</strong>

A Hungarian journalist working for an Internet news portal in Romania, Sipos specializes in investigative reporting.  His background includes philosophy, sociology and public policies. Sipos has experience working with data, filing FOI requests, and tackling spreadsheets.

<blockquote>
I am trying to learn as much as I can about data journalism through online groups, MOOCs and books purchased from Amazon. My ultimate goal is to set up a small investigative / data journalism start-up in Romania.
</blockquote>

<strong>Gabe Sawhney</strong>

A member of <a href="http://betterbudget.ca">Better Budget
Toronto</a> Gabe joined the Team to bring transparency to his
city’s <a
href="http://spacing.ca/toronto/2012/12/10/lorinc-building-a-better-budget-at-city-hall/">budget</a>.

<blockquote>
I want to mobilize action (citizens, elected officials and policymakers) for better process, better clarity, better formats, and more transparency around city budgets.
</blockquote>

<strong>Elaine Ayo</strong>, <a href="https://twitter.com/eieayo">@eieayo</a>

Statistician student based in Washington, DC Elaine has spent the last
three years in Seoul, South Korea as a copy editor for an English news
wire. Prior to that Elaine reported for her hometown paper, the San
Antonio Express-News, in Texas.

<strong>Hans Loos</strong>

An IT and telecom freelance journalist based in Belgium, Hans studied
sociology and has a passion for statistics.

<blockquote>
I have started to learn to program and study R but without big results up till now.
</blockquote>

## Data Donors

In progress ...
