<p align="center">
  Bugs, issues and suggestions re PortalJS framework
  <br />
  <br /><a href="https://discord.gg/xfFDMPU9dC"><img src="https://dcbadge.vercel.app/api/server/xfFDMPU9dC" /></a>
</p>

## PortalJS framework

This repo and issue tracker are for

- PortalJS 🌀 - https://www.portaljs.com/
- DataHub Cloud ☁️ - https://datahub.io/

### Issues

Found a bug: 👉 https://github.com/datopian/portaljs/issues/new

### Discussions

Got a suggestion, a question, want some support or just want to shoot the breeze 🙂

Head to the discussion forum: 👉 https://github.com/datopian/portaljs/discussions

### Chat on Discord

If you would prefer to get help via live chat check out our discord 👉

[Discord](https://discord.gg/xfFDMPU9dC)

### Docs

- For PortalJS go to https://www.portaljs.com/opensource
- For DataHub Cloud – https://datahub.io/docs

## PortalJS Cloud 🌀

PortalJS Cloud 🌀 is a platform for rapidly creating rich data portal and publishing systems using a modern frontend approach. PortalJS Cloud can be used to publish a single dataset or build a full-scale data catalog/portal.

PortalJS Cloud is built in JavaScript and React on top of the popular [Next.js](https://nextjs.org) framework. PortalJS Cloud assumes a "decoupled" approach where the frontend is a separate service from the backend and interacts with backend(s) via an API. It can be used with any backend and has out of the box support for [CKAN](https://ckan.org/), GitHub, Frictionless Data Packages and more.

### Features

- 🗺️ Unified sites: present data and content in one seamless site, pulling datasets from a DMS (e.g. CKAN) and content from a CMS (e.g. Wordpress) with a common internal API.
- 👩‍💻 Developer friendly: built with familiar frontend tech (JavaScript, React, Next.js).
- 🔋 Batteries included: full set of portal components out of the box e.g. catalog search, dataset showcase, blog, etc.
- 🎨 Easy to theme and customize: installable themes, use standard CSS and React+CSS tooling. Add new routes quickly.
- 🧱 Extensible: quickly extend and develop/import your own React components
- 📝 Well documented: full set of documentation plus the documentation of Next.js.

### For developers

- 🏗 Build with modern, familiar frontend tech such as JavaScript and React.
- 🚀 Next.js framework: so everything in Next.js for free: Server Side Rendering, Static Site Generation, huge number of examples and integrations, etc.
  - Server Side Rendering (SSR) => Unlimited number of pages, SEO and more whilst still using React.
  - Static Site Generation (SSG) => Ultra-simple deployment, great performance, great lighthouse scores and more (good for small sites)
