# Parma

**Parma** is a city in the northern Italian region of Emilia-Romagna famous for its architecture, music, art, prosciutto (ham), cheese and surrounding countryside. It is home to the University of Parma, one of the oldest universities in the world. Parma is divided into two parts by the stream of the same name. The district on the far side of the river is *Oltretorrente*. Parma's Etruscan name was adapted by Romans to describe the round shield called *Parma*.

![Parma][image-1]

The Italian poet Attilio Bertolucci (born in a hamlet in the countryside) wrote: "As a capital city it had to have a river. As a little capital it received a stream, which is often dry".

**Contents**
1. Culture
    1. Food and cuisine
    1. People
        1. Painters and sculptors
        1. Others

## Culture
### Food and cuisine
Parma is famous for its food and rich gastronomical tradition: two of its specialties are Parmigiano Reggiano cheese (also produced in Reggio Emilia), and Prosciutto di Parma (Parma ham), both given Protected Designation of Origin status. Parma also claims several stuffed pasta dishes like "tortelli d'erbetta" and "anolini in brodo".

![Parma Night][image-2]

### People
* **Painters and sculptors**
	* **Michelangelo Anselmi**, painter born in Tuscany
	* **Benedetto Antelami**, architect and sculptor
	* **Alessandro Araldi**, painter
	* **Sisto Badalocchio**, painter
	* **Jacopo Bertoia** (Giacomo Zanguidi or Jacopo Zanguidi or Bertoja), painter
	* **Amedeo Bocchi**, painter
	* **Giulio Carmignani**, painter
	* **Antonio da Correggio** (Antonio Allegri), born in Correggio (Reggio Emilia), painter
	* **Francesco Marmitta**, painter
	* **Filippo Mazzola**, painter
	* **Francesco Mazzola**, best known as Il Parmigianino, painter
	* **Girolamo Mazzola Bedoli**, painter
	* **Giovanni Maria Francesco Rondani**, painter
	* **Bartolomeo Schedoni**, painter
* **Others**
	* **Vittorio Adorni**, cyclist
	* **Giovanni Amighetti**, composer, musician
	* **Amoretti Brothers**, typographers and typefounders, Bodoni's opponents
	* **Giambattista Bodoni**, typographer

# Giambattista Bodoni
**Giambattista Bodoni** was an Italian typographer, type-designer, compositor, printer and publisher in **Parma**.
![Giambattista Bodoni by Giuseppe Lucatelli][image-3]
He first took the type-designs of Pierre Simon Fournier as his exemplars, but afterwards became an admirer of the more modelled types of **John Baskerville**; and he and Firmin Didot evolved a style of type called "Modern," in which the letters are cut in such a way as to produce a strong contrast between the thick and thin parts of their body. Bodoni designed many typefaces, each one in a large range of type sizes. He is even more admired as a compositor than as a type designer, as the large range of sizes which he cut enabled him to compose his pages with the greatest possible subtlety of spacing. Like Baskerville, he sets off his texts with wide margins and uses little or no illustrations or decorations.
![Quosque Tandem][image-4]
There have been several modern revivals of his typefaces, all called *Bodoni*. They are often used as display faces.

# Bodoni
**Bodoni** is the name given to the serif typefaces first designed by **Giambattista Bodoni** (1740–1813) in the late eighteenth century and frequently revived since. Bodoni's typefaces are classified as **Didone** or **modern**. Bodoni followed the ideas of John Baskerville, as found in the printing type **Baskerville**—increased stroke contrast reflecting developing printing technology and a more vertical axis—but he took them to a more extreme conclusion. Bodoni had a long career and his designs changed and varied, ending with a typeface of a slightly condensed underlying structure with flat, unbracketed serifs, extreme contrast between thick and thin strokes, and an overall geometric construction.
![ITCBodoni][image-5]
Some digital versions of Bodoni are said to be hard to read due to "dazzle" caused by the alternating thick and thin strokes, particularly as the thin strokes are very thin at small point sizes. This is very common when optical sizes of font intended for use at display sizes are printed at text size, at which point the hairline strokes can recede to being hard to see. Versions of Bodoni that are intended to be used at text size are "Bodoni Old Face", optimized for 9 points; ITC Bodoni 12 (for 12 points); and ITC Bodoni 6 (for 6 points).
![Bodoni vita nuova facsimile sepia][image-6]
Massimo Vignelli stated that "Bodoni is one of the most elegant typefaces ever designed." In the English-speaking world, "modern" serif designs like Bodoni are most commonly used in headings and display uses and in upmarket magazine printing, which is often done on high-gloss paper that retains and sets off the crisp detail of the fine strokes. In Europe, they are more often used in body text.

## Foundry type revivals and variants
There have been many revivals of the Bodoni typeface; ATF Bodoni and Bauer Bodoni are two of the more successful.
* **ATF's** Bodoni series created in 1909, was the first American release to be a direct revival of Bodoni's work. All variants were designed by Morris Fuller Benton who captured the flavour of Bodoni's original while emphasizing legibility rather than trying to push against the limits of printing technology. This revival is regarded as "the first accurate revival of a historical face for general printing and design applications". However, some details were less based on Bodoni than on the work of his French contemporary Firmin Didot, for example a 't' with a flat rather than slanted top.
	* _Bodoni_ (1909)
	* _Bodoni Italic_ (1910)
	* _Bodoni Book_ (1910)
	* _Bodoni Book Italic_ (1911)
	* _Bodoni Bold + Italic_ (1911)
	* _Bodoni Bold Shaded_ (1912)
	* _Bodoni Shaded Initials_ (1914)
	* _Card Bodoni_ (1915)
	* _Card Bodoni Bold_ (1917)
	* _Bodoni Open_ (1918)
	* _Bodoni Book Expanded_ (1924)
	* _Ultra Bodoni + italic_ (1928)
	* _Bodoni Bold Condensed_ (1933)
	* _Ultra Bodoni Condensed + extra condensed_ (1933)
	* _Engravers Bodoni_ (1933), designed in 1926.
* **Monotype**:
	* _Bodoni #175 + italic_ (1911)
	* _Bodoni #375 + italic_ (1930), based on the Benton version.
	* _Recut Bodoni Bold + italic_
	* _Bodoni Bold Condensed_ (Sol Hess, 1934)
* **Ludlow**:
	* _Bodoni Light + italic_ (Robert Wiebking, 1923)
	* _True-Cut Bodoni + italic_ (Wiebking, 1923), based on actual specimens at the Newberry Library.
	* _Bodoni Bold + italic_ (Wiebking, 1930)
	* _Bodoni Modern + italic_ (R. Hunter Middleton, 1936), probably the most faithful recutting.
* **Damon Type Foundry** offered a Bodoni under the name _Bartlet_.
* **Linotype** and **Intertype** also produced matrices for machine composition that were somewhat narrower than the foundry type versions.
* **Haas Type Foundry** produced a version which was then licensed to D. Stempel AG, Amsterdam Type Foundry, and Berthold.[26]()
* The **Bauer Type Foundry** version was drawn by Heinrich Jost in 1926. The Bauer version emphasizes the extreme contrast between hairline and main stroke. The series included the following weights:
	* _Bodoni Roman_
	* _Bodoni Title_
	* _Bodoni Bold_
	* _Bodoni Italic_
	* _Bodoni Italic Bold_



[image-1]:	https://upload.wikimedia.org/wikipedia/commons/thumb/c/ce/Parma-pjt7.jpg/1920px-Parma-pjt7.jpg
[image-2]:	https://upload.wikimedia.org/wikipedia/commons/thumb/d/d0/09_Parma_night%2C_Italy_-_%E3%82%A4%E3%82%BF%E3%83%AA%E3%82%A2%E3%81%AE%E3%82%AB%E3%83%95%E3%82%A7.jpg/764px-09_Parma_night%2C_Italy_-_%E3%82%A4%E3%82%BF%E3%83%AA%E3%82%A2%E3%81%AE%E3%82%AB%E3%83%95%E3%82%A7.jpg
[image-3]:	https://upload.wikimedia.org/wikipedia/commons/5/55/Giambattista_Bodoni_by_Giuseppe_Lucatelli.jpg
[image-4]:	https://upload.wikimedia.org/wikipedia/commons/thumb/4/4f/Quosque_tandem.jpg/800px-Quosque_tandem.jpg
[image-5]:	https://upload.wikimedia.org/wikipedia/commons/a/a0/ITCBodoni.png
[image-6]:	https://upload.wikimedia.org/wikipedia/en/thumb/2/2b/Bodoni_vita_nuova_facsimile_sepia.png/1920px-Bodoni_vita_nuova_facsimile_sepia.png
