import 'package:dart_code_metrics/src/analyzers/lint_analyzer/models/severity.dart';
import 'package:dart_code_metrics/src/analyzers/lint_analyzer/rules/rules_list/prefer_first/prefer_first_rule.dart';
import 'package:test/test.dart';

import '../../../../../helpers/rule_test_helper.dart';

const _examplePath = 'prefer_first/examples/example.dart';

void main() {
  group(
    'PreferFirstRule',
    () {
      test('initialization', () async {
        final unit = await RuleTestHelper.resolveFromFile(_examplePath);
        final issues = PreferFirstRule().check(unit);

        RuleTestHelper.verifyInitialization(
          issues: issues,
          ruleId: 'prefer-first',
          severity: Severity.style,
        );
      });

      test('reports about found issues', () async {
        final unit = await RuleTestHelper.resolveFromFile(_examplePath);
        final issues = PreferFirstRule().check(unit);

        RuleTestHelper.verifyIssues(
          issues: issues,
          startLines: [
            11,
            16,
            24,
            25,
            31,
            34,
            39,
            44,
            51,
            56,
            65,
            70,
            78,
            83,
            91,
            96,
            104,
            109,
            117,
            122,
            130,
            135,
            144,
            145,
            152,
            155,
            164,
            169,
          ],
          startColumns: [
            34,
            5,
            31,
            31,
            5,
            5,
            9,
            5,
            29,
            5,
            7,
            5,
            33,
            5,
            39,
            5,
            35,
            5,
            31,
            5,
            38,
            5,
            7,
            47,
            5,
            5,
            7,
            5,
          ],
          messages: [
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
            'Use first instead of accessing the element at zero index.',
          ],
          replacementComments: [
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
            "Replace with 'first'.",
          ],
          replacements: [
            'iterable.first',
            '..first',
            'list.first',
            'list.first',
            '..first',
            '..first',
            '..first',
            '..first',
            'set.first',
            '..first',
            'doubleLinkedQueue.first',
            '..first',
            'hashSet.first',
            '..first',
            'linkedHashSet.first',
            '..first',
            'listQueue.first',
            '..first',
            'queue.first',
            '..first',
            'splayTreeSet.first',
            '..first',
            'unmodifiableListView.first',
            'unmodifiableListView.first',
            '..first',
            '..first',
            'unmodifiableSetView.first',
            '..first',
          ],
          locationTexts: [
            'iterable.elementAt(0)',
            '..elementAt(0)',
            'list.elementAt(0)',
            'list[0]',
            '..elementAt(0)',
            '..[0]',
            '..[0]',
            '..[0]',
            'set.elementAt(0)',
            '..elementAt(0)',
            'doubleLinkedQueue.elementAt(0)',
            '..elementAt(0)',
            'hashSet.elementAt(0)',
            '..elementAt(0)',
            'linkedHashSet.elementAt(0)',
            '..elementAt(0)',
            'listQueue.elementAt(0)',
            '..elementAt(0)',
            'queue.elementAt(0)',
            '..elementAt(0)',
            'splayTreeSet.elementAt(0)',
            '..elementAt(0)',
            'unmodifiableListView.elementAt(0)',
            'unmodifiableListView[0]',
            '..elementAt(0)',
            '..[0]',
            'unmodifiableSetView.elementAt(0)',
            '..elementAt(0)',
          ],
        );
      });
    },
  );
}
