<?php declare(strict_types=1);
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto\Namespace;

interface Stats
{
    /**
     * Get [channel statistics](https://core.telegram.org/api/stats).
     *
     * @param bool $dark Whether to enable dark theme for graph colors
     * @param array|int|string $channel The channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.broadcastStats', period: array{_: 'statsDateRangeDays', min_date: int, max_date: int}, followers: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, views_per_post: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, shares_per_post: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, reactions_per_post: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, views_per_story: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, shares_per_story: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, reactions_per_story: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, enabled_notifications: array{_: 'statsPercentValue', part: float, total: float}, growth_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, followers_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, mute_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, top_hours_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, interactions_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, iv_interactions_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, views_by_source_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, new_followers_by_source_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, languages_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, reactions_by_emotion_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, story_interactions_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, story_reactions_by_emotion_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, recent_posts_interactions: list<array{_: 'postInteractionCountersMessage', msg_id: int, views: int, forwards: int, reactions: int}|array{_: 'postInteractionCountersStory', story_id: int, views: int, forwards: int, reactions: int}>} @see https://docs.madelineproto.xyz/API_docs/types/stats.BroadcastStats.html
     */
    public function getBroadcastStats(bool|null $dark = null, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Load [channel statistics graph](https://core.telegram.org/api/stats) asynchronously.
     *
     * @param string $token Graph token from [statsGraphAsync](https://docs.madelineproto.xyz/API_docs/constructors/statsGraphAsync.html) constructor
     * @param int $x Zoom value, if required
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string} @see https://docs.madelineproto.xyz/API_docs/types/StatsGraph.html
     */
    public function loadAsyncGraph(string|null $token = '', int|null $x = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [supergroup statistics](https://core.telegram.org/api/stats).
     *
     * @param bool $dark Whether to enable dark theme for graph colors
     * @param array|int|string $channel [Supergroup ID](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.megagroupStats', period: array{_: 'statsDateRangeDays', min_date: int, max_date: int}, members: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, messages: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, viewers: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, posters: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, growth_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, members_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, new_members_by_source_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, languages_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, messages_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, actions_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, top_hours_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, weekdays_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, top_posters: list<array{_: 'statsGroupTopPoster', user_id: int, messages: int, avg_chars: int}>, top_admins: list<array{_: 'statsGroupTopAdmin', user_id: int, deleted: int, kicked: int, banned: int}>, top_inviters: list<array{_: 'statsGroupTopInviter', user_id: int, invitations: int}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stats.MegagroupStats.html
     */
    public function getMegagroupStats(bool|null $dark = null, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtains a list of messages, indicating to which other public channels was a channel message forwarded.
     * Will return a list of [messages](https://docs.madelineproto.xyz/API_docs/constructors/message.html) with `peer_id` equal to the public channel to which this message was forwarded.
     *
     * @param array|int|string $channel Source channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $msg_id Source message ID
     * @param string $offset Offset for [pagination](https://core.telegram.org/api/offsets), empty string on first call, then use the `next_offset` field of the returned constructor (if present, otherwise no more results are available).
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.publicForwards', count: int, forwards: list<array{_: 'publicForwardMessage', message: array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, video_processing_pending: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int, effect?: int, factcheck?: array{_: 'factCheck', need_check: bool, country?: string, text?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}, hash: list<int|string>}}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: array, street_line2: array, city: array, state: array, country_iso2: array, post_code: array}}, shipping_option_id?: string, subscription_until_date?: int}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string, subscription_until_date?: int}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int|string>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: array, data_hash: array, secret: array}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}>, plain_data?: array{_: 'securePlainPhone', phone: array}|array{_: 'securePlainEmail', email: array}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: array, motion: array, background_color?: array, second_background_color?: array, third_background_color?: array, fourth_background_color?: array, intensity?: array, rotation?: array, emoticon?: array}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: array, motion: array, background_color?: array, second_background_color?: array, third_background_color?: array, fourth_background_color?: array, intensity?: array, rotation?: array, emoticon?: array}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}}|array{_: 'messageActionGiveawayLaunch', stars?: int}|array{_: 'messageActionGiveawayResults', stars: bool, winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}|array{_: 'messageActionPaymentRefunded', peer: array|int|string, charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, currency: string, total_amount: int, payload?: string}|array{_: 'messageActionGiftStars', currency: string, amount: int, stars: int, crypto_currency?: string, crypto_amount?: int, transaction_id?: string}|array{_: 'messageActionPrizeStars', boost_peer: array|int|string, unclaimed: bool, stars: int, transaction_id: string, giveaway_msg_id: int}|array{_: 'messageActionStarGift', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int}, name_hidden: bool, saved: bool, converted: bool, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}, convert_stars?: int}, ttl_period?: int}}|array{_: 'publicForwardStory', peer: array|int|string, story: array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}}>, next_offset?: string, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stats.PublicForwards.html
     */
    public function getMessagePublicForwards(array|int|string|null $channel = null, int|null $msg_id = 0, string|null $offset = '', int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [message statistics](https://core.telegram.org/api/stats).
     *
     * @param bool $dark Whether to enable dark theme for graph colors
     * @param array|int|string $channel Channel ID @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $msg_id Message ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.messageStats', views_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, reactions_by_emotion_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}} @see https://docs.madelineproto.xyz/API_docs/types/stats.MessageStats.html
     */
    public function getMessageStats(bool|null $dark = null, array|int|string|null $channel = null, int|null $msg_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [statistics](https://core.telegram.org/api/stats) for a certain [story](https://core.telegram.org/api/stories).
     *
     * @param bool $dark Whether to enable the dark theme for graph colors
     * @param array|int|string $peer The peer that posted the story @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id Story ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.storyStats', views_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, reactions_by_emotion_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}} @see https://docs.madelineproto.xyz/API_docs/types/stats.StoryStats.html
     */
    public function getStoryStats(bool|null $dark = null, array|int|string|null $peer = null, int|null $id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtain forwards of a [story](https://core.telegram.org/api/stories) as a message to public chats and reposts by public channels.
     *
     * @param array|int|string $peer Peer where the story was originally posted @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $id [Story](https://core.telegram.org/api/stories) ID
     * @param string $offset Offset for pagination, from [stats.PublicForwards](https://docs.madelineproto.xyz/API_docs/constructors/stats.publicForwards.html).`next_offset`.
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.publicForwards', count: int, forwards: list<array{_: 'publicForwardMessage', message: array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, video_processing_pending: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int, effect?: int, factcheck?: array{_: 'factCheck', need_check: bool, country?: string, text?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}, hash: list<int|string>}}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: array, street_line2: array, city: array, state: array, country_iso2: array, post_code: array}}, shipping_option_id?: string, subscription_until_date?: int}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string, subscription_until_date?: int}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int|string>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: array, data_hash: array, secret: array}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: array, access_hash: array, size: array, dc_id: array, date: array, file_hash: array, secret: array}>, plain_data?: array{_: 'securePlainPhone', phone: array}|array{_: 'securePlainEmail', email: array}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: array, motion: array, background_color?: array, second_background_color?: array, third_background_color?: array, fourth_background_color?: array, intensity?: array, rotation?: array, emoticon?: array}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: array, motion: array, background_color?: array, second_background_color?: array, third_background_color?: array, fourth_background_color?: array, intensity?: array, rotation?: array, emoticon?: array}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}}|array{_: 'messageActionGiveawayLaunch', stars?: int}|array{_: 'messageActionGiveawayResults', stars: bool, winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}|array{_: 'messageActionPaymentRefunded', peer: array|int|string, charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, currency: string, total_amount: int, payload?: string}|array{_: 'messageActionGiftStars', currency: string, amount: int, stars: int, crypto_currency?: string, crypto_amount?: int, transaction_id?: string}|array{_: 'messageActionPrizeStars', boost_peer: array|int|string, unclaimed: bool, stars: int, transaction_id: string, giveaway_msg_id: int}|array{_: 'messageActionStarGift', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int}, name_hidden: bool, saved: bool, converted: bool, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: array, length: array}|array{_: 'messageEntityMention', offset: array, length: array}|array{_: 'messageEntityHashtag', offset: array, length: array}|array{_: 'messageEntityBotCommand', offset: array, length: array}|array{_: 'messageEntityUrl', offset: array, length: array}|array{_: 'messageEntityEmail', offset: array, length: array}|array{_: 'messageEntityBold', offset: array, length: array}|array{_: 'messageEntityItalic', offset: array, length: array}|array{_: 'messageEntityCode', offset: array, length: array}|array{_: 'messageEntityPre', offset: array, length: array, language: array}|array{_: 'messageEntityTextUrl', offset: array, length: array, url: array}|array{_: 'messageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'inputMessageEntityMentionName', offset: array, length: array, user_id: array}|array{_: 'messageEntityPhone', offset: array, length: array}|array{_: 'messageEntityCashtag', offset: array, length: array}|array{_: 'messageEntityUnderline', offset: array, length: array}|array{_: 'messageEntityStrike', offset: array, length: array}|array{_: 'messageEntityBankCard', offset: array, length: array}|array{_: 'messageEntitySpoiler', offset: array, length: array}|array{_: 'messageEntityCustomEmoji', offset: array, length: array, document_id: array}|array{_: 'messageEntityBlockquote', collapsed: array, offset: array, length: array}|array{_: 'messageEntityBlockquote', offset: array, length: array}>}, convert_stars?: int}, ttl_period?: int}}|array{_: 'publicForwardStory', peer: array|int|string, story: array{_: 'storyItemDeleted', id: int}|array{_: 'storyItemSkipped', close_friends: bool, id: int, date: int, expire_date: int}|array{_: 'storyItem', pinned: bool, public: bool, close_friends: bool, min: bool, noforwards: bool, edited: bool, contacts: bool, selected_contacts: bool, out: bool, id: int, date: int, from_id?: array|int|string, fwd_from?: array{_: 'storyFwdHeader', modified: bool, from?: array|int|string, from_name?: string, story_id?: int}, expire_date: int, caption?: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, media_areas?: list<array{_: 'mediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'inputMediaAreaVenue', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, query_id: int, result_id: string}|array{_: 'mediaAreaGeoPoint', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius?: int}, address?: array{_: 'geoPointAddress', country_iso2: string, state?: string, city?: string, street?: string}}|array{_: 'mediaAreaSuggestedReaction', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, dark: bool, flipped: bool, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}|array{_: 'mediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel_id: int, msg_id: int}|array{_: 'inputMediaAreaChannelPost', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, channel: array|int|string, msg_id: int}|array{_: 'mediaAreaUrl', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, url: string}|array{_: 'mediaAreaWeather', coordinates: array{_: 'mediaAreaCoordinates', x: float, y: float, w: float, h: float, rotation: float, radius?: float}, temperature_c: float, emoji: string, color: int}>, privacy?: list<array{_: 'privacyValueAllowContacts'}|array{_: 'privacyValueAllowAll'}|array{_: 'privacyValueAllowUsers', users: list<int>}|array{_: 'privacyValueDisallowContacts'}|array{_: 'privacyValueDisallowAll'}|array{_: 'privacyValueDisallowUsers', users: list<int>}|array{_: 'privacyValueAllowChatParticipants', chats: list<int>}|array{_: 'privacyValueDisallowChatParticipants', chats: list<int>}|array{_: 'privacyValueAllowCloseFriends'}|array{_: 'privacyValueAllowPremium'}|array{_: 'privacyValueAllowBots'}|array{_: 'privacyValueDisallowBots'}>, views?: array{_: 'storyViews', has_viewers: bool, views_count: int, forwards_count?: int, reactions?: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: array}|array{_: 'reactionCustomEmoji', document_id: array}|array{_: 'reactionPaid'}, count: int}>, reactions_count?: int, recent_viewers?: list<int>}, sent_reaction?: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}}>, next_offset?: string, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stats.PublicForwards.html
     */
    public function getStoryPublicForwards(array|int|string|null $peer = null, int|null $id = 0, string|null $offset = '', int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param bool $dark
     * @param array|int|string $peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.broadcastRevenueStats', top_hours_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, revenue_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token?: string}, balances: array{_: 'broadcastRevenueBalances', withdrawal_enabled: bool, current_balance: int, available_balance: int, overall_revenue: int}, usd_rate: float} @see https://docs.madelineproto.xyz/API_docs/types/stats.BroadcastRevenueStats.html
     */
    public function getBroadcastRevenueStats(bool|null $dark = null, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param string|array $password @see https://docs.madelineproto.xyz/API_docs/types/InputCheckPasswordSRP.html
     * @param array|int|string $peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.broadcastRevenueWithdrawalUrl', url: string} @see https://docs.madelineproto.xyz/API_docs/types/stats.BroadcastRevenueWithdrawalUrl.html
     */
    public function getBroadcastRevenueWithdrawalUrl(string|array $password, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param array|int|string $peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'stats.broadcastRevenueTransactions', count: int, transactions: list<array{_: 'broadcastRevenueTransactionProceeds', amount: int, from_date: int, to_date: int}|array{_: 'broadcastRevenueTransactionWithdrawal', pending: bool, failed: bool, amount: int, date: int, provider: string, transaction_date?: int, transaction_url?: string}|array{_: 'broadcastRevenueTransactionRefund', amount: int, date: int, provider: string}>} @see https://docs.madelineproto.xyz/API_docs/types/stats.BroadcastRevenueTransactions.html
     */
    public function getBroadcastRevenueTransactions(array|int|string|null $peer = null, int|null $offset = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;
}
