<?php declare(strict_types=1);
/**
 * Lang module.
 *
 * This file is part of MadelineProto.
 * MadelineProto is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * MadelineProto is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU General Public License along with MadelineProto.
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * @author    Daniil Gentili <daniil@daniil.it>
 * @copyright 2016-2023 Daniil Gentili <daniil@daniil.it>
 * @license   https://opensource.org/licenses/AGPL-3.0 AGPLv3
 * @link      https://docs.madelineproto.xyz MadelineProto documentation
 */

namespace danog\MadelineProto;

/** @internal */
final class Lang
{
    public const PERCENTAGES = [
        'zh_Hans' => 100,
        'en' => 100,
        'fr' => 36,
        'de' => 0,
        'he' => 74,
        'it' => 100,
        'ckb' => 74,
        'fa' => 100,
        'pt' => 0,
        'ru' => 82,
        'uz' => 75,
    ];

    public static int $currentPercentage = 100;

    public static array $lang = [
        'ckb' =>
        [
            '2fa_uncalled' => 'چاوەڕێی پاسۆردەکە ناکەم! تکایە سەرەتا پەیوەندی بە phoneLogin و شێوازەکانی completePhoneLogin بکەن!',
            'accepting_call' => 'وەرگرتنی پەیوەندی لە %s...',
            'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
            'already_loggedIn' => 'ئەم نموونەیەی MadelineProto پێشتر چووەتە ژوورەوە!',
            'apiAppInstructionsAuto0' => 'ناوی ئەپەکە بنووسە، دەتوانێت هەر شتێک بێت: ',
            'apiAppInstructionsAuto1' => 'ناوی کورتی ئەپەکە بنووسە، ئەلفوبێی ژمارەیی، ٥-٣٢ پیت: ',
            'apiAppInstructionsAuto2' => 'URL ی ئەپ/ماڵپەڕەکە دابنێ، یان t.me/yourusername: ',
            'apiAppInstructionsAuto3' => 'چوونە ناو پلاتفۆرمی ئەپەکە: ',
            'apiAppInstructionsAuto4' => 'باسی ئەپەکەت بکە: ',
            'apiAppInstructionsAutoTypeOther' => 'شتی تر (لە وەسفدا دیاری بکە)',
            'apiAppInstructionsManual0' => 'ناوی ئەپەکەت دەتوانێت هەر شتێک بێت',
            'apiAppInstructionsManual1' => 'ناوی کورتی ئەپەکەت، ئەلفوبێی ژمارەیی، ٥-٣٢ پیت',
            'apiAppInstructionsManual2' => 'URL ی ئەپ/ماڵپەڕەکەت، یان t.me/yourusername',
            'apiAppInstructionsManual3' => 'هەر شتێک',
            'apiAppInstructionsManual4' => 'لێرەدا باسی ئەپەکەت بکە',
            'apiAppWeb' => 'زانیارییەکانی API داخڵ بکە',
            'apiAutoPrompt0' => 'ژمارەی تەلەفۆنێک داخڵ بکە کە پێشتر لە تێلێگرام تۆمار کراوە: ',
            'apiAutoPrompt1' => 'ئەو کۆدەی پشتڕاستکردنەوە کە لە تێلێگرام وەرتگرتووە داخڵ بکە: ',
            'apiAutoWeb' => 'ژمارەیەکی تەلەفۆن دابنێ کە <b>پێشتر تۆمارکراوە</b> لە تێلێگرام بۆ بەدەستهێنانی ناسنامەی API',
            'apiChooseManualAutoTip' => 'تێبینی بکە کە دەتوانیت API ID/hash ڕاستەوخۆ لە کۆدەکەدا دابین بکەیت بە بەکارهێنانی ڕێکخستنەکان: %s',
            'apiChooseManualAutoTipWeb' => 'تێبینی بکە کە دەتوانیت API ID/hash ڕاستەوخۆ لە کۆدەکەدا دابین بکەیت بە بەکارهێنانی <a target="_blank" href="%s">ڕێکخستنەکان</a>.',
            'apiChoosePrompt' => 'هەڵبژاردەی تۆ: ',
            'apiError' => 'هەڵە: %s. دووبارە هەوڵبدەرەوە.',
            'apiManualInstructions0' => 'چوونەژوورەوە بۆ https://my.telegram.org',
            'apiManualInstructions1' => 'بڕۆ بۆ ئامرازەکانی پەرەپێدانی API',
            'apiManualInstructions2' => 'کلیک لەسەر create application بکە',
            'apiManualPrompt0' => 'ناسنامەی API ی خۆت دابنێ: ',
            'apiManualPrompt1' => 'هاشی API ەکەت بنووسە: ',
            'apiManualWeb' => 'API ID و API هاشەکەت دابنێ',
            'apiParamsError' => 'تۆ هەموو پارامێتەرەکانی پێویستت دابین نەکردووە!',
            'api_not_set' => 'پێویستە کلیلی api و api id دابین بکەیت، خۆت @ my.telegram.org بەدەست بهێنە',
            'array_invalid' => 'تۆ ڕیزبەندییەکی دروستت دابین نەکردووە',
            'baseDirLimitation' => 'A basedir limitation is configured: this can impact performance and cause some issues, please disable it if possible!',
            'bool_error' => 'نەتوانرا boolean دەربهێنرێت',
            'botAlreadyRunning' => 'The bot is already running!',
            'botapi_conversion_error' => 'ناتوانرێت %s بگۆڕێت بۆ ئۆبجێکتی API بۆت',
            'call_already_accepted' => 'پەیوەندی %s پێشتر وەرگیراوە',
            'call_already_declined' => 'پەیوەندی %s پێشتر ڕەتکراوەتەوە',
            'call_completing' => 'تەواوکردنی پەیوەندی لە %s...',
            'call_confirming' => 'پشتڕاستکردنەوەی پەیوەندی لە %s...',
            'call_discarding' => 'فڕێدانی پەیوەندی %s...',
            'call_error_1' => 'نەتوانرا پەیوەندی %s بدۆزرێتەوە و وەریبگرێت',
            'call_error_2' => 'نەتوانرا پەیوەندی %s بدۆزرێتەوە و پشتڕاستی بکاتەوە',
            'call_error_3' => 'نەتوانرا پەیوەندی %s بدۆزرێتەوە و تەواو بکات',
            'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
            'constructor_not_found' => 'Constructor نەدۆزرایەوە بۆ جۆری: ',
            'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
            'could_not_convert_object' => 'Could not convert object of type %s',
            'deserialization_error' => 'هەڵەیەک لە کاتی ڕیزبەندیکردندا ڕوویدا',
            'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
            'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
            'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
            'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
            'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
            'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
            'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
            'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
            'done' => 'تەواو!',
            'encode_double_error' => 'نەتوانرا بە باشی دووانە کۆد بکات',
            'extensionRecommended' => 'Warning: the %s extension is not installed, please install it to speed up MadelineProto!',
            'extensionRequired' => 'MadelineProto requires the %s extension to run. %s',
            'extensionRequiredInstallWithApt' => 'Try running sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Follow the instructions at %s to install it.',
            'file_not_exist' => 'فایله‌که‌ بوونی نییه‌',
            'file_parsing' => 'پارسکردنی %s...',
            'file_type_invalid' => 'جۆری پەڕگەی نادروست دۆزراوەتەوە (%s)',
            'fingerprint_invalid' => 'پەنجەمۆری کلیل نادروستە!',
            'go' => 'بڕۆ',
            'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
            'length_too_big' => 'درێژی زۆر گەورەیە',
            'loginBot' => 'تۆکنی بۆتەکەت بنووسە: ',
            'loginBotTokenWeb' => 'بۆت تۆکن',
            'loginChoosePromptWeb' => 'دەتەوێت وەک بەکارهێنەر یان وەک بۆت بچیتە ژوورەوە؟',
            'loginManual' => 'یان دەتوانیت تۆکنێکی بۆت یان ژمارەی تەلەفۆنیش دابنێیت بۆ ئەوەی بە دەستی بچیتە ژوورەوە: ',
            'loginNoCode' => 'تۆ کۆدی تەلەفۆنت بۆ دابین نەکرد!',
            'loginNoName' => 'ناوی یەکەمتان دابین نەکردووە!',
            'loginNoPass' => 'تۆ پاسۆردەکەت دابین نەکرد!',
            'loginOptionBot' => 'بۆت',
            'loginOptionUser' => 'بەکارهێنەر',
            'loginQr' => 'کۆدی QR ی سەرەوە سکان بکە بۆ ئەوەی بە شێوەیەکی ئۆتۆماتیکی بچیتە ژوورەوە.',
            'loginQrCodeExpired' => 'کۆدی QR بەسەرچوو، کۆدی نوێی دروستکرد...',
            'loginQrCodeSuccessful' => 'چوونەژوورەوەی کۆدی QR سەرکەوتوو بوو!',
            'loginUser' => 'ژمارەی مۆبایلت داخل بکە: ',
            'loginUserCode' => 'کۆدەکە داخڵ بکە: ',
            'loginUserPass' => 'وشەی نهێنی خۆت بنووسە (ئاماژە %s): ',
            'loginUserPassHint' => 'ئاماژە: %s',
            'loginUserPassWeb' => 'ژمارەی نهێنییەکەت داخل بکە: ',
            'loginUserPhoneCodeWeb' => 'کۆد',
            'loginUserPhoneWeb' => 'ژمارەی تەلەفۆن',
            'loginWebQr' => 'هەروەها دەتوانیت بە شێوەیەکی ئۆتۆماتیکی بچیتە ژوورەوە بە سکانکردنی ئەم QR کۆدە:',
            'loginWebQr1' => 'لە مۆبایلەکەتدا تێلێگرام بکەرەوە',
            'loginWebQr2' => 'بڕۆ بۆ ڕێکخستنەکان > ئامێرەکان > بەستنەوەی ئامێری سەر مێز',
            'loginWebQr3' => 'بۆ پشتڕاستکردنەوەی چوونەژوورەوە مۆبایلەکەت ئاراستەی ئەم شاشەیە بکە',
            'login_2fa_enabled' => '2FA چالاک کراوە، دەبێت بانگی فەنکشنی complete2falogin بکەیت...',
            'login_auth_key' => 'چوونە ژوورەوە بە بەکارهێنانی کلیلی auth...',
            'login_bot' => 'چوونە ژوورەوە وەک بۆتێک...',
            'login_code_sending' => 'ناردنی کۆد...',
            'login_code_sent' => 'کۆد بە سەرکەوتوویی نێردراوە! کاتێک کۆدەکەت وەرگرت پێویستە فەنکشنی completePhoneLogin بەکاربهێنیت.',
            'login_code_uncalled' => 'چاوەڕێی کۆدەکە ناکەم! تکایە سەرەتا پەیوەندی بە شێوازی phoneLogin بکەن',
            'login_need_signup' => 'ئەکاونتێک بۆ ئەم ژمارەیە دروست نەکراوە، دەبێت پەیوەندی بە فەنکشنی completeSignup بکەیت...',
            'login_ok' => 'بە سەرکەوتوویی چوونەژوورەوە!',
            'login_user' => 'چوونە ژوورەوە وەک بەکارهێنەرێکی ئاسایی...',
            'logout_ok' => 'بە سەرکەوتوویی دەرچووە!',
            'long_not_16' => 'بەهای پێدراو درێژییەکەی ١٦ بایت نییە',
            'long_not_32' => 'بەهای پێدراو درێژییەکەی ٣٢ بایت نییە',
            'long_not_64' => 'بەهای پێدراو درێژییەکەی ٦٤ بایت نییە',
            'madelineproto_ready' => 'MadelineProto ئامادەیە!',
            'manualAdminActionRequired' => '!!!!!!!!! MANUAL SYSTEM ADMIN ACTION REQUIRED !!!!!!!!!',
            'method_not_found' => 'نەتوانرا شێواز بدۆزرێتەوە: ',
            'mmapErrorPart1' => 'The maximum number of memory mapped (mmap) regions was reached (%s): please increase the vm.max_map_count kernel config to 262144 to fix.',
            'mmapErrorPart2' => 'To fix, run the following command as root: %s',
            'mmapErrorPart3' => 'To persist the change across reboots: %s',
            'mmapErrorPart4' => 'On Windows and WSL, increasing the size of the pagefile might help; please switch to native Linux if the issue persists.',
            'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
            'nearest_dc' => 'ئێمە لە %s داین، نزیکترین DC %d ە.',
            'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
            'noReportPeers' => 'Warning: no report peers are set, please add the following method to your event handler',
            'non_text_conversion' => 'هێشتا ناتوانرێت نامە نا کورتەکان بگۆڕدرێت!',
            'not_loggedIn' => 'من چوومەتە ژوورەوە!',
            'not_numeric' => 'بەهای پێدراو ژمارەیی نییە',
            'params_missing' => 'پارامێتری پێویست نەماوە',
            'peer_not_in_db' => 'ئەم هاوتایە لە بنکەدراوەی ناوخۆیی هاوتادا ئامادە نییە',
            'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
            'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
            'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
            'predicate_not_set' => 'پێشبینی (بەهای ژێر _) دانەنرابوو!',
            'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
            'rpc_tg_error' => 'تێلێگرام هەڵەیەکی RPC ی گەڕاندەوە: %s (%s)، کە بەهۆی %s:%s%sTL شوێنپێهەڵگرتنەوە دروست بووە:',
            'sec_peer_not_in_db' => 'ئەم هاوتا نهێنییە لە بنکەدراوەی ناوخۆیی هاوتادا ئامادە نییە',
            'secret_chat_skipping' => 'من چاتی نهێنی %sم لە بنکەدراوەدا نییە، نامەکەم بەجێهێشتووە...',
            'serialization_ofd' => 'زنجیرەییکردن بەسەرچووە، دووبارە بنیاتنانەوەی ئۆبجێکتی!',
            'session_corrupted' => 'دانیشتنەکە گەندەڵ بووە!',
            'signing_up' => 'ناو تۆمارکردن وەک بەکارهێنەرێکی ئاسایی...',
            'signupFirstName' => 'ناوی یەکەمی خۆت بنووسە: ',
            'signupFirstNameWeb' => 'ناوی یەکەم',
            'signupLastName' => 'ناوی کۆتایی خۆت بنووسە (دەتوانێت بەتاڵ بێت): ',
            'signupLastNameWeb' => 'ناوی کۆتایی',
            'signupWeb' => 'تکایە ناوت تۆمار بکە',
            'signup_ok' => 'بە سەرکەوتوویی ناوت تۆمار کرد!',
            'signup_uncalled' => 'چاوەڕێی ناو تۆمارکردن ناکەم! تکایە سەرەتا پەیوەندی بە phoneLogin و شێوازەکانی completePhoneLogin بکەن!',
            'src_file_invalid' => 'پەڕگەی سەرچاوەی نادروست دابین کرا: ',
            'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
            'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
            'stream_handle_invalid' => 'دەستەیەکی نادروستی سترێم دابین کرابوو.',
            'string_required' => 'A string was expected!',
            'translate_madelineproto_cli' => 'MadelineProto can be translated in your language (current translation progress: %d%%), go to https://weblate.madelineproto.xyz to contribute with the translation!',
            'translate_madelineproto_web' => 'MadelineProto can be translated in your language (current translation progress: %d%%), click <a href="https://weblate.madelineproto.xyz" target="_blank">here to contribute with the translation!</a>',
            'type_extract_error' => 'نەتوانرا جۆری "%s" دەربهێنرێت، پێویستە MadelineProto نوێ بکەیتەوە!',
            'type_extract_error_id' => 'نەتوانرا جۆری: %s بە id %s دەربهێنرێت، پێویستە MadelineProto نوێ بکەیتەوە!',
            'update_madelineproto' => 'You\'re running an old version of MadelineProto, an update is required: currently running %s, but the latest version with multiple bugfixes and new features is %s!',
            'value_bigger_than_2147483647' => 'بەهای دابینکراو %s گەورەترە لە 2147483647',
            'value_bigger_than_4294967296' => 'بەهای مەرجدار %s گەورەترە لە 4294967296',
            'value_bigger_than_9223372036854775807' => 'بەهای دابینکراو %s گەورەترە لە 9223372036854775807',
            'value_smaller_than_0' => 'بەهای بە مەرجێک %s بچووکترە لە 0',
            'value_smaller_than_2147483648' => 'بەهای دابینکراو %s بچووکترە لە -2147483648',
            'value_smaller_than_9223372036854775808' => 'بەهای دابینکراو %s بچووکترە لە -9223372036854775808',
            'waveform_must_have_100_values' => 'A waveform array must have 100 values!',
            'waveform_value' => 'A waveform value must be between 0 and 31!',
            'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
        ],
        'de' =>
        [
            '2fa_uncalled' => 'I\'m not waiting for the password! Please call the phoneLogin and the completePhoneLogin methods first!',
            'accepting_call' => 'Accepting call from %s...',
            'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
            'already_loggedIn' => 'This instance of MadelineProto is already logged in!',
            'apiAppInstructionsAuto0' => 'Enter the app\'s name, can be anything: ',
            'apiAppInstructionsAuto1' => 'Enter the app\'s short name, alphanumeric, 5-32 characters: ',
            'apiAppInstructionsAuto2' => 'Enter the app/website\'s URL, or t.me/yourusername: ',
            'apiAppInstructionsAuto3' => 'Enter the app platform: ',
            'apiAppInstructionsAuto4' => 'Describe your app: ',
            'apiAppInstructionsAutoTypeOther' => 'Other (specify in description)',
            'apiAppInstructionsManual0' => 'your app\'s name, can be anything',
            'apiAppInstructionsManual1' => 'your app\'s short name, alphanumeric, 5-32 characters',
            'apiAppInstructionsManual2' => 'your app/website\'s URL, or t.me/yourusername',
            'apiAppInstructionsManual3' => 'anything',
            'apiAppInstructionsManual4' => 'Describe your app here',
            'apiAppWeb' => 'Enter API information',
            'apiAutoPrompt0' => 'Enter a phone number that is already registered on Telegram: ',
            'apiAutoPrompt1' => 'Enter the verification code you received in Telegram: ',
            'apiAutoWeb' => 'Enter a phone number that is <b>already registered</b> on telegram to get the API ID',
            'apiChooseManualAutoTip' => 'Note that you can also provide the API ID/hash directly in the code using the settings: %s',
            'apiChooseManualAutoTipWeb' => 'Note that you can also provide the API ID/hash directly in the code using the <a target="_blank" href="%s">settings</a>.',
            'apiChoosePrompt' => 'Your choice (m/a): ',
            'apiError' => 'ERROR: %s. Try again.',
            'apiManualInstructions0' => 'Login to https://my.telegram.org',
            'apiManualInstructions1' => 'Go to API development tools',
            'apiManualInstructions2' => 'Click on create application',
            'apiManualPrompt0' => 'Enter your API ID: ',
            'apiManualPrompt1' => 'Enter your API hash: ',
            'apiManualWeb' => 'Enter your API ID and API hash',
            'apiParamsError' => 'You didn\'t provide all of the required parameters!',
            'api_not_set' => 'You must provide an api key and an api id, get your own @ my.telegram.org',
            'array_invalid' => 'You didn\'t provide a valid array',
            'baseDirLimitation' => 'A basedir limitation is configured: this can impact performance and cause some issues, please disable it if possible!',
            'bool_error' => 'Could not extract boolean',
            'botAlreadyRunning' => 'The bot is already running!',
            'botapi_conversion_error' => 'Can\'t convert %s to a bot API object',
            'call_already_accepted' => 'Call %s already accepted',
            'call_already_declined' => 'Call %s already declined',
            'call_completing' => 'Completing call from %s...',
            'call_confirming' => 'Confirming call from %s...',
            'call_discarding' => 'Discarding call %s...',
            'call_error_1' => 'Could not find and accept call %s',
            'call_error_2' => 'Could not find and confirm call %s',
            'call_error_3' => 'Could not find and complete call %s',
            'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
            'constructor_not_found' => 'Constructor not found for type: ',
            'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
            'could_not_convert_object' => 'Could not convert object of type %s',
            'deserialization_error' => 'An error occurred on deserialization',
            'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
            'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
            'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
            'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
            'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
            'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
            'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
            'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
            'done' => 'Done!',
            'encode_double_error' => 'Could not properly encode double',
            'extensionRecommended' => 'Warning: the %s extension is not installed, please install it to speed up MadelineProto!',
            'extensionRequired' => 'MadelineProto requires the %s extension to run. %s',
            'extensionRequiredInstallWithApt' => 'Try running sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Follow the instructions at %s to install it.',
            'file_not_exist' => 'File does not exist',
            'file_parsing' => 'Parsing %s...',
            'file_type_invalid' => 'Invalid file type detected (%s)',
            'fingerprint_invalid' => 'Invalid key fingerprint!',
            'go' => 'Go',
            'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
            'length_too_big' => 'Length is too big',
            'loginBot' => 'Enter your bot token: ',
            'loginBotTokenWeb' => 'Bot token',
            'loginChoosePromptWeb' => 'Do you want to login as a user or as a bot?',
            'loginManual' => 'Alternatively, you can also enter a bot token or phone number to login manually: ',
            'loginNoCode' => 'You didn\'t provide a phone code!',
            'loginNoName' => 'You didn\'t provide the first name!',
            'loginNoPass' => 'You didn\'t provide the password!',
            'loginOptionBot' => 'Bot',
            'loginOptionUser' => 'User',
            'loginQr' => 'Scan the above QR code to login automatically.',
            'loginQrCodeExpired' => 'The QR code expired, generating a new one...',
            'loginQrCodeSuccessful' => 'QR code login successful!',
            'loginUser' => 'Enter your phone number: ',
            'loginUserCode' => 'Enter the code: ',
            'loginUserPass' => 'Enter your password (hint %s): ',
            'loginUserPassHint' => 'Hint: %s',
            'loginUserPassWeb' => 'Enter your password: ',
            'loginUserPhoneCodeWeb' => 'Code',
            'loginUserPhoneWeb' => 'Phone number',
            'loginWebQr' => 'You can also login automatically by scanning the following QR code:',
            'loginWebQr1' => 'Open Telegram on your phone',
            'loginWebQr2' => 'Go to Settings > Devices > Link Desktop Device',
            'loginWebQr3' => 'Point your phone at this screen to confirm login',
            'login_2fa_enabled' => '2FA enabled, you will have to call the complete2falogin function...',
            'login_auth_key' => 'Logging in using auth key...',
            'login_bot' => 'Logging in as a bot...',
            'login_code_sending' => 'Sending code...',
            'login_code_sent' => 'Code sent successfully! Once you receive the code you should use the completePhoneLogin function.',
            'login_code_uncalled' => 'I\'m not waiting for the code! Please call the phoneLogin method first',
            'login_need_signup' => 'An account has not been created for this number, you will have to call the completeSignup function...',
            'login_ok' => 'Logged in successfully!',
            'login_user' => 'Logging in as a normal user...',
            'logout_ok' => 'Logged out successfully!',
            'long_not_16' => 'Given value is not 16 bytes long',
            'long_not_32' => 'Given value is not 32 bytes long',
            'long_not_64' => 'Given value is not 64 bytes long',
            'madelineproto_ready' => 'MadelineProto is ready!',
            'manualAdminActionRequired' => '!!!!!!!!! MANUAL SYSTEM ADMIN ACTION REQUIRED !!!!!!!!!',
            'method_not_found' => 'Could not find method: ',
            'mmapErrorPart1' => 'The maximum number of memory mapped (mmap) regions was reached (%s): please increase the vm.max_map_count kernel config to 262144 to fix.',
            'mmapErrorPart2' => 'To fix, run the following command as root: %s',
            'mmapErrorPart3' => 'To persist the change across reboots: %s',
            'mmapErrorPart4' => 'On Windows and WSL, increasing the size of the pagefile might help; please switch to native Linux if the issue persists.',
            'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
            'nearest_dc' => 'We\'re in %s, nearest DC is %d.',
            'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
            'noReportPeers' => 'Warning: no report peers are set, please add the following method to your event handler',
            'non_text_conversion' => 'Can\'t convert non text messages yet!',
            'not_loggedIn' => 'I\'m not logged in!',
            'not_numeric' => 'Given value isn\'t numeric',
            'params_missing' => 'Missing required parameter',
            'peer_not_in_db' => 'This peer is not present in the internal peer database',
            'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
            'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
            'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
            'predicate_not_set' => 'Predicate (value under _) was not set!',
            'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
            'rpc_tg_error' => 'Telegram returned an RPC error: %s (%s), caused by %s:%s%sTL trace:',
            'sec_peer_not_in_db' => 'This secret peer is not present in the internal peer database',
            'secret_chat_skipping' => 'I do not have the secret chat %s in the database, skipping message...',
            'serialization_ofd' => 'Serialization is out of date, reconstructing object!',
            'session_corrupted' => 'The session is corrupted!',
            'signing_up' => 'Signing up as a normal user...',
            'signupFirstName' => 'Enter your first name: ',
            'signupFirstNameWeb' => 'First name',
            'signupLastName' => 'Enter your last name (can be empty): ',
            'signupLastNameWeb' => 'Last name',
            'signupWeb' => 'Sign up please',
            'signup_ok' => 'Signed up in successfully!',
            'signup_uncalled' => 'I\'m not waiting to signup! Please call the phoneLogin and the completePhoneLogin methods first!',
            'src_file_invalid' => 'Invalid source file was provided: ',
            'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
            'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
            'stream_handle_invalid' => 'An invalid stream handle was provided.',
            'string_required' => 'A string was expected!',
            'translate_madelineproto_cli' => 'MadelineProto can be translated in your language (current translation progress: %d%%), go to https://weblate.madelineproto.xyz to contribute with the translation!',
            'translate_madelineproto_web' => 'MadelineProto can be translated in your language (current translation progress: %d%%), click <a href="https://weblate.madelineproto.xyz" target="_blank">here to contribute with the translation!</a>',
            'type_extract_error' => 'Could not extract type "%s", you should update MadelineProto!',
            'type_extract_error_id' => 'Could not extract type: %s with id %s, you should update MadelineProto!',
            'update_madelineproto' => 'You\'re running an old version of MadelineProto, an update is required: currently running %s, but the latest version with multiple bugfixes and new features is %s!',
            'value_bigger_than_2147483647' => 'Provided value %s is bigger than 2147483647',
            'value_bigger_than_4294967296' => 'Provided value %s is bigger than 4294967296',
            'value_bigger_than_9223372036854775807' => 'Provided value %s is bigger than 9223372036854775807',
            'value_smaller_than_0' => 'Provided value %s is smaller than 0',
            'value_smaller_than_2147483648' => 'Provided value %s is smaller than -2147483648',
            'value_smaller_than_9223372036854775808' => 'Provided value %s is smaller than -9223372036854775808',
            'waveform_must_have_100_values' => 'A waveform array must have 100 values!',
            'waveform_value' => 'A waveform value must be between 0 and 31!',
            'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
        ],
        'en' =>
        [
            '2fa_uncalled' => 'I\'m not waiting for the password! Please call the phoneLogin and the completePhoneLogin methods first!',
            'accepting_call' => 'Accepting call from %s...',
            'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
            'already_loggedIn' => 'This instance of MadelineProto is already logged in!',
            'apiAppInstructionsAuto0' => 'Enter the app\'s name, can be anything: ',
            'apiAppInstructionsAuto1' => 'Enter the app\'s short name, alphanumeric, 5-32 characters: ',
            'apiAppInstructionsAuto2' => 'Enter the app/website\'s URL, or t.me/yourusername: ',
            'apiAppInstructionsAuto3' => 'Enter the app platform: ',
            'apiAppInstructionsAuto4' => 'Describe your app: ',
            'apiAppInstructionsAutoTypeOther' => 'Other (specify in description)',
            'apiAppInstructionsManual0' => 'your app\'s name, can be anything',
            'apiAppInstructionsManual1' => 'your app\'s short name, alphanumeric, 5-32 characters',
            'apiAppInstructionsManual2' => 'your app/website\'s URL, or t.me/yourusername',
            'apiAppInstructionsManual3' => 'anything',
            'apiAppInstructionsManual4' => 'Describe your app here',
            'apiAppWeb' => 'Enter API information',
            'apiAutoPrompt0' => 'Enter a phone number that is already registered on Telegram: ',
            'apiAutoPrompt1' => 'Enter the verification code you received in Telegram: ',
            'apiAutoWeb' => 'Enter a phone number that is <b>already registered</b> on telegram to get the API ID',
            'apiChooseManualAutoTip' => 'Note that you can also provide the API ID/hash directly in the code using the settings: %s',
            'apiChooseManualAutoTipWeb' => 'Note that you can also provide the API ID/hash directly in the code using the <a target="_blank" href="%s">settings</a>.',
            'apiChoosePrompt' => 'Your choice (m/a): ',
            'apiError' => 'ERROR: %s. Try again.',
            'apiManualInstructions0' => 'Login to https://my.telegram.org',
            'apiManualInstructions1' => 'Go to API development tools',
            'apiManualInstructions2' => 'Click on create application',
            'apiManualPrompt0' => 'Enter your API ID: ',
            'apiManualPrompt1' => 'Enter your API hash: ',
            'apiManualWeb' => 'Enter your API ID and API hash',
            'apiParamsError' => 'You didn\'t provide all of the required parameters!',
            'api_not_set' => 'You must provide an api key and an api id, get your own @ my.telegram.org',
            'array_invalid' => 'You didn\'t provide a valid array',
            'baseDirLimitation' => 'A basedir limitation is configured: this can impact performance and cause some issues, please disable it if possible!',
            'bool_error' => 'Could not extract boolean',
            'botAlreadyRunning' => 'The bot is already running!',
            'botapi_conversion_error' => 'Can\'t convert %s to a bot API object',
            'call_already_accepted' => 'Call %s already accepted',
            'call_already_declined' => 'Call %s already declined',
            'call_completing' => 'Completing call from %s...',
            'call_confirming' => 'Confirming call from %s...',
            'call_discarding' => 'Discarding call %s...',
            'call_error_1' => 'Could not find and accept call %s',
            'call_error_2' => 'Could not find and confirm call %s',
            'call_error_3' => 'Could not find and complete call %s',
            'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
            'constructor_not_found' => 'Constructor not found for type: ',
            'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
            'could_not_convert_object' => 'Could not convert object of type %s',
            'deserialization_error' => 'An error occurred on deserialization',
            'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
            'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
            'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
            'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
            'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
            'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
            'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
            'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
            'done' => 'Done!',
            'encode_double_error' => 'Could not properly encode double',
            'extensionRecommended' => 'Warning: the %s extension is not installed, please install it to speed up MadelineProto!',
            'extensionRequired' => 'MadelineProto requires the %s extension to run. %s',
            'extensionRequiredInstallWithApt' => 'Try running sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Follow the instructions at %s to install it.',
            'file_not_exist' => 'File does not exist',
            'file_parsing' => 'Parsing %s...',
            'file_type_invalid' => 'Invalid file type detected (%s)',
            'fingerprint_invalid' => 'Invalid key fingerprint!',
            'go' => 'Go',
            'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
            'length_too_big' => 'Length is too big',
            'loginBot' => 'Enter your bot token: ',
            'loginBotTokenWeb' => 'Bot token',
            'loginChoosePromptWeb' => 'Do you want to login as a user or as a bot?',
            'loginManual' => 'Alternatively, you can also enter a bot token or phone number to login manually: ',
            'loginNoCode' => 'You didn\'t provide a phone code!',
            'loginNoName' => 'You didn\'t provide the first name!',
            'loginNoPass' => 'You didn\'t provide the password!',
            'loginOptionBot' => 'Bot',
            'loginOptionUser' => 'User',
            'loginQr' => 'Scan the above QR code to login automatically.',
            'loginQrCodeExpired' => 'The QR code expired, generating a new one...',
            'loginQrCodeSuccessful' => 'QR code login successful!',
            'loginUser' => 'Enter your phone number: ',
            'loginUserCode' => 'Enter the code: ',
            'loginUserPass' => 'Enter your password (hint %s): ',
            'loginUserPassHint' => 'Hint: %s',
            'loginUserPassWeb' => 'Enter your password: ',
            'loginUserPhoneCodeWeb' => 'Code',
            'loginUserPhoneWeb' => 'Phone number',
            'loginWebQr' => 'You can also login automatically by scanning the following QR code:',
            'loginWebQr1' => 'Open Telegram on your phone',
            'loginWebQr2' => 'Go to Settings > Devices > Link Desktop Device',
            'loginWebQr3' => 'Point your phone at this screen to confirm login',
            'login_2fa_enabled' => '2FA enabled, you will have to call the complete2falogin function...',
            'login_auth_key' => 'Logging in using auth key...',
            'login_bot' => 'Logging in as a bot...',
            'login_code_sending' => 'Sending code...',
            'login_code_sent' => 'Code sent successfully! Once you receive the code you should use the completePhoneLogin function.',
            'login_code_uncalled' => 'I\'m not waiting for the code! Please call the phoneLogin method first',
            'login_need_signup' => 'An account has not been created for this number, you will have to call the completeSignup function...',
            'login_ok' => 'Logged in successfully!',
            'login_user' => 'Logging in as a normal user...',
            'logout_ok' => 'Logged out successfully!',
            'long_not_16' => 'Given value is not 16 bytes long',
            'long_not_32' => 'Given value is not 32 bytes long',
            'long_not_64' => 'Given value is not 64 bytes long',
            'madelineproto_ready' => 'MadelineProto is ready!',
            'manualAdminActionRequired' => '!!!!!!!!! MANUAL SYSTEM ADMIN ACTION REQUIRED !!!!!!!!!',
            'method_not_found' => 'Could not find method: ',
            'mmapErrorPart1' => 'The maximum number of memory mapped (mmap) regions was reached (%s): please increase the vm.max_map_count kernel config to 262144 to fix.',
            'mmapErrorPart2' => 'To fix, run the following command as root: %s',
            'mmapErrorPart3' => 'To persist the change across reboots: %s',
            'mmapErrorPart4' => 'On Windows and WSL, increasing the size of the pagefile might help; please switch to native Linux if the issue persists.',
            'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
            'nearest_dc' => 'We\'re in %s, nearest DC is %d.',
            'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
            'noReportPeers' => 'Warning: no report peers are set, please add the following method to your event handler',
            'non_text_conversion' => 'Can\'t convert non text messages yet!',
            'not_loggedIn' => 'I\'m not logged in!',
            'not_numeric' => 'Given value isn\'t numeric',
            'params_missing' => 'Missing required parameter',
            'peer_not_in_db' => 'This peer is not present in the internal peer database',
            'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
            'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
            'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
            'predicate_not_set' => 'Predicate (value under _) was not set!',
            'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
            'rpc_tg_error' => 'Telegram returned an RPC error: %s (%s), caused by %s:%s%sTL trace:',
            'sec_peer_not_in_db' => 'This secret peer is not present in the internal peer database',
            'secret_chat_skipping' => 'I do not have the secret chat %s in the database, skipping message...',
            'serialization_ofd' => 'Serialization is out of date, reconstructing object!',
            'session_corrupted' => 'The session is corrupted!',
            'signing_up' => 'Signing up as a normal user...',
            'signupFirstName' => 'Enter your first name: ',
            'signupFirstNameWeb' => 'First name',
            'signupLastName' => 'Enter your last name (can be empty): ',
            'signupLastNameWeb' => 'Last name',
            'signupWeb' => 'Sign up please',
            'signup_ok' => 'Signed up in successfully!',
            'signup_uncalled' => 'I\'m not waiting to signup! Please call the phoneLogin and the completePhoneLogin methods first!',
            'src_file_invalid' => 'Invalid source file was provided: ',
            'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
            'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
            'stream_handle_invalid' => 'An invalid stream handle was provided.',
            'string_required' => 'A string was expected!',
            'translate_madelineproto_cli' => 'MadelineProto can be translated in your language (current translation progress: %d%%), go to https://weblate.madelineproto.xyz to contribute with the translation!',
            'translate_madelineproto_web' => 'MadelineProto can be translated in your language (current translation progress: %d%%), click <a href="https://weblate.madelineproto.xyz" target="_blank">here to contribute with the translation!</a>',
            'type_extract_error' => 'Could not extract type "%s", you should update MadelineProto!',
            'type_extract_error_id' => 'Could not extract type: %s with id %s, you should update MadelineProto!',
            'update_madelineproto' => 'You\'re running an old version of MadelineProto, an update is required: currently running %s, but the latest version with multiple bugfixes and new features is %s!',
            'value_bigger_than_2147483647' => 'Provided value %s is bigger than 2147483647',
            'value_bigger_than_4294967296' => 'Provided value %s is bigger than 4294967296',
            'value_bigger_than_9223372036854775807' => 'Provided value %s is bigger than 9223372036854775807',
            'value_smaller_than_0' => 'Provided value %s is smaller than 0',
            'value_smaller_than_2147483648' => 'Provided value %s is smaller than -2147483648',
            'value_smaller_than_9223372036854775808' => 'Provided value %s is smaller than -9223372036854775808',
            'waveform_must_have_100_values' => 'A waveform array must have 100 values!',
            'waveform_value' => 'A waveform value must be between 0 and 31!',
            'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
        ],
        'fa' =>
        [
            '2fa_uncalled' => 'من منتظر کلمه عبور نیستم! لطفا اول توابع phoneLogin و completePhoneLogin را صدا بزنید!',
            'accepting_call' => 'در حال پذیرش تماس از طرف %s...',
            'account_banned' => '!!!!!!! اخطار !!!!!!!
سیستم جلوگیری از فلود تلگرام، این حساب را معلق کرده.
برای ادامه، تایید دستی نیاز است.
یک ایمیل به recover@telegram.org بفرستید، و از آنها آزادسازی شماره %s را جویا باشید، و کوتاه توضیح دهید که چه کاری با این شماره انجام خواهید داد.
سپس دوباره وارد شوید.
اگر از قصد این حساب را حذف کرده‌اید، این پیام را نادیده بگیرید.',
            'already_loggedIn' => 'نمونه‌ی MadelineProto از قبل وارد شده!',
            'apiAppInstructionsAuto0' => 'نام برنامه خود را وارد کنید، میتواند هرچیزی باشد ',
            'apiAppInstructionsAuto1' => 'نام مخفف برنامه‌تان را وارد کنید، 5 تا 32 کاراکتر الفبا اعداد: ',
            'apiAppInstructionsAuto2' => 'لینک برنامه/وبسایت را وارد کنید، یا t.me/yourusername: ',
            'apiAppInstructionsAuto3' => 'سکوی (پلتفرم) برنامه را وارد کنید: ',
            'apiAppInstructionsAuto4' => 'برنامه‌تان را توصیف کنید: ',
            'apiAppInstructionsAutoTypeOther' => 'مابقی (در توضیحات مشخص کنید)',
            'apiAppInstructionsManual0' => 'اسم اپلیکیشن شما، می‌تواند هرچیزی باشد',
            'apiAppInstructionsManual1' => 'اسم کوتاه اپلیکیشن شما، 5 تا 32 کاراکتر، حروف و اعداد انگلیسی',
            'apiAppInstructionsManual2' => 'لینک اپلیکیشن/وبسایت شما، یا t.me/yourusername',
            'apiAppInstructionsManual3' => 'هرچیزی',
            'apiAppInstructionsManual4' => 'اپلیکیشن خود را اینجا توصیف کنید',
            'apiAppWeb' => 'اطلاعات API را وارد کنید',
            'apiAutoPrompt0' => 'شماره‌ای را وارد کنید که از قبل در تلگرام ثبت‌نام کرده باشد: ',
            'apiAutoPrompt1' => 'کد تاییدی را که در تلگرام دریافت کردید، وارد کنید ',
            'apiAutoWeb' => 'برای دریافت API ID شماره‌ای را وارد کنید که از قبل در تلگرام <b>ثبت‌نام</b> کرده باشد',
            'apiChooseManualAutoTip' => 'در نظر داشته باشید که می‌توانید API ID و API Hash را به طور مستقیم داخل کدتان با استفاده از تنظیمات وارد کنید. %s',
            'apiChooseManualAutoTipWeb' => 'در نظر باشید که می‌توانید API ID و API Hash را به صورت مستقیم داخل کدتان با استفاده از <a target="_blank" href="%s">تنظیمات</a> وارد کنید.',
            'apiChoosePrompt' => 'انتخاب شما (m/a): ',
            'apiError' => 'ارور: %s. دوباره امتحان کنید.',
            'apiManualInstructions0' => 'وارد حساب خود در https://my.telegram.org شوید',
            'apiManualInstructions1' => 'به ابزارهای توسعه API بروید',
            'apiManualInstructions2' => 'روی create application کلیک کنید',
            'apiManualPrompt0' => 'API ID خود را وارد کنید: ',
            'apiManualPrompt1' => 'API Hash خود را وارد کنید: ',
            'apiManualWeb' => 'API ID و API HASH خود را وارد کنید',
            'apiParamsError' => 'شما تمام ورودی‌های موردنیاز را وارد نکردید!',
            'api_not_set' => 'شما باید یک api key و یک api id وارد کنید، @ خوتان را از my.telegram.org بگیرید',
            'array_invalid' => 'شما یک آرایه معتبر وارد نکردید',
            'baseDirLimitation' => 'یک محدودیت basedir پیکربندی شده است: این میتواند روی پرفورمنس تاثیر بگذارد و باعث ایجاد مشکلات شود، لطفا در صورت امکان آن را غیرفعال کنید!',
            'bool_error' => 'نمی‌توان‌ boolean را استخراج کرد',
            'botAlreadyRunning' => 'ربات هم اکنون در حال اجرا است!',
            'botapi_conversion_error' => 'نمیتوان %s را به شی ربات API تبدیل کرد',
            'call_already_accepted' => 'تماس %s از قبل پذیرفته شده',
            'call_already_declined' => 'تماس %s از قبل رد شده',
            'call_completing' => 'در حال کامل کردن تماس از طرف %s...',
            'call_confirming' => 'در حال تایید تماس از طرف %s...',
            'call_discarding' => 'درحال صرف نظر کردن از تماس %s...',
            'call_error_1' => 'نمی‌توان تماس %s را پیدا کرد و پذیرفت',
            'call_error_2' => 'نمی‌توان تماس %s را پیدا و تایید کرد',
            'call_error_3' => 'نمیتوان تماس %s را یافت و کامل کرد',
            'cli_need_dl.php_link' => 'لطفا هنگام استفاده از getDownloadLink روی CLI (محیط ترمینال)، لینک اسکریپت دانلود را مشخص کنید!',
            'constructor_not_found' => 'سازنده برای این نوع پیدا نشد: ',
            'could_not_connect_to_MadelineProto' => 'نمی توان به مدلین‌پروتو متصل شد، لطفاً proc_open را فعال کنید و محدودیت open_basedir را بردارید، یا بازنویسی مسیر وب سرور را غیرفعال کنید تا مشکل رفع شود! اگر این کار را کردید، مطمئن شوید که نسخه PHP در کامندلاین و وبسرور دقیقا یکی است (ورژن یکسان، افزونه‌های یکسان و...) و برای کسب اطلاعات بیشتر راجب اروری که مانع شروع IPC server میشود، فایل MadelineProto.log را بررسی کنید.',
            'could_not_convert_object' => 'نمیتوان مقدار آبجکت تایپ %s را تبدیل کرد',
            'deserialization_error' => 'مشکلی در سریال‌زدایی پیش آمد',
            'dl.php_check_logs_make_sure_session_running' => 'هم ربات ایونت‌هندلر مدلین‌پروتو مرتبط و هم سرور IPC مدلین‌پروتو آفلاین هستند، لطفا لاگ‌ها را بررسی کنید و مطمئن شوید حداقل یکی از آنها در حال اجراست!',
            'dl.php_powered_by_madelineproto' => 'سرور دانلود فایل تلگرام (تا حداکثر 4 گیگابایت)، قدرت گرفته از <a href="https://docs.madelineproto.xyz" target="_blank">مدلین‌پروتو</a>!<br>برای اطلاعات بیشتر در مورد طریقه اجرای سرور دانلود تلگرام شخصی خود <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">اینجا</a> کلیک کنید!',
            'do_not_delete_MadelineProto.log' => 'فایل MadelineProto.log هیچوقت نباید حذف شود، لطفا به جای حذف، بیشترین اندازه دلخواه را در تنظیمات مشخص کنید!',
            'do_not_remove_MadelineProto.log_phar' => 'لطفا madeline.phar یا madeline.php را حذف نکنید، در غیراینصورت مدلین‌پروتو crash خواهد کرد. در صورت داشتن هرگونه مشکل با مدلین‌پروتو، آن را به https://github.com/danog/MadelineProto یا https://t.me/pwrtelegramgroup گزارش کنید',
            'do_not_use_blocking_class' => 'به دلایل عملکردی و اجرایی، هندلرها نباید از کلس %s که async نیست استفاده کنند، به جای آن از %s استفاده کنید',
            'do_not_use_blocking_function' => 'به دلایل عملکردی و اجرایی، ایونت‌هندلرها نباید از فانکشن %s که async نیست استفاده کنند، لطفا به جای آن از %s استفاده کنید',
            'do_not_use_deprecated_function' => 'تابع %s منسوخ شده، لطفا به جای آن از %s استفاده کنید',
            'do_not_use_non_root_require_in_event_handler' => 'به دلایل عملکردی و اجرایی، شما نباید از require یا include داخل کلس ایونت‌هندلر استفاده کنید، فقط require های سطح root مجاز هستند.',
            'do_not_use_yield' => 'مدلین‌پروتو نسخه 8 نیازی به yield در توابع async ندارد و حتی آن را پشتیبانی هم نمیکند، شما باید تمام کلمات کلیدی yield را که قبلا در اجرای توابع async به کار میرفتند حذف کنید',
            'done' => 'انجام شد!',
            'encode_double_error' => 'نمی‌توان به درستی double را رمزنگاری (انکد) کرد',
            'extensionRecommended' => 'هشدار: افزونه %s نصب نشده است. لطفا برای افزایش سرعت مدلین‌پروتو آن را نصب کنید!',
            'extensionRequired' => 'مدلین برای اجرا نیاز به افزونه %s دارد. %s',
            'extensionRequiredInstallWithApt' => 'اجرای کامند sudo apt-get install %s را امتحان کنید.',
            'extensionRequiredInstallWithCustomInstructions' => 'برای نصب آن، دستورالعمل ها را در %s دنبال کنید.',
            'file_not_exist' => 'فایل وجود ندارد',
            'file_parsing' => 'درحال تجزیه %s...',
            'file_type_invalid' => 'نوع فایل نامعتبر شناسایی شد (%s)',
            'fingerprint_invalid' => 'اثرانگشت کلید نامعتبر است!',
            'go' => 'برو',
            'invalid_dl.php_session' => '%s یک اسکریپت دانلود درست و معتبر نیست چرا که سشن‌آیدی متفاوت است (انتظار این سشن‌آیدی وجود داشت: %s، اما این دریافت شد: %s)',
            'length_too_big' => 'طول بسیار بزرگ است',
            'loginBot' => 'توکن ربات‌تان را وارد کنید: ',
            'loginBotTokenWeb' => 'توکن ربات',
            'loginChoosePromptWeb' => 'میخواهید به عنوان یک کاربر یا به عنوان یک ربات، وارد شوید؟',
            'loginManual' => 'همچنین از سوی دیگر، میتوانید توکن ربات یا شماره تلفن خود را برای ورود خودکار وارد کنید: ',
            'loginNoCode' => 'شما کد شماره را وارد نکردید!',
            'loginNoName' => 'شما نام را وارد نکردید!',
            'loginNoPass' => 'شما کلمه عبور را وارد نکردید!',
            'loginOptionBot' => 'ربات',
            'loginOptionUser' => 'کاربر',
            'loginQr' => 'برای ورود خودکار QR Code بالا را اسکن کنید.',
            'loginQrCodeExpired' => 'QR Code منقضی شد، در حال ساخت QR code جدید...',
            'loginQrCodeSuccessful' => 'ورود با QR code با موفقیت انجام شد!',
            'loginUser' => 'شماره تلفن‌تان را وارد کنید: ',
            'loginUserCode' => 'کد را وارد کنید: ',
            'loginUserPass' => 'رمز خود را وارد کنید (اشاره %s): ',
            'loginUserPassHint' => 'اشاره: %s',
            'loginUserPassWeb' => 'رمز خود را وارد کنید: ',
            'loginUserPhoneCodeWeb' => 'کد',
            'loginUserPhoneWeb' => 'شماره تلفن',
            'loginWebQr' => 'همچنین میتوانید به صورت خودکار با اسکن QR Code پایین وارد شوید:',
            'loginWebQr1' => 'تلگرام را در موبایل خود باز کنید',
            'loginWebQr2' => 'بروید به تنظیمات > دستگاه‌ها > اتصال دستگاه دسکتاپ',
            'loginWebQr3' => 'گوشی خود را به سمت این صفحه بگیرید تا ورود را تایید کنید',
            'login_2fa_enabled' => 'احراز هویت دوعاملی فعال است، شما باید تابع complete2falogin را صدا بزنید...',
            'login_auth_key' => 'درحال ورود با استفاده از کلید هویتی...',
            'login_bot' => 'در حال ورود به عنوان یک ربات...',
            'login_code_sending' => 'در حال ارسال کد...',
            'login_code_sent' => 'کد با موفقیت ارسال شد! زمانی که کد را دریافت کردید باید از تابع completePhoneLogin استفاده کنید.',
            'login_code_uncalled' => 'من منتظر کد نیستم! لطفا اول تابع phoneLogin را صدا بزنید',
            'login_need_signup' => 'حسابی برای این شماره ساخته نشده‌است، شما باید تابع completeSignup را صدا بزنید...',
            'login_ok' => 'با موفقیت وارد شد!',
            'login_user' => 'در حال ورود به عنوان یک کاربر عادی...',
            'logout_ok' => 'با موفقیت خارج شد!',
            'long_not_16' => 'مقدار ورودی به طول 16 بایت نیست',
            'long_not_32' => 'مقدار ورودی به طول 32 بایت نیست',
            'long_not_64' => 'مقدار ورودی به طول 64 بایت نیست',
            'madelineproto_ready' => 'MadelineProto آماده است!',
            'manualAdminActionRequired' => '!!!!!!!!! فعالیت دستی ادمین سیستم نیاز است !!!!!!!!!',
            'method_not_found' => 'تابع پیدا نشد: ',
            'mmapErrorPart1' => 'بیشترین مقدار حافظه تخصیص داده شده (mmap ) پر شده است (%s ) : لطفا از داخل کانفیگ های مربوط به کرنل مقدار vm.max_map_count را به مقدار 262144 افزایش دهیدتا مشکل رفع گردد.',
            'mmapErrorPart2' => 'برای حل کردن مشکل، کامند مقابل را با دسترسی root اجرا کنید: %s',
            'mmapErrorPart3' => 'برای تداوم تغییر در طول راه‌اندازی دوباره: %s',
            'mmapErrorPart4' => 'روی ویندوز و WSL، افزایش سایز pagefile ممکن است کمک کند؛ اگر مشکل پافشاری کرد لطفا سیستم‌عامل خود را به لینوکس تغییر دهید.',
            'must_have_declare_types' => 'به دلایل عملکردی و اجرایی، اولین دستور فایل ایونت‌هندلر باید دستور مقابل باشد: "declare(strict_types=1);"',
            'nearest_dc' => 'ما در %s هستیم، نزدیک ترین دیتاسنتر %d است.',
            'need_dl.php' => 'اسکریپت دانلود پیشفرض تولید نشد (%s)، لطفا یک فایل dl.php بسیازید و این محتوا را در آن قرار دهید: %s سپس لینک آن فایل را به ورودی دوم getDownloadLink بدهید',
            'noReportPeers' => 'هشدار: هیچ peerی به عنوان peer گزارشات تنظیم نشده، لطفا متود زیر را به ایونت هندلر اضافه کنید',
            'non_text_conversion' => 'فعلا نمی‌توان پیام‌های غیرمتنی را تبدیل کرد!',
            'not_loggedIn' => 'من وارد نشدم!',
            'not_numeric' => 'مقدار ورودی عددی نیست',
            'params_missing' => 'ورودی موردنیاز یافت نشد',
            'peer_not_in_db' => 'این peer در پایگاه داده (دیتابیس) peer وجود ندارد',
            'plugin_path_does_not_exist' => 'مسیر پلاگین %s وجود ندارد!',
            'plugins_do_not_use_require' => 'به دلایل عملکردی و اجرایی، پلاگین‌ها فقط میتوانند فایل های دیگر را که در پوشه پلاگین هاست با استفاده از راه‌اندازی بارگذار خودکار PSR-4، به صورت خودکار include یا require کنند (بدون require کردن دستی آنها).',
            'plugins_must_have_exactly_one_class' => 'یک پلاگین باید دقیقا یک کلس را تعریف کند! برای تعریف چند کلس، اینترفیس یا تریت، فایل‌های جداگانه بسازید، آنها توسط مدلین‌پروتو به صورت خودکار بارگذاری خواهند شد.',
            'predicate_not_set' => 'مستند (مقدار تحت _) تنظیم نشده!',
            'recommend_not_use_filesystem_function' => 'استفاده از تابع %s پیشنهاد نمیشود، چراکه دسترسی و کار با فایل های سیستمی موقع پردازش آپدیت باعث کم شدن سرعت ربات شما میشود، لطفا صفحه https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions را ببینید تا با راه‌های جایگزین برای ذخیره اطلاعات که باعث کاهش سرعت ربات شما نمیشوند آشنا شوید!',
            'rpc_tg_error' => 'تلگرام یک خطای RPC برگرداند: %s (%s), ناشی از %s:%s%sTL رد:',
            'sec_peer_not_in_db' => 'این peer مخفی در پایگاه داده (دیتابیس) داخلی peer وجود ندارد',
            'secret_chat_skipping' => 'من چت مخفی (سکرت) %s را در پایگاه داده (دیتابیس) ندارم، درحال رد شدن از پیام...',
            'serialization_ofd' => 'مرتب سازی (سریالایز) منقضی شده، درحال بازسازی شی!',
            'session_corrupted' => 'سشن شما خراب است!',
            'signing_up' => 'در حال ثبت‌نام به عنوان یک کاربر عادی...',
            'signupFirstName' => 'نام خود را وارد کنید: ',
            'signupFirstNameWeb' => 'نام',
            'signupLastName' => 'نام خانوادگی خود را وارد کنید (می‌تواند خالی باشد): ',
            'signupLastNameWeb' => 'نام خانوادگی',
            'signupWeb' => 'لطفا ثبت‌نام کنید',
            'signup_ok' => 'با موفقیت ثبت‌نام شد!',
            'signup_uncalled' => 'من منتظر ساخت حساب نیستم! لطفا اول توابع phoneLogin و completePhoneLogin را صدا بزنید!',
            'src_file_invalid' => 'منبع فایل نامعتبری لحاظ گردیده: ',
            'static_analysis_minor' => 'یک مشکل جزئی در طول بررسی استاتیک %s رخ داد: %s',
            'static_analysis_severe' => 'یک مشکل سمت سرور در طول بررسی استاتیک %s رخ داد: %s',
            'stream_handle_invalid' => 'یک کنترل‌کننده جریان (استریم هندل) نامعتبر لحاظ گردیده.',
            'string_required' => 'مقدار مورد انتظار رشته است!',
            'translate_madelineproto_cli' => 'مدلین‌پروتو را می‌توان به زبان شما ترجمه کرد (پیشرفت ترجمه فعلی: %d%%)، برای مشارکت در ترجمه به https://weblate.madelineproto.xyz بروید!',
            'translate_madelineproto_web' => 'مدلین‌پروتو را می‌توان به زبان شما ترجمه کرد (پیشرفت ترجمه فعلی: %d%%)، برای مشارکت در ترجمه <a href="https://weblate.madelineproto.xyz" target="_blank">اینجا را کلیک کنید!</a >',
            'type_extract_error' => 'نمی‌توان نوع (تایپ) "%s" را استخراج کرد، شما باید MadelineProto را به روز رسانی کنید!',
            'type_extract_error_id' => 'نمی‌توان نوع: %s را با ایدی %s استخراج کرد، شما باید MadelineProto را به روز رسانی کنید!',
            'update_madelineproto' => 'شما نسخه قدیمی MadelineProto را اجرا می‌کنید، سورس شما نیاز به بروزرسانی دارد: در حال حاضر %s در حال اجرا است، اما آخرین نسخه با چندین رفع اشکال و ویژگی‌های جدید %s است!',
            'value_bigger_than_2147483647' => 'مقدار داده شده‌ی %s بیشتر از 2147483647 است',
            'value_bigger_than_4294967296' => 'مقدار داده شده‌ی %s بیشتر از 4294967296 است',
            'value_bigger_than_9223372036854775807' => 'مقدار داده شده‌ی %s بیشتر از 9223372036854775807 است',
            'value_smaller_than_0' => 'مقدار داده شده‌ی %s کمتر از 0 است',
            'value_smaller_than_2147483648' => 'مقدار داده شده‌ی %s کمتر از -2147483648 است',
            'value_smaller_than_9223372036854775808' => 'مقدار داده شده‌ی %s کمتر از -9223372036854775808 است',
            'waveform_must_have_100_values' => 'آرایه waveformباید 100 مقدار داشته باشد(سایز مورد انتظار 100 است ) !',
            'waveform_value' => 'مقدار عددیwaveform باید بین 0 تا 31 باشد!',
            'windows_warning' => 'برای کاربران ویندوزی: لطفا اگر این ناموفق بود به لینوکس کوچ کنید. همچنین میتوانید تلاش کنید تا تنظیمات فایروال خود را تغییر دهید تا به تمام پروسه‌های PHP اجازه ساخت سوکت را بدهید (100 درصد تغییر سیستم به لینوکس آسان‌تر است، مدلین‌پروتو در لینوکس خارج از باکس کار میکند، نیازی به تغییر ندارد)',
        ],
        'fr' =>
        [
            '2fa_uncalled' => 'I\'m not waiting for the password! Please call the phoneLogin and the completePhoneLogin methods first!',
            'accepting_call' => 'Acceptation de l\'appel de %s...',
            'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
            'already_loggedIn' => 'Cette instance de MadelineProto est déjà connectée!',
            'apiAppInstructionsAuto0' => 'Enter the app\'s name, can be anything: ',
            'apiAppInstructionsAuto1' => 'Enter the app\'s short name, alphanumeric, 5-32 characters: ',
            'apiAppInstructionsAuto2' => 'Enter the app/website\'s URL, or t.me/yourusername: ',
            'apiAppInstructionsAuto3' => 'Enter the app platform: ',
            'apiAppInstructionsAuto4' => 'Describe your app: ',
            'apiAppInstructionsAutoTypeOther' => 'Other (specify in description)',
            'apiAppInstructionsManual0' => 'your app\'s name, can be anything',
            'apiAppInstructionsManual1' => 'your app\'s short name, alphanumeric, 5-32 characters',
            'apiAppInstructionsManual2' => 'your app/website\'s URL, or t.me/yourusername',
            'apiAppInstructionsManual3' => 'anything',
            'apiAppInstructionsManual4' => 'Describe your app here',
            'apiAppWeb' => 'Enter API information',
            'apiAutoPrompt0' => 'Enter a phone number that is already registered on Telegram: ',
            'apiAutoPrompt1' => 'Entrez le code de vérification que vous avez reçu dans Telegram: ',
            'apiAutoWeb' => 'Enter a phone number that is <b>already registered</b> on telegram to get the API ID',
            'apiChooseManualAutoTip' => 'Note that you can also provide the API ID/hash directly in the code using the settings: %s',
            'apiChooseManualAutoTipWeb' => 'Note that you can also provide the API ID/hash directly in the code using the <a target="_blank" href="%s">settings</a>.',
            'apiChoosePrompt' => 'Your choice (m/a): ',
            'apiError' => 'ERREUR: %s. Essayez de nouveau.',
            'apiManualInstructions0' => 'Connectez-vous à https://my.telegram.org',
            'apiManualInstructions1' => 'Go to API development tools',
            'apiManualInstructions2' => 'Click on create application',
            'apiManualPrompt0' => 'Enter your API ID: ',
            'apiManualPrompt1' => 'Enter your API hash: ',
            'apiManualWeb' => 'Enter your API ID and API hash',
            'apiParamsError' => 'Vous n\'avez pas fourni tous les paramètres requis!',
            'api_not_set' => 'You must provide an api key and an api id, get your own @ my.telegram.org',
            'array_invalid' => 'Vous n\'avez pas fourni de tableau valide',
            'baseDirLimitation' => 'A basedir limitation is configured: this can impact performance and cause some issues, please disable it if possible!',
            'bool_error' => 'Could not extract boolean',
            'botAlreadyRunning' => 'The bot is already running!',
            'botapi_conversion_error' => 'Can\'t convert %s to a bot API object',
            'call_already_accepted' => 'Call %s already accepted',
            'call_already_declined' => 'Call %s already declined',
            'call_completing' => 'Fin de l\'appel de %s...',
            'call_confirming' => 'Confirmation de l\'appel de %s...',
            'call_discarding' => 'Abandon de l\'appel %s...',
            'call_error_1' => 'Impossible de trouver et d\'accepter l\'appel %s',
            'call_error_2' => 'Impossible de trouver et de confirmer l\'appel %s',
            'call_error_3' => 'Impossible de trouver et de terminer l\'appel %s',
            'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
            'constructor_not_found' => 'Constructor not found for type: ',
            'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
            'could_not_convert_object' => 'Could not convert object of type %s',
            'deserialization_error' => 'Une erreur s\'est produite lors de la désérialisation',
            'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
            'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
            'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
            'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
            'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
            'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
            'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
            'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
            'done' => 'Done!',
            'encode_double_error' => 'Could not properly encode double',
            'extensionRecommended' => 'Warning: the %s extension is not installed, please install it to speed up MadelineProto!',
            'extensionRequired' => 'MadelineProto requires the %s extension to run. %s',
            'extensionRequiredInstallWithApt' => 'Try running sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Follow the instructions at %s to install it.',
            'file_not_exist' => 'Le fichier n\'existe pas',
            'file_parsing' => 'Analyse de %s...',
            'file_type_invalid' => 'Invalid file type detected (%s)',
            'fingerprint_invalid' => 'Invalid key fingerprint!',
            'go' => 'Go',
            'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
            'length_too_big' => 'Length is too big',
            'loginBot' => 'Enter your bot token: ',
            'loginBotTokenWeb' => 'Bot token',
            'loginChoosePromptWeb' => 'Do you want to login as a user or as a bot?',
            'loginManual' => 'Alternatively, you can also enter a bot token or phone number to login manually: ',
            'loginNoCode' => 'You didn\'t provide a phone code!',
            'loginNoName' => 'Vous n\'avez pas fourni le prénom!',
            'loginNoPass' => 'Vous n\'avez pas fourni le mot de passe!',
            'loginOptionBot' => 'Bot',
            'loginOptionUser' => 'Utilisateur',
            'loginQr' => 'Scannez le code QR ci-dessus pour vous connecter automatiquement.',
            'loginQrCodeExpired' => 'The QR code expired, generating a new one...',
            'loginQrCodeSuccessful' => 'Connexion par code QR réussie!',
            'loginUser' => 'Entrez votre numéro de téléphone: ',
            'loginUserCode' => 'Entrez le code: ',
            'loginUserPass' => 'Entrez votre mot de passe (Indice %s): ',
            'loginUserPassHint' => 'Indice: %s',
            'loginUserPassWeb' => 'Entrez votre mot de passe: ',
            'loginUserPhoneCodeWeb' => 'Code',
            'loginUserPhoneWeb' => 'Numéro de téléphone',
            'loginWebQr' => 'Vous pouvez également vous connecter automatiquement en scannant le code QR suivant:',
            'loginWebQr1' => 'Ouvrez Telegram sur votre téléphone',
            'loginWebQr2' => 'Go to Settings > Devices > Link Desktop Device',
            'loginWebQr3' => 'Pointez votre téléphone vers cet écran pour confirmer la connexion',
            'login_2fa_enabled' => '2FA activé, vous devrez appeler la fonction complete2falogin...',
            'login_auth_key' => 'Logging in using auth key...',
            'login_bot' => 'Logging in as a bot...',
            'login_code_sending' => 'Envoi du code...',
            'login_code_sent' => 'Code envoyé avec succès! Une fois que vous avez reçu le code, vous devez utiliser la fonction completePhoneLogin.',
            'login_code_uncalled' => 'I\'m not waiting for the code! Please call the phoneLogin method first',
            'login_need_signup' => 'An account has not been created for this number, you will have to call the completeSignup function...',
            'login_ok' => 'Connecté avec succès!',
            'login_user' => 'Connexion en tant qu\'utilisateur normal...',
            'logout_ok' => 'Déconnecté avec succès!',
            'long_not_16' => 'La valeur donnée ne fait pas 16 octets',
            'long_not_32' => 'La valeur donnée ne fait pas 32 octets',
            'long_not_64' => 'La valeur donnée ne fait pas 64 octets',
            'madelineproto_ready' => 'MadelineProto est prêt!',
            'manualAdminActionRequired' => '!!!!!!!!! MANUAL SYSTEM ADMIN ACTION REQUIRED !!!!!!!!!',
            'method_not_found' => 'Could not find method: ',
            'mmapErrorPart1' => 'The maximum number of memory mapped (mmap) regions was reached (%s): please increase the vm.max_map_count kernel config to 262144 to fix.',
            'mmapErrorPart2' => 'To fix, run the following command as root: %s',
            'mmapErrorPart3' => 'To persist the change across reboots: %s',
            'mmapErrorPart4' => 'On Windows and WSL, increasing the size of the pagefile might help; please switch to native Linux if the issue persists.',
            'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
            'nearest_dc' => 'We\'re in %s, nearest DC is %d.',
            'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
            'noReportPeers' => 'Warning: no report peers are set, please add the following method to your event handler',
            'non_text_conversion' => 'Impossible de convertir des messages non textuels pour le moment!',
            'not_loggedIn' => 'I\'m not logged in!',
            'not_numeric' => 'La valeur donnée n\'est pas numérique',
            'params_missing' => 'Paramètre requis manquant',
            'peer_not_in_db' => 'This peer is not present in the internal peer database',
            'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
            'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
            'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
            'predicate_not_set' => 'Predicate (value under _) was not set!',
            'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
            'rpc_tg_error' => 'Telegram returned an RPC error: %s (%s), caused by %s:%s%sTL trace:',
            'sec_peer_not_in_db' => 'This secret peer is not present in the internal peer database',
            'secret_chat_skipping' => 'I do not have the secret chat %s in the database, skipping message...',
            'serialization_ofd' => 'La sérialisation est obsolète, reconstruction de l\'objet!',
            'session_corrupted' => 'La session est corrompue!',
            'signing_up' => 'Inscription en tant qu\'utilisateur normal...',
            'signupFirstName' => 'Entrez votre prénom: ',
            'signupFirstNameWeb' => 'Prénom',
            'signupLastName' => 'Entrez votre nom de famille (peut être vide): ',
            'signupLastNameWeb' => 'Nom de famille',
            'signupWeb' => 'Inscrivez-vous s\'il vous plaît',
            'signup_ok' => 'Inscription réussie!',
            'signup_uncalled' => 'I\'m not waiting to signup! Please call the phoneLogin and the completePhoneLogin methods first!',
            'src_file_invalid' => 'Invalid source file was provided: ',
            'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
            'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
            'stream_handle_invalid' => 'An invalid stream handle was provided.',
            'string_required' => 'A string was expected!',
            'translate_madelineproto_cli' => 'MadelineProto can be translated in your language (current translation progress: %d%%), go to https://weblate.madelineproto.xyz to contribute with the translation!',
            'translate_madelineproto_web' => 'MadelineProto can be translated in your language (current translation progress: %d%%), click <a href="https://weblate.madelineproto.xyz" target="_blank">here to contribute with the translation!</a>',
            'type_extract_error' => 'Could not extract type "%s", you should update MadelineProto!',
            'type_extract_error_id' => 'Could not extract type: %s with id %s, you should update MadelineProto!',
            'update_madelineproto' => 'You\'re running an old version of MadelineProto, an update is required: currently running %s, but the latest version with multiple bugfixes and new features is %s!',
            'value_bigger_than_2147483647' => 'La valeur fournie %s est supérieure à 2147483647',
            'value_bigger_than_4294967296' => 'La valeur fournie %s est supérieure à 4294967296',
            'value_bigger_than_9223372036854775807' => 'La valeur fournie %s est supérieure à 9223372036854775807',
            'value_smaller_than_0' => 'La valeur fournie %s est inférieure à 0',
            'value_smaller_than_2147483648' => 'La valeur fournie %s est inférieure à -2147483648',
            'value_smaller_than_9223372036854775808' => 'La valeur fournie %s est inférieure à -9223372036854775808',
            'waveform_must_have_100_values' => 'A waveform array must have 100 values!',
            'waveform_value' => 'A waveform value must be between 0 and 31!',
            'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
        ],
        'he' =>
        [
            '2fa_uncalled' => 'אני לא מחכה לסיסמא! עליך להשתמש בפונקציות phoneLogin ו- completePhoneLogin קודם!',
            'accepting_call' => 'מקבל שיחה מ %s...',
            'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
            'already_loggedIn' => 'מופע זה של MadelineProto כבר מחובר!',
            'apiAppInstructionsAuto0' => 'הזן את שם האפליקציה שלך, יכול להיות כל שם: ',
            'apiAppInstructionsAuto1' => 'הזן שם קצר לאפליקציה שלך, אותיות באנגלית בלבד, 5-32 תווים: ',
            'apiAppInstructionsAuto2' => 'הזן את הקישור לאפליקציה/לאתר שלך או t.me/yourusername: ',
            'apiAppInstructionsAuto3' => 'הזן את פלטופרמת האפליקציה: ',
            'apiAppInstructionsAuto4' => 'תאר את האפליקציה שלך: ',
            'apiAppInstructionsAutoTypeOther' => 'אחר (פרט בתיאור)',
            'apiAppInstructionsManual0' => 'שם האפליקציה שלך, יכול להיות כל שם',
            'apiAppInstructionsManual1' => 'שם קצר לאפליקציה שלך, אותיות באנגלית בלבד, 5-32 תווים',
            'apiAppInstructionsManual2' => 'קישור לאפליקציה/לאתר שלך או t.me/yourusername',
            'apiAppInstructionsManual3' => 'הכל',
            'apiAppInstructionsManual4' => 'תאר את האפליקציה שלך פה',
            'apiAppWeb' => 'הזן את פרטי ה API',
            'apiAutoPrompt0' => 'הזן את מספר הטלפון שכבר רשום בטלגרם: ',
            'apiAutoPrompt1' => 'הזן את קוד האימות שקיבלת באפליקצית טגלרם: ',
            'apiAutoWeb' => 'הזן את מספר הטלפון <b>שכבר רשום</b> בטלגרם כדי לקבל את ה API ID',
            'apiChooseManualAutoTip' => 'שים לב שאתה יכול גם לספק את מזהה ה-API/hash ישירות בקוד באמצעות ההגדרות: %s',
            'apiChooseManualAutoTipWeb' => 'שים לב שאתה יכול גם לספק את מזהה ה-API/hash ישירות בקוד באמצעות ה- <a target="_blank" href="%s">הגדרות</a>.',
            'apiChoosePrompt' => 'בחירתך (m/a): ',
            'apiError' => 'שגיאה: %s. נסה שנית.',
            'apiManualInstructions0' => 'התחבר ל https://my.telegram.org',
            'apiManualInstructions1' => 'לך ל API development tools',
            'apiManualInstructions2' => 'לחץ על create application',
            'apiManualPrompt0' => 'הזן את ה API ID שלך: ',
            'apiManualPrompt1' => 'הזן את ה API Hash שלך: ',
            'apiManualWeb' => 'הזן את API ID ו API hash',
            'apiParamsError' => 'לא סיפקת את כל הפרמטרים הנדרשים!',
            'api_not_set' => 'עליך להזין api key ו- api id משלך, קבל אחד בקישור @ my.telegram.org',
            'array_invalid' => 'לא סיפקת מערך חוקי',
            'baseDirLimitation' => 'A basedir limitation is configured: this can impact performance and cause some issues, please disable it if possible!',
            'bool_error' => 'לא ניתן היה לחלץ בוליאני',
            'botAlreadyRunning' => 'The bot is already running!',
            'botapi_conversion_error' => 'לא ניתן להמיר את %s לאובייקט bot API',
            'call_already_accepted' => 'שיחה %s כבר התקבלה',
            'call_already_declined' => 'שיחה %s כבר נדחתה',
            'call_completing' => 'משלים שיחה מ %s...',
            'call_confirming' => 'אישור שיחה מ %s...',
            'call_discarding' => 'ביטול שיחה %s...',
            'call_error_1' => 'לא ניתן היה למצוא ולקבל את השיחה %s',
            'call_error_2' => 'לא ניתן היה למצוא ולאשר את השיחה %s',
            'call_error_3' => 'לא ניתן היה למצוא ולהשלים את השיחה %s',
            'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
            'constructor_not_found' => 'הבנאי לא נמצא לסוג: ',
            'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
            'could_not_convert_object' => 'Could not convert object of type %s',
            'deserialization_error' => 'אירעה שגיאה בעת דה-סידריאליזציה',
            'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
            'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
            'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
            'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
            'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
            'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
            'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
            'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
            'done' => 'בוצע!',
            'encode_double_error' => 'לא ניתן היה לקודד כפול כראוי',
            'extensionRecommended' => 'Warning: the %s extension is not installed, please install it to speed up MadelineProto!',
            'extensionRequired' => 'MadelineProto requires the %s extension to run. %s',
            'extensionRequiredInstallWithApt' => 'Try running sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Follow the instructions at %s to install it.',
            'file_not_exist' => 'קובץ לא קיים',
            'file_parsing' => 'ממיר %s...',
            'file_type_invalid' => 'זוהה סוג קובץ לא חוקי (%s)',
            'fingerprint_invalid' => 'טביעת אצבע לא חוקית של מפתח!',
            'go' => 'קדימה',
            'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
            'length_too_big' => 'האורך גדול מדי',
            'loginBot' => 'הזן את הטוקן של הבוט שלך: ',
            'loginBotTokenWeb' => 'טוקן הבוט',
            'loginChoosePromptWeb' => 'האם ברצונך להתחבר כמשתמש או כבוט?',
            'loginManual' => 'לחלופין, אתה יכול גם להזין טורן של בוט או מספר טלפון כדי להתחבר באופן ידני: ',
            'loginNoCode' => 'לא הזנת קוד טלפון!',
            'loginNoName' => 'לא הזנהת את השם הפרטי!',
            'loginNoPass' => 'לא הזנת את הסיסמה!',
            'loginOptionBot' => 'בוט',
            'loginOptionUser' => 'משתמש',
            'loginQr' => 'סרוק את קוד ה-QR המופיע כדי להתחבר אוטומטית.',
            'loginQrCodeExpired' => 'פג תוקפו של קוד ה-QR, תיצרו קוד חדש...',
            'loginQrCodeSuccessful' => 'התחברות דרך קוד QR בוצעה בהצלחה!',
            'loginUser' => 'הזן את מספר הטלפון שלך: ',
            'loginUserCode' => 'הזן את הקוד: ',
            'loginUserPass' => 'הזן את הסיסמא שלך (רמז %s): ',
            'loginUserPassHint' => 'רמז: %s',
            'loginUserPassWeb' => 'הזן את הסיסמא שלך: ',
            'loginUserPhoneCodeWeb' => 'קוד',
            'loginUserPhoneWeb' => 'מספר טלפון',
            'loginWebQr' => 'ניתן גם להתחבר אוטומטית על ידי סריקת קוד ה-QR הבא:',
            'loginWebQr1' => 'פתח את טלגרם בטלפון שלך',
            'loginWebQr2' => 'עבור אל הגדרות > מכשירים > קישור מכשיר שולחן עבודה',
            'loginWebQr3' => 'כוון את הטלפון שלך למסך זה כדי לאשר את הכניסה',
            'login_2fa_enabled' => 'אימות דו שלבי מופעל, עליך להשתמש בפונקציית complete2falogin...',
            'login_auth_key' => 'מתחבר באמצעות מפתח אישור...',
            'login_bot' => 'מתחבר כבוט...',
            'login_code_sending' => 'שולח קוד...',
            'login_code_sent' => 'הקוד נשלח בהצלחה! לאחר שתקבל את הקוד, עליך להשתמש בפונקציית completePhoneLogin.',
            'login_code_uncalled' => 'אני לא מחכה לקוד! עליך להשתמש בפונקציית phoneLogin קודם!',
            'login_need_signup' => 'לא נוצר חשבון עבור מספר זה, עליך להשתמש בפונקציית completeSignup...',
            'login_ok' => 'התחברת בהצלחה!',
            'login_user' => 'מתחבר כמשתמש רגיל...',
            'logout_ok' => 'התנתק בהצלחה!',
            'long_not_16' => 'הערך הנתון אינו באורך 16 בתים',
            'long_not_32' => 'הערך הנתון אינו באורך 32 בתים',
            'long_not_64' => 'הערך הנתון אינו באורך 64 בתים',
            'madelineproto_ready' => 'MadelineProto מוכן!',
            'manualAdminActionRequired' => '!!!!!!!!! MANUAL SYSTEM ADMIN ACTION REQUIRED !!!!!!!!!',
            'method_not_found' => 'הפונקציה לא נמצא: ',
            'mmapErrorPart1' => 'The maximum number of memory mapped (mmap) regions was reached (%s): please increase the vm.max_map_count kernel config to 262144 to fix.',
            'mmapErrorPart2' => 'To fix, run the following command as root: %s',
            'mmapErrorPart3' => 'To persist the change across reboots: %s',
            'mmapErrorPart4' => 'On Windows and WSL, increasing the size of the pagefile might help; please switch to native Linux if the issue persists.',
            'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
            'nearest_dc' => 'אנחנו ב %s, חוות שרתי ה DC הקרובה היא %d.',
            'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
            'noReportPeers' => 'Warning: no report peers are set, please add the following method to your event handler',
            'non_text_conversion' => 'עדיין לא ניתן להמיר הודעות שאינן טקסט!',
            'not_loggedIn' => 'אני לא מחובר!',
            'not_numeric' => 'הערך הנתון אינו מספרי',
            'params_missing' => 'חסר פרמטר נדרש',
            'peer_not_in_db' => 'עמית זה לא קיים במסד הנתונים הפנימי של עמיתים',
            'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
            'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
            'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
            'predicate_not_set' => 'פרדיקט (ערך תחת _) לא הוגדר!',
            'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
            'rpc_tg_error' => 'טלגרם החזירה שגיאת RPC: %s (%s), נתפס ע"י %s:%s%sמעקב TL:',
            'sec_peer_not_in_db' => 'עמית סודי זה אינו קיים במסד הנתונים הפנימי של עמיתים',
            'secret_chat_skipping' => 'אין לי את הצ\'אט הסודי %s במסד הנתונים, דילוג על הודעה...',
            'serialization_ofd' => 'הסידרה לא מעודכנת, משחזרת אובייקט!',
            'session_corrupted' => 'הסשן פגום!',
            'signing_up' => 'נרשם כמשתמש רגיל...',
            'signupFirstName' => 'הזן את השם הפרטי שלך: ',
            'signupFirstNameWeb' => 'שם פרטי',
            'signupLastName' => 'הזן את שם המשפחה שלך (יכול להיות ריק): ',
            'signupLastNameWeb' => 'שם משפחה',
            'signupWeb' => 'הירשם בבקשה',
            'signup_ok' => 'נרשמת בהצלחה!',
            'signup_uncalled' => 'אני לא מחכה להירשם! עליך להשתמש בפונקציות phoneLogin ו- completePhoneLogin קודם!',
            'src_file_invalid' => 'סופק קובץ מקור לא חוקי: ',
            'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
            'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
            'stream_handle_invalid' => 'סופק stream handle לא חוקי',
            'string_required' => 'A string was expected!',
            'translate_madelineproto_cli' => 'MadelineProto can be translated in your language (current translation progress: %d%%), go to https://weblate.madelineproto.xyz to contribute with the translation!',
            'translate_madelineproto_web' => 'MadelineProto can be translated in your language (current translation progress: %d%%), click <a href="https://weblate.madelineproto.xyz" target="_blank">here to contribute with the translation!</a>',
            'type_extract_error' => 'לא ניתן היה לחלץ את הסוג "%s", נדרש לעדכן את MadelineProto!',
            'type_extract_error_id' => 'לא ניתן היה לחלץ את הסוג: %s עם מזהה id %s, נדרש לעדכן את MadelineProto!',
            'update_madelineproto' => 'You\'re running an old version of MadelineProto, an update is required: currently running %s, but the latest version with multiple bugfixes and new features is %s!',
            'value_bigger_than_2147483647' => 'הערך שהתקבל %s גדול מ 2147483647',
            'value_bigger_than_4294967296' => 'הערך שהתקבל %s גדול מ 4294967296',
            'value_bigger_than_9223372036854775807' => 'הערך שהתקבל %s גדול מ 9223372036854775807',
            'value_smaller_than_0' => 'הערך שהתקבל %s קטן מ 0',
            'value_smaller_than_2147483648' => 'הערך שהתקבל %s קטן מ -2147483648',
            'value_smaller_than_9223372036854775808' => 'הערך שהתקבל %s קטן מ -9223372036854775808',
            'waveform_must_have_100_values' => 'A waveform array must have 100 values!',
            'waveform_value' => 'A waveform value must be between 0 and 31!',
            'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
        ],
        'it' =>
        [
            '2fa_uncalled' => 'Non sto aspettando la password, chiama prima le funzioni phoneLogin e completePhoneLogin!',
            'accepting_call' => 'Sto accettando una chiamata da %s...',
            'account_banned' => '!!!!!!! ATTENZIONE !!!!!!!
Il sistema antispam di telegram ha sospeso questo account.
Per continuare, è richiesta una verifica manuale.
Mandare un\'email in inglese a recover@telegram.org, chiedendo di sbannare il numero di telefono %s, spiegando brevemente cosa si ha intenzione di fare con l\'account.
Poi rieseguite nuovamente il login.
Ignorare questo messaggio se la sessione è stata resettata intenzionalmente.',
            'already_loggedIn' => 'Questa istanza di MadelineProto è già loggata!',
            'apiAppInstructionsAuto0' => 'Inserisci il nome dell\'app, può essere qualsiasi cosa: ',
            'apiAppInstructionsAuto1' => 'Inserisci il nome ridotto dell\'app, caratteri alfanumerici: ',
            'apiAppInstructionsAuto2' => 'Inserisci il sito internet dell\'app, oppure t.me/username: ',
            'apiAppInstructionsAuto3' => 'Inserisci la piattaforma dell\'app: ',
            'apiAppInstructionsAuto4' => 'Descrivi la tua app: ',
            'apiAppInstructionsAutoTypeOther' => 'Altro (specificare nella descrizione)',
            'apiAppInstructionsManual0' => 'titolo dell\'app, può essere qualsiasi cosa',
            'apiAppInstructionsManual1' => 'il nome ridotto dell\'app, caratteri alfanumerici',
            'apiAppInstructionsManual2' => 'L\'indirizzo del tuo sito, oppure t.me/username',
            'apiAppInstructionsManual3' => 'Qualsiasi',
            'apiAppInstructionsManual4' => 'Descrivi la tua app',
            'apiAppWeb' => 'Inserire informazioni API',
            'apiAutoPrompt0' => 'Inserisci un numero di telefono che è già registrato su Telegram: ',
            'apiAutoPrompt1' => 'Inserisci il codice di verifica che hai ricevuto su Telegram: ',
            'apiAutoWeb' => 'Inserisci un numero di telefono <b>gi&agrave; registrato su Telegram</b> per ottenere l&apos;API ID',
            'apiChooseManualAutoTip' => 'Nota che puoi anche fornire i parametri API direttamente nelle impostazioni: %s',
            'apiChooseManualAutoTipWeb' => 'Nota che puoi anche fornire i parametri API direttamente nelle <a target="_blank" href="%s">impostazioni</a>.',
            'apiChoosePrompt' => 'La tua scelta (m/a): ',
            'apiError' => 'ERRORE: %s. Prova ancora.',
            'apiManualInstructions0' => 'Effettua il login su https://my.telegram.org',
            'apiManualInstructions1' => 'Vai su API development tools',
            'apiManualInstructions2' => 'Clicca su create application',
            'apiManualPrompt0' => 'Inserisci il tuo API ID: ',
            'apiManualPrompt1' => 'Inserisci il tuo API hash: ',
            'apiManualWeb' => 'Inserisci il tuo API ID e API hash',
            'apiParamsError' => 'Non hai fornito tutti i parametri richiesti!',
            'api_not_set' => 'Devi specificare una chiave ed un ID API, ottienili su https://my.telegram.org',
            'array_invalid' => 'Il valore fornito non è un array',
            'baseDirLimitation' => 'È presente una limitazione basedir: questo può impattare negativamente sulle performance e causare vari problemi, si prega di disabilitare le limitazioni basedir se possibile!',
            'bool_error' => 'Non sono riuscito ad estrarre un booleano',
            'botAlreadyRunning' => 'Il bot è già in esecuzione!',
            'botapi_conversion_error' => 'Non sono risucito a convertire %s in un oggetto bot API',
            'call_already_accepted' => 'La chiamata %s è già stata accettata',
            'call_already_declined' => 'La chiamata %s è già stata annullata',
            'call_completing' => 'Sto completando una chiamata da %s...',
            'call_confirming' => 'Sto confermando una chiamata da %s...',
            'call_discarding' => 'Sto rifiutando la chiamata %s...',
            'call_error_1' => 'Impossibile trovare ed accettare la chiamata %s',
            'call_error_2' => 'Impossibile trovare e confermare la chiamata %s',
            'call_error_3' => 'Impossibile trovare e completare la chiamata %s',
            'cli_need_dl.php_link' => 'È necessario specificare l\'URL dello script di scaricamente per usare getDownloadLink via CLI!',
            'constructor_not_found' => 'Costruttore non trovato per tipo: ',
            'could_not_connect_to_MadelineProto' => 'Non è stato possibile collegarsi a MadelineProto, per favore abilitare la funzione proc_open e rimuovere ogni limitazione open_basedir o disabilitare le rewrite lato server per fixare! Se l\'avete già fatto, assicuratevi che la versione PHP CLI è la stessa versione di PHP web (apache/php-fpm) (stessa versione, estensioni, eccetera) e controllate il file MadelineProto.log per più informazioni sull\'errore che ha impedito l\'avvio del server IPC.',
            'could_not_convert_object' => 'Non è stato possibile convertire l\'oggetto di tipo %s',
            'deserialization_error' => 'C\'è stato un errore durante la deserializzazione',
            'dl.php_check_logs_make_sure_session_running' => 'Sia l\'event handler associato al bot che il server IPC della sessione sono offline, controllare i log e assicurarsi che almeno uno dei due sia online!',
            'dl.php_powered_by_madelineproto' => 'Server di scaricamento file Telegram (fino a 4GB), creato usando <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Clicca <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">qui</a> per configurare il tuo personale server di scaricamento file Telegram!',
            'do_not_delete_MadelineProto.log' => 'il file MadelineProto.log non deve essere mai eliminato, per favore imposta una dimensione massima nelle impostazioni invece di eliminarlo!',
            'do_not_remove_MadelineProto.log_phar' => 'Per favore non rimuovere madeline.phar o madeline.php, o MadelineProto crasherà. Se hai problemi con MadelineProto, segnalali su https://github.com/danog/MadelineProto o https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'per motivi di performance, gli event handler non possono usare la classe bloccante non-asincrona %s, per favore usa %s',
            'do_not_use_blocking_function' => 'per motivi di performance, gli event handler non possono usare la funzione bloccante non asincrona %s, per favore usa %s',
            'do_not_use_deprecated_function' => 'la funzione %s è deprecata, per favore usa %s',
            'do_not_use_non_root_require_in_event_handler' => 'per motivi di performance, non è possibile usare require o include dentro l\'event handler, è possibile includere file solo all\'esterno della classe.',
            'do_not_use_yield' => 'MadelineProto 8 non richede e non supporta l\'uso della parola chiave yield in funzioni asincrono, è necessario rimuovere tutte gli yield usati in precedenza per chiamate a funzioni asincrone',
            'done' => 'Fatto!',
            'encode_double_error' => 'Non sono riuscito a codificare il numero a virgola mobile fornito',
            'extensionRecommended' => 'Attenzione: l\'estensione %s non è installata, si prega di installarla per velocizzare MadelineProto!',
            'extensionRequired' => 'MadelineProto richiede l\'estensione %s. %s',
            'extensionRequiredInstallWithApt' => 'Provate ad avviare sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Seguire le istruzioni su %s per installarla.',
            'file_not_exist' => 'Il file specificato non esiste',
            'file_parsing' => 'Leggendo %s...',
            'file_type_invalid' => 'È stato fornito un tipo file errato',
            'fingerprint_invalid' => 'fingerprint della chiave non valido!',
            'go' => 'Vai',
            'invalid_dl.php_session' => '%s non è uno script di scaricamento valido perché l\'ID della sessione non è corretto (mi aspettavo %s, ho ricevuto %s)',
            'length_too_big' => 'Il valore fornito è troppo lungo',
            'loginBot' => 'Inserisci il tuo bot token: ',
            'loginBotTokenWeb' => 'Token del bot',
            'loginChoosePromptWeb' => 'Vuoi effettuare il login come utente o come bot?',
            'loginManual' => 'In alternativa, puoi inserire un bot token o un numero di telefono per effettuare il login manualmente: ',
            'loginNoCode' => 'Non hai fornito un codice di verifica!',
            'loginNoName' => 'Non hai fornito un nome!',
            'loginNoPass' => 'Non hai fornito la password!',
            'loginOptionBot' => 'Bot',
            'loginOptionUser' => 'Utente',
            'loginQr' => 'Scansiona il codice QR per fare il login automaticamente.',
            'loginQrCodeExpired' => 'Il codice QR è scaduto, generazione di un nuovo codice QR in corso...',
            'loginQrCodeSuccessful' => 'Il login con codice QR è stato effettuato correttamente!',
            'loginUser' => 'Inserisci il tuo numero di telefono: ',
            'loginUserCode' => 'Inserisci il codice di verifica: ',
            'loginUserPass' => 'Inserisci la tua password (suggerimento %s): ',
            'loginUserPassHint' => 'Suggerimento: %s',
            'loginUserPassWeb' => 'Inserisci la tua password: ',
            'loginUserPhoneCodeWeb' => 'Codice di verifica',
            'loginUserPhoneWeb' => 'Numero di telefono',
            'loginWebQr' => 'Puoi anche effettuare il login automaticamente scansionando il seguente codice QR:',
            'loginWebQr1' => 'Apri Telegram sul tuo telefono',
            'loginWebQr2' => 'Vai su Impostazioni > Dispositivi > Collega dispositivo desktop',
            'loginWebQr3' => 'Inquadra il codice sullo schermo per completare il login',
            'login_2fa_enabled' => 'L\'autenticazione a due fattori è abilitata, dovrai chiamare il metodo complete2falogin...',
            'login_auth_key' => 'Sto facendo il login con la chiave di autorizzazione...',
            'login_bot' => 'Sto eseguendo il login come bot...',
            'login_code_sending' => 'Sto inviando il codice...',
            'login_code_sent' => 'Il codice è stato inviato correttamente! Una volta ricevuto il codice dovrai usare la funzione completePhoneLogin.',
            'login_code_uncalled' => 'Non sto aspettando il codice, usa prima la funzione phoneLogin!',
            'login_need_signup' => 'Questo numero non è registrato su telegram, dovrai chiamare la funzione completeSignup...',
            'login_ok' => 'Il login è stato eseguito correttamente!',
            'login_user' => 'Sto eseguendo il login come utente normale...',
            'logout_ok' => 'Il logout è stato eseguito correttamente!',
            'long_not_16' => 'Il valore fornito non è lungo 16 byte',
            'long_not_32' => 'Il valore fornito non è lungo 32 byte',
            'long_not_64' => 'Il valore fornito non è lungo 64 byte',
            'madelineproto_ready' => 'MadelineProto è pronto!',
            'manualAdminActionRequired' => '!!!!!!!!! È NECESSARIO L\'INTERVENTO DELL\'AMMINISTRATORE DI SISTEMA !!!!!!!!!',
            'method_not_found' => 'Impossibile trovare il seguente metodo: ',
            'mmapErrorPart1' => 'È stato raggiunto il limite massimo di regioni di memoria mappate (mmap, %s): è necessario incrementare il parametro di configurazione del kernel vm.max_map_count a 262144 per correggere l\'errore.',
            'mmapErrorPart2' => 'Per correggere l\'errore, avviare il seguente comando come root: %s',
            'mmapErrorPart3' => 'Per correggere l\'errore in modo permanente, anche dopo un riavvio: %s',
            'mmapErrorPart4' => 'Su Windows e WSL, potrebbe aiutare l\'incremento della dimensione del file di paginazione; passare a Linux nativo se il problema persiste.',
            'must_have_declare_types' => 'per motivi di performance, la prima riga del file contenente l\'event handler deve essere uguale a "declare(strict_types=1);"',
            'nearest_dc' => 'Siamo in %s, il DC più vicino è %d.',
            'need_dl.php' => 'Impossibile generare lo script di scaricamento di default (%s), è necessario creare un file dl.php con il seguente contenuto: %s e passare il suo URL al secondo parametro di getDownloadLink',
            'noReportPeers' => 'Attenzione: non è stato impostato alcun peer per la segnalazione errori, per favore aggiungi il seguente metodo all\'event handler',
            'non_text_conversion' => 'Non posso ancora convertire messaggi media!',
            'not_loggedIn' => 'Non ho ancora fatto il login!',
            'not_numeric' => 'Il valore fornito non è numerico',
            'params_missing' => 'Non hai fornito un parametro obbligatorio, rileggi la documentazione API',
            'peer_not_in_db' => 'Questo utente/gruppo/canale non è presente nel database interno MadelineProto',
            'plugin_path_does_not_exist' => 'La cartella dei plugin %s non esiste!',
            'plugins_do_not_use_require' => 'per motivi di performance, i plugin possono solo includere altri file presenti nella cartella plugins usando il meccanismo di autocaricamento PSR-4 (non usando require o include).',
            'plugins_must_have_exactly_one_class' => 'un plugin deve definire esattamente una classe! Per definire più classi, interfacce o trait, si prega di creare file separati, che verranno caricati da MadelineProto automaticamente.',
            'predicate_not_set' => 'Il predicato (valore sotto chiave _, esempio [\'_\' => \'inputPeer\']) non è impostato!',
            'recommend_not_use_filesystem_function' => 'l\'uso della funzione %s non è racommandato, perché l\'accesso al filesystem durante la gestione degli update rallenterà il bot, si prega di leggere https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions per una lista di modi alternativi per memorizzare informazioni in modi che non rallenteranno il tuo bot!',
            'rpc_tg_error' => 'Telegram ha ritornato un errore RPC: %s (%s), causato da %s:%s%sTL trace:',
            'sec_peer_not_in_db' => 'La chat segreta non è presente nel database interno MadelineProto',
            'secret_chat_skipping' => 'Non ho la chat segreta %s nel database, ignorando messaggio...',
            'serialization_ofd' => 'La serializzazione non è aggiornata, reistanziamento dell\'oggetto in corso!',
            'session_corrupted' => 'La sessione si è corrotta!',
            'signing_up' => 'Mi sto registrando su telegram come utente normale...',
            'signupFirstName' => 'Inserisci il tuo nome: ',
            'signupFirstNameWeb' => 'Nome',
            'signupLastName' => 'Inserisci il tuo cognome: ',
            'signupLastNameWeb' => 'Cognome',
            'signupWeb' => 'Registrazione',
            'signup_ok' => 'Mi sono registrato su Telegram!',
            'signup_uncalled' => 'Chiama prima le funzioni phoneLogin e completePhoneLogin!',
            'src_file_invalid' => 'È stato fornito un file sorgente non valido: ',
            'static_analysis_minor' => 'È stato riscontrato un problema minore durante l\'analisi statica di %s: %s',
            'static_analysis_severe' => 'È stato riscontrato un problema grave durante l\'analisi statica di %s: %s',
            'stream_handle_invalid' => 'Il valore fornito non è uno stream.',
            'string_required' => 'È richiesta una stringa!',
            'translate_madelineproto_cli' => 'MadelineProto può essere tradotto nella tua lingua (stato attuale della traduzione: %d%%), vai su https://weblate.madelineproto.xyz per contribuire alla traduzione!',
            'translate_madelineproto_web' => 'MadelineProto pu&ograve; essere tradotto nella tua lingua (stato attuale della traduzione: %d%%), cliccate  <a href="https://weblate.madelineproto.xyz" target="_blank">qui per contribuire alla traduzione!</a>',
            'type_extract_error' => 'Impossibile estrarre il tipo "%s", dovresti aggiornare MadelineProto!',
            'type_extract_error_id' => 'Non sono riuscito ad estrarre il tipo %s con ID %s, dovresti aggiornare MadelineProto!',
            'update_madelineproto' => 'Stai usando una vecchia versione di MadelineProto, è necessario un aggiornamento: la versione che stai usando adesso è %s, ma l\'ultima versione con tutti gli ultimi bugfix e tante nuove funzionalità è %s!',
            'value_bigger_than_2147483647' => 'Il valore fornito (%s) è maggiore di 2147483647',
            'value_bigger_than_4294967296' => 'Il valore fornito (%s) è maggiore di 4294967296',
            'value_bigger_than_9223372036854775807' => 'Il valore fornito (%s) è maggiore di 9223372036854775807',
            'value_smaller_than_0' => 'Il valore fornito (%s) è minore di 0',
            'value_smaller_than_2147483648' => 'Il valore fornito (%s) è minore di -2147483648',
            'value_smaller_than_9223372036854775808' => 'Il valore fornito (%s) è minore di -9223372036854775808',
            'waveform_must_have_100_values' => 'Una forma d\'onda deve essere un array contenente 100 valori!',
            'waveform_value' => 'Un singolo valore di una forma d\'onda deve essere compreso tra 0 e 31!',
            'windows_warning' => 'Per utenti Windows: per favore passate a Linux se questo passaggio fallisce. Per continuare ad usare Windows, potrebbe essere necessario modificare le impostazioni del firewall per permettere a tutti i processi PHP di creare socket (100% è più facile passare a Linux, su Linux MadelineProto funziona direttamente senza alcuna modifica richiesta)',
        ],
        'pt' =>
        [
            '2fa_uncalled' => 'I\'m not waiting for the password! Please call the phoneLogin and the completePhoneLogin methods first!',
            'accepting_call' => 'Accepting call from %s...',
            'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
            'already_loggedIn' => 'This instance of MadelineProto is already logged in!',
            'apiAppInstructionsAuto0' => 'Enter the app\'s name, can be anything: ',
            'apiAppInstructionsAuto1' => 'Enter the app\'s short name, alphanumeric, 5-32 characters: ',
            'apiAppInstructionsAuto2' => 'Enter the app/website\'s URL, or t.me/yourusername: ',
            'apiAppInstructionsAuto3' => 'Enter the app platform: ',
            'apiAppInstructionsAuto4' => 'Describe your app: ',
            'apiAppInstructionsAutoTypeOther' => 'Other (specify in description)',
            'apiAppInstructionsManual0' => 'your app\'s name, can be anything',
            'apiAppInstructionsManual1' => 'your app\'s short name, alphanumeric, 5-32 characters',
            'apiAppInstructionsManual2' => 'your app/website\'s URL, or t.me/yourusername',
            'apiAppInstructionsManual3' => 'anything',
            'apiAppInstructionsManual4' => 'Describe your app here',
            'apiAppWeb' => 'Enter API information',
            'apiAutoPrompt0' => 'Enter a phone number that is already registered on Telegram: ',
            'apiAutoPrompt1' => 'Enter the verification code you received in Telegram: ',
            'apiAutoWeb' => 'Enter a phone number that is <b>already registered</b> on telegram to get the API ID',
            'apiChooseManualAutoTip' => 'Note that you can also provide the API ID/hash directly in the code using the settings: %s',
            'apiChooseManualAutoTipWeb' => 'Note that you can also provide the API ID/hash directly in the code using the <a target="_blank" href="%s">settings</a>.',
            'apiChoosePrompt' => 'Your choice (m/a): ',
            'apiError' => 'ERROR: %s. Try again.',
            'apiManualInstructions0' => 'Login to https://my.telegram.org',
            'apiManualInstructions1' => 'Go to API development tools',
            'apiManualInstructions2' => 'Click on create application',
            'apiManualPrompt0' => 'Enter your API ID: ',
            'apiManualPrompt1' => 'Enter your API hash: ',
            'apiManualWeb' => 'Enter your API ID and API hash',
            'apiParamsError' => 'You didn\'t provide all of the required parameters!',
            'api_not_set' => 'You must provide an api key and an api id, get your own @ my.telegram.org',
            'array_invalid' => 'You didn\'t provide a valid array',
            'baseDirLimitation' => 'A basedir limitation is configured: this can impact performance and cause some issues, please disable it if possible!',
            'bool_error' => 'Could not extract boolean',
            'botAlreadyRunning' => 'The bot is already running!',
            'botapi_conversion_error' => 'Can\'t convert %s to a bot API object',
            'call_already_accepted' => 'Call %s already accepted',
            'call_already_declined' => 'Call %s already declined',
            'call_completing' => 'Completing call from %s...',
            'call_confirming' => 'Confirming call from %s...',
            'call_discarding' => 'Discarding call %s...',
            'call_error_1' => 'Could not find and accept call %s',
            'call_error_2' => 'Could not find and confirm call %s',
            'call_error_3' => 'Could not find and complete call %s',
            'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
            'constructor_not_found' => 'Constructor not found for type: ',
            'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
            'could_not_convert_object' => 'Could not convert object of type %s',
            'deserialization_error' => 'An error occurred on deserialization',
            'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
            'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
            'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
            'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
            'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
            'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
            'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
            'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
            'done' => 'Done!',
            'encode_double_error' => 'Could not properly encode double',
            'extensionRecommended' => 'Warning: the %s extension is not installed, please install it to speed up MadelineProto!',
            'extensionRequired' => 'MadelineProto requires the %s extension to run. %s',
            'extensionRequiredInstallWithApt' => 'Try running sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Follow the instructions at %s to install it.',
            'file_not_exist' => 'File does not exist',
            'file_parsing' => 'Parsing %s...',
            'file_type_invalid' => 'Invalid file type detected (%s)',
            'fingerprint_invalid' => 'Invalid key fingerprint!',
            'go' => 'Go',
            'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
            'length_too_big' => 'Length is too big',
            'loginBot' => 'Enter your bot token: ',
            'loginBotTokenWeb' => 'Bot token',
            'loginChoosePromptWeb' => 'Do you want to login as a user or as a bot?',
            'loginManual' => 'Alternatively, you can also enter a bot token or phone number to login manually: ',
            'loginNoCode' => 'You didn\'t provide a phone code!',
            'loginNoName' => 'You didn\'t provide the first name!',
            'loginNoPass' => 'You didn\'t provide the password!',
            'loginOptionBot' => 'Bot',
            'loginOptionUser' => 'User',
            'loginQr' => 'Scan the above QR code to login automatically.',
            'loginQrCodeExpired' => 'The QR code expired, generating a new one...',
            'loginQrCodeSuccessful' => 'QR code login successful!',
            'loginUser' => 'Enter your phone number: ',
            'loginUserCode' => 'Enter the code: ',
            'loginUserPass' => 'Enter your password (hint %s): ',
            'loginUserPassHint' => 'Hint: %s',
            'loginUserPassWeb' => 'Enter your password: ',
            'loginUserPhoneCodeWeb' => 'Code',
            'loginUserPhoneWeb' => 'Phone number',
            'loginWebQr' => 'You can also login automatically by scanning the following QR code:',
            'loginWebQr1' => 'Open Telegram on your phone',
            'loginWebQr2' => 'Go to Settings > Devices > Link Desktop Device',
            'loginWebQr3' => 'Point your phone at this screen to confirm login',
            'login_2fa_enabled' => '2FA enabled, you will have to call the complete2falogin function...',
            'login_auth_key' => 'Logging in using auth key...',
            'login_bot' => 'Logging in as a bot...',
            'login_code_sending' => 'Sending code...',
            'login_code_sent' => 'Code sent successfully! Once you receive the code you should use the completePhoneLogin function.',
            'login_code_uncalled' => 'I\'m not waiting for the code! Please call the phoneLogin method first',
            'login_need_signup' => 'An account has not been created for this number, you will have to call the completeSignup function...',
            'login_ok' => 'Logged in successfully!',
            'login_user' => 'Logging in as a normal user...',
            'logout_ok' => 'Logged out successfully!',
            'long_not_16' => 'Given value is not 16 bytes long',
            'long_not_32' => 'Given value is not 32 bytes long',
            'long_not_64' => 'Given value is not 64 bytes long',
            'madelineproto_ready' => 'MadelineProto is ready!',
            'manualAdminActionRequired' => '!!!!!!!!! MANUAL SYSTEM ADMIN ACTION REQUIRED !!!!!!!!!',
            'method_not_found' => 'Could not find method: ',
            'mmapErrorPart1' => 'The maximum number of memory mapped (mmap) regions was reached (%s): please increase the vm.max_map_count kernel config to 262144 to fix.',
            'mmapErrorPart2' => 'To fix, run the following command as root: %s',
            'mmapErrorPart3' => 'To persist the change across reboots: %s',
            'mmapErrorPart4' => 'On Windows and WSL, increasing the size of the pagefile might help; please switch to native Linux if the issue persists.',
            'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
            'nearest_dc' => 'We\'re in %s, nearest DC is %d.',
            'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
            'noReportPeers' => 'Warning: no report peers are set, please add the following method to your event handler',
            'non_text_conversion' => 'Can\'t convert non text messages yet!',
            'not_loggedIn' => 'I\'m not logged in!',
            'not_numeric' => 'Given value isn\'t numeric',
            'params_missing' => 'Missing required parameter',
            'peer_not_in_db' => 'This peer is not present in the internal peer database',
            'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
            'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
            'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
            'predicate_not_set' => 'Predicate (value under _) was not set!',
            'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
            'rpc_tg_error' => 'Telegram returned an RPC error: %s (%s), caused by %s:%s%sTL trace:',
            'sec_peer_not_in_db' => 'This secret peer is not present in the internal peer database',
            'secret_chat_skipping' => 'I do not have the secret chat %s in the database, skipping message...',
            'serialization_ofd' => 'Serialization is out of date, reconstructing object!',
            'session_corrupted' => 'The session is corrupted!',
            'signing_up' => 'Signing up as a normal user...',
            'signupFirstName' => 'Enter your first name: ',
            'signupFirstNameWeb' => 'First name',
            'signupLastName' => 'Enter your last name (can be empty): ',
            'signupLastNameWeb' => 'Last name',
            'signupWeb' => 'Sign up please',
            'signup_ok' => 'Signed up in successfully!',
            'signup_uncalled' => 'I\'m not waiting to signup! Please call the phoneLogin and the completePhoneLogin methods first!',
            'src_file_invalid' => 'Invalid source file was provided: ',
            'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
            'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
            'stream_handle_invalid' => 'An invalid stream handle was provided.',
            'string_required' => 'A string was expected!',
            'translate_madelineproto_cli' => 'MadelineProto can be translated in your language (current translation progress: %d%%), go to https://weblate.madelineproto.xyz to contribute with the translation!',
            'translate_madelineproto_web' => 'MadelineProto can be translated in your language (current translation progress: %d%%), click <a href="https://weblate.madelineproto.xyz" target="_blank">here to contribute with the translation!</a>',
            'type_extract_error' => 'Could not extract type "%s", you should update MadelineProto!',
            'type_extract_error_id' => 'Could not extract type: %s with id %s, you should update MadelineProto!',
            'update_madelineproto' => 'You\'re running an old version of MadelineProto, an update is required: currently running %s, but the latest version with multiple bugfixes and new features is %s!',
            'value_bigger_than_2147483647' => 'Provided value %s is bigger than 2147483647',
            'value_bigger_than_4294967296' => 'Provided value %s is bigger than 4294967296',
            'value_bigger_than_9223372036854775807' => 'Provided value %s is bigger than 9223372036854775807',
            'value_smaller_than_0' => 'Provided value %s is smaller than 0',
            'value_smaller_than_2147483648' => 'Provided value %s is smaller than -2147483648',
            'value_smaller_than_9223372036854775808' => 'Provided value %s is smaller than -9223372036854775808',
            'waveform_must_have_100_values' => 'A waveform array must have 100 values!',
            'waveform_value' => 'A waveform value must be between 0 and 31!',
            'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
        ],
        'ru' =>
        [
            '2fa_uncalled' => 'Я не жду сейчас пароля! Вызовите сначала методы phoneLogin и completePhoneLogin!',
            'accepting_call' => 'Принимяю звонок от %s...',
            'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
            'already_loggedIn' => 'Этот инстанс MadelineProto уже залогинен!',
            'apiAppInstructionsAuto0' => 'Введите имя приложения, может быть что угодно: ',
            'apiAppInstructionsAuto1' => 'Введите короткое имя вашего приложения, латиница и цифры, 5-32 букв: ',
            'apiAppInstructionsAuto2' => 'Введите ссылку на сайт вашего приложения, или t.me/yourusername: ',
            'apiAppInstructionsAuto3' => 'Введите платформу приложения: ',
            'apiAppInstructionsAuto4' => 'Опишите ваше приложение: ',
            'apiAppInstructionsAutoTypeOther' => 'Другое (указано в описании)',
            'apiAppInstructionsManual0' => 'Имя вашего приложения, что угодно',
            'apiAppInstructionsManual1' => 'короткое имя вашего приложения, латиница и цифры, 5-32 букв',
            'apiAppInstructionsManual2' => 'Ссылка на сайт важего приложения, или t.me/username',
            'apiAppInstructionsManual3' => 'что угодно',
            'apiAppInstructionsManual4' => 'Опишите ваше приложение сдесь',
            'apiAppWeb' => 'Введите API информацию',
            'apiAutoPrompt0' => 'Введите номер телефона который уже записан в Telegram: ',
            'apiAutoPrompt1' => 'Введите код проверки, который вы получили в Telegram: ',
            'apiAutoWeb' => 'Введите номер телефона который <b>уже записан</b> в Телеграме чтобы получить API ID',
            'apiChooseManualAutoTip' => 'Также можно указать API ID/hash сразу в коде используя настройки: %s',
            'apiChooseManualAutoTipWeb' => 'Также можно указать API ID/hash сразу в коде с помощью <a target="_blank" href="%s">настроек</a>.',
            'apiChoosePrompt' => 'Ваш выбор (m/a): ',
            'apiError' => 'ОШИБКА: %s. Попробуйте снова.',
            'apiManualInstructions0' => 'Залогинтесь в https://my.telegram.org',
            'apiManualInstructions1' => 'Нажмите на "API development tools"',
            'apiManualInstructions2' => 'Выберите "create application"',
            'apiManualPrompt0' => 'Введите ваш API ID: ',
            'apiManualPrompt1' => 'Введите ваш API hash: ',
            'apiManualWeb' => 'Введите ваш API ID и API hash',
            'apiParamsError' => 'Вы не заполнили все обязательные параметры!',
            'api_not_set' => 'Необходимо указать свой api ключ, достаньте свой @ my.telegram.org',
            'array_invalid' => 'Вы указали невалидный массив',
            'baseDirLimitation' => 'Настройка basedir сконфигурирована: это может повлиять на производительность и вызвать некоторые проблемы, отключите её если это возможно!',
            'bool_error' => 'Невозможно считать boolean',
            'botAlreadyRunning' => 'Бот уже запущен!',
            'botapi_conversion_error' => 'Can\'t convert %s to a bot API object',
            'call_already_accepted' => 'Звонок %s уже был принят',
            'call_already_declined' => 'Звонок %s уже был отвергнут',
            'call_completing' => 'Финализирую звонок от %s...',
            'call_confirming' => 'Подтверждаю звонок от %s...',
            'call_discarding' => 'Отвергаю звонок %s...',
            'call_error_1' => 'Не смог найти и принять звонок %s',
            'call_error_2' => 'Невозможно найти и подтвердить звонок %s',
            'call_error_3' => 'Невозможно найти и подтвердить звонок %s',
            'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
            'constructor_not_found' => 'Constructor not found for type: ',
            'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
            'could_not_convert_object' => 'Невозможно сконвертировать объект типа %s',
            'deserialization_error' => 'Произошла ошибка при deserialization',
            'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
            'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
            'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
            'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
            'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
            'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
            'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
            'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
            'done' => 'Готово!',
            'encode_double_error' => 'Невозможно создать double',
            'extensionRecommended' => 'Внимание: расширение %s не установлено, просьба его установить для ускорения MadelineProto!',
            'extensionRequired' => 'MadelineProto нуждается в расширении %s. %s',
            'extensionRequiredInstallWithApt' => 'Попробуйте запустить sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Следуйте инструкциям в %s для установки.',
            'file_not_exist' => 'Файл не существует',
            'file_parsing' => 'Чтение %s...',
            'file_type_invalid' => 'Invalid file type detected (%s)',
            'fingerprint_invalid' => 'Невалидный фингерпринт ключа!',
            'go' => 'ОК',
            'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
            'length_too_big' => 'Длина слишком большая',
            'loginBot' => 'Введите токен бота: ',
            'loginBotTokenWeb' => 'Токен бота',
            'loginChoosePromptWeb' => 'Авторизоваться как пользователь или как бот?',
            'loginManual' => 'Вы также можете ввести токен бота или номер телефона чтобы войти вручную: ',
            'loginNoCode' => 'Вы не ввели код!',
            'loginNoName' => 'Вы не ввели имя!',
            'loginNoPass' => 'Вы не ввели пароль!',
            'loginOptionBot' => 'Бот',
            'loginOptionUser' => 'Пользователь',
            'loginQr' => 'Отсканируйте QR код выше чтобы войти автоматически.',
            'loginQrCodeExpired' => 'QR код больше не действует, генерируем новый...',
            'loginQrCodeSuccessful' => 'Вход по QR коду прошел успешно!',
            'loginUser' => 'Номер телефона: ',
            'loginUserCode' => 'Введите код: ',
            'loginUserPass' => 'Введите ваш пароль (подсказка %s): ',
            'loginUserPassHint' => 'Подсказка: %s',
            'loginUserPassWeb' => 'Введите ваш пароль: ',
            'loginUserPhoneCodeWeb' => 'Код',
            'loginUserPhoneWeb' => 'Номер телефона',
            'loginWebQr' => 'Вы также можете войти, отсканировав QR код:',
            'loginWebQr1' => 'Откройте Telegram в вашем смартфоне',
            'loginWebQr2' => 'Откройте Настройки > Устройства > Подключить устройство',
            'loginWebQr3' => 'Наведите ваш смартфон на этот экран чтобы подтвердить вход',
            'login_2fa_enabled' => '2FA активно, вам необходимо сначала вызвать функцию complete2falogin...',
            'login_auth_key' => 'Вход с помощью ключа авторизации...',
            'login_bot' => 'Вхожу как бот...',
            'login_code_sending' => 'Отправка кода...',
            'login_code_sent' => 'Код успешно отправлен! Как только Вы получите код Вам нужно использовать функцию completePhoneLogin.',
            'login_code_uncalled' => 'Я не ожидаю код! Пожалуйста сначала вызовите метод phoneLogin',
            'login_need_signup' => 'На этот номер телефона не найдена учётная запись Телеграм...',
            'login_ok' => 'Мы залогинены!',
            'login_user' => 'Вхожу как пользователь...',
            'logout_ok' => 'Logout!',
            'long_not_16' => 'Длинна данного значения не равна 16 байтам',
            'long_not_32' => 'Длинна данного значения не равна 32 байтам',
            'long_not_64' => 'Длинна данного значения не равна 64 байтам',
            'madelineproto_ready' => 'MadelineProto готов!',
            'manualAdminActionRequired' => '!!!!!!!!! НЕОБХОДИМЫ РУЧНЫЕ ДЕЙСТВИЯ СИСТЕМНОГО АДМИНИСТРАТОРА !!!!!!!!!',
            'method_not_found' => 'Невозможно найти метод: ',
            'mmapErrorPart1' => 'Превышено максимальное количество маппированных зон памяти (%s, это НЕ потребление памяти, а mmap): пожалуйста увеличьте значение настройки ядра vm.max_map_count до 262144, чтобы исправить проблему.',
            'mmapErrorPart2' => 'Чтобы исправить, необходимо запустить эту команду как root: %s',
            'mmapErrorPart3' => 'Чтобы сохранить настройки даже после перезапуска: %s',
            'mmapErrorPart4' => 'На Windows и WSL, проблема может испариться при увеличении размера page file; пожалуйста перейдите на нативный Linux если это не исправит проблему.',
            'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
            'nearest_dc' => 'Вы в %s, ближайший ДЦ: %d.',
            'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
            'noReportPeers' => 'Внимание: не настроен ни один юзер для сообщения ошибок, пожалуйста добавьте этот метод в Event Handler',
            'non_text_conversion' => 'Can\'t convert non text messages yet!',
            'not_loggedIn' => 'Я вошёл в систему!',
            'not_numeric' => 'Данное значение не цифра',
            'params_missing' => 'Не хватает необходимого папаметра',
            'peer_not_in_db' => 'Этот peer не находится во внутренней базе',
            'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
            'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
            'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
            'predicate_not_set' => 'Предикат (значение под ключом _) не был указан!',
            'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
            'rpc_tg_error' => 'Телеграм возвратил RPC ошибку: %s (%s), из-за %s:%s%sTL trace:',
            'sec_peer_not_in_db' => 'Этого секретного чата нету во внутренней базе',
            'secret_chat_skipping' => 'I do not have the secret chat %s in the database, skipping message...',
            'serialization_ofd' => 'Сериализация старая, реконструкция объекта!',
            'session_corrupted' => 'Сессия повреждена!',
            'signing_up' => 'Вход под нормальным пользователем...',
            'signupFirstName' => 'Введите ваше имя: ',
            'signupFirstNameWeb' => 'Имя',
            'signupLastName' => 'Введите вашу фамилию (может быть пустым): ',
            'signupLastNameWeb' => 'Фамилия',
            'signupWeb' => 'Зарегистрируйтесь, пожалуйста',
            'signup_ok' => 'Запись прошла успешно!',
            'signup_uncalled' => 'Я не в процессе записи! Пожалуйста, вызовите сначала методы phoneLogin и completePhoneLogin!',
            'src_file_invalid' => 'Невалидный файл: ',
            'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
            'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
            'stream_handle_invalid' => 'Использован невалидный стрим.',
            'string_required' => 'Ожидана string!',
            'translate_madelineproto_cli' => 'MadelineProto можно локализировать на ваш язык (на данный момент переведено: %d%%), откройте https://weblate.madelineproto.xyz чтобы помочь с переводом!',
            'translate_madelineproto_web' => 'MadelineProto можно локализировать на ваш язык (на данный момент переведено: %d%%), кликните <a href="https://weblate.madelineproto.xyz" target="_blank">сюда чтобы помочь с переводом!</a>',
            'type_extract_error' => 'Невозможно распаковать тип "%s", необходимо обновить MadelineProto!',
            'type_extract_error_id' => 'Could not extract type: %s with id %s, you should update MadelineProto!',
            'update_madelineproto' => 'Вы используете старую версию MadelineProto, необходимо обновится: сейчас используется версия %s, но последняя версия со многими поправками и с новым функционалом - %s!',
            'value_bigger_than_2147483647' => 'Значение %s больше чем 2147483647',
            'value_bigger_than_4294967296' => 'Значение %s больше чем 4294967296',
            'value_bigger_than_9223372036854775807' => 'Значение %s больше чем 9223372036854775807',
            'value_smaller_than_0' => 'Значение %s меньше нуля',
            'value_smaller_than_2147483648' => 'Значение %s меньше чем -2147483648',
            'value_smaller_than_9223372036854775808' => 'Значение %s меньше чем -9223372036854775808',
            'waveform_must_have_100_values' => 'Массив waveform должен иметь 100 значений!',
            'waveform_value' => 'Значение waveform должно быть между 0 и 31!',
            'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
        ],
        'uz' =>
        [
            '2fa_uncalled' => 'Men parolni kutmayapman! Iltimos, birinchi navbatda phoneLogin va completePhoneLogin metodlarini ishga tushuring!',
            'accepting_call' => '%s qo‘ng‘irog‘i qabul qilinmoqda...',
            'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
            'already_loggedIn' => 'MadelineProto-ning bu nusxasi allaqachon tizimga kirgan!',
            'apiAppInstructionsAuto0' => 'Ilovangiz nomini kiriting: ',
            'apiAppInstructionsAuto1' => 'Ilovani qisqacha nomini kiriting, harflar va raqamlardan iborat 5-32 belgilar orasida ',
            'apiAppInstructionsAuto2' => 'Ilova yoki vebsay manzilini kiriting, yoki t.me/havola ',
            'apiAppInstructionsAuto3' => 'Ilova platformasini kiriting: ',
            'apiAppInstructionsAuto4' => 'Ilovangizni izohlang: ',
            'apiAppInstructionsAutoTypeOther' => 'Boshqa (izohda ko\'rsatiladi)',
            'apiAppInstructionsManual0' => 'sizning ilovangizni nomi, u istalgan ko\'rinishda bo\'lishi mumkin',
            'apiAppInstructionsManual1' => 'Ilovangizni qisqacha nomi, harflar va raqamlardan iborat 5-32 belgilar orasida',
            'apiAppInstructionsManual2' => 'Ilova yoki vebsaytingiz manzili, yoki t.me/havola',
            'apiAppInstructionsManual3' => 'istalgan narsa',
            'apiAppInstructionsManual4' => 'Ilovangizni izoh bering',
            'apiAppWeb' => 'API ma\'lumotlarini kiriting',
            'apiAutoPrompt0' => 'Telegram ro\'yhatdan o\'tkazilgan telefon raqamingizni kiriting ',
            'apiAutoPrompt1' => 'Telegramdan olgan tasdiqlash kodingizni kiriting ',
            'apiAutoWeb' => 'API ID olish uchun telegramdan oldin <b>ro\'yhatdan o\'tkazilgan</b> telefon raqamingizni kiriting',
            'apiChooseManualAutoTip' => 'Shuni esda tutingki, siz API ID/hashni to\'g\'ridan-to\'g\'ri kodda sozlamalardan foydalanib ko\'rsatishingiz mumkin: %s',
            'apiChooseManualAutoTipWeb' => 'Shuni esda tutingki, siz API identifikatorini/xesh-ni to\'g\'ridan-to\'g\'ri kodda <a target="_blank" href="%s">sozlamalardan</a> foydalanib ko\'rsatishingiz mumkin.',
            'apiChoosePrompt' => 'Sizning tanlovingiz (q/a): ',
            'apiError' => 'Xatolik: %s. Qayta urinib ko\'ring.',
            'apiManualInstructions0' => 'https://my.telegram.org ga kirish',
            'apiManualInstructions1' => 'API yaratish asboblariga o\'tish',
            'apiManualInstructions2' => 'Ilova yaratishga bosing',
            'apiManualPrompt0' => 'API ID qiymatingizni kiriting ',
            'apiManualPrompt1' => 'API hash qiymatingizni kiriting ',
            'apiManualWeb' => 'API ID va API hash qiymatlaringizni kiriting',
            'apiParamsError' => 'Siz barcha kerakli parametrlarni taqdim etmadingiz!',
            'api_not_set' => 'Siz api kaliti va api ID taqdim etishingiz kerak, o\'zingiz @ my.telegram.org manzilidan oling',
            'array_invalid' => 'Siz toʻgʻri massiv taqdim qilmadingiz',
            'baseDirLimitation' => 'A basedir limitation is configured: this can impact performance and cause some issues, please disable it if possible!',
            'bool_error' => 'Mantiqiy natija chiqarib bo\'lmadi',
            'botAlreadyRunning' => 'Bot allaqachon ishlayapti!',
            'botapi_conversion_error' => '%s bot API obyektiga aylantirib bo‘lmadi',
            'call_already_accepted' => '%s chaqiruvi allaqachon qabul qilingan',
            'call_already_declined' => '%s qo‘ng‘iroqlari allaqachon rad etilgan',
            'call_completing' => '%s qo‘ng‘irog‘i tugallanmoqda...',
            'call_confirming' => '%sdan qo‘ng‘iroq tasdiqlanmoqda...',
            'call_discarding' => '%s qo‘ng‘irog‘i bekor qilinmoqda...',
            'call_error_1' => '%s qo‘ng‘irog‘ini topib, qabul qilib bo‘lmadi',
            'call_error_2' => '%s qo‘ng‘irog‘i topilmadi va tasdiqlanmadi',
            'call_error_3' => '%s qo‘ng‘irog‘ini topib bo‘lmadi',
            'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
            'constructor_not_found' => 'Ushbu tur uchun konstruktor topilmadi: ',
            'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
            'could_not_convert_object' => 'Could not convert object of type %s',
            'deserialization_error' => 'Seriyadan chiqarishda xatolik yuz berdi',
            'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
            'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
            'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
            'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
            'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
            'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
            'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
            'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
            'done' => 'Bajarildi!',
            'encode_double_error' => 'Doubleni toʻgʻri kodlab boʻlmadi',
            'extensionRecommended' => 'Warning: the %s extension is not installed, please install it to speed up MadelineProto!',
            'extensionRequired' => 'MadelineProto requires the %s extension to run. %s',
            'extensionRequiredInstallWithApt' => 'Try running sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => 'Follow the instructions at %s to install it.',
            'file_not_exist' => 'Fayl mavjud emas',
            'file_parsing' => '%s tahlil qilinmoqda...',
            'file_type_invalid' => 'Yaroqsiz fayl turi aniqlandi (%s)',
            'fingerprint_invalid' => 'Barmoq izi yaroqsiz!',
            'go' => 'Boshlash',
            'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
            'length_too_big' => 'Uzunlik juda katta',
            'loginBot' => 'Bot tokeningizni kiriting ',
            'loginBotTokenWeb' => 'Bot tokeni',
            'loginChoosePromptWeb' => 'Foydalanuvchi sifatida yoki bot sifatida kirmoqchimisiz?',
            'loginManual' => 'Shu bilan bir qatorda, qo\'lda kirish uchun bot tokenini yoki telefon raqamini ham kiritishingiz mumkin: ',
            'loginNoCode' => 'Telefon raqamingiz kodini kiritmadingiz!',
            'loginNoName' => 'Ismingizni kiritmadingiz!',
            'loginNoPass' => 'Parolingizni kiritmadingiz!',
            'loginOptionBot' => 'Bot',
            'loginOptionUser' => 'Foydalanuvchi',
            'loginQr' => 'Avtomatik tarzda kirish uchun QR kodni skanerlang.',
            'loginQrCodeExpired' => 'QR kod eskirdi, yangisini yaratish...',
            'loginQrCodeSuccessful' => 'QR kod orqali muvaffaqiyatli kirish amalga oshirildi!',
            'loginUser' => 'Telefon raqamingizni kiriting ',
            'loginUserCode' => 'Kodni kiriting: ',
            'loginUserPass' => 'Parolingizni kiriting (eslatma %s): ',
            'loginUserPassHint' => 'Eslatma: %s',
            'loginUserPassWeb' => 'Parolingizni kiriting: ',
            'loginUserPhoneCodeWeb' => 'Kod',
            'loginUserPhoneWeb' => 'Telefon raqam',
            'loginWebQr' => 'Siz ushbu QR kodni skanerlagan holda, avtomatik tarzda kira olasiz:',
            'loginWebQr1' => 'Telegram dasturini telefoningizda oching',
            'loginWebQr2' => 'Sozlamalar > Uskunalar > Yangi qurilma ulashga o\'ting',
            'loginWebQr3' => 'Kirishni tasdiqlash uchun telefoningizni ushbu ekranga yo\'naltiring',
            'login_2fa_enabled' => '2FA faollashtirilgan, siz complete2falogin funksiyasini chaqirishingiz kerak bo\'ladi...',
            'login_auth_key' => 'auth keydan foydalanib kirish...',
            'login_bot' => 'Bot ko\'rinishida kirish...',
            'login_code_sending' => 'Kod yuborilmoqda...',
            'login_code_sent' => 'Kod muvaffaqiyatli yuborildi! Kodni olganingizdan so\'ng siz to\'liq PhoneLogin funksiyasidan foydalanishingiz kerak.',
            'login_code_uncalled' => 'Men kodni kutmayapman! Iltimos, avval phoneLogin funsksiyasini ishga tushuring',
            'login_need_signup' => 'Bu raqam uchun hisob yaratilmagan, siz completeSignup funksiyasidan foydalanishingiz kerak boʻladi...',
            'login_ok' => 'Kirish muvaffaqiyatli amalga oshirildi!',
            'login_user' => 'Odatiy foydalanuvchi kabi kirish...',
            'logout_ok' => 'Chiqish muvaffaqiyatli amalga oshirildi!',
            'long_not_16' => 'Berilgan qiymat 16 bayt emas',
            'long_not_32' => 'Berilgan qiymat 32 bayt emas',
            'long_not_64' => 'Berilgan qiymat 64 bayt emas',
            'madelineproto_ready' => 'MadelineProto tayyor!',
            'manualAdminActionRequired' => '!!!!!!!!! MANUAL SYSTEM ADMIN ACTION REQUIRED !!!!!!!!!',
            'method_not_found' => 'Metodni topib bo\'lmadi: ',
            'mmapErrorPart1' => 'The maximum number of memory mapped (mmap) regions was reached (%s): please increase the vm.max_map_count kernel config to 262144 to fix.',
            'mmapErrorPart2' => 'To fix, run the following command as root: %s',
            'mmapErrorPart3' => 'To persist the change across reboots: %s',
            'mmapErrorPart4' => 'On Windows and WSL, increasing the size of the pagefile might help; please switch to native Linux if the issue persists.',
            'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
            'nearest_dc' => 'Biz %s ichidamiz, eng yaqin shahar %d.',
            'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
            'noReportPeers' => 'Warning: no report peers are set, please add the following method to your event handler',
            'non_text_conversion' => 'Matnli boʻlmagan xabarlarni oʻzgartirib boʻlmaydi!',
            'not_loggedIn' => 'Kirish amalga oshirilmagan!',
            'not_numeric' => 'Kiritilgan qiymat raqamlar emas',
            'params_missing' => 'Talab etiladigan parametr kiritilmagan',
            'peer_not_in_db' => 'Bu obyekt ichki ma\'lumotlar bazasida mavjud emas',
            'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
            'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
            'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
            'predicate_not_set' => 'Predikat (_ ostidagi qiymat) belgilanmagan!',
            'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
            'rpc_tg_error' => 'Telegram RPC xatosini qaytardi: %s (%s), %s:%s%s TL izidan kelib chiqqan:',
            'sec_peer_not_in_db' => 'Ushbu maxfiy obyekt ichki obyektlar bazasida mavjud emas',
            'secret_chat_skipping' => 'Menda %s maxfiy chati maʼlumotlar bazasida yoʻq, xabar oʻtkazib yuborilmoqda...',
            'serialization_ofd' => 'Seriyalash eskirgan, ob\'ekt qayta tiklanmoqda!',
            'session_corrupted' => 'Sessiya buzilgan!',
            'signing_up' => 'Oddiy foydalanuvchi sifatida roʻyxatdan oʻtish...',
            'signupFirstName' => 'Ismingizni kiriting: ',
            'signupFirstNameWeb' => 'Ism',
            'signupLastName' => 'Familiyangizni kiriting (bo\'sh qoldirish mumkin): ',
            'signupLastNameWeb' => 'Familiya',
            'signupWeb' => 'Iltimos, ro\'yhatdan o\'ting',
            'signup_ok' => 'Muvaffaqiyatli ro\'yxatdan o\'tildi!',
            'signup_uncalled' => 'Men ro\'yxatdan o\'tishni kutmayman! Iltimos, birinchi navbatda phoneLogin va completePhoneLogin metodlarini ishga tushuring!',
            'src_file_invalid' => 'Yaroqsiz manba fayl taqdim etildi: ',
            'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
            'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
            'stream_handle_invalid' => 'Yaroqsiz oqim tutqichi taqdim etildi.',
            'string_required' => 'A string was expected!',
            'translate_madelineproto_cli' => 'MadelineProto can be translated in your language (current translation progress: %d%%), go to https://weblate.madelineproto.xyz to contribute with the translation!',
            'translate_madelineproto_web' => 'MadelineProto can be translated in your language (current translation progress: %d%%), click <a href="https://weblate.madelineproto.xyz" target="_blank">here to contribute with the translation!</a>',
            'type_extract_error' => '“%s” turini chiqarib bo‘lmadi, siz MadelineProtoni yangilashingiz kerak!',
            'type_extract_error_id' => 'Turni ajratib bo‘lmadi: %s identifikatori %s, siz MadelineProtoni yangilashingiz kerak!',
            'update_madelineproto' => 'You\'re running an old version of MadelineProto, an update is required: currently running %s, but the latest version with multiple bugfixes and new features is %s!',
            'value_bigger_than_2147483647' => 'Taqdim etilgan %s qiymati 2147483647 dan katta',
            'value_bigger_than_4294967296' => 'Taqdim etilgan %s qiymati 4294967296dan katta',
            'value_bigger_than_9223372036854775807' => 'Taqdim etilgan %s qiymati 9223372036854775807 dan katta',
            'value_smaller_than_0' => 'Taqdim etilgan %s qiymati 0 dan kichik',
            'value_smaller_than_2147483648' => 'Taqdim etilgan %s qiymati -2147483648dan kichik',
            'value_smaller_than_9223372036854775808' => 'Taqdim etilgan %s qiymati -9223372036854775808dan kichik',
            'waveform_must_have_100_values' => 'A waveform array must have 100 values!',
            'waveform_value' => 'A waveform value must be between 0 and 31!',
            'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
        ],
        'zh_Hans' =>
        [
            '2fa_uncalled' => '我不等你输入密码！请先调用 phoneLogin 和 completePhoneLogin 方法！',
            'accepting_call' => '正在接听来自 %s 的电话...',
            'account_banned' => '!!!!!!! 警告 !!!!!!!
Telegram 的防洪系统已暂停此帐户。
要继续，需要手动验证。
发送电子邮件至 recovery@telegram.org，要求解禁电话号码 %s，并简要描述您将如何处理此电话号码。
然后重新登录。
如果您有意删除此帐户，请忽略此消息。',
            'already_loggedIn' => 'MadelineProto 的这个实例已经登录！',
            'apiAppInstructionsAuto0' => '输入应用程序的名称，可以是任何内容： ',
            'apiAppInstructionsAuto1' => '输入应用程序的简称，字母数字，5-32个字符： ',
            'apiAppInstructionsAuto2' => '输入应用程序/网站的 URL，或 t.me/yourusername： ',
            'apiAppInstructionsAuto3' => '输入应用纲领： ',
            'apiAppInstructionsAuto4' => '描述你的应用： ',
            'apiAppInstructionsAutoTypeOther' => '其他（在描述中指定）',
            'apiAppInstructionsManual0' => '你的应用名称，可以是任意名称',
            'apiAppInstructionsManual1' => '您的应用的简称，字母数字，5-32 个字符',
            'apiAppInstructionsManual2' => '你的应用/网站的 URL，或者 t.me/yourusername',
            'apiAppInstructionsManual3' => '任何事',
            'apiAppInstructionsManual4' => '在此描述您的应用',
            'apiAppWeb' => '输入 API 信息',
            'apiAutoPrompt0' => '输入已经在 Telegram 注册的电话号码： ',
            'apiAutoPrompt1' => '输入您在 Telegram 中收到的验证码： ',
            'apiAutoWeb' => '输入<b>已在电报上注册</b>的电话号码以获取 API ID',
            'apiChooseManualAutoTip' => '请注意，您也可以使用以下设置直接在代码中提供 API ID/hash：％s',
            'apiChooseManualAutoTipWeb' => '请注意，您还可以使用<a target="_blank" href="%s">设置</a>直接在代码中提供 API ID/hash。',
            'apiChoosePrompt' => '您的选择 (m/a): ',
            'apiError' => '错误：%s. 请重试。',
            'apiManualInstructions0' => '登录 https://my.telegram.org',
            'apiManualInstructions1' => '前往API 开发工具',
            'apiManualInstructions2' => '点击创建应用程序',
            'apiManualPrompt0' => '输入您的 API ID： ',
            'apiManualPrompt1' => '输入您的 API hash： ',
            'apiManualWeb' => '输入您的 API ID 和 API hash',
            'apiParamsError' => '您没有提供所有必需的参数！',
            'api_not_set' => '您必须提供一个 api key 和一个 api id，请获取您自己的 @ my.telegram.org',
            'array_invalid' => '您没有提供有效的数组',
            'baseDirLimitation' => '配置了 basedir 限制：这可能会影响性能并导致一些问题，请尽可能禁用它！',
            'bool_error' => '无法提取布尔值',
            'botAlreadyRunning' => '机器人已开始运行！',
            'botapi_conversion_error' => '无法将 %s 转换为机器人 API 对象',
            'call_already_accepted' => '呼叫 %s 已被接受',
            'call_already_declined' => '已拒绝来电 %s',
            'call_completing' => '正在完成来自 %s 的呼叫...',
            'call_confirming' => '确认来自 %s 的呼叫...',
            'call_discarding' => '正在丢弃呼叫 %s...',
            'call_error_1' => '无法找到并接受呼叫 %s',
            'call_error_2' => '无法找到并确认呼叫 %s',
            'call_error_3' => '无法找到并完成呼叫 %s',
            'cli_need_dl.php_link' => '通过 CLI 使用 getDownloadLink 时，请指定下载脚本 URL！',
            'constructor_not_found' => '未找到该类型的构造函数： ',
            'could_not_connect_to_MadelineProto' => '无法连接到 MadelineProto，请启用 proc_open 并删除 open_basedir 限制或禁用 webserver 路径重写以进行修复！如果您已经这样做了，请确保 PHP 的 CLI 版本与 web 版本完全相同（相同的版本、扩展等），并查看 MadelineProto.log 文件以获取有关阻止 IPC 服务器启动的错误的更多信息。',
            'could_not_convert_object' => '无法转换 %s 类型的对象',
            'deserialization_error' => '反序列化时发生错误',
            'dl.php_check_logs_make_sure_session_running' => '相关的 MadelineProto EventHandler 机器人或 MadelineProto IPC 服务器处于离线状态，请检查日志并确保其中至少有一个正在运行！',
            'dl.php_powered_by_madelineproto' => 'Telegram 文件下载服务器（最高 4GB），由 <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a> 提供支持！<br>单击<a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">此处</a>了解有关如何设置您自己的 Telegram 文件下载服务器的更多信息！',
            'do_not_delete_MadelineProto.log' => '绝不能删除 MadelineProto.log 文件，请在设置中设置自定义最大大小！',
            'do_not_remove_MadelineProto.log_phar' => '请不要删除 madeline.phar 或 madeline.php，否则 MadelineProto 将崩溃。如果您对 MadelineProto 有任何问题，请报告给 https://github.com/danog/MadelineProto 或 https://t.me/pwrtelegramgroup',
            'do_not_use_blocking_class' => '出于性能原因，处理程序可能不会使用非异步阻塞类 %s，请改用 %s',
            'do_not_use_blocking_function' => '出于性能原因，事件处理程序可能不会使用非异步阻塞函数 %s，请改用 %s',
            'do_not_use_deprecated_function' => '%s 函数已弃用，请使用 %s 代替',
            'do_not_use_non_root_require_in_event_handler' => '出于性能原因，您不能在事件处理程序类中使用 require 或 include，只允许使用根级需要。',
            'do_not_use_yield' => 'MadelineProto 8 不要求或支持在异步函数中使用 Yield，您必须删除以前用于异步函数调用的所有 Yield 关键字',
            'done' => '完成！',
            'encode_double_error' => '无法正确编码双重',
            'extensionRecommended' => '警告：未安装 %s 扩展，请安装它以加快 MadelineProto 的速度！',
            'extensionRequired' => 'MadelineProto 需要 %s 扩展才能运行.%s',
            'extensionRequiredInstallWithApt' => '尝试运行 sudo apt-get install %s.',
            'extensionRequiredInstallWithCustomInstructions' => '按照 %s 中的说明进行安装。',
            'file_not_exist' => '文件不存在',
            'file_parsing' => '正在解析 %s...',
            'file_type_invalid' => '检测到无效的文件类型 (%s)',
            'fingerprint_invalid' => '密钥指纹无效！',
            'go' => '去',
            'invalid_dl.php_session' => '%s 不是有效的下载脚本，因为其会话 ID 不同（预期为 %s，实际为 %s）',
            'length_too_big' => '长度太大',
            'loginBot' => '输入您的机器人令牌： ',
            'loginBotTokenWeb' => '机器人令牌',
            'loginChoosePromptWeb' => '您想以用户身份还是机器人身份登录？',
            'loginManual' => '或者，您也可以输入机器人令牌或电话号码手动登录： ',
            'loginNoCode' => '您没有提供电话代码！',
            'loginNoName' => '您没有提供名字！',
            'loginNoPass' => '您没有提供密码！',
            'loginOptionBot' => '机器人',
            'loginOptionUser' => '用户',
            'loginQr' => '扫描以上二维码即可自动登录。',
            'loginQrCodeExpired' => 'QR 码已过期，正在生成新的 QR 码...',
            'loginQrCodeSuccessful' => '二维码登录成功！',
            'loginUser' => '输入你的电话号码： ',
            'loginUserCode' => '输入验证码： ',
            'loginUserPass' => '输入您的密码（提示 %s）： ',
            'loginUserPassHint' => '提示：%s',
            'loginUserPassWeb' => '输入您的密码： ',
            'loginUserPhoneCodeWeb' => '验证码',
            'loginUserPhoneWeb' => '电话号码',
            'loginWebQr' => '您也可以通过扫描以下二维码自动登录：',
            'loginWebQr1' => '在手机上打开 Telegram',
            'loginWebQr2' => '前往“设置”>“设备”>“链接桌面设备”',
            'loginWebQr3' => '将你的手机对准此屏幕以确认登录',
            'login_2fa_enabled' => '启用 2FA 后，您将必须调用 complete2falogin 函数...',
            'login_auth_key' => '使用身份验证密钥登录...',
            'login_bot' => '以机器人身份登录...',
            'login_code_sending' => '正在发送代码...',
            'login_code_sent' => '代码发送成功！收到代码后，您应该使用 completePhoneLogin 函数。',
            'login_code_uncalled' => '我不等代码了！请先调用 phoneLogin 方法',
            'login_need_signup' => '尚未为此号码创建帐户，您必须调用 completeSignup 函数...',
            'login_ok' => '登录成功！',
            'login_user' => '以普通用户身份登录...',
            'logout_ok' => '退出成功！',
            'long_not_16' => '给定值的长度不是 16 个字节',
            'long_not_32' => '给定值的长度不是 32 个字节',
            'long_not_64' => '给定值的长度不是 64 个字节',
            'madelineproto_ready' => 'MadelineProto 已准备好！',
            'manualAdminActionRequired' => '!!!!!!!!! 需要系统管理员手动操作 !!!!!!!!!',
            'method_not_found' => '找不到方法： ',
            'mmapErrorPart1' => '已达到内存映射（mmap）区域的最大数量（％s）：请将 vm.max_map_count 内核配置增加到 262144 进行修复。',
            'mmapErrorPart2' => '要修复此问题，请以 root 身份运行以下命令：％s',
            'mmapErrorPart3' => '要在重启后保留更改：％s',
            'mmapErrorPart4' => '在 Windows 和 WSL 上，增加页面文件的大小可能会有所帮助；如果问题仍然存在，请切换到原生 Linux。',
            'must_have_declare_types' => '出于性能原因，事件处理程序文件的第一个语句必须是“declare(strict_types=1);”',
            'nearest_dc' => '我们在 %s，最近的 DC 是 %d。',
            'need_dl.php' => '无法生成默认下载脚本（％s），请创建一个包含以下内容的 dl.php 文件：％s 并将其 URL 传递给 getDownloadLink 的第二个参数',
            'noReportPeers' => '警告：未设置报告对等体，请将以下方法添加到您的事件处理程序中',
            'non_text_conversion' => '尚无法转换非文本信息！',
            'not_loggedIn' => '我还没有登录！',
            'not_numeric' => '给定值不是数字',
            'params_missing' => '缺少必需参数',
            'peer_not_in_db' => '内部对等数据库中不存在此对等点',
            'plugin_path_does_not_exist' => '插件路径 %s 不存在！',
            'plugins_do_not_use_require' => '出于性能原因，插件只能通过触发 PSR-4 自动加载器来自动包含或需要插件文件夹中的其他文件（而不是通过手动 require() 它们）。',
            'plugins_must_have_exactly_one_class' => '一个插件必须定义一个类！要定义多个类、接口或特征，请创建单独的文件，它们将由 MadelineProto 自动加载。',
            'predicate_not_set' => '谓词（_ 下的值）未设置！',
            'recommend_not_use_filesystem_function' => '不建议使用 %s 函数，因为在更新处理期间访问文件系统会减慢您的机器人速度，请参阅 https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions 以获取不会减慢您的机器人速度的替代数据存储方法列表！',
            'rpc_tg_error' => 'Telegram 返回了 RPC 错误：%s（%s），由 %s:%s%sTL 跟踪导致：',
            'sec_peer_not_in_db' => '内部对等数据库中不存在此秘密对等体',
            'secret_chat_skipping' => '我的数据库中没有秘密聊天 %s，跳过消息...',
            'serialization_ofd' => '序列化已过时，正在重建对象！',
            'session_corrupted' => '会话已损坏！',
            'signing_up' => '正在注册为普通用户...',
            'signupFirstName' => '输入您的名字： ',
            'signupFirstNameWeb' => '名字',
            'signupLastName' => '输入您的姓氏（可以为空）： ',
            'signupLastNameWeb' => '姓氏',
            'signupWeb' => '请注册',
            'signup_ok' => '报名成功！',
            'signup_uncalled' => '我不等着注册！请先调用 phoneLogin 和 completePhoneLogin 方法！',
            'src_file_invalid' => '提供的源文件无效： ',
            'static_analysis_minor' => '对 %s 进行静态分析时遇到一个小问题：%s',
            'static_analysis_severe' => '对 %s 进行静态分析时遇到严重问题：%s',
            'stream_handle_invalid' => '提供了无效的流句柄。',
            'string_required' => '期望的是字符串！',
            'translate_madelineproto_cli' => 'MadelineProto 可以翻译成您的语言（当前翻译进度：%d%%)，请访问 https://weblate.madelineproto.xyz 为翻译做出贡献！',
            'translate_madelineproto_web' => 'MadelineProto 可以翻译成您的语言（当前翻译进度：%d%%），点击<a href="https://weblate.madelineproto.xyz" target="_blank">此处为翻译做出贡献！</a>',
            'type_extract_error' => '无法提取类型“%s”，您应该更新 MadelineProto！',
            'type_extract_error_id' => '无法提取类型：%s，ID 为 %s，您应该更新 MadelineProto！',
            'update_madelineproto' => '您正在运行旧版本的 MadelineProto，需要更新：当前运行 %s，但最新版本具有多项错误修复和新功能是 %s！',
            'value_bigger_than_2147483647' => '提供的值 %s 大于 2147483647',
            'value_bigger_than_4294967296' => '提供的值 %s 大于 4294967296',
            'value_bigger_than_9223372036854775807' => '提供的值 %s 大于 9223372036854775807',
            'value_smaller_than_0' => '提供的值 %s 小于 0',
            'value_smaller_than_2147483648' => '提供的值 %s 小于 -2147483648',
            'value_smaller_than_9223372036854775808' => '提供的值 %s 小于 -9223372036854775808',
            'waveform_must_have_100_values' => '波形数组必须有 100 个值！',
            'waveform_value' => '波形值必须介于0至31之间！',
            'windows_warning' => '对于 Windows 用户：如果失败，请切换到 Linux。您还可以尝试修改防火墙设置以允许所有 PHP 进程创建套接字（切换到 Linux 更容易，在 Linux 上 MadelineProto 开箱即用，无需进行任何更改）',
        ],
    ];

    // THIS WILL BE OVERWRITTEN BY $lang["en"]
    /** @var array<string, string> */
    public static array $current_lang = [
        '2fa_uncalled' => 'I\'m not waiting for the password! Please call the phoneLogin and the completePhoneLogin methods first!',
        'accepting_call' => 'Accepting call from %s...',
        'account_banned' => '!!!!!!! WARNING !!!!!!!
Telegram\'s flood prevention system suspended this account.
To continue, manual verification is required.
Send an email to recover@telegram.org, asking to unban the phone number %s, and shortly describe what will you do with this phone number.
Then login again.
If you intentionally deleted this account, ignore this message.',
        'already_loggedIn' => 'This instance of MadelineProto is already logged in!',
        'apiAppInstructionsAuto0' => 'Enter the app\'s name, can be anything: ',
        'apiAppInstructionsAuto1' => 'Enter the app\'s short name, alphanumeric, 5-32 characters: ',
        'apiAppInstructionsAuto2' => 'Enter the app/website\'s URL, or t.me/yourusername: ',
        'apiAppInstructionsAuto3' => 'Enter the app platform: ',
        'apiAppInstructionsAuto4' => 'Describe your app: ',
        'apiAppInstructionsAutoTypeOther' => 'Other (specify in description)',
        'apiAppInstructionsManual0' => 'your app\'s name, can be anything',
        'apiAppInstructionsManual1' => 'your app\'s short name, alphanumeric, 5-32 characters',
        'apiAppInstructionsManual2' => 'your app/website\'s URL, or t.me/yourusername',
        'apiAppInstructionsManual3' => 'anything',
        'apiAppInstructionsManual4' => 'Describe your app here',
        'apiAppWeb' => 'Enter API information',
        'apiAutoPrompt0' => 'Enter a phone number that is already registered on Telegram: ',
        'apiAutoPrompt1' => 'Enter the verification code you received in Telegram: ',
        'apiAutoWeb' => 'Enter a phone number that is <b>already registered</b> on telegram to get the API ID',
        'apiChooseManualAutoTip' => 'Note that you can also provide the API ID/hash directly in the code using the settings: %s',
        'apiChooseManualAutoTipWeb' => 'Note that you can also provide the API ID/hash directly in the code using the <a target="_blank" href="%s">settings</a>.',
        'apiChoosePrompt' => 'Your choice (m/a): ',
        'apiError' => 'ERROR: %s. Try again.',
        'apiManualInstructions0' => 'Login to https://my.telegram.org',
        'apiManualInstructions1' => 'Go to API development tools',
        'apiManualInstructions2' => 'Click on create application',
        'apiManualPrompt0' => 'Enter your API ID: ',
        'apiManualPrompt1' => 'Enter your API hash: ',
        'apiManualWeb' => 'Enter your API ID and API hash',
        'apiParamsError' => 'You didn\'t provide all of the required parameters!',
        'api_not_set' => 'You must provide an api key and an api id, get your own @ my.telegram.org',
        'array_invalid' => 'You didn\'t provide a valid array',
        'baseDirLimitation' => 'A basedir limitation is configured: this can impact performance and cause some issues, please disable it if possible!',
        'bool_error' => 'Could not extract boolean',
        'botAlreadyRunning' => 'The bot is already running!',
        'botapi_conversion_error' => 'Can\'t convert %s to a bot API object',
        'call_already_accepted' => 'Call %s already accepted',
        'call_already_declined' => 'Call %s already declined',
        'call_completing' => 'Completing call from %s...',
        'call_confirming' => 'Confirming call from %s...',
        'call_discarding' => 'Discarding call %s...',
        'call_error_1' => 'Could not find and accept call %s',
        'call_error_2' => 'Could not find and confirm call %s',
        'call_error_3' => 'Could not find and complete call %s',
        'cli_need_dl.php_link' => 'Please specify a download script URL when using getDownloadLink via CLI!',
        'constructor_not_found' => 'Constructor not found for type: ',
        'could_not_connect_to_MadelineProto' => 'Could not connect to MadelineProto, please enable proc_open and remove open_basedir restrictions or disable webserver path rewrites to fix! If you already did that, make sure the CLI version of PHP is exactly the same as the web version (same version, extensions, et cetera) and check out the MadelineProto.log file for more info about the error that prevented the IPC server from starting.',
        'could_not_convert_object' => 'Could not convert object of type %s',
        'deserialization_error' => 'An error occurred on deserialization',
        'dl.php_check_logs_make_sure_session_running' => 'Either the associated MadelineProto EventHandler bot or the MadelineProto IPC server are offline, please check logs and make sure at least one of them is running!',
        'dl.php_powered_by_madelineproto' => 'Telegram file download server (up to 4GB), powered by <a href="https://docs.madelineproto.xyz" target="_blank">MadelineProto</a>!<br>Click <a href="https://docs.madelineproto.xyz/docs/FILES.html#getting-a-download-link" target="_blank">here</a> for more info on how to setup your very own Telegram file download server!',
        'do_not_delete_MadelineProto.log' => 'the MadelineProto.log file must never be deleted, please set a custom max size in the settings, instead!',
        'do_not_remove_MadelineProto.log_phar' => 'Please do not remove madeline.phar or madeline.php, or else MadelineProto will crash. If you have any problem with MadelineProto, report it to https://github.com/danog/MadelineProto or https://t.me/pwrtelegramgroup',
        'do_not_use_blocking_class' => 'for performance reasons, handlers may not use the non-async blocking class %s, please use %s, instead',
        'do_not_use_blocking_function' => 'for performance reasons, event handlers may not use the non-async blocking function %s, please use %s, instead',
        'do_not_use_deprecated_function' => 'the %s function is deprecated, please use %s, instead',
        'do_not_use_non_root_require_in_event_handler' => 'for performance reasons, you must not use require or include inside of an event handler class, only root-level requires are allowed.',
        'do_not_use_yield' => 'MadelineProto 8 does not require or support the use of yield in async functions, you must remove all yield keywords previously used for async function calls',
        'done' => 'Done!',
        'encode_double_error' => 'Could not properly encode double',
        'extensionRecommended' => 'Warning: the %s extension is not installed, please install it to speed up MadelineProto!',
        'extensionRequired' => 'MadelineProto requires the %s extension to run. %s',
        'extensionRequiredInstallWithApt' => 'Try running sudo apt-get install %s.',
        'extensionRequiredInstallWithCustomInstructions' => 'Follow the instructions at %s to install it.',
        'file_not_exist' => 'File does not exist',
        'file_parsing' => 'Parsing %s...',
        'file_type_invalid' => 'Invalid file type detected (%s)',
        'fingerprint_invalid' => 'Invalid key fingerprint!',
        'go' => 'Go',
        'invalid_dl.php_session' => '%s is not a valid download script because its session ID is different (expected %s, got %s)',
        'length_too_big' => 'Length is too big',
        'loginBot' => 'Enter your bot token: ',
        'loginBotTokenWeb' => 'Bot token',
        'loginChoosePromptWeb' => 'Do you want to login as a user or as a bot?',
        'loginManual' => 'Alternatively, you can also enter a bot token or phone number to login manually: ',
        'loginNoCode' => 'You didn\'t provide a phone code!',
        'loginNoName' => 'You didn\'t provide the first name!',
        'loginNoPass' => 'You didn\'t provide the password!',
        'loginOptionBot' => 'Bot',
        'loginOptionUser' => 'User',
        'loginQr' => 'Scan the above QR code to login automatically.',
        'loginQrCodeExpired' => 'The QR code expired, generating a new one...',
        'loginQrCodeSuccessful' => 'QR code login successful!',
        'loginUser' => 'Enter your phone number: ',
        'loginUserCode' => 'Enter the code: ',
        'loginUserPass' => 'Enter your password (hint %s): ',
        'loginUserPassHint' => 'Hint: %s',
        'loginUserPassWeb' => 'Enter your password: ',
        'loginUserPhoneCodeWeb' => 'Code',
        'loginUserPhoneWeb' => 'Phone number',
        'loginWebQr' => 'You can also login automatically by scanning the following QR code:',
        'loginWebQr1' => 'Open Telegram on your phone',
        'loginWebQr2' => 'Go to Settings > Devices > Link Desktop Device',
        'loginWebQr3' => 'Point your phone at this screen to confirm login',
        'login_2fa_enabled' => '2FA enabled, you will have to call the complete2falogin function...',
        'login_auth_key' => 'Logging in using auth key...',
        'login_bot' => 'Logging in as a bot...',
        'login_code_sending' => 'Sending code...',
        'login_code_sent' => 'Code sent successfully! Once you receive the code you should use the completePhoneLogin function.',
        'login_code_uncalled' => 'I\'m not waiting for the code! Please call the phoneLogin method first',
        'login_need_signup' => 'An account has not been created for this number, you will have to call the completeSignup function...',
        'login_ok' => 'Logged in successfully!',
        'login_user' => 'Logging in as a normal user...',
        'logout_ok' => 'Logged out successfully!',
        'long_not_16' => 'Given value is not 16 bytes long',
        'long_not_32' => 'Given value is not 32 bytes long',
        'long_not_64' => 'Given value is not 64 bytes long',
        'madelineproto_ready' => 'MadelineProto is ready!',
        'manualAdminActionRequired' => '!!!!!!!!! MANUAL SYSTEM ADMIN ACTION REQUIRED !!!!!!!!!',
        'method_not_found' => 'Could not find method: ',
        'mmapErrorPart1' => 'The maximum number of memory mapped (mmap) regions was reached (%s): please increase the vm.max_map_count kernel config to 262144 to fix.',
        'mmapErrorPart2' => 'To fix, run the following command as root: %s',
        'mmapErrorPart3' => 'To persist the change across reboots: %s',
        'mmapErrorPart4' => 'On Windows and WSL, increasing the size of the pagefile might help; please switch to native Linux if the issue persists.',
        'must_have_declare_types' => 'for performance reasons, the first statement of an event handler file must be "declare(strict_types=1);"',
        'nearest_dc' => 'We\'re in %s, nearest DC is %d.',
        'need_dl.php' => 'Could not generate default download script (%s), please create a dl.php file with the following content: %s and pass its URL to the second parameter of getDownloadLink',
        'noReportPeers' => 'Warning: no report peers are set, please add the following method to your event handler',
        'non_text_conversion' => 'Can\'t convert non text messages yet!',
        'not_loggedIn' => 'I\'m not logged in!',
        'not_numeric' => 'Given value isn\'t numeric',
        'params_missing' => 'Missing required parameter',
        'peer_not_in_db' => 'This peer is not present in the internal peer database',
        'plugin_path_does_not_exist' => 'Plugin path %s does not exist!',
        'plugins_do_not_use_require' => 'for performance reasons, plugins can only automatically include or require other files present in the plugins folder by triggering the PSR-4 autoloader (not by manually require()\'ing them).',
        'plugins_must_have_exactly_one_class' => 'a plugin must define exactly one class! To define multiple classes, interfaces or traits, create separate files, they will be autoloaded by MadelineProto automatically.',
        'predicate_not_set' => 'Predicate (value under _) was not set!',
        'recommend_not_use_filesystem_function' => 'usage of the %s function is not recommended, because accessing the filesystem during update handling will slow down your bot, please see https://docs.madelineproto.xyz/docs/UPDATES.html#avoiding-the-use-of-filesystem-functions for a list of alternative ways to store data that will not slow down your bot!',
        'rpc_tg_error' => 'Telegram returned an RPC error: %s (%s), caused by %s:%s%sTL trace:',
        'sec_peer_not_in_db' => 'This secret peer is not present in the internal peer database',
        'secret_chat_skipping' => 'I do not have the secret chat %s in the database, skipping message...',
        'serialization_ofd' => 'Serialization is out of date, reconstructing object!',
        'session_corrupted' => 'The session is corrupted!',
        'signing_up' => 'Signing up as a normal user...',
        'signupFirstName' => 'Enter your first name: ',
        'signupFirstNameWeb' => 'First name',
        'signupLastName' => 'Enter your last name (can be empty): ',
        'signupLastNameWeb' => 'Last name',
        'signupWeb' => 'Sign up please',
        'signup_ok' => 'Signed up in successfully!',
        'signup_uncalled' => 'I\'m not waiting to signup! Please call the phoneLogin and the completePhoneLogin methods first!',
        'src_file_invalid' => 'Invalid source file was provided: ',
        'static_analysis_minor' => 'A minor issue was encountered during static analysis of %s: %s',
        'static_analysis_severe' => 'A severe issue was encountered during static analysis of %s: %s',
        'stream_handle_invalid' => 'An invalid stream handle was provided.',
        'string_required' => 'A string was expected!',
        'translate_madelineproto_cli' => 'MadelineProto can be translated in your language (current translation progress: %d%%), go to https://weblate.madelineproto.xyz to contribute with the translation!',
        'translate_madelineproto_web' => 'MadelineProto can be translated in your language (current translation progress: %d%%), click <a href="https://weblate.madelineproto.xyz" target="_blank">here to contribute with the translation!</a>',
        'type_extract_error' => 'Could not extract type "%s", you should update MadelineProto!',
        'type_extract_error_id' => 'Could not extract type: %s with id %s, you should update MadelineProto!',
        'update_madelineproto' => 'You\'re running an old version of MadelineProto, an update is required: currently running %s, but the latest version with multiple bugfixes and new features is %s!',
        'value_bigger_than_2147483647' => 'Provided value %s is bigger than 2147483647',
        'value_bigger_than_4294967296' => 'Provided value %s is bigger than 4294967296',
        'value_bigger_than_9223372036854775807' => 'Provided value %s is bigger than 9223372036854775807',
        'value_smaller_than_0' => 'Provided value %s is smaller than 0',
        'value_smaller_than_2147483648' => 'Provided value %s is smaller than -2147483648',
        'value_smaller_than_9223372036854775808' => 'Provided value %s is smaller than -9223372036854775808',
        'waveform_must_have_100_values' => 'A waveform array must have 100 values!',
        'waveform_value' => 'A waveform value must be between 0 and 31!',
        'windows_warning' => 'For Windows users: please switch to Linux if this fails. You can also try modifying the firewall settings to allow all PHP processes to create sockets (it\'s 100% easier to just switch to Linux, on Linux MadelineProto just works out of the box, no changes needed)',
    ];
}
