// ***************************************************************************
// 
// THIS FILE IS GENERATED BY "inv generate-nullables" DO NOT CHANGE MANUALLY!
// 
// ***************************************************************************
//
// *************************************************************************** }
//
// Delphi MVC Framework
//
// Copyright (c) 2010-2024 Daniele Teti and the DMVCFramework Team
//
// https://github.com/danieleteti/delphimvcframework
//
// ***************************************************************************
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


unit MVCFramework.Nullables;

interface

uses
  System.SysUtils, System.Classes, System.TypInfo, System.RTTI;

type
  EMVCNullable = class(Exception)

  end;

//**************************
// ** NullableString
//**************************

  NullableString = record
  private
    fValue: String;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: String;
    procedure SetValue(const Value: String);
    class operator Implicit(const Value: String): NullableString;
    class operator Implicit(const Value: NullableString): String;
    class operator Implicit(const Value: Pointer): NullableString;	
	  class operator Equal(LeftValue: NullableString; RightValue: NullableString) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableString contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableString contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: String;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableString): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: String): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: String read GetValue write SetValue;
  end;

//**************************
// ** NullableCurrency
//**************************

  NullableCurrency = record
  private
    fValue: Currency;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: Currency;
    procedure SetValue(const Value: Currency);
    class operator Implicit(const Value: Currency): NullableCurrency;
    class operator Implicit(const Value: NullableCurrency): Currency;
    class operator Implicit(const Value: Pointer): NullableCurrency;	
	  class operator Equal(LeftValue: NullableCurrency; RightValue: NullableCurrency) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableCurrency contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableCurrency contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: Currency;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableCurrency): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: Currency): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: Currency read GetValue write SetValue;
  end;

//**************************
// ** NullableBoolean
//**************************

  NullableBoolean = record
  private
    fValue: Boolean;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: Boolean;
    procedure SetValue(const Value: Boolean);
    class operator Implicit(const Value: Boolean): NullableBoolean;
    class operator Implicit(const Value: NullableBoolean): Boolean;
    class operator Implicit(const Value: Pointer): NullableBoolean;	
	  class operator Equal(LeftValue: NullableBoolean; RightValue: NullableBoolean) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableBoolean contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableBoolean contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: Boolean;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableBoolean): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: Boolean): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: Boolean read GetValue write SetValue;
  end;

//**************************
// ** NullableTDate
//**************************

  NullableTDate = record
  private
    fValue: TDate;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: TDate;
    procedure SetValue(const Value: TDate);
    class operator Implicit(const Value: TDate): NullableTDate;
    class operator Implicit(const Value: NullableTDate): TDate;
    class operator Implicit(const Value: Pointer): NullableTDate;	
	  class operator Equal(LeftValue: NullableTDate; RightValue: NullableTDate) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableTDate contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableTDate contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: TDate;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableTDate): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TDate): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: TDate read GetValue write SetValue;
  end;

//**************************
// ** NullableTTime
//**************************

  NullableTTime = record
  private
    fValue: TTime;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: TTime;
    procedure SetValue(const Value: TTime);
    class operator Implicit(const Value: TTime): NullableTTime;
    class operator Implicit(const Value: NullableTTime): TTime;
    class operator Implicit(const Value: Pointer): NullableTTime;	
	  class operator Equal(LeftValue: NullableTTime; RightValue: NullableTTime) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableTTime contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableTTime contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: TTime;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableTTime): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TTime): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: TTime read GetValue write SetValue;
  end;

//**************************
// ** NullableTDateTime
//**************************

  NullableTDateTime = record
  private
    fValue: TDateTime;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: TDateTime;
    procedure SetValue(const Value: TDateTime);
    class operator Implicit(const Value: TDateTime): NullableTDateTime;
    class operator Implicit(const Value: NullableTDateTime): TDateTime;
    class operator Implicit(const Value: Pointer): NullableTDateTime;	
	  class operator Equal(LeftValue: NullableTDateTime; RightValue: NullableTDateTime) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableTDateTime contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableTDateTime contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: TDateTime;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableTDateTime): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TDateTime): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: TDateTime read GetValue write SetValue;
  end;

//**************************
// ** NullableSingle
//**************************

  NullableSingle = record
  private
    fValue: Single;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: Single;
    procedure SetValue(const Value: Single);
    class operator Implicit(const Value: Single): NullableSingle;
    class operator Implicit(const Value: NullableSingle): Single;
    class operator Implicit(const Value: Pointer): NullableSingle;	
	  class operator Equal(LeftValue: NullableSingle; RightValue: NullableSingle) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableSingle contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableSingle contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: Single;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableSingle): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: Single): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: Single read GetValue write SetValue;
  end;

//**************************
// ** NullableDouble
//**************************

  NullableDouble = record
  private
    fValue: Double;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: Double;
    procedure SetValue(const Value: Double);
    class operator Implicit(const Value: Double): NullableDouble;
    class operator Implicit(const Value: NullableDouble): Double;
    class operator Implicit(const Value: Pointer): NullableDouble;	
	  class operator Equal(LeftValue: NullableDouble; RightValue: NullableDouble) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableDouble contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableDouble contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: Double;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableDouble): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: Double): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: Double read GetValue write SetValue;
  end;

//**************************
// ** NullableExtended
//**************************

  NullableExtended = record
  private
    fValue: Extended;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: Extended;
    procedure SetValue(const Value: Extended);
    class operator Implicit(const Value: Extended): NullableExtended;
    class operator Implicit(const Value: NullableExtended): Extended;
    class operator Implicit(const Value: Pointer): NullableExtended;	
	  class operator Equal(LeftValue: NullableExtended; RightValue: NullableExtended) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableExtended contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableExtended contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: Extended;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableExtended): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: Extended): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: Extended read GetValue write SetValue;
  end;

//**************************
// ** NullableInt16
//**************************

  NullableInt16 = record
  private
    fValue: Int16;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: Int16;
    procedure SetValue(const Value: Int16);
    class operator Implicit(const Value: Int16): NullableInt16;
    class operator Implicit(const Value: NullableInt16): Int16;
    class operator Implicit(const Value: Pointer): NullableInt16;	
	  class operator Equal(LeftValue: NullableInt16; RightValue: NullableInt16) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableInt16 contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableInt16 contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: Int16;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableInt16): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: Int16): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: Int16 read GetValue write SetValue;
  end;

//**************************
// ** NullableUInt16
//**************************

  NullableUInt16 = record
  private
    fValue: UInt16;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: UInt16;
    procedure SetValue(const Value: UInt16);
    class operator Implicit(const Value: UInt16): NullableUInt16;
    class operator Implicit(const Value: NullableUInt16): UInt16;
    class operator Implicit(const Value: Pointer): NullableUInt16;	
	  class operator Equal(LeftValue: NullableUInt16; RightValue: NullableUInt16) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableUInt16 contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableUInt16 contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: UInt16;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableUInt16): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: UInt16): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: UInt16 read GetValue write SetValue;
  end;

//**************************
// ** NullableInt32
//**************************

  NullableInt32 = record
  private
    fValue: Int32;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: Int32;
    procedure SetValue(const Value: Int32);
    class operator Implicit(const Value: Int32): NullableInt32;
    class operator Implicit(const Value: NullableInt32): Int32;
    class operator Implicit(const Value: Pointer): NullableInt32;	
	  class operator Equal(LeftValue: NullableInt32; RightValue: NullableInt32) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableInt32 contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableInt32 contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: Int32;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableInt32): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: Int32): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: Int32 read GetValue write SetValue;
  end;

//**************************
// ** NullableUInt32
//**************************

  NullableUInt32 = record
  private
    fValue: UInt32;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: UInt32;
    procedure SetValue(const Value: UInt32);
    class operator Implicit(const Value: UInt32): NullableUInt32;
    class operator Implicit(const Value: NullableUInt32): UInt32;
    class operator Implicit(const Value: Pointer): NullableUInt32;	
	  class operator Equal(LeftValue: NullableUInt32; RightValue: NullableUInt32) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableUInt32 contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableUInt32 contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: UInt32;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableUInt32): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: UInt32): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: UInt32 read GetValue write SetValue;
  end;

//**************************
// ** NullableInt64
//**************************

  NullableInt64 = record
  private
    fValue: Int64;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: Int64;
    procedure SetValue(const Value: Int64);
    class operator Implicit(const Value: Int64): NullableInt64;
    class operator Implicit(const Value: NullableInt64): Int64;
    class operator Implicit(const Value: Pointer): NullableInt64;	
	  class operator Equal(LeftValue: NullableInt64; RightValue: NullableInt64) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableInt64 contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableInt64 contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: Int64;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableInt64): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: Int64): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: Int64 read GetValue write SetValue;
  end;

//**************************
// ** NullableUInt64
//**************************

  NullableUInt64 = record
  private
    fValue: UInt64;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: UInt64;
    procedure SetValue(const Value: UInt64);
    class operator Implicit(const Value: UInt64): NullableUInt64;
    class operator Implicit(const Value: NullableUInt64): UInt64;
    class operator Implicit(const Value: Pointer): NullableUInt64;	
	  class operator Equal(LeftValue: NullableUInt64; RightValue: NullableUInt64) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableUInt64 contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableUInt64 contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: UInt64;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableUInt64): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: UInt64): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: UInt64 read GetValue write SetValue;
  end;

//**************************
// ** NullableTGUID
//**************************

  NullableTGUID = record
  private
    fValue: TGUID;
    fHasValue: String;
    function GetHasValue: Boolean;
	function GetIsNull: Boolean;	
  public
    procedure CheckHasValue;
    function GetValue: TGUID;
    procedure SetValue(const Value: TGUID);
    class operator Implicit(const Value: TGUID): NullableTGUID;
    class operator Implicit(const Value: NullableTGUID): TGUID;
    class operator Implicit(const Value: Pointer): NullableTGUID;	
	  class operator Equal(LeftValue: NullableTGUID; RightValue: NullableTGUID) : Boolean;	
    ///<summary>
    ///Returns `True` if the NullableTGUID contains a value
    ///</summary>	
    property HasValue: Boolean read GetHasValue;
    ///<summary>
    ///Returns `True` if the NullableTGUID contains a null
    ///</summary>	
    property IsNull: Boolean read GetIsNull;	
    ///<summary>
    ///Alias of `SetNull`
    ///</summary>
    procedure Clear;
    ///<summary>
    ///Set the value to `null`
    ///</summary>
    procedure SetNull;
    ///<summary>
    ///Returns the value stored or the default value for the type is the value is not set
    ///</summary>	
    function ValueOrDefault: TGUID;
    /// <summary>
    /// Returns true is both item have the same value and that value is not null. 
    /// </summary>
    function Equals(const Value: NullableTGUID): Boolean;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TGUID): Boolean; overload;
    ///<summary>
    ///Returns true if the nullable contains a value and returns the contained value in the out Value parameter.
    ///</summary>	
    function TryHasValue(out Value: TValue): Boolean; overload;
    ///<summary>
    ///Returns the value stored or raises exception if no value is stored
    ///</summary>	
    property Value: TGUID read GetValue write SetValue;
  end;

  TNullableType = (
     ntInvalidNullableType
   , ntNullableString
   , ntNullableCurrency
   , ntNullableBoolean
   , ntNullableTDate
   , ntNullableTTime
   , ntNullableTDateTime
   , ntNullableSingle
   , ntNullableDouble
   , ntNullableExtended
   , ntNullableInt16
   , ntNullableUInt16
   , ntNullableInt32
   , ntNullableUInt32
   , ntNullableInt64
   , ntNullableUInt64
   , ntNullableTGUID);


function GetNullableType(const aTypeInfo: PTypeInfo): TNullableType;

implementation

uses
  System.Math, System.DateUtils, System.Types;

function DateAreEquals(const DateA, DateB: TDate): Boolean;
begin
  Result := CompareDate(DateA, DateB) = 0;
end;

function TimeAreEquals(const TimeA, TimeB: TTime): Boolean;
begin
  Result := CompareValue(TimeA,TimeB, 0.000001) = 0;
end;


{ NullableString }

procedure NullableString.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableString value is null');
  end;
end;

function NullableString.TryHasValue(out Value: String): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableString.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<String>(fValue);    
  end;
end;


procedure NullableString.Clear;
begin
  SetNull;
end;

function NullableString.Equals(const Value: NullableString): Boolean;
begin
  Result := Self = Value;
end;

function NullableString.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableString.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableString.GetValue: String;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableString.Implicit(const Value: NullableString): String;
begin
  Result := Value.Value;
end;

class operator NullableString.Implicit(const Value: String): NullableString;
begin
  Result.Value := Value;
end;

class operator NullableString.Implicit(const Value: Pointer): NullableString;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableString.Equal(LeftValue: NullableString; RightValue: NullableString) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 (LeftValue.Value = RightValue.Value));
end;

procedure NullableString.SetNull;
begin
  fValue := Default (String);
  fHasValue := '';
end;

procedure NullableString.SetValue(const Value: String);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableString.ValueOrDefault: String;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (String);
  end;
end;



{ NullableCurrency }

procedure NullableCurrency.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableCurrency value is null');
  end;
end;

function NullableCurrency.TryHasValue(out Value: Currency): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableCurrency.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<Currency>(fValue);    
  end;
end;


procedure NullableCurrency.Clear;
begin
  SetNull;
end;

function NullableCurrency.Equals(const Value: NullableCurrency): Boolean;
begin
  Result := Self = Value;
end;

function NullableCurrency.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableCurrency.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableCurrency.GetValue: Currency;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableCurrency.Implicit(const Value: NullableCurrency): Currency;
begin
  Result := Value.Value;
end;

class operator NullableCurrency.Implicit(const Value: Currency): NullableCurrency;
begin
  Result.Value := Value;
end;

class operator NullableCurrency.Implicit(const Value: Pointer): NullableCurrency;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableCurrency.Equal(LeftValue: NullableCurrency; RightValue: NullableCurrency) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 (LeftValue.Value = RightValue.Value));
end;

procedure NullableCurrency.SetNull;
begin
  fValue := Default (Currency);
  fHasValue := '';
end;

procedure NullableCurrency.SetValue(const Value: Currency);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableCurrency.ValueOrDefault: Currency;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (Currency);
  end;
end;



{ NullableBoolean }

procedure NullableBoolean.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableBoolean value is null');
  end;
end;

function NullableBoolean.TryHasValue(out Value: Boolean): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableBoolean.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<Boolean>(fValue);    
  end;
end;


procedure NullableBoolean.Clear;
begin
  SetNull;
end;

function NullableBoolean.Equals(const Value: NullableBoolean): Boolean;
begin
  Result := Self = Value;
end;

function NullableBoolean.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableBoolean.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableBoolean.GetValue: Boolean;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableBoolean.Implicit(const Value: NullableBoolean): Boolean;
begin
  Result := Value.Value;
end;

class operator NullableBoolean.Implicit(const Value: Boolean): NullableBoolean;
begin
  Result.Value := Value;
end;

class operator NullableBoolean.Implicit(const Value: Pointer): NullableBoolean;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableBoolean.Equal(LeftValue: NullableBoolean; RightValue: NullableBoolean) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 (LeftValue.Value = RightValue.Value));
end;

procedure NullableBoolean.SetNull;
begin
  fValue := Default (Boolean);
  fHasValue := '';
end;

procedure NullableBoolean.SetValue(const Value: Boolean);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableBoolean.ValueOrDefault: Boolean;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (Boolean);
  end;
end;



{ NullableTDate }

procedure NullableTDate.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableTDate value is null');
  end;
end;

function NullableTDate.TryHasValue(out Value: TDate): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableTDate.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<TDate>(fValue);    
  end;
end;


procedure NullableTDate.Clear;
begin
  SetNull;
end;

function NullableTDate.Equals(const Value: NullableTDate): Boolean;
begin
  Result := Self = Value;
end;

function NullableTDate.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableTDate.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableTDate.GetValue: TDate;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableTDate.Implicit(const Value: NullableTDate): TDate;
begin
  Result := Value.Value;
end;

class operator NullableTDate.Implicit(const Value: TDate): NullableTDate;
begin
  Result.Value := Value;
end;

class operator NullableTDate.Implicit(const Value: Pointer): NullableTDate;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableTDate.Equal(LeftValue: NullableTDate; RightValue: NullableTDate) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 (DateAreEquals(LeftValue.Value, RightValue.Value)));
end;

procedure NullableTDate.SetNull;
begin
  fValue := Default (TDate);
  fHasValue := '';
end;

procedure NullableTDate.SetValue(const Value: TDate);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableTDate.ValueOrDefault: TDate;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (TDate);
  end;
end;



{ NullableTTime }

procedure NullableTTime.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableTTime value is null');
  end;
end;

function NullableTTime.TryHasValue(out Value: TTime): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableTTime.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<TTime>(fValue);    
  end;
end;


procedure NullableTTime.Clear;
begin
  SetNull;
end;

function NullableTTime.Equals(const Value: NullableTTime): Boolean;
begin
  Result := Self = Value;
end;

function NullableTTime.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableTTime.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableTTime.GetValue: TTime;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableTTime.Implicit(const Value: NullableTTime): TTime;
begin
  Result := Value.Value;
end;

class operator NullableTTime.Implicit(const Value: TTime): NullableTTime;
begin
  Result.Value := Value;
end;

class operator NullableTTime.Implicit(const Value: Pointer): NullableTTime;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableTTime.Equal(LeftValue: NullableTTime; RightValue: NullableTTime) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 (TimeAreEquals(LeftValue.Value, RightValue.Value)));
end;

procedure NullableTTime.SetNull;
begin
  fValue := Default (TTime);
  fHasValue := '';
end;

procedure NullableTTime.SetValue(const Value: TTime);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableTTime.ValueOrDefault: TTime;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (TTime);
  end;
end;



{ NullableTDateTime }

procedure NullableTDateTime.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableTDateTime value is null');
  end;
end;

function NullableTDateTime.TryHasValue(out Value: TDateTime): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableTDateTime.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<TDateTime>(fValue);    
  end;
end;


procedure NullableTDateTime.Clear;
begin
  SetNull;
end;

function NullableTDateTime.Equals(const Value: NullableTDateTime): Boolean;
begin
  Result := Self = Value;
end;

function NullableTDateTime.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableTDateTime.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableTDateTime.GetValue: TDateTime;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableTDateTime.Implicit(const Value: NullableTDateTime): TDateTime;
begin
  Result := Value.Value;
end;

class operator NullableTDateTime.Implicit(const Value: TDateTime): NullableTDateTime;
begin
  Result.Value := Value;
end;

class operator NullableTDateTime.Implicit(const Value: Pointer): NullableTDateTime;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableTDateTime.Equal(LeftValue: NullableTDateTime; RightValue: NullableTDateTime) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 (DateAreEquals(LeftValue.Value, RightValue.Value) and 
	 TimeAreEquals(LeftValue.Value, RightValue.Value)));
end;

procedure NullableTDateTime.SetNull;
begin
  fValue := Default (TDateTime);
  fHasValue := '';
end;

procedure NullableTDateTime.SetValue(const Value: TDateTime);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableTDateTime.ValueOrDefault: TDateTime;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (TDateTime);
  end;
end;



{ NullableSingle }

procedure NullableSingle.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableSingle value is null');
  end;
end;

function NullableSingle.TryHasValue(out Value: Single): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableSingle.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<Single>(fValue);    
  end;
end;


procedure NullableSingle.Clear;
begin
  SetNull;
end;

function NullableSingle.Equals(const Value: NullableSingle): Boolean;
begin
  Result := Self = Value;
end;

function NullableSingle.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableSingle.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableSingle.GetValue: Single;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableSingle.Implicit(const Value: NullableSingle): Single;
begin
  Result := Value.Value;
end;

class operator NullableSingle.Implicit(const Value: Single): NullableSingle;
begin
  Result.Value := Value;
end;

class operator NullableSingle.Implicit(const Value: Pointer): NullableSingle;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableSingle.Equal(LeftValue: NullableSingle; RightValue: NullableSingle) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 SameValue(LeftValue.Value, RightValue.Value, 0.000001));
end;

procedure NullableSingle.SetNull;
begin
  fValue := Default (Single);
  fHasValue := '';
end;

procedure NullableSingle.SetValue(const Value: Single);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableSingle.ValueOrDefault: Single;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (Single);
  end;
end;



{ NullableDouble }

procedure NullableDouble.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableDouble value is null');
  end;
end;

function NullableDouble.TryHasValue(out Value: Double): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableDouble.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<Double>(fValue);    
  end;
end;


procedure NullableDouble.Clear;
begin
  SetNull;
end;

function NullableDouble.Equals(const Value: NullableDouble): Boolean;
begin
  Result := Self = Value;
end;

function NullableDouble.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableDouble.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableDouble.GetValue: Double;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableDouble.Implicit(const Value: NullableDouble): Double;
begin
  Result := Value.Value;
end;

class operator NullableDouble.Implicit(const Value: Double): NullableDouble;
begin
  Result.Value := Value;
end;

class operator NullableDouble.Implicit(const Value: Pointer): NullableDouble;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableDouble.Equal(LeftValue: NullableDouble; RightValue: NullableDouble) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 SameValue(LeftValue.Value, RightValue.Value, 0.000000001));
end;

procedure NullableDouble.SetNull;
begin
  fValue := Default (Double);
  fHasValue := '';
end;

procedure NullableDouble.SetValue(const Value: Double);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableDouble.ValueOrDefault: Double;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (Double);
  end;
end;



{ NullableExtended }

procedure NullableExtended.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableExtended value is null');
  end;
end;

function NullableExtended.TryHasValue(out Value: Extended): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableExtended.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<Extended>(fValue);    
  end;
end;


procedure NullableExtended.Clear;
begin
  SetNull;
end;

function NullableExtended.Equals(const Value: NullableExtended): Boolean;
begin
  Result := Self = Value;
end;

function NullableExtended.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableExtended.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableExtended.GetValue: Extended;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableExtended.Implicit(const Value: NullableExtended): Extended;
begin
  Result := Value.Value;
end;

class operator NullableExtended.Implicit(const Value: Extended): NullableExtended;
begin
  Result.Value := Value;
end;

class operator NullableExtended.Implicit(const Value: Pointer): NullableExtended;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableExtended.Equal(LeftValue: NullableExtended; RightValue: NullableExtended) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and 
	 SameValue(LeftValue.Value, RightValue.Value, 0.000000001));
end;

procedure NullableExtended.SetNull;
begin
  fValue := Default (Extended);
  fHasValue := '';
end;

procedure NullableExtended.SetValue(const Value: Extended);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableExtended.ValueOrDefault: Extended;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (Extended);
  end;
end;



{ NullableInt16 }

procedure NullableInt16.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableInt16 value is null');
  end;
end;

function NullableInt16.TryHasValue(out Value: Int16): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableInt16.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<Int16>(fValue);    
  end;
end;


procedure NullableInt16.Clear;
begin
  SetNull;
end;

function NullableInt16.Equals(const Value: NullableInt16): Boolean;
begin
  Result := Self = Value;
end;

function NullableInt16.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableInt16.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableInt16.GetValue: Int16;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableInt16.Implicit(const Value: NullableInt16): Int16;
begin
  Result := Value.Value;
end;

class operator NullableInt16.Implicit(const Value: Int16): NullableInt16;
begin
  Result.Value := Value;
end;

class operator NullableInt16.Implicit(const Value: Pointer): NullableInt16;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableInt16.Equal(LeftValue: NullableInt16; RightValue: NullableInt16) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and (LeftValue.Value = RightValue.Value));
end;

procedure NullableInt16.SetNull;
begin
  fValue := Default (Int16);
  fHasValue := '';
end;

procedure NullableInt16.SetValue(const Value: Int16);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableInt16.ValueOrDefault: Int16;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (Int16);
  end;
end;



{ NullableUInt16 }

procedure NullableUInt16.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableUInt16 value is null');
  end;
end;

function NullableUInt16.TryHasValue(out Value: UInt16): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableUInt16.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<UInt16>(fValue);    
  end;
end;


procedure NullableUInt16.Clear;
begin
  SetNull;
end;

function NullableUInt16.Equals(const Value: NullableUInt16): Boolean;
begin
  Result := Self = Value;
end;

function NullableUInt16.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableUInt16.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableUInt16.GetValue: UInt16;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableUInt16.Implicit(const Value: NullableUInt16): UInt16;
begin
  Result := Value.Value;
end;

class operator NullableUInt16.Implicit(const Value: UInt16): NullableUInt16;
begin
  Result.Value := Value;
end;

class operator NullableUInt16.Implicit(const Value: Pointer): NullableUInt16;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableUInt16.Equal(LeftValue: NullableUInt16; RightValue: NullableUInt16) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and (LeftValue.Value = RightValue.Value));
end;

procedure NullableUInt16.SetNull;
begin
  fValue := Default (UInt16);
  fHasValue := '';
end;

procedure NullableUInt16.SetValue(const Value: UInt16);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableUInt16.ValueOrDefault: UInt16;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (UInt16);
  end;
end;



{ NullableInt32 }

procedure NullableInt32.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableInt32 value is null');
  end;
end;

function NullableInt32.TryHasValue(out Value: Int32): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableInt32.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<Int32>(fValue);    
  end;
end;


procedure NullableInt32.Clear;
begin
  SetNull;
end;

function NullableInt32.Equals(const Value: NullableInt32): Boolean;
begin
  Result := Self = Value;
end;

function NullableInt32.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableInt32.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableInt32.GetValue: Int32;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableInt32.Implicit(const Value: NullableInt32): Int32;
begin
  Result := Value.Value;
end;

class operator NullableInt32.Implicit(const Value: Int32): NullableInt32;
begin
  Result.Value := Value;
end;

class operator NullableInt32.Implicit(const Value: Pointer): NullableInt32;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableInt32.Equal(LeftValue: NullableInt32; RightValue: NullableInt32) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and (LeftValue.Value = RightValue.Value));
end;

procedure NullableInt32.SetNull;
begin
  fValue := Default (Int32);
  fHasValue := '';
end;

procedure NullableInt32.SetValue(const Value: Int32);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableInt32.ValueOrDefault: Int32;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (Int32);
  end;
end;



{ NullableUInt32 }

procedure NullableUInt32.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableUInt32 value is null');
  end;
end;

function NullableUInt32.TryHasValue(out Value: UInt32): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableUInt32.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<UInt32>(fValue);    
  end;
end;


procedure NullableUInt32.Clear;
begin
  SetNull;
end;

function NullableUInt32.Equals(const Value: NullableUInt32): Boolean;
begin
  Result := Self = Value;
end;

function NullableUInt32.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableUInt32.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableUInt32.GetValue: UInt32;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableUInt32.Implicit(const Value: NullableUInt32): UInt32;
begin
  Result := Value.Value;
end;

class operator NullableUInt32.Implicit(const Value: UInt32): NullableUInt32;
begin
  Result.Value := Value;
end;

class operator NullableUInt32.Implicit(const Value: Pointer): NullableUInt32;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableUInt32.Equal(LeftValue: NullableUInt32; RightValue: NullableUInt32) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and (LeftValue.Value = RightValue.Value));
end;

procedure NullableUInt32.SetNull;
begin
  fValue := Default (UInt32);
  fHasValue := '';
end;

procedure NullableUInt32.SetValue(const Value: UInt32);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableUInt32.ValueOrDefault: UInt32;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (UInt32);
  end;
end;



{ NullableInt64 }

procedure NullableInt64.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableInt64 value is null');
  end;
end;

function NullableInt64.TryHasValue(out Value: Int64): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableInt64.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<Int64>(fValue);    
  end;
end;


procedure NullableInt64.Clear;
begin
  SetNull;
end;

function NullableInt64.Equals(const Value: NullableInt64): Boolean;
begin
  Result := Self = Value;
end;

function NullableInt64.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableInt64.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableInt64.GetValue: Int64;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableInt64.Implicit(const Value: NullableInt64): Int64;
begin
  Result := Value.Value;
end;

class operator NullableInt64.Implicit(const Value: Int64): NullableInt64;
begin
  Result.Value := Value;
end;

class operator NullableInt64.Implicit(const Value: Pointer): NullableInt64;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableInt64.Equal(LeftValue: NullableInt64; RightValue: NullableInt64) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and (LeftValue.Value = RightValue.Value));
end;

procedure NullableInt64.SetNull;
begin
  fValue := Default (Int64);
  fHasValue := '';
end;

procedure NullableInt64.SetValue(const Value: Int64);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableInt64.ValueOrDefault: Int64;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (Int64);
  end;
end;



{ NullableUInt64 }

procedure NullableUInt64.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableUInt64 value is null');
  end;
end;

function NullableUInt64.TryHasValue(out Value: UInt64): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableUInt64.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<UInt64>(fValue);    
  end;
end;


procedure NullableUInt64.Clear;
begin
  SetNull;
end;

function NullableUInt64.Equals(const Value: NullableUInt64): Boolean;
begin
  Result := Self = Value;
end;

function NullableUInt64.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableUInt64.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableUInt64.GetValue: UInt64;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableUInt64.Implicit(const Value: NullableUInt64): UInt64;
begin
  Result := Value.Value;
end;

class operator NullableUInt64.Implicit(const Value: UInt64): NullableUInt64;
begin
  Result.Value := Value;
end;

class operator NullableUInt64.Implicit(const Value: Pointer): NullableUInt64;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableUInt64.Equal(LeftValue: NullableUInt64; RightValue: NullableUInt64) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and (LeftValue.Value = RightValue.Value));
end;

procedure NullableUInt64.SetNull;
begin
  fValue := Default (UInt64);
  fHasValue := '';
end;

procedure NullableUInt64.SetValue(const Value: UInt64);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableUInt64.ValueOrDefault: UInt64;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (UInt64);
  end;
end;



{ NullableTGUID }

procedure NullableTGUID.CheckHasValue;
begin
  if not GetHasValue then
  begin
    raise EMVCNullable.Create('NullableTGUID value is null');
  end;
end;

function NullableTGUID.TryHasValue(out Value: TGUID): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := fValue;
  end;
end;

function NullableTGUID.TryHasValue(out Value: TValue): Boolean;
begin
  Result := HasValue;
  if Result then
  begin
    Value := TValue.From<TGUID>(fValue);    
  end;
end;


procedure NullableTGUID.Clear;
begin
  SetNull;
end;

function NullableTGUID.Equals(const Value: NullableTGUID): Boolean;
begin
  Result := Self = Value;
end;

function NullableTGUID.GetHasValue: Boolean;
begin
  Result := fHasValue = '_';
end;

function NullableTGUID.GetIsNull: Boolean;
begin
  Result := not HasValue;
end;

function NullableTGUID.GetValue: TGUID;
begin
  CheckHasValue;
  Result := fValue;
end;

class operator NullableTGUID.Implicit(const Value: NullableTGUID): TGUID;
begin
  Result := Value.Value;
end;

class operator NullableTGUID.Implicit(const Value: TGUID): NullableTGUID;
begin
  Result.Value := Value;
end;

class operator NullableTGUID.Implicit(const Value: Pointer): NullableTGUID;
begin
  if Value = nil then
  begin
    Result.SetNull;
  end
  else
  begin
    raise EInvalidPointer.Create('Pointer value can only be "nil"');
  end;
end;

class operator NullableTGUID.Equal(LeftValue: NullableTGUID; RightValue: NullableTGUID) : Boolean;
begin
  Result := (LeftValue.IsNull and RightValue.IsNull) or ((LeftValue.HasValue and RightValue.HasValue) and (LeftValue.Value = RightValue.Value));
end;

procedure NullableTGUID.SetNull;
begin
  fValue := Default (TGUID);
  fHasValue := '';
end;

procedure NullableTGUID.SetValue(const Value: TGUID);
begin
  fValue := Value;
  fHasValue := '_';
end;

function NullableTGUID.ValueOrDefault: TGUID;
begin
  if HasValue then
  begin
    Result := GetValue
  end
  else
  begin
    Result := Default (TGUID);
  end;
end;


function GetNullableType(const aTypeInfo: PTypeInfo): TNullableType;
begin
  if aTypeInfo = TypeInfo(NullableString) then 
    Exit(ntNullableString); 
  if aTypeInfo = TypeInfo(NullableCurrency) then 
    Exit(ntNullableCurrency); 
  if aTypeInfo = TypeInfo(NullableBoolean) then 
    Exit(ntNullableBoolean); 
  if aTypeInfo = TypeInfo(NullableTDate) then 
    Exit(ntNullableTDate); 
  if aTypeInfo = TypeInfo(NullableTTime) then 
    Exit(ntNullableTTime); 
  if aTypeInfo = TypeInfo(NullableTDateTime) then 
    Exit(ntNullableTDateTime); 
  if aTypeInfo = TypeInfo(NullableSingle) then 
    Exit(ntNullableSingle); 
  if aTypeInfo = TypeInfo(NullableDouble) then 
    Exit(ntNullableDouble); 
  if aTypeInfo = TypeInfo(NullableExtended) then 
    Exit(ntNullableExtended); 
  if aTypeInfo = TypeInfo(NullableInt16) then 
    Exit(ntNullableInt16); 
  if aTypeInfo = TypeInfo(NullableUInt16) then 
    Exit(ntNullableUInt16); 
  if aTypeInfo = TypeInfo(NullableInt32) then 
    Exit(ntNullableInt32); 
  if aTypeInfo = TypeInfo(NullableUInt32) then 
    Exit(ntNullableUInt32); 
  if aTypeInfo = TypeInfo(NullableInt64) then 
    Exit(ntNullableInt64); 
  if aTypeInfo = TypeInfo(NullableUInt64) then 
    Exit(ntNullableUInt64); 
  if aTypeInfo = TypeInfo(NullableTGUID) then 
    Exit(ntNullableTGUID); 
  Result := ntInvalidNullableType;
end;

end.

