

# FloatButtonGroup组件props属性

| 参数            | 说明                                                  | 类型                                              | 默认值    | 可选择性 |
| :-------------- | :---------------------------------------------------- | :------------------------------------------------ | :-------- | :------- |
| `options`       | 结构对象数组                                          | `optionItemType[]`                                | -         | 必须     |
| `shadow`        | 是否添加阴影样式                                      | `boolean`                                         | `true`    | 可选     |
| `left`          | 位置相关：组件默认开启`fixed`定位，同定位属性`left`   | `number`                                          | -         | 可选     |
| `right`         | 位置相关：组件默认开启`fixed`定位，同定位属性`rihgt`  | `number`                                          | -         | 可选     |
| `top`           | 位置相关：组件默认开启`fixed`定位，同定位属性`top`    | `number`                                          | -         | 可选     |
| `bottom`        | 位置相关：组件默认开启`fixed`定位，同定位属性`bottom` | `number`                                          | -         | 可选     |
| `platformStyle` | 提供现有知名电商平台样式                              | `"default"` &#124; `"JingDong"` &#124; `"TaoBao"` | `default` | 可选     |

## optionItemType对象配置属性

| 参数          | 说明             | 类型                                                         | 默认值 | 可选择性 |
| :------------ | :--------------- | :----------------------------------------------------------- | :----- | :------- |
| `description` | 按钮描述         | `string`                                                     | "默认" | 可选     |
| `type`        | 按钮类型         | `"link"` &#124; `"elevator"` &#124; `"button"` &#124; `"backTop"` | -      | 必须     |
| `action`      | 按钮行为配置对象 | `linkActionOption` &#124; `elevatorActionOption` &#124; `buttonActionOption` &#124; `backTopActionOption`（与`type`属性的取值对应） | -      | 必须     |

### type值为"link"时对应的action属性

| 参数     | 说明                      | 类型                                                         | 默认值     | 可选择性 |
| :------- | :------------------------ | :----------------------------------------------------------- | :--------- | :------- |
| `href`   | 类似于a标签的`href`属性   | `string`                                                     | ""         | 可选     |
| `target` | 类似于a标签的`target`属性 | `'_blank'` &#124; `'_self'` &#124; `'_parent'` &#124; `'_top'` &#124; `'framename'` | `'_blank'` | 可选     |

### type值为"elevator"时对应的action属性

| 参数  | 说明                                                         | 类型     | 默认值 | 可选择性 |
| :---- | :----------------------------------------------------------- | :------- | :----- | :------- |
| `top` | 点击后滚动至元素`scrollTop`的值为`top`的位置(滚动元素为离组件最近的滚动的父元素) | `number` | 0      | 可选     |

### type值为"button"时对应的action属性

| 参数      | 说明                     | 类型                 | 默认值     | 可选择性 |
| :-------- | :----------------------- | :------------------- | :--------- | :------- |
| `onClick` | 点击按钮后触发的回调函数 | `(e: event) => void` | `() => {}` | 可选     |

### type值为"backTop"时对应的action属性

| 参数           | 说明                               | 类型     | 默认值 | 可选择性 |
| :------------- | :--------------------------------- | :------- | :----- | :------- |
| `visbleheight` | 滚动高度达到此参数值才出现 backTop | `number` | 0      | 可选     |
