# NLP Paper Summaries
This repository contains a list of NLP paper summaries intended to make NLP techniques and topics more approachable and accessible. We have identified and listed several important papers with summaries or TL;DRs. But we also invite the whole community to provide their own perspective and approachable explanations to these works and help in democratizing NLP research. The objective is to provide readers with a reliable resource that could serve as an entry point to the field of NLP.

Work in progress!

Join our [Slack community](https://join.slack.com/t/dairai/shared_invite/zt-pcxkmoip-b4nJkci8L_dynpMwLvlCcQ) to find our more about this and other ongoing projects or send me an email at ellfae@gmail.com and I will send you an invite.

**Slack channel:** #paper_summaries

## How to contribute

If you have blogged about an NLP paper or technique or find an interesting read out there, I encourage you to share with the wider community. To add your blog posts, summaries, or TL;DRs to this list just hit on the __edit__ button (✏️) in the README.md file inside the corresponding folder. You can then add your entry by modifying the readme file and submitting a PR which will be reviewed before going live.

Alternatively, we can work on transferring or writing your summaries or TL;DRs to this repo directly so as to make them more accessible. To achieve this go inside any of the folders and you will find a __"Contribute ✍️"__ link that is essentially a request for your contribution. Click on that link and it will take you directly to a window where you can start writing your summary or TL;DR. Once you are done submitting the PR, then we will review it and add the entry to the corresponding table.

If you would like to contribute by blogging about an NLP paper/technique, you can check out our suggestion/guidance at this [issue](https://github.com/dair-ai/dair-ai.github.io/issues/23).

And if you need any ideas on how else to contribute to this repo, take a look in the [issues](https://github.com/dair-ai/nlp_paper_summaries/issues) section. We are in need of maintainers.

For now, I have adopted a few tracks from [ACL](https://acl2020.org/calls/papers/) for the categorization of the summaries but this can change based on the granularity of grouping that is needed. Open to ideas here.

Note that we currently provide the source of where the summary originated from. We are working with a few authors to migrate the content directly to this repo so that the summaries are centralized and easily accessible. This also simplifies the way others can contribute to this project. When a summary is fully available on this repo, we will tag the summaries as __"GitHub"__ under the __"Summary"__ tab of the table of summaries to identify them easily.

We are including an extra __TL;DR__ section wherever applicable. This is not meant as a full-fledged summary but rather covers the key points of each paper and serves as a refresher for those who have previously encountered the paper or want to get a quick idea of the concepts being discussed.

This [video 📹](https://youtu.be/sgh7jJjQjOo) demonstrates how to add an entry to any of the folders in this repository.

This next [video 📹](https://youtu.be/OGCm7RyrZzk) demonstrates how to add a summary or TL;DR in the form of a pull request to the repo. 

If you are facing any issues submitting your PR, just send me an email at ellfae@gmail.com or [DM me on Twitter](https://twitter.com/omarsar0).

## Table of Contents
- [Cognitive Modeling and Psycholinguistics](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Cognitive%20Modeling%20and%20Psycholinguistics)
- [Computational Social Science and Social Media](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Computational%20Social%20Science%20and%20Social%20Media)
- [Dialogue and Interactive Systems](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Dialogue%20and%20Interactive%20Systems)
- [Discourse and Pragmatics](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Discourse%20and%20Pragmatics)
- [Ethics and NLP](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Ethics%20and%20NLP)
- [Generation](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Generation)
- [Information Extraction](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Information%20Extraction)
- [Information Retrieval and Text Mining](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Information%20Retrieval%20and%20Text%20Mining)
- [Interpretability and Analysis of Models for NLP](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Interpretability%20and%20Analysis%20of%20Models%20for%20NLP)
- [Language Grounding to Vision, Robotics and Beyond](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Language%20Grounding%20to%20Vision%2C%20Robotics%20and%20Beyond)
- [Language Modeling](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Language%20Modeling)
- [Machine Learning for NLP](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Machine%20Learning%20for%20NLP)
- [Machine Translation](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Machine%20Translation)
- [Model Compression](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Model%20Compression)
- [Multi-Task Learning](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Multi-Task%20Learning)
- [NLP Applications](https://github.com/dair-ai/nlp_paper_summaries/tree/master/NLP%20Applications)
- [Overviews, Surveys, and Highlights](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Overviews%2C%20Surveys%2C%20and%20Highlights)
- [Phonology, Morphology and Word Segmentation](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Phonology%2C%20Morphology%20and%20Word%20Segmentation)
- [Privacy and NLP](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Privacy%20and%20NLP)
- [Question Answering](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Question%20Answering)
- [Resources and Evaluation	](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Resources%20and%20Evaluation)
- [Semantics: Lexical](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Semantics:%20Lexical)
- [Semantics: Sentence Level](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Semantics:%20Sentence%20Level)
- [Semantics: Textual Inference and Other Areas of Semantics](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Semantics:%20Textual%20Inference%20and%20Other%20Areas%20of%20Semantics)
- [Sentiment Analysis, Stylistic Analysis, and Argument Mining](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Sentiment%20Analysis%2C%20Stylistic%20Analysis%2C%20and%20Argument%20Mining)
- [Speech and Multimodality](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Speech%20and%20Multimodality)
- [Summarization](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Summarization)
- [Syntax: Tagging, Chunking and Parsing](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Syntax:%20Tagging%2C%20Chunking%20and%20Parsing)
- [Theory and Formalism in NLP (Linguistic and Mathematical)](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Theory%20and%20Formalism%20in%20NLP%20(Linguistic%20and%20Mathematical))
- [Unsupervised Representation Learning](https://github.com/dair-ai/nlp_paper_summaries/tree/master/Unsupervised%20Representation%20Learning)
