﻿using System;

namespace NamedPipeImpersonation.Library
{
    internal class Globals
    {
        public static string BinaryPath { get; set; } = null;
        public static IntPtr ConnectEventHandle { get; set; } = IntPtr.Zero;
        public static IntPtr PipeEventHandle { get; set; } = IntPtr.Zero;
        public static string ServiceName { get; } = "PrivFuPipeSvc";
        public static int Timeout { get; set; } = 3000;
        public static bool UseDropper { get; set; } = false;

        /*
         * Raw Bytes of NamedPipeClient binary
         */
        public static byte[] BinaryData { get; } = new byte[] {
            0x4D, 0x5A, 0x90, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
            0xFF, 0xFF, 0x00, 0x00, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x80, 0x00, 0x00, 0x00, 0x0E, 0x1F, 0xBA, 0x0E, 0x00, 0xB4, 0x09, 0xCD,
            0x21, 0xB8, 0x01, 0x4C, 0xCD, 0x21, 0x54, 0x68, 0x69, 0x73, 0x20, 0x70,
            0x72, 0x6F, 0x67, 0x72, 0x61, 0x6D, 0x20, 0x63, 0x61, 0x6E, 0x6E, 0x6F,
            0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x75, 0x6E, 0x20, 0x69, 0x6E, 0x20,
            0x44, 0x4F, 0x53, 0x20, 0x6D, 0x6F, 0x64, 0x65, 0x2E, 0x0D, 0x0D, 0x0A,
            0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x45, 0x00, 0x00,
            0x4C, 0x01, 0x03, 0x00, 0x0F, 0xBA, 0xD3, 0xC9, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x22, 0x00, 0x0B, 0x01, 0x30, 0x00,
            0x00, 0x0A, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x86, 0x28, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
            0x00, 0x00, 0x40, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
            0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x60, 0x85, 0x00, 0x00, 0x10, 0x00,
            0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x33, 0x28, 0x00, 0x00, 0x4F, 0x00, 0x00, 0x00,
            0x00, 0x40, 0x00, 0x00, 0xF0, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x60, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x8C, 0x27, 0x00, 0x00,
            0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
            0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x08, 0x20, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x2E, 0x74, 0x65, 0x78, 0x74, 0x00, 0x00, 0x00,
            0x8C, 0x08, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00,
            0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x60, 0x2E, 0x72, 0x73, 0x72,
            0x63, 0x00, 0x00, 0x00, 0xF0, 0x05, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
            0x00, 0x06, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x40,
            0x2E, 0x72, 0x65, 0x6C, 0x6F, 0x63, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00,
            0x00, 0x60, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x40, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x28, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x02, 0x00, 0x05, 0x00,
            0xCC, 0x20, 0x00, 0x00, 0xC0, 0x06, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
            0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x1B, 0x30, 0x04, 0x00, 0x49, 0x00, 0x00, 0x00,
            0x01, 0x00, 0x00, 0x11, 0x02, 0x8E, 0x2C, 0x44, 0x72, 0x01, 0x00, 0x00,
            0x70, 0x02, 0x16, 0x9A, 0x18, 0x73, 0x0F, 0x00, 0x00, 0x0A, 0x0A, 0x28,
            0x10, 0x00, 0x00, 0x0A, 0x02, 0x16, 0x9A, 0x6F, 0x11, 0x00, 0x00, 0x0A,
            0x0B, 0x06, 0x20, 0xB8, 0x0B, 0x00, 0x00, 0x6F, 0x12, 0x00, 0x00, 0x0A,
            0x06, 0x07, 0x16, 0x07, 0x8E, 0x69, 0x6F, 0x13, 0x00, 0x00, 0x0A, 0xDE,
            0x0A, 0x06, 0x2C, 0x06, 0x06, 0x6F, 0x14, 0x00, 0x00, 0x0A, 0xDC, 0xDE,
            0x03, 0x26, 0xDE, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x01, 0x1C, 0x00, 0x00,
            0x02, 0x00, 0x13, 0x00, 0x26, 0x39, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x04, 0x00, 0x41, 0x45, 0x00, 0x03, 0x10, 0x00, 0x00, 0x01,
            0x1E, 0x02, 0x28, 0x15, 0x00, 0x00, 0x0A, 0x2A, 0x42, 0x53, 0x4A, 0x42,
            0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00,
            0x76, 0x34, 0x2E, 0x30, 0x2E, 0x33, 0x30, 0x33, 0x31, 0x39, 0x00, 0x00,
            0x00, 0x00, 0x05, 0x00, 0x6C, 0x00, 0x00, 0x00, 0x1C, 0x02, 0x00, 0x00,
            0x23, 0x7E, 0x00, 0x00, 0x88, 0x02, 0x00, 0x00, 0xDC, 0x02, 0x00, 0x00,
            0x23, 0x53, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x73, 0x00, 0x00, 0x00, 0x00,
            0x64, 0x05, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x23, 0x55, 0x53, 0x00,
            0x6C, 0x05, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x23, 0x47, 0x55, 0x49,
            0x44, 0x00, 0x00, 0x00, 0x7C, 0x05, 0x00, 0x00, 0x44, 0x01, 0x00, 0x00,
            0x23, 0x42, 0x6C, 0x6F, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x02, 0x00, 0x00, 0x01, 0x47, 0x15, 0x02, 0x00, 0x09, 0x00, 0x00, 0x00,
            0x00, 0xFA, 0x01, 0x33, 0x00, 0x16, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
            0x15, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
            0x01, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00,
            0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xB2, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
            0x27, 0x01, 0x63, 0x02, 0x06, 0x00, 0x94, 0x01, 0x63, 0x02, 0x06, 0x00,
            0x5B, 0x00, 0x31, 0x02, 0x0F, 0x00, 0x83, 0x02, 0x00, 0x00, 0x06, 0x00,
            0x83, 0x00, 0x0B, 0x02, 0x06, 0x00, 0x0A, 0x01, 0x0B, 0x02, 0x06, 0x00,
            0xEB, 0x00, 0x0B, 0x02, 0x06, 0x00, 0x7B, 0x01, 0x0B, 0x02, 0x06, 0x00,
            0x47, 0x01, 0x0B, 0x02, 0x06, 0x00, 0x60, 0x01, 0x0B, 0x02, 0x06, 0x00,
            0x9A, 0x00, 0x0B, 0x02, 0x06, 0x00, 0x6F, 0x00, 0x44, 0x02, 0x06, 0x00,
            0x4D, 0x00, 0x44, 0x02, 0x06, 0x00, 0xCE, 0x00, 0x0B, 0x02, 0x06, 0x00,
            0xB5, 0x00, 0xCF, 0x01, 0x06, 0x00, 0xB0, 0x02, 0xFF, 0x01, 0x0A, 0x00,
            0xE9, 0x01, 0x92, 0x02, 0x0A, 0x00, 0x1D, 0x02, 0x92, 0x02, 0x06, 0x00,
            0xC6, 0x01, 0xCF, 0x02, 0x06, 0x00, 0xF8, 0x01, 0x14, 0x00, 0x06, 0x00,
            0x27, 0x00, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0xBF, 0x02,
            0xBF, 0x02, 0x41, 0x00, 0x01, 0x00, 0x01, 0x00, 0x50, 0x20, 0x00, 0x00,
            0x00, 0x00, 0x91, 0x00, 0x06, 0x02, 0x45, 0x00, 0x01, 0x00, 0xC4, 0x20,
            0x00, 0x00, 0x00, 0x00, 0x86, 0x18, 0x2B, 0x02, 0x06, 0x00, 0x02, 0x00,
            0x00, 0x00, 0x01, 0x00, 0xAB, 0x02, 0x09, 0x00, 0x2B, 0x02, 0x01, 0x00,
            0x11, 0x00, 0x2B, 0x02, 0x06, 0x00, 0x19, 0x00, 0x2B, 0x02, 0x0A, 0x00,
            0x29, 0x00, 0x2B, 0x02, 0x10, 0x00, 0x31, 0x00, 0x2B, 0x02, 0x10, 0x00,
            0x39, 0x00, 0x2B, 0x02, 0x10, 0x00, 0x41, 0x00, 0x2B, 0x02, 0x10, 0x00,
            0x49, 0x00, 0x2B, 0x02, 0x10, 0x00, 0x51, 0x00, 0x2B, 0x02, 0x10, 0x00,
            0x59, 0x00, 0x2B, 0x02, 0x10, 0x00, 0x61, 0x00, 0x2B, 0x02, 0x15, 0x00,
            0x69, 0x00, 0x2B, 0x02, 0x10, 0x00, 0x71, 0x00, 0x2B, 0x02, 0x10, 0x00,
            0x79, 0x00, 0x2B, 0x02, 0x10, 0x00, 0x89, 0x00, 0x2B, 0x02, 0x21, 0x00,
            0x99, 0x00, 0x0A, 0x00, 0x29, 0x00, 0x99, 0x00, 0xA2, 0x02, 0x2E, 0x00,
            0x89, 0x00, 0xB7, 0x02, 0x01, 0x00, 0xA1, 0x00, 0x47, 0x00, 0x34, 0x00,
            0xA9, 0x00, 0x3F, 0x00, 0x06, 0x00, 0x81, 0x00, 0x2B, 0x02, 0x06, 0x00,
            0x2E, 0x00, 0x0B, 0x00, 0x4B, 0x00, 0x2E, 0x00, 0x13, 0x00, 0x54, 0x00,
            0x2E, 0x00, 0x1B, 0x00, 0x73, 0x00, 0x2E, 0x00, 0x23, 0x00, 0x7C, 0x00,
            0x2E, 0x00, 0x2B, 0x00, 0x91, 0x00, 0x2E, 0x00, 0x33, 0x00, 0x91, 0x00,
            0x2E, 0x00, 0x3B, 0x00, 0x97, 0x00, 0x2E, 0x00, 0x43, 0x00, 0x7C, 0x00,
            0x2E, 0x00, 0x4B, 0x00, 0xA2, 0x00, 0x2E, 0x00, 0x53, 0x00, 0x91, 0x00,
            0x2E, 0x00, 0x5B, 0x00, 0x91, 0x00, 0x2E, 0x00, 0x63, 0x00, 0xBF, 0x00,
            0x2E, 0x00, 0x6B, 0x00, 0xE9, 0x00, 0x2E, 0x00, 0x73, 0x00, 0xF6, 0x00,
            0x1A, 0x00, 0x04, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x02, 0x00, 0x00,
            0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x3C, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x33, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x4D, 0x6F,
            0x64, 0x75, 0x6C, 0x65, 0x3E, 0x00, 0x67, 0x65, 0x74, 0x5F, 0x41, 0x53,
            0x43, 0x49, 0x49, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x2E, 0x49,
            0x4F, 0x00, 0x6D, 0x73, 0x63, 0x6F, 0x72, 0x6C, 0x69, 0x62, 0x00, 0x49,
            0x44, 0x69, 0x73, 0x70, 0x6F, 0x73, 0x61, 0x62, 0x6C, 0x65, 0x00, 0x53,
            0x79, 0x73, 0x74, 0x65, 0x6D, 0x2E, 0x43, 0x6F, 0x72, 0x65, 0x00, 0x44,
            0x69, 0x73, 0x70, 0x6F, 0x73, 0x65, 0x00, 0x57, 0x72, 0x69, 0x74, 0x65,
            0x00, 0x47, 0x75, 0x69, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
            0x74, 0x65, 0x00, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x61, 0x62, 0x6C,
            0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x43,
            0x6F, 0x6D, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6C, 0x65, 0x41, 0x74, 0x74,
            0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x41, 0x73, 0x73, 0x65, 0x6D,
            0x62, 0x6C, 0x79, 0x54, 0x69, 0x74, 0x6C, 0x65, 0x41, 0x74, 0x74, 0x72,
            0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x41, 0x73, 0x73, 0x65, 0x6D, 0x62,
            0x6C, 0x79, 0x54, 0x72, 0x61, 0x64, 0x65, 0x6D, 0x61, 0x72, 0x6B, 0x41,
            0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x54, 0x61, 0x72,
            0x67, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6D, 0x65, 0x77, 0x6F, 0x72, 0x6B,
            0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x41, 0x73,
            0x73, 0x65, 0x6D, 0x62, 0x6C, 0x79, 0x46, 0x69, 0x6C, 0x65, 0x56, 0x65,
            0x72, 0x73, 0x69, 0x6F, 0x6E, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
            0x74, 0x65, 0x00, 0x41, 0x73, 0x73, 0x65, 0x6D, 0x62, 0x6C, 0x79, 0x43,
            0x6F, 0x6E, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E,
            0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x41, 0x73,
            0x73, 0x65, 0x6D, 0x62, 0x6C, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
            0x70, 0x74, 0x69, 0x6F, 0x6E, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
            0x74, 0x65, 0x00, 0x43, 0x6F, 0x6D, 0x70, 0x69, 0x6C, 0x61, 0x74, 0x69,
            0x6F, 0x6E, 0x52, 0x65, 0x6C, 0x61, 0x78, 0x61, 0x74, 0x69, 0x6F, 0x6E,
            0x73, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x41,
            0x73, 0x73, 0x65, 0x6D, 0x62, 0x6C, 0x79, 0x50, 0x72, 0x6F, 0x64, 0x75,
            0x63, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00,
            0x41, 0x73, 0x73, 0x65, 0x6D, 0x62, 0x6C, 0x79, 0x43, 0x6F, 0x70, 0x79,
            0x72, 0x69, 0x67, 0x68, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
            0x74, 0x65, 0x00, 0x41, 0x73, 0x73, 0x65, 0x6D, 0x62, 0x6C, 0x79, 0x43,
            0x6F, 0x6D, 0x70, 0x61, 0x6E, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
            0x75, 0x74, 0x65, 0x00, 0x52, 0x75, 0x6E, 0x74, 0x69, 0x6D, 0x65, 0x43,
            0x6F, 0x6D, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6C, 0x69, 0x74, 0x79,
            0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x00, 0x4E, 0x61,
            0x6D, 0x65, 0x64, 0x50, 0x69, 0x70, 0x65, 0x43, 0x6C, 0x69, 0x65, 0x6E,
            0x74, 0x2E, 0x65, 0x78, 0x65, 0x00, 0x45, 0x6E, 0x63, 0x6F, 0x64, 0x69,
            0x6E, 0x67, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x2E, 0x52, 0x75,
            0x6E, 0x74, 0x69, 0x6D, 0x65, 0x2E, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F,
            0x6E, 0x69, 0x6E, 0x67, 0x00, 0x4E, 0x61, 0x6D, 0x65, 0x64, 0x50, 0x69,
            0x70, 0x65, 0x43, 0x6C, 0x69, 0x65, 0x6E, 0x74, 0x53, 0x74, 0x72, 0x65,
            0x61, 0x6D, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x00, 0x4D, 0x61,
            0x69, 0x6E, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x2E, 0x52, 0x65,
            0x66, 0x6C, 0x65, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x00, 0x50, 0x69, 0x70,
            0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x00, 0x2E,
            0x63, 0x74, 0x6F, 0x72, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x2E,
            0x44, 0x69, 0x61, 0x67, 0x6E, 0x6F, 0x73, 0x74, 0x69, 0x63, 0x73, 0x00,
            0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x2E, 0x52, 0x75, 0x6E, 0x74, 0x69,
            0x6D, 0x65, 0x2E, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6F, 0x70, 0x53, 0x65,
            0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65,
            0x6D, 0x2E, 0x52, 0x75, 0x6E, 0x74, 0x69, 0x6D, 0x65, 0x2E, 0x43, 0x6F,
            0x6D, 0x70, 0x69, 0x6C, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
            0x65, 0x73, 0x00, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6E, 0x67,
            0x4D, 0x6F, 0x64, 0x65, 0x73, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D,
            0x2E, 0x49, 0x4F, 0x2E, 0x50, 0x69, 0x70, 0x65, 0x73, 0x00, 0x47, 0x65,
            0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x00, 0x61, 0x72, 0x67, 0x73, 0x00,
            0x4F, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x00, 0x43, 0x6F, 0x6E, 0x6E, 0x65,
            0x63, 0x74, 0x00, 0x4E, 0x61, 0x6D, 0x65, 0x64, 0x50, 0x69, 0x70, 0x65,
            0x43, 0x6C, 0x69, 0x65, 0x6E, 0x74, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65,
            0x6D, 0x2E, 0x54, 0x65, 0x78, 0x74, 0x00, 0x00, 0x00, 0x03, 0x2E, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x70, 0x55, 0x7B, 0xB9, 0x69, 0x26, 0x42, 0x42,
            0x91, 0xCD, 0x77, 0xF0, 0xC0, 0xD9, 0x4E, 0x69, 0x00, 0x04, 0x20, 0x01,
            0x01, 0x08, 0x03, 0x20, 0x00, 0x01, 0x05, 0x20, 0x01, 0x01, 0x11, 0x11,
            0x04, 0x20, 0x01, 0x01, 0x0E, 0x04, 0x20, 0x01, 0x01, 0x02, 0x06, 0x07,
            0x02, 0x12, 0x45, 0x1D, 0x05, 0x07, 0x20, 0x03, 0x01, 0x0E, 0x0E, 0x11,
            0x49, 0x04, 0x00, 0x00, 0x12, 0x4D, 0x05, 0x20, 0x01, 0x1D, 0x05, 0x0E,
            0x07, 0x20, 0x03, 0x01, 0x1D, 0x05, 0x08, 0x08, 0x08, 0xB7, 0x7A, 0x5C,
            0x56, 0x19, 0x34, 0xE0, 0x89, 0x05, 0x00, 0x01, 0x01, 0x1D, 0x0E, 0x08,
            0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x01, 0x00, 0x01,
            0x00, 0x54, 0x02, 0x16, 0x57, 0x72, 0x61, 0x70, 0x4E, 0x6F, 0x6E, 0x45,
            0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6F, 0x6E, 0x54, 0x68, 0x72, 0x6F,
            0x77, 0x73, 0x01, 0x08, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x14, 0x01, 0x00, 0x0F, 0x4E, 0x61, 0x6D, 0x65, 0x64, 0x50, 0x69, 0x70,
            0x65, 0x43, 0x6C, 0x69, 0x65, 0x6E, 0x74, 0x00, 0x00, 0x05, 0x01, 0x00,
            0x00, 0x00, 0x00, 0x0A, 0x01, 0x00, 0x05, 0x52, 0x61, 0x7A, 0x65, 0x72,
            0x00, 0x00, 0x1C, 0x01, 0x00, 0x17, 0x43, 0x6F, 0x70, 0x79, 0x72, 0x69,
            0x67, 0x68, 0x74, 0x20, 0xC2, 0xA9, 0x20, 0x52, 0x61, 0x7A, 0x65, 0x72,
            0x20, 0x32, 0x30, 0x32, 0x33, 0x00, 0x00, 0x29, 0x01, 0x00, 0x24, 0x30,
            0x63, 0x63, 0x39, 0x32, 0x33, 0x66, 0x62, 0x2D, 0x65, 0x31, 0x66, 0x64,
            0x2D, 0x34, 0x35, 0x36, 0x62, 0x2D, 0x39, 0x66, 0x65, 0x34, 0x2D, 0x39,
            0x65, 0x62, 0x61, 0x35, 0x61, 0x33, 0x64, 0x63, 0x32, 0x66, 0x63, 0x00,
            0x00, 0x0C, 0x01, 0x00, 0x07, 0x31, 0x2E, 0x30, 0x2E, 0x30, 0x2E, 0x30,
            0x00, 0x00, 0x4D, 0x01, 0x00, 0x1C, 0x2E, 0x4E, 0x45, 0x54, 0x46, 0x72,
            0x61, 0x6D, 0x65, 0x77, 0x6F, 0x72, 0x6B, 0x2C, 0x56, 0x65, 0x72, 0x73,
            0x69, 0x6F, 0x6E, 0x3D, 0x76, 0x34, 0x2E, 0x35, 0x2E, 0x32, 0x01, 0x00,
            0x54, 0x0E, 0x14, 0x46, 0x72, 0x61, 0x6D, 0x65, 0x77, 0x6F, 0x72, 0x6B,
            0x44, 0x69, 0x73, 0x70, 0x6C, 0x61, 0x79, 0x4E, 0x61, 0x6D, 0x65, 0x14,
            0x2E, 0x4E, 0x45, 0x54, 0x20, 0x46, 0x72, 0x61, 0x6D, 0x65, 0x77, 0x6F,
            0x72, 0x6B, 0x20, 0x34, 0x2E, 0x35, 0x2E, 0x32, 0x00, 0x00, 0x00, 0x00,
            0x69, 0xE6, 0xBD, 0xCD, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
            0x6F, 0x00, 0x00, 0x00, 0xC4, 0x27, 0x00, 0x00, 0xC4, 0x09, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x52, 0x53, 0x44, 0x53, 0xDF, 0x00, 0x32, 0x6A,
            0x61, 0x96, 0xF7, 0x48, 0xAC, 0x87, 0x25, 0x72, 0x24, 0xF0, 0x0F, 0x6A,
            0x01, 0x00, 0x00, 0x00, 0x43, 0x3A, 0x5C, 0x44, 0x65, 0x76, 0x5C, 0x50,
            0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x73, 0x5C, 0x50, 0x72, 0x69, 0x76,
            0x46, 0x75, 0x5C, 0x41, 0x72, 0x74, 0x73, 0x4F, 0x66, 0x47, 0x65, 0x74,
            0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x5C, 0x4E, 0x61, 0x6D, 0x65, 0x64,
            0x50, 0x69, 0x70, 0x65, 0x43, 0x6C, 0x69, 0x65, 0x6E, 0x74, 0x5C, 0x6F,
            0x62, 0x6A, 0x5C, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x5C, 0x4E,
            0x61, 0x6D, 0x65, 0x64, 0x50, 0x69, 0x70, 0x65, 0x43, 0x6C, 0x69, 0x65,
            0x6E, 0x74, 0x2E, 0x70, 0x64, 0x62, 0x00, 0x5B, 0x28, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x75, 0x28, 0x00, 0x00, 0x00,
            0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67,
            0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x5F, 0x43, 0x6F, 0x72, 0x45, 0x78, 0x65, 0x4D, 0x61, 0x69, 0x6E,
            0x00, 0x6D, 0x73, 0x63, 0x6F, 0x72, 0x65, 0x65, 0x2E, 0x64, 0x6C, 0x6C,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x25, 0x00, 0x20, 0x40, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x80,
            0x18, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
            0x01, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
            0x01, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
            0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0x90, 0x40, 0x00, 0x00,
            0x60, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x60, 0x03, 0x34, 0x00, 0x00, 0x00, 0x56, 0x00, 0x53, 0x00, 0x5F, 0x00,
            0x56, 0x00, 0x45, 0x00, 0x52, 0x00, 0x53, 0x00, 0x49, 0x00, 0x4F, 0x00,
            0x4E, 0x00, 0x5F, 0x00, 0x49, 0x00, 0x4E, 0x00, 0x46, 0x00, 0x4F, 0x00,
            0x00, 0x00, 0x00, 0x00, 0xBD, 0x04, 0xEF, 0xFE, 0x00, 0x00, 0x01, 0x00,
            0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
            0x01, 0x00, 0x56, 0x00, 0x61, 0x00, 0x72, 0x00, 0x46, 0x00, 0x69, 0x00,
            0x6C, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6E, 0x00, 0x66, 0x00, 0x6F, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x04, 0x00, 0x00, 0x00, 0x54, 0x00,
            0x72, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x6C, 0x00, 0x61, 0x00,
            0x74, 0x00, 0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xB0, 0x04, 0xC0, 0x02, 0x00, 0x00, 0x01, 0x00, 0x53, 0x00,
            0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6E, 0x00, 0x67, 0x00, 0x46, 0x00,
            0x69, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6E, 0x00, 0x66, 0x00,
            0x6F, 0x00, 0x00, 0x00, 0x9C, 0x02, 0x00, 0x00, 0x01, 0x00, 0x30, 0x00,
            0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x34, 0x00, 0x62, 0x00,
            0x30, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x01, 0x00, 0x01, 0x00, 0x43, 0x00,
            0x6F, 0x00, 0x6D, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x6E, 0x00, 0x74, 0x00,
            0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x06, 0x00,
            0x01, 0x00, 0x43, 0x00, 0x6F, 0x00, 0x6D, 0x00, 0x70, 0x00, 0x61, 0x00,
            0x6E, 0x00, 0x79, 0x00, 0x4E, 0x00, 0x61, 0x00, 0x6D, 0x00, 0x65, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x52, 0x00, 0x61, 0x00, 0x7A, 0x00, 0x65, 0x00,
            0x72, 0x00, 0x00, 0x00, 0x48, 0x00, 0x10, 0x00, 0x01, 0x00, 0x46, 0x00,
            0x69, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x44, 0x00, 0x65, 0x00, 0x73, 0x00,
            0x63, 0x00, 0x72, 0x00, 0x69, 0x00, 0x70, 0x00, 0x74, 0x00, 0x69, 0x00,
            0x6F, 0x00, 0x6E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x61, 0x00,
            0x6D, 0x00, 0x65, 0x00, 0x64, 0x00, 0x50, 0x00, 0x69, 0x00, 0x70, 0x00,
            0x65, 0x00, 0x43, 0x00, 0x6C, 0x00, 0x69, 0x00, 0x65, 0x00, 0x6E, 0x00,
            0x74, 0x00, 0x00, 0x00, 0x30, 0x00, 0x08, 0x00, 0x01, 0x00, 0x46, 0x00,
            0x69, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x56, 0x00, 0x65, 0x00, 0x72, 0x00,
            0x73, 0x00, 0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x31, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x2E, 0x00,
            0x30, 0x00, 0x00, 0x00, 0x48, 0x00, 0x14, 0x00, 0x01, 0x00, 0x49, 0x00,
            0x6E, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6E, 0x00, 0x61, 0x00,
            0x6C, 0x00, 0x4E, 0x00, 0x61, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x00, 0x00,
            0x4E, 0x00, 0x61, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x64, 0x00, 0x50, 0x00,
            0x69, 0x00, 0x70, 0x00, 0x65, 0x00, 0x43, 0x00, 0x6C, 0x00, 0x69, 0x00,
            0x65, 0x00, 0x6E, 0x00, 0x74, 0x00, 0x2E, 0x00, 0x65, 0x00, 0x78, 0x00,
            0x65, 0x00, 0x00, 0x00, 0x52, 0x00, 0x17, 0x00, 0x01, 0x00, 0x4C, 0x00,
            0x65, 0x00, 0x67, 0x00, 0x61, 0x00, 0x6C, 0x00, 0x43, 0x00, 0x6F, 0x00,
            0x70, 0x00, 0x79, 0x00, 0x72, 0x00, 0x69, 0x00, 0x67, 0x00, 0x68, 0x00,
            0x74, 0x00, 0x00, 0x00, 0x43, 0x00, 0x6F, 0x00, 0x70, 0x00, 0x79, 0x00,
            0x72, 0x00, 0x69, 0x00, 0x67, 0x00, 0x68, 0x00, 0x74, 0x00, 0x20, 0x00,
            0xA9, 0x00, 0x20, 0x00, 0x52, 0x00, 0x61, 0x00, 0x7A, 0x00, 0x65, 0x00,
            0x72, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x32, 0x00, 0x33, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x2A, 0x00, 0x01, 0x00, 0x01, 0x00, 0x4C, 0x00,
            0x65, 0x00, 0x67, 0x00, 0x61, 0x00, 0x6C, 0x00, 0x54, 0x00, 0x72, 0x00,
            0x61, 0x00, 0x64, 0x00, 0x65, 0x00, 0x6D, 0x00, 0x61, 0x00, 0x72, 0x00,
            0x6B, 0x00, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x50, 0x00, 0x14, 0x00, 0x01, 0x00, 0x4F, 0x00, 0x72, 0x00, 0x69, 0x00,
            0x67, 0x00, 0x69, 0x00, 0x6E, 0x00, 0x61, 0x00, 0x6C, 0x00, 0x46, 0x00,
            0x69, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x6E, 0x00, 0x61, 0x00, 0x6D, 0x00,
            0x65, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x61, 0x00, 0x6D, 0x00, 0x65, 0x00,
            0x64, 0x00, 0x50, 0x00, 0x69, 0x00, 0x70, 0x00, 0x65, 0x00, 0x43, 0x00,
            0x6C, 0x00, 0x69, 0x00, 0x65, 0x00, 0x6E, 0x00, 0x74, 0x00, 0x2E, 0x00,
            0x65, 0x00, 0x78, 0x00, 0x65, 0x00, 0x00, 0x00, 0x40, 0x00, 0x10, 0x00,
            0x01, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x64, 0x00, 0x75, 0x00,
            0x63, 0x00, 0x74, 0x00, 0x4E, 0x00, 0x61, 0x00, 0x6D, 0x00, 0x65, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x4E, 0x00, 0x61, 0x00, 0x6D, 0x00, 0x65, 0x00,
            0x64, 0x00, 0x50, 0x00, 0x69, 0x00, 0x70, 0x00, 0x65, 0x00, 0x43, 0x00,
            0x6C, 0x00, 0x69, 0x00, 0x65, 0x00, 0x6E, 0x00, 0x74, 0x00, 0x00, 0x00,
            0x34, 0x00, 0x08, 0x00, 0x01, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00,
            0x64, 0x00, 0x75, 0x00, 0x63, 0x00, 0x74, 0x00, 0x56, 0x00, 0x65, 0x00,
            0x72, 0x00, 0x73, 0x00, 0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x00, 0x00,
            0x31, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x2E, 0x00,
            0x30, 0x00, 0x00, 0x00, 0x38, 0x00, 0x08, 0x00, 0x01, 0x00, 0x41, 0x00,
            0x73, 0x00, 0x73, 0x00, 0x65, 0x00, 0x6D, 0x00, 0x62, 0x00, 0x6C, 0x00,
            0x79, 0x00, 0x20, 0x00, 0x56, 0x00, 0x65, 0x00, 0x72, 0x00, 0x73, 0x00,
            0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x00, 0x00, 0x31, 0x00, 0x2E, 0x00,
            0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x2E, 0x00, 0x30, 0x00, 0x00, 0x00,
            0x00, 0x44, 0x00, 0x00, 0xEA, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0xEF, 0xBB, 0xBF, 0x3C, 0x3F, 0x78, 0x6D, 0x6C,
            0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3D, 0x22, 0x31, 0x2E,
            0x30, 0x22, 0x20, 0x65, 0x6E, 0x63, 0x6F, 0x64, 0x69, 0x6E, 0x67, 0x3D,
            0x22, 0x55, 0x54, 0x46, 0x2D, 0x38, 0x22, 0x20, 0x73, 0x74, 0x61, 0x6E,
            0x64, 0x61, 0x6C, 0x6F, 0x6E, 0x65, 0x3D, 0x22, 0x79, 0x65, 0x73, 0x22,
            0x3F, 0x3E, 0x0D, 0x0A, 0x0D, 0x0A, 0x3C, 0x61, 0x73, 0x73, 0x65, 0x6D,
            0x62, 0x6C, 0x79, 0x20, 0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3D, 0x22, 0x75,
            0x72, 0x6E, 0x3A, 0x73, 0x63, 0x68, 0x65, 0x6D, 0x61, 0x73, 0x2D, 0x6D,
            0x69, 0x63, 0x72, 0x6F, 0x73, 0x6F, 0x66, 0x74, 0x2D, 0x63, 0x6F, 0x6D,
            0x3A, 0x61, 0x73, 0x6D, 0x2E, 0x76, 0x31, 0x22, 0x20, 0x6D, 0x61, 0x6E,
            0x69, 0x66, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E,
            0x3D, 0x22, 0x31, 0x2E, 0x30, 0x22, 0x3E, 0x0D, 0x0A, 0x20, 0x20, 0x3C,
            0x61, 0x73, 0x73, 0x65, 0x6D, 0x62, 0x6C, 0x79, 0x49, 0x64, 0x65, 0x6E,
            0x74, 0x69, 0x74, 0x79, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E,
            0x3D, 0x22, 0x31, 0x2E, 0x30, 0x2E, 0x30, 0x2E, 0x30, 0x22, 0x20, 0x6E,
            0x61, 0x6D, 0x65, 0x3D, 0x22, 0x4D, 0x79, 0x41, 0x70, 0x70, 0x6C, 0x69,
            0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x2E, 0x61, 0x70, 0x70, 0x22, 0x2F,
            0x3E, 0x0D, 0x0A, 0x20, 0x20, 0x3C, 0x74, 0x72, 0x75, 0x73, 0x74, 0x49,
            0x6E, 0x66, 0x6F, 0x20, 0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3D, 0x22, 0x75,
            0x72, 0x6E, 0x3A, 0x73, 0x63, 0x68, 0x65, 0x6D, 0x61, 0x73, 0x2D, 0x6D,
            0x69, 0x63, 0x72, 0x6F, 0x73, 0x6F, 0x66, 0x74, 0x2D, 0x63, 0x6F, 0x6D,
            0x3A, 0x61, 0x73, 0x6D, 0x2E, 0x76, 0x32, 0x22, 0x3E, 0x0D, 0x0A, 0x20,
            0x20, 0x20, 0x20, 0x3C, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
            0x3E, 0x0D, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3C, 0x72, 0x65,
            0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x69,
            0x6C, 0x65, 0x67, 0x65, 0x73, 0x20, 0x78, 0x6D, 0x6C, 0x6E, 0x73, 0x3D,
            0x22, 0x75, 0x72, 0x6E, 0x3A, 0x73, 0x63, 0x68, 0x65, 0x6D, 0x61, 0x73,
            0x2D, 0x6D, 0x69, 0x63, 0x72, 0x6F, 0x73, 0x6F, 0x66, 0x74, 0x2D, 0x63,
            0x6F, 0x6D, 0x3A, 0x61, 0x73, 0x6D, 0x2E, 0x76, 0x33, 0x22, 0x3E, 0x0D,
            0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3C, 0x72, 0x65,
            0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75,
            0x74, 0x69, 0x6F, 0x6E, 0x4C, 0x65, 0x76, 0x65, 0x6C, 0x20, 0x6C, 0x65,
            0x76, 0x65, 0x6C, 0x3D, 0x22, 0x61, 0x73, 0x49, 0x6E, 0x76, 0x6F, 0x6B,
            0x65, 0x72, 0x22, 0x20, 0x75, 0x69, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
            0x3D, 0x22, 0x66, 0x61, 0x6C, 0x73, 0x65, 0x22, 0x2F, 0x3E, 0x0D, 0x0A,
            0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3C, 0x2F, 0x72, 0x65, 0x71, 0x75,
            0x65, 0x73, 0x74, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6C, 0x65,
            0x67, 0x65, 0x73, 0x3E, 0x0D, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x3C, 0x2F,
            0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x3E, 0x0D, 0x0A, 0x20,
            0x20, 0x3C, 0x2F, 0x74, 0x72, 0x75, 0x73, 0x74, 0x49, 0x6E, 0x66, 0x6F,
            0x3E, 0x0D, 0x0A, 0x3C, 0x2F, 0x61, 0x73, 0x73, 0x65, 0x6D, 0x62, 0x6C,
            0x79, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x20, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x88, 0x38, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };
    }
}
