# IronPentest

## Description
IronPentest is a collection of pentesting tools converted from C# and PowerShell and written in the IronPython language. The goal is to write tools using .NET calls with as little use of the Python Standard Library as possible. Essentially, they can be considered C# equivalents for those with a Python background. Testing has only been performed on Windows 10 Build 17134.

Scripts must be compiled with `ipyc.exe` to be used in Windows environments, unless the Windows environment also happens to have IronPython.

## Requirements
- IronPython 2.7.9

## Notes
It is possible to compile scripts that `import` from the Python Standard Library however it requires a lot of work to include the `.py` files that get imported. An alternative route might be to compile the entire Python Standard Library into a DLL to compile with the script but that would result in larger than needed executables.

Additionally, scripts that import `clrtype` appear to have issues running even if compiled in the executable. However, for the purposes of this repo, `clrtype` is only needed if trying to use scripts that use a class like `NativeMethods` (i.e. `amsibypass-template.py`).

#### Shells
- Compatible with both IPv4/IPv6. Recommend use of `socat` over `netcat` for connections. Additionally, the ICMP shell should use the provided listener (written in plain Python for ease).

### Misc
- Additional scripts that might have some use if you wish to implement.

## Thanks
Mostly for providing motivation and/or examples of code for conversion.

- byt3bl33d3r - https://github.com/byt3bl33d3r/SILENTTRINITY

- elitest - https://twitter.com/elitest

- Threat Express - http://threatexpress.com/

- Bank Security - https://medium.com/@Bank_Security

