package azurerm

// Code generated by 'go generate'; DO NOT EDIT
import (
	"context"

	"github.com/pkg/errors"

	"github.com/Azure/azure-sdk-for-go/services/apimanagement/mgmt/2021-08-01/apimanagement"
	"github.com/Azure/azure-sdk-for-go/services/appinsights/mgmt/2020-02-02/insights"
	"github.com/Azure/azure-sdk-for-go/services/compute/mgmt/2021-12-01/compute"
	"github.com/Azure/azure-sdk-for-go/services/containerregistry/mgmt/2019-05-01/containerregistry"
	"github.com/Azure/azure-sdk-for-go/services/containerservice/mgmt/2022-01-01/containerservice"
	"github.com/Azure/azure-sdk-for-go/services/dataprotection/mgmt/2021-07-01/dataprotection"
	"github.com/Azure/azure-sdk-for-go/services/dns/mgmt/2018-05-01/dns"
	"github.com/Azure/azure-sdk-for-go/services/logic/mgmt/2019-05-01/logic"
	"github.com/Azure/azure-sdk-for-go/services/mariadb/mgmt/2020-01-01/mariadb"
	newActivityLogAlertsClient "github.com/Azure/azure-sdk-for-go/services/monitor/mgmt/2020-10-01/insights"
	"github.com/Azure/azure-sdk-for-go/services/mysql/mgmt/2020-01-01/mysql"
	"github.com/Azure/azure-sdk-for-go/services/network/mgmt/2021-05-01/network"
	"github.com/Azure/azure-sdk-for-go/services/operationalinsights/mgmt/2020-08-01/operationalinsights"
	"github.com/Azure/azure-sdk-for-go/services/postgresql/mgmt/2020-01-01/postgresql"
	"github.com/Azure/azure-sdk-for-go/services/preview/desktopvirtualization/mgmt/2021-09-03-preview/desktopvirtualization"
	"github.com/Azure/azure-sdk-for-go/services/preview/keyvault/mgmt/2020-04-01-preview/keyvault"
	monitor "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2021-07-01-preview/insights"
	newActionGroupClient "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2021-09-01-preview/insights"
	"github.com/Azure/azure-sdk-for-go/services/preview/policyinsights/mgmt/2020-07-01-preview/policyinsights"
	"github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2021-06-01-preview/policy"
	"github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/v5.0/sql"
	"github.com/Azure/azure-sdk-for-go/services/preview/sqlvirtualmachine/mgmt/2017-03-01-preview/sqlvirtualmachine"
	"github.com/Azure/azure-sdk-for-go/services/privatedns/mgmt/2018-09-01/privatedns"
	"github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2021-08-01/recoveryservices"
	"github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2021-12-01/backup"
	"github.com/Azure/azure-sdk-for-go/services/redis/mgmt/2020-12-01/redis"
	"github.com/Azure/azure-sdk-for-go/services/storage/mgmt/2021-08-01/storage"
	"github.com/Azure/azure-sdk-for-go/services/web/mgmt/2021-03-01/web"
)

// ListVirtualMachines returns a list of VirtualMachines within a subscription and a resource group
func (ar *AzureReader) ListVirtualMachines(ctx context.Context, filter string) ([]compute.VirtualMachine, error) {
	client := compute.NewVirtualMachinesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), filter)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list compute.VirtualMachine from Azure APIs")
	}

	resources := make([]compute.VirtualMachine, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualMachineScaleSets returns a list of VirtualMachineScaleSets within a subscription and a resource group
func (ar *AzureReader) ListVirtualMachineScaleSets(ctx context.Context) ([]compute.VirtualMachineScaleSet, error) {
	client := compute.NewVirtualMachineScaleSetsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list compute.VirtualMachineScaleSet from Azure APIs")
	}

	resources := make([]compute.VirtualMachineScaleSet, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualMachineScaleSetExtensions returns a list of VirtualMachineScaleSetExtensions within a subscription and a resource group
func (ar *AzureReader) ListVirtualMachineScaleSetExtensions(ctx context.Context, VMScaleSetName string) ([]compute.VirtualMachineScaleSetExtension, error) {
	client := compute.NewVirtualMachineScaleSetExtensionsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), VMScaleSetName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list compute.VirtualMachineScaleSetExtension from Azure APIs")
	}

	resources := make([]compute.VirtualMachineScaleSetExtension, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualMachineExtensions returns a list of VirtualMachineExtensions within a subscription and a resource group
func (ar *AzureReader) ListVirtualMachineExtensions(ctx context.Context, VMName string, expand string) ([]compute.VirtualMachineExtension, error) {
	client := compute.NewVirtualMachineExtensionsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), VMName, expand)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list compute.VirtualMachineExtension from Azure APIs")
	}

	return *output.Value, nil

}

// ListAvailabilitySets returns a list of AvailabilitySets within a subscription and a resource group
func (ar *AzureReader) ListAvailabilitySets(ctx context.Context) ([]compute.AvailabilitySet, error) {
	client := compute.NewAvailabilitySetsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list compute.AvailabilitySet from Azure APIs")
	}

	resources := make([]compute.AvailabilitySet, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListImages returns a list of Images within a subscription
func (ar *AzureReader) ListImages(ctx context.Context) ([]compute.Image, error) {
	client := compute.NewImagesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list compute.Image from Azure APIs")
	}

	resources := make([]compute.Image, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListDisks returns a list of Disks within a subscription and a resource group
func (ar *AzureReader) ListDisks(ctx context.Context) ([]compute.Disk, error) {
	client := compute.NewDisksClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list compute.Disk from Azure APIs")
	}

	resources := make([]compute.Disk, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualNetworks returns a list of VirtualNetworks within a subscription and a resource group
func (ar *AzureReader) ListVirtualNetworks(ctx context.Context) ([]network.VirtualNetwork, error) {
	client := network.NewVirtualNetworksClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.VirtualNetwork from Azure APIs")
	}

	resources := make([]network.VirtualNetwork, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSubnets returns a list of Subnets within a subscription and a resource group
func (ar *AzureReader) ListSubnets(ctx context.Context, virtualNetworkName string) ([]network.Subnet, error) {
	client := network.NewSubnetsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), virtualNetworkName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.Subnet from Azure APIs")
	}

	resources := make([]network.Subnet, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListInterfaces returns a list of Interfaces within a subscription and a resource group
func (ar *AzureReader) ListInterfaces(ctx context.Context) ([]network.Interface, error) {
	client := network.NewInterfacesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.Interface from Azure APIs")
	}

	resources := make([]network.Interface, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSecurityGroups returns a list of SecurityGroups within a subscription and a resource group
func (ar *AzureReader) ListSecurityGroups(ctx context.Context) ([]network.SecurityGroup, error) {
	client := network.NewSecurityGroupsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.SecurityGroup from Azure APIs")
	}

	resources := make([]network.SecurityGroup, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListApplicationGateways returns a list of ApplicationGateways within a subscription and a resource group
func (ar *AzureReader) ListApplicationGateways(ctx context.Context) ([]network.ApplicationGateway, error) {
	client := network.NewApplicationGatewaysClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.ApplicationGateway from Azure APIs")
	}

	resources := make([]network.ApplicationGateway, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListApplicationSecurityGroups returns a list of ApplicationSecurityGroups within a subscription and a resource group
func (ar *AzureReader) ListApplicationSecurityGroups(ctx context.Context) ([]network.ApplicationSecurityGroup, error) {
	client := network.NewApplicationSecurityGroupsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.ApplicationSecurityGroup from Azure APIs")
	}

	resources := make([]network.ApplicationSecurityGroup, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListDdosProtectionPlans returns a list of DdosProtectionPlans within a subscription
func (ar *AzureReader) ListDdosProtectionPlans(ctx context.Context) ([]network.DdosProtectionPlan, error) {
	client := network.NewDdosProtectionPlansClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.DdosProtectionPlan from Azure APIs")
	}

	resources := make([]network.DdosProtectionPlan, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListAzureFirewalls returns a list of AzureFirewalls within a subscription and a resource group
func (ar *AzureReader) ListAzureFirewalls(ctx context.Context) ([]network.AzureFirewall, error) {
	client := network.NewAzureFirewallsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.AzureFirewall from Azure APIs")
	}

	resources := make([]network.AzureFirewall, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListLocalNetworkGateways returns a list of LocalNetworkGateways within a subscription and a resource group
func (ar *AzureReader) ListLocalNetworkGateways(ctx context.Context) ([]network.LocalNetworkGateway, error) {
	client := network.NewLocalNetworkGatewaysClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.LocalNetworkGateway from Azure APIs")
	}

	resources := make([]network.LocalNetworkGateway, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListNatGateways returns a list of NatGateways within a subscription and a resource group
func (ar *AzureReader) ListNatGateways(ctx context.Context) ([]network.NatGateway, error) {
	client := network.NewNatGatewaysClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.NatGateway from Azure APIs")
	}

	resources := make([]network.NatGateway, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListProfiles returns a list of Profiles within a subscription and a resource group
func (ar *AzureReader) ListProfiles(ctx context.Context) ([]network.Profile, error) {
	client := network.NewProfilesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.Profile from Azure APIs")
	}

	resources := make([]network.Profile, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSecurityRules returns a list of SecurityRules within a subscription and a resource group
func (ar *AzureReader) ListSecurityRules(ctx context.Context, networkSecurityGroupName string) ([]network.SecurityRule, error) {
	client := network.NewSecurityRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), networkSecurityGroupName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.SecurityRule from Azure APIs")
	}

	resources := make([]network.SecurityRule, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPublicIPAddresses returns a list of PublicIPAddresses within a subscription and a resource group
func (ar *AzureReader) ListPublicIPAddresses(ctx context.Context) ([]network.PublicIPAddress, error) {
	client := network.NewPublicIPAddressesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.PublicIPAddress from Azure APIs")
	}

	resources := make([]network.PublicIPAddress, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPublicIPPrefixes returns a list of PublicIPPrefixes within a subscription and a resource group
func (ar *AzureReader) ListPublicIPPrefixes(ctx context.Context) ([]network.PublicIPPrefix, error) {
	client := network.NewPublicIPPrefixesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.PublicIPPrefix from Azure APIs")
	}

	resources := make([]network.PublicIPPrefix, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListRoutes returns a list of Routes within a subscription and a resource group
func (ar *AzureReader) ListRoutes(ctx context.Context, routeTableName string) ([]network.Route, error) {
	client := network.NewRoutesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), routeTableName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.Route from Azure APIs")
	}

	resources := make([]network.Route, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListRouteTables returns a list of RouteTables within a subscription and a resource group
func (ar *AzureReader) ListRouteTables(ctx context.Context) ([]network.RouteTable, error) {
	client := network.NewRouteTablesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.RouteTable from Azure APIs")
	}

	resources := make([]network.RouteTable, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualNetworkGateways returns a list of VirtualNetworkGateways within a subscription and a resource group
func (ar *AzureReader) ListVirtualNetworkGateways(ctx context.Context) ([]network.VirtualNetworkGateway, error) {
	client := network.NewVirtualNetworkGatewaysClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.VirtualNetworkGateway from Azure APIs")
	}

	resources := make([]network.VirtualNetworkGateway, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualNetworkGatewayConnections returns a list of VirtualNetworkGatewayConnections within a subscription and a resource group
func (ar *AzureReader) ListVirtualNetworkGatewayConnections(ctx context.Context) ([]network.VirtualNetworkGatewayConnection, error) {
	client := network.NewVirtualNetworkGatewayConnectionsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.VirtualNetworkGatewayConnection from Azure APIs")
	}

	resources := make([]network.VirtualNetworkGatewayConnection, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualNetworkPeerings returns a list of VirtualNetworkPeerings within a subscription and a resource group
func (ar *AzureReader) ListVirtualNetworkPeerings(ctx context.Context, virtualNetworkName string) ([]network.VirtualNetworkPeering, error) {
	client := network.NewVirtualNetworkPeeringsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), virtualNetworkName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.VirtualNetworkPeering from Azure APIs")
	}

	resources := make([]network.VirtualNetworkPeering, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListWebApplicationFirewallPolicies returns a list of WebApplicationFirewallPolicies within a subscription and a resource group
func (ar *AzureReader) ListWebApplicationFirewallPolicies(ctx context.Context) ([]network.WebApplicationFirewallPolicy, error) {
	client := network.NewWebApplicationFirewallPoliciesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.WebApplicationFirewallPolicy from Azure APIs")
	}

	resources := make([]network.WebApplicationFirewallPolicy, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualHubs returns a list of VirtualHubs within a subscription
func (ar *AzureReader) ListVirtualHubs(ctx context.Context) ([]network.VirtualHub, error) {
	client := network.NewVirtualHubsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.VirtualHub from Azure APIs")
	}

	resources := make([]network.VirtualHub, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualHubBgpConnections returns a list of VirtualHubBgpConnections within a subscription and a resource group
func (ar *AzureReader) ListVirtualHubBgpConnections(ctx context.Context, virtualHubName string) ([]network.BgpConnection, error) {
	client := network.NewVirtualHubBgpConnectionsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), virtualHubName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.BgpConnection from Azure APIs")
	}

	resources := make([]network.BgpConnection, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListHubVirtualNetworkConnections returns a list of HubVirtualNetworkConnections within a subscription and a resource group
func (ar *AzureReader) ListHubVirtualNetworkConnections(ctx context.Context, virtualHubName string) ([]network.HubVirtualNetworkConnection, error) {
	client := network.NewHubVirtualNetworkConnectionsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), virtualHubName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.HubVirtualNetworkConnection from Azure APIs")
	}

	resources := make([]network.HubVirtualNetworkConnection, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListVirtualHubIPConfiguration returns a list of VirtualHubIPConfiguration within a subscription and a resource group
func (ar *AzureReader) ListVirtualHubIPConfiguration(ctx context.Context, virtualHubName string) ([]network.HubIPConfiguration, error) {
	client := network.NewVirtualHubIPConfigurationClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), virtualHubName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.HubIPConfiguration from Azure APIs")
	}

	resources := make([]network.HubIPConfiguration, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListHubRouteTables returns a list of HubRouteTables within a subscription and a resource group
func (ar *AzureReader) ListHubRouteTables(ctx context.Context, virtualHubName string) ([]network.HubRouteTable, error) {
	client := network.NewHubRouteTablesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), virtualHubName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.HubRouteTable from Azure APIs")
	}

	resources := make([]network.HubRouteTable, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSecurityPartnerProviders returns a list of SecurityPartnerProviders within a subscription
func (ar *AzureReader) ListSecurityPartnerProviders(ctx context.Context) ([]network.SecurityPartnerProvider, error) {
	client := network.NewSecurityPartnerProvidersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.SecurityPartnerProvider from Azure APIs")
	}

	resources := make([]network.SecurityPartnerProvider, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListLoadBalancers returns a list of LoadBalancers within a subscription and a resource group
func (ar *AzureReader) ListLoadBalancers(ctx context.Context) ([]network.LoadBalancer, error) {
	client := network.NewLoadBalancersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.LoadBalancer from Azure APIs")
	}

	resources := make([]network.LoadBalancer, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListLoadBalancerBackendAddressPools returns a list of LoadBalancerBackendAddressPools within a subscription and a resource group
func (ar *AzureReader) ListLoadBalancerBackendAddressPools(ctx context.Context, loadBalancerName string) ([]network.BackendAddressPool, error) {
	client := network.NewLoadBalancerBackendAddressPoolsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), loadBalancerName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list network.BackendAddressPool from Azure APIs")
	}

	resources := make([]network.BackendAddressPool, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListHostPools returns a list of HostPools within a subscription and a resource group
func (ar *AzureReader) ListHostPools(ctx context.Context) ([]desktopvirtualization.HostPool, error) {
	client := desktopvirtualization.NewHostPoolsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list desktopvirtualization.HostPool from Azure APIs")
	}

	resources := make([]desktopvirtualization.HostPool, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListApplicationGroups returns a list of ApplicationGroups within a subscription and a resource group
func (ar *AzureReader) ListApplicationGroups(ctx context.Context, filter string) ([]desktopvirtualization.ApplicationGroup, error) {
	client := desktopvirtualization.NewApplicationGroupsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName(), filter)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list desktopvirtualization.ApplicationGroup from Azure APIs")
	}

	resources := make([]desktopvirtualization.ApplicationGroup, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListWorkflows returns a list of Workflows within a subscription and a resource group
func (ar *AzureReader) ListWorkflows(ctx context.Context, top *int32, filter string) ([]logic.Workflow, error) {
	client := logic.NewWorkflowsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName(), top, filter)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list logic.Workflow from Azure APIs")
	}

	resources := make([]logic.Workflow, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListWorkflowTriggers returns a list of WorkflowTriggers within a subscription and a resource group
func (ar *AzureReader) ListWorkflowTriggers(ctx context.Context, workflowName string, top *int32, filter string) ([]logic.WorkflowTrigger, error) {
	client := logic.NewWorkflowTriggersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), workflowName, top, filter)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list logic.WorkflowTrigger from Azure APIs")
	}

	resources := make([]logic.WorkflowTrigger, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListWorkflowRuns returns a list of WorkflowRuns within a subscription and a resource group
func (ar *AzureReader) ListWorkflowRuns(ctx context.Context, workflowName string, top *int32, filter string) ([]logic.WorkflowRun, error) {
	client := logic.NewWorkflowRunsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), workflowName, top, filter)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list logic.WorkflowRun from Azure APIs")
	}

	resources := make([]logic.WorkflowRun, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListWorkflowRunActions returns a list of WorkflowRunActions within a subscription and a resource group
func (ar *AzureReader) ListWorkflowRunActions(ctx context.Context, workflowName string, runName string, top *int32, filter string) ([]logic.WorkflowRunAction, error) {
	client := logic.NewWorkflowRunActionsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), workflowName, runName, top, filter)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list logic.WorkflowRunAction from Azure APIs")
	}

	resources := make([]logic.WorkflowRunAction, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListContainerRegistries returns a list of Registries within a subscription
func (ar *AzureReader) ListContainerRegistries(ctx context.Context) ([]containerregistry.Registry, error) {
	client := containerregistry.NewRegistriesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list containerregistry.Registry from Azure APIs")
	}

	resources := make([]containerregistry.Registry, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListContainerRegistryWebhooks returns a list of Webhooks within a subscription and a resource group
func (ar *AzureReader) ListContainerRegistryWebhooks(ctx context.Context, registryName string) ([]containerregistry.Webhook, error) {
	client := containerregistry.NewWebhooksClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), registryName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list containerregistry.Webhook from Azure APIs")
	}

	resources := make([]containerregistry.Webhook, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListKubernetesClusters returns a list of ManagedClusters within a subscription
func (ar *AzureReader) ListKubernetesClusters(ctx context.Context) ([]containerservice.ManagedCluster, error) {
	client := containerservice.NewManagedClustersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list containerservice.ManagedCluster from Azure APIs")
	}

	resources := make([]containerservice.ManagedCluster, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListKubernetesClusterNodes returns a list of AgentPools within a subscription and a resource group
func (ar *AzureReader) ListKubernetesClusterNodes(ctx context.Context, managedClusterName string) ([]containerservice.AgentPool, error) {
	client := containerservice.NewAgentPoolsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), managedClusterName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list containerservice.AgentPool from Azure APIs")
	}

	resources := make([]containerservice.AgentPool, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSTORAGEAccounts returns a list of Accounts within a subscription and a resource group
func (ar *AzureReader) ListSTORAGEAccounts(ctx context.Context) ([]storage.Account, error) {
	client := storage.NewAccountsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list storage.Account from Azure APIs")
	}

	resources := make([]storage.Account, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSTORAGEBlobContainers returns a list of BlobContainers within a subscription and a resource group
func (ar *AzureReader) ListSTORAGEBlobContainers(ctx context.Context, accountName string, maxpagesize string, filter string, include storage.ListContainersInclude) ([]storage.ListContainerItem, error) {
	client := storage.NewBlobContainersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), accountName, maxpagesize, filter, include)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list storage.ListContainerItem from Azure APIs")
	}

	resources := make([]storage.ListContainerItem, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSTORAGEQueue returns a list of Queue within a subscription and a resource group
func (ar *AzureReader) ListSTORAGEQueue(ctx context.Context, accountName string, maxpagesize string, filter string) ([]storage.ListQueue, error) {
	client := storage.NewQueueClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), accountName, maxpagesize, filter)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list storage.ListQueue from Azure APIs")
	}

	resources := make([]storage.ListQueue, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSTORAGEFileShares returns a list of FileShares within a subscription and a resource group
func (ar *AzureReader) ListSTORAGEFileShares(ctx context.Context, accountName string, maxpagesize string, filter string, expand string) ([]storage.FileShareItem, error) {
	client := storage.NewFileSharesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), accountName, maxpagesize, filter, expand)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list storage.FileShareItem from Azure APIs")
	}

	resources := make([]storage.FileShareItem, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSTORAGETable returns a list of Table within a subscription and a resource group
func (ar *AzureReader) ListSTORAGETable(ctx context.Context, accountName string) ([]storage.Table, error) {
	client := storage.NewTableClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), accountName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list storage.Table from Azure APIs")
	}

	resources := make([]storage.Table, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListMARIADBConfigurations returns a list of Configurations within a subscription and a resource group
func (ar *AzureReader) ListMARIADBConfigurations(ctx context.Context, serverName string) ([]mariadb.Configuration, error) {
	client := mariadb.NewConfigurationsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mariadb.Configuration from Azure APIs")
	}

	return *output.Value, nil

}

// ListMARIADBDatabases returns a list of Databases within a subscription and a resource group
func (ar *AzureReader) ListMARIADBDatabases(ctx context.Context, serverName string) ([]mariadb.Database, error) {
	client := mariadb.NewDatabasesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mariadb.Database from Azure APIs")
	}

	return *output.Value, nil

}

// ListMARIADBFirewallRules returns a list of FirewallRules within a subscription and a resource group
func (ar *AzureReader) ListMARIADBFirewallRules(ctx context.Context, serverName string) ([]mariadb.FirewallRule, error) {
	client := mariadb.NewFirewallRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mariadb.FirewallRule from Azure APIs")
	}

	return *output.Value, nil

}

// ListMARIADBServers returns a list of Servers within a subscription
func (ar *AzureReader) ListMARIADBServers(ctx context.Context) ([]mariadb.Server, error) {
	client := mariadb.NewServersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mariadb.Server from Azure APIs")
	}

	return *output.Value, nil

}

// ListMARIADBVirtualNetworkRules returns a list of VirtualNetworkRules within a subscription and a resource group
func (ar *AzureReader) ListMARIADBVirtualNetworkRules(ctx context.Context, serverName string) ([]mariadb.VirtualNetworkRule, error) {
	client := mariadb.NewVirtualNetworkRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mariadb.VirtualNetworkRule from Azure APIs")
	}

	resources := make([]mariadb.VirtualNetworkRule, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListMYSQLConfigurations returns a list of Configurations within a subscription and a resource group
func (ar *AzureReader) ListMYSQLConfigurations(ctx context.Context, serverName string) ([]mysql.Configuration, error) {
	client := mysql.NewConfigurationsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mysql.Configuration from Azure APIs")
	}

	return *output.Value, nil

}

// ListMYSQLDatabases returns a list of Databases within a subscription and a resource group
func (ar *AzureReader) ListMYSQLDatabases(ctx context.Context, serverName string) ([]mysql.Database, error) {
	client := mysql.NewDatabasesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mysql.Database from Azure APIs")
	}

	return *output.Value, nil

}

// ListMYSQLFirewallRules returns a list of FirewallRules within a subscription and a resource group
func (ar *AzureReader) ListMYSQLFirewallRules(ctx context.Context, serverName string) ([]mysql.FirewallRule, error) {
	client := mysql.NewFirewallRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mysql.FirewallRule from Azure APIs")
	}

	return *output.Value, nil

}

// ListMYSQLServers returns a list of Servers within a subscription
func (ar *AzureReader) ListMYSQLServers(ctx context.Context) ([]mysql.Server, error) {
	client := mysql.NewServersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mysql.Server from Azure APIs")
	}

	return *output.Value, nil

}

// ListMYSQLVirtualNetworkRules returns a list of VirtualNetworkRules within a subscription and a resource group
func (ar *AzureReader) ListMYSQLVirtualNetworkRules(ctx context.Context, serverName string) ([]mysql.VirtualNetworkRule, error) {
	client := mysql.NewVirtualNetworkRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list mysql.VirtualNetworkRule from Azure APIs")
	}

	resources := make([]mysql.VirtualNetworkRule, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPOSTGRESQLConfigurations returns a list of Configurations within a subscription and a resource group
func (ar *AzureReader) ListPOSTGRESQLConfigurations(ctx context.Context, serverName string) ([]postgresql.Configuration, error) {
	client := postgresql.NewConfigurationsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list postgresql.Configuration from Azure APIs")
	}

	return *output.Value, nil

}

// ListPOSTGRESQLDatabases returns a list of Databases within a subscription and a resource group
func (ar *AzureReader) ListPOSTGRESQLDatabases(ctx context.Context, serverName string) ([]postgresql.Database, error) {
	client := postgresql.NewDatabasesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list postgresql.Database from Azure APIs")
	}

	return *output.Value, nil

}

// ListPOSTGRESQLFirewallRules returns a list of FirewallRules within a subscription and a resource group
func (ar *AzureReader) ListPOSTGRESQLFirewallRules(ctx context.Context, serverName string) ([]postgresql.FirewallRule, error) {
	client := postgresql.NewFirewallRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list postgresql.FirewallRule from Azure APIs")
	}

	return *output.Value, nil

}

// ListPOSTGRESQLServers returns a list of Servers within a subscription
func (ar *AzureReader) ListPOSTGRESQLServers(ctx context.Context) ([]postgresql.Server, error) {
	client := postgresql.NewServersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list postgresql.Server from Azure APIs")
	}

	return *output.Value, nil

}

// ListPOSTGRESQLVirtualNetworkRules returns a list of VirtualNetworkRules within a subscription and a resource group
func (ar *AzureReader) ListPOSTGRESQLVirtualNetworkRules(ctx context.Context, serverName string) ([]postgresql.VirtualNetworkRule, error) {
	client := postgresql.NewVirtualNetworkRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list postgresql.VirtualNetworkRule from Azure APIs")
	}

	resources := make([]postgresql.VirtualNetworkRule, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSQLDatabases returns a list of Databases within a subscription and a resource group
func (ar *AzureReader) ListSQLDatabases(ctx context.Context, serverName string, skipToken string) ([]sql.Database, error) {
	client := sql.NewDatabasesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName, skipToken)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list sql.Database from Azure APIs")
	}

	resources := make([]sql.Database, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSQLElasticPools returns a list of ElasticPools within a subscription and a resource group
func (ar *AzureReader) ListSQLElasticPools(ctx context.Context, serverName string, skip *int32) ([]sql.ElasticPool, error) {
	client := sql.NewElasticPoolsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName, skip)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list sql.ElasticPool from Azure APIs")
	}

	resources := make([]sql.ElasticPool, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSQLFirewallRules returns a list of FirewallRules within a subscription and a resource group
func (ar *AzureReader) ListSQLFirewallRules(ctx context.Context, serverName string) ([]sql.FirewallRule, error) {
	client := sql.NewFirewallRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list sql.FirewallRule from Azure APIs")
	}

	resources := make([]sql.FirewallRule, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSQLServers returns a list of Servers within a subscription
func (ar *AzureReader) ListSQLServers(ctx context.Context, expand string) ([]sql.Server, error) {
	client := sql.NewServersClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, expand)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list sql.Server from Azure APIs")
	}

	resources := make([]sql.Server, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSQLServerSecurityAlertPolicies returns a list of ServerSecurityAlertPolicies within a subscription and a resource group
func (ar *AzureReader) ListSQLServerSecurityAlertPolicies(ctx context.Context, serverName string) ([]sql.ServerSecurityAlertPolicy, error) {
	client := sql.NewServerSecurityAlertPoliciesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list sql.ServerSecurityAlertPolicy from Azure APIs")
	}

	resources := make([]sql.ServerSecurityAlertPolicy, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSQLServerVulnerabilityAssessments returns a list of ServerVulnerabilityAssessments within a subscription and a resource group
func (ar *AzureReader) ListSQLServerVulnerabilityAssessments(ctx context.Context, serverName string) ([]sql.ServerVulnerabilityAssessment, error) {
	client := sql.NewServerVulnerabilityAssessmentsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list sql.ServerVulnerabilityAssessment from Azure APIs")
	}

	resources := make([]sql.ServerVulnerabilityAssessment, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSQLVirtualNetworkRules returns a list of VirtualNetworkRules within a subscription and a resource group
func (ar *AzureReader) ListSQLVirtualNetworkRules(ctx context.Context, serverName string) ([]sql.VirtualNetworkRule, error) {
	client := sql.NewVirtualNetworkRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByServer(ctx, ar.GetResourceGroupName(), serverName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list sql.VirtualNetworkRule from Azure APIs")
	}

	resources := make([]sql.VirtualNetworkRule, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSQLVirtualMachines returns a list of SQLVirtualMachines within a subscription
func (ar *AzureReader) ListSQLVirtualMachines(ctx context.Context) ([]sqlvirtualmachine.SQLVirtualMachine, error) {
	client := sqlvirtualmachine.NewSQLVirtualMachinesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list sqlvirtualmachine.SQLVirtualMachine from Azure APIs")
	}

	resources := make([]sqlvirtualmachine.SQLVirtualMachine, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListRedisCaches returns a list of RedisCaches within a subscription and a resource group
func (ar *AzureReader) ListRedisCaches(ctx context.Context) ([]redis.ResourceType, error) {
	client := redis.NewClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list redis.ResourceType from Azure APIs")
	}

	resources := make([]redis.ResourceType, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListREDISFirewallRules returns a list of FirewallRules within a subscription and a resource group
func (ar *AzureReader) ListREDISFirewallRules(ctx context.Context, cacheName string) ([]redis.FirewallRule, error) {
	client := redis.NewFirewallRulesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), cacheName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list redis.FirewallRule from Azure APIs")
	}

	resources := make([]redis.FirewallRule, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListDNSZones returns a list of Zones within a subscription
func (ar *AzureReader) ListDNSZones(ctx context.Context, top *int32) ([]dns.Zone, error) {
	client := dns.NewZonesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, top)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list dns.Zone from Azure APIs")
	}

	resources := make([]dns.Zone, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListDNSRecordSets returns a list of RecordSets within a subscription and a resource group
func (ar *AzureReader) ListDNSRecordSets(ctx context.Context, zoneName string, top *int32, recordSetNameSuffix string) ([]dns.RecordSet, error) {
	client := dns.NewRecordSetsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListAllByDNSZone(ctx, ar.GetResourceGroupName(), zoneName, top, recordSetNameSuffix)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list dns.RecordSet from Azure APIs")
	}

	resources := make([]dns.RecordSet, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPRIVATEDNSPrivateZones returns a list of PrivateZones within a subscription
func (ar *AzureReader) ListPRIVATEDNSPrivateZones(ctx context.Context, top *int32) ([]privatedns.PrivateZone, error) {
	client := privatedns.NewPrivateZonesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, top)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list privatedns.PrivateZone from Azure APIs")
	}

	resources := make([]privatedns.PrivateZone, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPRIVATEDNSRecordSets returns a list of RecordSets within a subscription and a resource group
func (ar *AzureReader) ListPRIVATEDNSRecordSets(ctx context.Context, zoneName string, top *int32, recordSetNameSuffix string) ([]privatedns.RecordSet, error) {
	client := privatedns.NewRecordSetsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), zoneName, top, recordSetNameSuffix)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list privatedns.RecordSet from Azure APIs")
	}

	resources := make([]privatedns.RecordSet, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPRIVATEDNSVirtualNetworkLinks returns a list of VirtualNetworkLinks within a subscription and a resource group
func (ar *AzureReader) ListPRIVATEDNSVirtualNetworkLinks(ctx context.Context, privateZoneName string, top *int32) ([]privatedns.VirtualNetworkLink, error) {
	client := privatedns.NewVirtualNetworkLinksClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), privateZoneName, top)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list privatedns.VirtualNetworkLink from Azure APIs")
	}

	resources := make([]privatedns.VirtualNetworkLink, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPOLICYDefinitions returns a list of Definitions within a subscription
func (ar *AzureReader) ListPOLICYDefinitions(ctx context.Context, filter string, top *int32) ([]policy.Definition, error) {
	client := policy.NewDefinitionsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, filter, top)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list policy.Definition from Azure APIs")
	}

	resources := make([]policy.Definition, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPOLICYSetDefinitions returns a list of SetDefinitions within a subscription
func (ar *AzureReader) ListPOLICYSetDefinitions(ctx context.Context, filter string, top *int32) ([]policy.SetDefinition, error) {
	client := policy.NewSetDefinitionsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, filter, top)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list policy.SetDefinition from Azure APIs")
	}

	resources := make([]policy.SetDefinition, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListPOLICYINSIGHTSRemediations returns a list of Remediations within a subscription and a resource group
func (ar *AzureReader) ListPOLICYINSIGHTSRemediations(ctx context.Context, top *int32, filter string) ([]policyinsights.Remediation, error) {
	client := policyinsights.NewRemediationsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListForResourceGroup(ctx, ar.config.SubscriptionID, ar.GetResourceGroupName(), top, filter)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list policyinsights.Remediation from Azure APIs")
	}

	resources := make([]policyinsights.Remediation, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListKeyVaults returns a list of Vaults within a subscription and a resource group
func (ar *AzureReader) ListKeyVaults(ctx context.Context, top *int32) ([]keyvault.Vault, error) {
	client := keyvault.NewVaultsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName(), top)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list keyvault.Vault from Azure APIs")
	}

	resources := make([]keyvault.Vault, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListINSIGHTSComponents returns a list of Components within a subscription
func (ar *AzureReader) ListINSIGHTSComponents(ctx context.Context) ([]insights.ApplicationInsightsComponent, error) {
	client := insights.NewComponentsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list insights.ApplicationInsightsComponent from Azure APIs")
	}

	resources := make([]insights.ApplicationInsightsComponent, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListINSIGHTSAPIKeys returns a list of APIKeys within a subscription and a resource group
func (ar *AzureReader) ListINSIGHTSAPIKeys(ctx context.Context, ApplicationInsightsComponent string) ([]insights.ApplicationInsightsComponentAPIKey, error) {
	client := insights.NewAPIKeysClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), ApplicationInsightsComponent)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list insights.ApplicationInsightsComponentAPIKey from Azure APIs")
	}

	return *output.Value, nil

}

// ListINSIGHTSAnalyticsItems returns a list of AnalyticsItems within a subscription and a resource group
func (ar *AzureReader) ListINSIGHTSAnalyticsItems(ctx context.Context, ApplicationInsightsComponent string, scopePath insights.ItemScopePath, scope insights.ItemScope, typeParameter insights.ItemTypeParameter, includeContent *bool) ([]insights.ApplicationInsightsComponentAnalyticsItem, error) {
	client := insights.NewAnalyticsItemsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, ar.GetResourceGroupName(), ApplicationInsightsComponent, scopePath, scope, typeParameter, includeContent)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list insights.ApplicationInsightsComponentAnalyticsItem from Azure APIs")
	}

	return *output.Value, nil

}

// ListINSIGHTSWebTests returns a list of WebTests within a subscription
func (ar *AzureReader) ListINSIGHTSWebTests(ctx context.Context) ([]insights.WebTest, error) {
	client := insights.NewWebTestsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list insights.WebTest from Azure APIs")
	}

	resources := make([]insights.WebTest, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListLogAnalyticsWorkspaces returns a list of Workspaces within a subscription
func (ar *AzureReader) ListLogAnalyticsWorkspaces(ctx context.Context) ([]operationalinsights.Workspace, error) {
	client := operationalinsights.NewWorkspacesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list operationalinsights.Workspace from Azure APIs")
	}

	return *output.Value, nil

}

// ListLogAnalyticsLinkedService returns a list of LinkedServices within a subscription and a resource group
func (ar *AzureReader) ListLogAnalyticsLinkedService(ctx context.Context, workspaceName string) ([]operationalinsights.LinkedService, error) {
	client := operationalinsights.NewLinkedServicesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByWorkspace(ctx, ar.GetResourceGroupName(), workspaceName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list operationalinsights.LinkedService from Azure APIs")
	}

	return *output.Value, nil

}

// ListLogAnalyticsDatasource returns a list of DataSources within a subscription and a resource group
func (ar *AzureReader) ListLogAnalyticsDatasource(ctx context.Context, workspaceName string, filter string, skiptoken string) ([]operationalinsights.DataSource, error) {
	client := operationalinsights.NewDataSourcesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByWorkspace(ctx, ar.GetResourceGroupName(), workspaceName, filter, skiptoken)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list operationalinsights.DataSource from Azure APIs")
	}

	resources := make([]operationalinsights.DataSource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListMonitorActionsGroup returns a list of ActionGroupResources within a subscription and a resource group
func (ar *AzureReader) ListMonitorActionsGroup(ctx context.Context) ([]newActionGroupClient.ActionGroupResource, error) {
	client := newActionGroupClient.NewActionGroupsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list newActionGroupClient.ActionGroupResource from Azure APIs")
	}

	return *output.Value, nil

}

// ListMonitorActivityLogAlert returns a list of ActivityLogAlertResources within a subscription and a resource group
func (ar *AzureReader) ListMonitorActivityLogAlert(ctx context.Context) ([]newActivityLogAlertsClient.ActivityLogAlertResource, error) {
	client := newActivityLogAlertsClient.NewActivityLogAlertsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list newActivityLogAlertsClient.ActivityLogAlertResource from Azure APIs")
	}

	resources := make([]newActivityLogAlertsClient.ActivityLogAlertResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListMonitorAutoScaleSettings returns a list of AutoscaleSettingResources within a subscription and a resource group
func (ar *AzureReader) ListMonitorAutoScaleSettings(ctx context.Context) ([]monitor.AutoscaleSettingResource, error) {
	client := monitor.NewAutoscaleSettingsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list monitor.AutoscaleSettingResource from Azure APIs")
	}

	resources := make([]monitor.AutoscaleSettingResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListMonitorLogProfiles returns a list of LogProfileResources within a subscription
func (ar *AzureReader) ListMonitorLogProfiles(ctx context.Context) ([]monitor.LogProfileResource, error) {
	client := monitor.NewLogProfilesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list monitor.LogProfileResource from Azure APIs")
	}

	return *output.Value, nil

}

// ListMonitorMetricsAlerts returns a list of MetricAlertResources within a subscription and a resource group
func (ar *AzureReader) ListMonitorMetricsAlerts(ctx context.Context) ([]monitor.MetricAlertResource, error) {
	client := monitor.NewMetricAlertsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list monitor.MetricAlertResource from Azure APIs")
	}

	return *output.Value, nil

}

// ListWebApps returns a list of Sites within a subscription
func (ar *AzureReader) ListWebApps(ctx context.Context) ([]web.Site, error) {
	client := web.NewAppsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list web.Site from Azure APIs")
	}

	resources := make([]web.Site, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListDeploymentSlots returns a list of Sites within a subscription and a resource group
func (ar *AzureReader) ListDeploymentSlots(ctx context.Context, name string) ([]web.Site, error) {
	client := web.NewAppsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListSlots(ctx, ar.GetResourceGroupName(), name)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list web.Site from Azure APIs")
	}

	resources := make([]web.Site, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListAppServicePlans returns a list of AppServicePlans within a subscription
func (ar *AzureReader) ListAppServicePlans(ctx context.Context, detailed *bool) ([]web.AppServicePlan, error) {
	client := web.NewAppServicePlansClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, detailed)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list web.AppServicePlan from Azure APIs")
	}

	resources := make([]web.AppServicePlan, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListSourceControls returns a list of SourceControls within a subscription
func (ar *AzureReader) ListSourceControls(ctx context.Context) ([]web.SourceControl, error) {
	client := web.NewWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListSourceControls(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list web.SourceControl from Azure APIs")
	}

	resources := make([]web.SourceControl, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListStaticSites returns a list of StaticSiteARMResources within a subscription
func (ar *AzureReader) ListStaticSites(ctx context.Context) ([]web.StaticSiteARMResource, error) {
	client := web.NewStaticSitesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list web.StaticSiteARMResource from Azure APIs")
	}

	resources := make([]web.StaticSiteARMResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListStaticSitesCustomDomain returns a list of StaticSiteCustomDomainOverviewARMResources within a subscription and a resource group
func (ar *AzureReader) ListStaticSitesCustomDomain(ctx context.Context, name string) ([]web.StaticSiteCustomDomainOverviewARMResource, error) {
	client := web.NewStaticSitesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListStaticSiteCustomDomains(ctx, ar.GetResourceGroupName(), name)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list web.StaticSiteCustomDomainOverviewARMResource from Azure APIs")
	}

	resources := make([]web.StaticSiteCustomDomainOverviewARMResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListHybridConnections returns a list of HybridConnections within a subscription and a resource group
func (ar *AzureReader) ListHybridConnections(ctx context.Context, name string) ([]web.HybridConnection, error) {
	client := web.NewAppServicePlansClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListHybridConnections(ctx, ar.GetResourceGroupName(), name)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list web.HybridConnection from Azure APIs")
	}

	resources := make([]web.HybridConnection, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListBackupVaultResources returns a list of BackupVaultResources within a subscription and a resource group
func (ar *AzureReader) ListBackupVaultResources(ctx context.Context) ([]dataprotection.BackupVaultResource, error) {
	client := dataprotection.NewBackupVaultsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.GetInResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list dataprotection.BackupVaultResource from Azure APIs")
	}

	resources := make([]dataprotection.BackupVaultResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListBackupInstanceResources returns a list of BackupInstanceResources within a subscription and a resource group
func (ar *AzureReader) ListBackupInstanceResources(ctx context.Context, vaultName string) ([]dataprotection.BackupInstanceResource, error) {
	client := dataprotection.NewBackupInstancesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, vaultName, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list dataprotection.BackupInstanceResource from Azure APIs")
	}

	resources := make([]dataprotection.BackupInstanceResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListBaseBackupPolicyResources returns a list of BaseBackupPolicyResources within a subscription and a resource group
func (ar *AzureReader) ListBaseBackupPolicyResources(ctx context.Context, vaultName string) ([]dataprotection.BaseBackupPolicyResource, error) {
	client := dataprotection.NewBackupPoliciesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, vaultName, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list dataprotection.BaseBackupPolicyResource from Azure APIs")
	}

	resources := make([]dataprotection.BaseBackupPolicyResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListAPIManagementServiceResources returns a list of ServiceResources within a subscription
func (ar *AzureReader) ListAPIManagementServiceResources(ctx context.Context) ([]apimanagement.ServiceResource, error) {
	client := apimanagement.NewServiceClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list apimanagement.ServiceResource from Azure APIs")
	}

	resources := make([]apimanagement.ServiceResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListRecoveryServicesVault returns a list of Vaults within a subscription and a resource group
func (ar *AzureReader) ListRecoveryServicesVault(ctx context.Context) ([]recoveryservices.Vault, error) {
	client := recoveryservices.NewVaultsClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.ListByResourceGroup(ctx, ar.GetResourceGroupName())
	if err != nil {
		return nil, errors.Wrap(err, "unable to list recoveryservices.Vault from Azure APIs")
	}

	resources := make([]recoveryservices.Vault, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListBackupPolicies returns a list of ProtectionPolicyResources within a subscription and a resource group
func (ar *AzureReader) ListBackupPolicies(ctx context.Context, filter string, vaultName string) ([]backup.ProtectionPolicyResource, error) {
	client := backup.NewPoliciesClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, filter, ar.GetResourceGroupName(), vaultName)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list backup.ProtectionPolicyResource from Azure APIs")
	}

	resources := make([]backup.ProtectionPolicyResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}

// ListBackupProtectedItems returns a list of ProtectedItemResources within a subscription and a resource group
func (ar *AzureReader) ListBackupProtectedItems(ctx context.Context, vaultName string, filter string, skipToken string) ([]backup.ProtectedItemResource, error) {
	client := backup.NewProtectedItemsGroupClientWithBaseURI(ar.env.ResourceManagerEndpoint, ar.config.SubscriptionID)
	client.Authorizer = ar.authorizer

	output, err := client.List(ctx, vaultName, ar.GetResourceGroupName(), filter, skipToken)
	if err != nil {
		return nil, errors.Wrap(err, "unable to list backup.ProtectedItemResource from Azure APIs")
	}

	resources := make([]backup.ProtectedItemResource, 0)
	for output.NotDone() {

		for _, res := range output.Values() {
			resources = append(resources, res)
		}

		if err := output.NextWithContext(ctx); err != nil {
			break
		}
	}
	return resources, nil

}
