package reader

import (
	"context"

	"github.com/aws/aws-sdk-go/service/apigateway"
	"github.com/aws/aws-sdk-go/service/athena"
	"github.com/aws/aws-sdk-go/service/autoscaling"
	"github.com/aws/aws-sdk-go/service/batch"
	"github.com/aws/aws-sdk-go/service/cloudfront"
	"github.com/aws/aws-sdk-go/service/cloudwatch"
	"github.com/aws/aws-sdk-go/service/configservice"
	"github.com/aws/aws-sdk-go/service/databasemigrationservice"
	"github.com/aws/aws-sdk-go/service/dax"
	"github.com/aws/aws-sdk-go/service/directconnect"
	"github.com/aws/aws-sdk-go/service/directoryservice"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/ec2"
	"github.com/aws/aws-sdk-go/service/ecs"
	"github.com/aws/aws-sdk-go/service/efs"
	"github.com/aws/aws-sdk-go/service/eks"
	"github.com/aws/aws-sdk-go/service/elasticache"
	"github.com/aws/aws-sdk-go/service/elasticbeanstalk"
	"github.com/aws/aws-sdk-go/service/elasticsearchservice"
	"github.com/aws/aws-sdk-go/service/elb"
	"github.com/aws/aws-sdk-go/service/elbv2"
	"github.com/aws/aws-sdk-go/service/emr"
	"github.com/aws/aws-sdk-go/service/fsx"
	"github.com/aws/aws-sdk-go/service/glue"
	"github.com/aws/aws-sdk-go/service/iam"
	"github.com/aws/aws-sdk-go/service/kinesis"
	"github.com/aws/aws-sdk-go/service/lambda"
	"github.com/aws/aws-sdk-go/service/lightsail"
	"github.com/aws/aws-sdk-go/service/mediastore"
	"github.com/aws/aws-sdk-go/service/mq"
	"github.com/aws/aws-sdk-go/service/neptune"
	"github.com/aws/aws-sdk-go/service/rds"
	"github.com/aws/aws-sdk-go/service/redshift"
	"github.com/aws/aws-sdk-go/service/route53"
	"github.com/aws/aws-sdk-go/service/route53resolver"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/aws/aws-sdk-go/service/ses"
	"github.com/aws/aws-sdk-go/service/sqs"
	"github.com/aws/aws-sdk-go/service/storagegateway"
)

// Code generated by github.com/cycloidio/terracognita/aws/cmd; DO NOT EDIT

// Reader is the interface defining all methods that need to be implemented
//
// The next behavior commented in the below paragraph, applies to every method
// which clearly match what's explained, for the sake of not repeating the same,
// over and over.
// The most of the methods defined by this interface, return their results in a
// map. Those maps, have as keys, the AWS region which have been requested and
// the values are the items returned by AWS for such region.
// Because the methods may make calls to different regions, in case that there
// is an error on a region, the returned map won't have any entry for such
// region and such errors will be reported by the returned error, nonetheless
// the items, got from the successful requests to other regions, will be
// returned, with the meaning that the methods will return partial results, in
// case of errors.
// For avoiding by the callers the problem of if the returned map may be nil,
// the function will always return a map instance, which will be of length 0
// in case that there is not any successful request.
type Reader interface {
	// GetAccountID returns the current ID for the account used
	GetAccountID() string

	// GetRegion returns the currently used region for the Connector
	GetRegion() string

	// GetAPIGatewayDeployments returns the Deployment Functions on the given input
	// Returned values are commented in the interface doc comment block.
	GetAPIGatewayDeployments(ctx context.Context, input *apigateway.GetDeploymentsInput) ([]*apigateway.Deployment, error)

	// GetAPIGatewayResources returns the Resource Functions on the given input
	// Returned values are commented in the interface doc comment block.
	GetAPIGatewayResources(ctx context.Context, input *apigateway.GetResourcesInput) ([]*apigateway.Resource, error)

	// GetAPIGatewayRestAPIs returns the RestApi Functions on the given input
	// Returned values are commented in the interface doc comment block.
	GetAPIGatewayRestAPIs(ctx context.Context, input *apigateway.GetRestApisInput) ([]*apigateway.RestApi, error)

	// GetAPIGatewayStages returns the Stage Functions on the given input
	// Returned values are commented in the interface doc comment block.
	GetAPIGatewayStages(ctx context.Context, input *apigateway.GetStagesInput) ([]*apigateway.Stage, error)

	// GetAthenaDataCatalogs returns the Athena worker groups on the given input
	// Returned values are commented in the interface doc comment block.
	GetAthenaWorkGroups(ctx context.Context, input *athena.ListWorkGroupsInput) ([]*athena.WorkGroupSummary, error)

	// GetAutoScalingGroups returns all AutoScalingGroup belonging to the Account ID based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetAutoScalingGroups(ctx context.Context, input *autoscaling.DescribeAutoScalingGroupsInput) ([]*autoscaling.Group, error)

	// GetLaunchConfigurations returns all LaunchConfiguration belonging to the Account ID based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetLaunchConfigurations(ctx context.Context, input *autoscaling.DescribeLaunchConfigurationsInput) ([]*autoscaling.LaunchConfiguration, error)

	// GetAutoScalingPolicies returns all AutoScalingPolicies belonging to the Account ID based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetAutoScalingPolicies(ctx context.Context, input *autoscaling.DescribePoliciesInput) ([]*autoscaling.ScalingPolicy, error)

	// GetAutoScalingScheduledActions returns all ScheduledActions based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetAutoScalingScheduledActions(ctx context.Context, input *autoscaling.DescribeScheduledActionsInput) ([]*autoscaling.ScheduledUpdateGroupAction, error)

	// GetBatchJobDefinitions returns the batch jobs on the given input
	// Returned values are commented in the interface doc comment block.
	GetBatchJobDefinitions(ctx context.Context, input *batch.DescribeJobDefinitionsInput) ([]*batch.JobDefinition, error)

	// GetCloudFrontDistributions returns all the CloudFront Distributions on the given input
	// Returned values are commented in the interface doc comment block.
	GetCloudFrontDistributions(ctx context.Context, input *cloudfront.ListDistributionsInput) ([]*cloudfront.DistributionSummary, error)

	// GetCloudFrontOriginAccessIdentities returns all the CloudFront Origin Access Identities on the given input
	// Returned values are commented in the interface doc comment block.
	GetCloudFrontOriginAccessIdentities(ctx context.Context, input *cloudfront.ListCloudFrontOriginAccessIdentitiesInput) ([]*cloudfront.OriginAccessIdentitySummary, error)

	// GetCloudFrontPublicKeys returns all the CloudFront Public Keys on the given input
	// Returned values are commented in the interface doc comment block.
	GetCloudFrontPublicKeys(ctx context.Context, input *cloudfront.ListPublicKeysInput) ([]*cloudfront.PublicKeySummary, error)

	// GetMetricAlarms returns all cloudwatch alarms based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetMetricAlarms(ctx context.Context, input *cloudwatch.DescribeAlarmsInput) ([]*cloudwatch.MetricAlarm, error)

	// GetRecordedResourceCounts returns counts of the AWS resources which have
	// been recorded by AWS Config.
	// See https://docs.aws.amazon.com/config/latest/APIReference/API_GetDiscoveredResourceCounts.html
	// for more information about what to enable in your AWS account, the list of
	// supported resources, etc.
	GetRecordedResourceCounts(ctx context.Context, input *configservice.GetDiscoveredResourceCountsInput) ([]*configservice.ResourceCount, error)

	// GetDAXClusters returns the DAX clusters on the given input
	// Returned values are commented in the interface doc comment block.
	GetDAXClusters(ctx context.Context, input *dax.DescribeClustersInput) ([]*dax.Cluster, error)

	// GetDirectConnectGateways returns the Direct Connect gateways on the given input
	// Returned values are commented in the interface doc comment block.
	GetDirectConnectGateways(ctx context.Context, input *directconnect.DescribeDirectConnectGatewaysInput) ([]*directconnect.Gateway, error)

	// GetDirectoryServiceDirectories returns the Directory Service directorie on the given input
	// Returned values are commented in the interface doc comment block.
	GetDirectoryServiceDirectories(ctx context.Context, input *directoryservice.DescribeDirectoriesInput) ([]*directoryservice.DirectoryDescription, error)

	// GetDMSDescribeReplicationInstances returns the DMS replication instances on the given input
	// Returned values are commented in the interface doc comment block.
	GetDMSDescribeReplicationInstances(ctx context.Context, input *databasemigrationservice.DescribeReplicationInstancesInput) ([]*databasemigrationservice.ReplicationInstance, error)

	// GetDynamodbGlobalTables returns the dynamodb global tables on the given input
	// Returned values are commented in the interface doc comment block.
	GetDynamodbGlobalTables(ctx context.Context, input *dynamodb.ListGlobalTablesInput) ([]*dynamodb.GlobalTable, error)

	// GetDynamodbTables returns the dynamodb talbles on the given input
	// Returned values are commented in the interface doc comment block.
	GetDynamodbTables(ctx context.Context, input *dynamodb.ListTablesInput) ([]*string, error)

	// GetAddresses returns all EC2 Addresses based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetAddresses(ctx context.Context, input *ec2.DescribeAddressesInput) ([]*ec2.Address, error)

	// GetImages returns all EC2 AMI based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetImages(ctx context.Context, input *ec2.DescribeImagesInput) ([]*ec2.Image, error)

	// GetOwnImages returns all EC2 AMI belonging to the Account ID based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetOwnImages(ctx context.Context, input *ec2.DescribeImagesInput) ([]*ec2.Image, error)

	// GetInstances returns all EC2 instances based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetInstances(ctx context.Context, input *ec2.DescribeInstancesInput) ([]*ec2.Instance, error)

	// GetEC2InternetGateways returns the EC2 Internet Gateways on the given input
	// Returned values are commented in the interface doc comment block.
	GetEC2InternetGateways(ctx context.Context, input *ec2.DescribeInternetGatewaysInput) ([]*ec2.InternetGateway, error)

	// GetKeyPairs returns all KeyPairs based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetKeyPairs(ctx context.Context, input *ec2.DescribeKeyPairsInput) ([]*ec2.KeyPairInfo, error)

	// GetLaunchTemplates returns all LaunchTemplate belonging to the Account ID based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetLaunchTemplates(ctx context.Context, input *ec2.DescribeLaunchTemplatesInput) ([]*ec2.LaunchTemplate, error)

	// GetEC2NatGateways returns the EC2 nat gateways on the given input
	// Returned values are commented in the interface doc comment block.
	GetEC2NatGateways(ctx context.Context, input *ec2.DescribeNatGatewaysInput) ([]*ec2.NatGateway, error)

	// GetSecurityGroups returns all EC2 security groups based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetSecurityGroups(ctx context.Context, input *ec2.DescribeSecurityGroupsInput) ([]*ec2.SecurityGroup, error)

	// GetSnapshots returns all snapshots based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetSnapshots(ctx context.Context, input *ec2.DescribeSnapshotsInput) ([]*ec2.Snapshot, error)

	// GetOwnSnapshots returns all snapshots belonging to the Account ID based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetOwnSnapshots(ctx context.Context, input *ec2.DescribeSnapshotsInput) ([]*ec2.Snapshot, error)

	// GetSubnets returns all EC2 subnets based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetSubnets(ctx context.Context, input *ec2.DescribeSubnetsInput) ([]*ec2.Subnet, error)

	// GetVolumes returns all EC2 volumes based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetVolumes(ctx context.Context, input *ec2.DescribeVolumesInput) ([]*ec2.Volume, error)

	// GetVpcEndpoints returns the ec2 VPC Endpoints on the given input
	// Returned values are commented in the interface doc comment block.
	GetVpcEndpoints(ctx context.Context, input *ec2.DescribeVpcEndpointsInput) ([]*ec2.VpcEndpoint, error)

	// GetVpcs returns all EC2 VPCs based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetVpcs(ctx context.Context, input *ec2.DescribeVpcsInput) ([]*ec2.Vpc, error)

	// GetVpcPeeringConnections returns all VpcPeeringConnections based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetVpcPeeringConnections(ctx context.Context, input *ec2.DescribeVpcPeeringConnectionsInput) ([]*ec2.VpcPeeringConnection, error)

	// GetVPNGateways returns the ec2 VPN Gateways on the given input
	// Returned values are commented in the interface doc comment block.
	GetVPNGateways(ctx context.Context, input *ec2.DescribeVpnGatewaysInput) ([]*ec2.VpnGateway, error)

	// GetRouteTables returns the ec2 VPN Route Tables on the given input
	// Returned values are commented in the interface doc comment block.
	GetRouteTables(ctx context.Context, input *ec2.DescribeRouteTablesInput) ([]*ec2.RouteTable, error)

	// GetTransitGateways returns the ec2 Transit Gateways on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGateways(ctx context.Context, input *ec2.DescribeTransitGatewaysInput) ([]*ec2.TransitGateway, error)

	// GetTransitGateways returns the ec2 Transit Gateway VPC Attachments on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGatewayVpcAttachments(ctx context.Context, input *ec2.DescribeTransitGatewayVpcAttachmentsInput) ([]*ec2.TransitGatewayVpcAttachment, error)

	// GetTransitGateways returns the ec2 Transit Gateway Route Tables on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGatewayRouteTables(ctx context.Context, input *ec2.DescribeTransitGatewayRouteTablesInput) ([]*ec2.TransitGatewayRouteTable, error)

	// GetTransitGateways returns the ec2 Transit Gateway Multicasts on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGatewayMulticast(ctx context.Context, input *ec2.DescribeTransitGatewayMulticastDomainsInput) ([]*ec2.TransitGatewayMulticastDomain, error)

	// GetTransitGatewayPeeringAttachments returns the ec2 Transit Gateway Peering Attachments on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGatewayPeeringAttachments(ctx context.Context, input *ec2.DescribeTransitGatewayPeeringAttachmentsInput) ([]*ec2.TransitGatewayPeeringAttachment, error)

	// GetTransitGatewayPrefixListReference returns the ec2 Transit Gateway Prefix List References on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGatewayPrefixListReference(ctx context.Context, input *ec2.GetTransitGatewayPrefixListReferencesInput) ([]*ec2.TransitGatewayPrefixListReference, error)

	// GetTransitGatewayRoutes returns the ec2 Transit Gateway Routes on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGatewayRoutes(ctx context.Context, input *ec2.SearchTransitGatewayRoutesInput) ([]*ec2.TransitGatewayRoute, error)

	// GetTransitGatewayRouteTableAssociations returns the ec2 Transit Gateway Route Table Associations on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGatewayRouteTableAssociations(ctx context.Context, input *ec2.GetTransitGatewayRouteTableAssociationsInput) ([]*ec2.TransitGatewayRouteTableAssociation, error)

	// GetTransitGatewayRouteTablePropagations returns the ec2 Transit Gateway Route Table Propagations on the given input
	// Returned values are commented in the interface doc comment block.
	GetTransitGatewayRouteTablePropagations(ctx context.Context, input *ec2.GetTransitGatewayRouteTablePropagationsInput) ([]*ec2.TransitGatewayRouteTablePropagation, error)

	// GetECSClustersArns returns the ecs clusters arns on the given input
	// Returned values are commented in the interface doc comment block.
	GetECSClustersArns(ctx context.Context, input *ecs.ListClustersInput) ([]*string, error)

	// GetECSClusters returns the ecs clusters on the given input
	// Returned values are commented in the interface doc comment block.
	GetECSClusters(ctx context.Context, input *ecs.DescribeClustersInput) ([]*ecs.Cluster, error)

	// GetECSServicesArns returns the ecs services arns on the given input
	// Returned values are commented in the interface doc comment block.
	GetECSServicesArns(ctx context.Context, input *ecs.ListServicesInput) ([]*string, error)

	// GetECSServices returns the ecs services on the given input
	// Returned values are commented in the interface doc comment block.
	GetECSServices(ctx context.Context, input *ecs.DescribeServicesInput) ([]*ecs.Service, error)

	// GetECSTaskDefinitionsArns returns the ecs task definitions arns on the given input
	// Returned values are commented in the interface doc comment block.
	GetECSTaskDefinitionsArns(ctx context.Context, input *ecs.ListTaskDefinitionsInput) ([]*string, error)

	// GetEFSFileSystems returns the EFS File Systems on the given input
	// Returned values are commented in the interface doc comment block.
	GetEFSFileSystems(ctx context.Context, input *efs.DescribeFileSystemsInput) ([]*efs.FileSystemDescription, error)

	// GetEKSCluster returns the EKS Cluster on the given input
	// Returned values are commented in the interface doc comment block.
	GetEKSCluster(ctx context.Context, input *eks.DescribeClusterInput) (*eks.Cluster, error)

	// GetEKSClusters returns the EKS Clusters on the given input
	// Returned values are commented in the interface doc comment block.
	GetEKSClusters(ctx context.Context, input *eks.ListClustersInput) ([]*string, error)

	// GetElastiCacheClusters returns all Elasticache clusters based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetElastiCacheClusters(ctx context.Context, input *elasticache.DescribeCacheClustersInput) ([]*elasticache.CacheCluster, error)

	// GetElastiCacheReplicationGroups returns the EKS Replication groups on the given input
	// Returned values are commented in the interface doc comment block.
	GetElastiCacheReplicationGroups(ctx context.Context, input *elasticache.DescribeReplicationGroupsInput) ([]*elasticache.ReplicationGroup, error)

	// GetElastiCacheTags returns a list of tags of Elasticache resources based on its ARN.
	// Returned values are commented in the interface doc comment block.
	GetElastiCacheTags(ctx context.Context, input *elasticache.ListTagsForResourceInput) ([]*elasticache.Tag, error)

	// GetElasticBeanstalkApplications returns the ElasticBeanstalk Applications on the given input
	// Returned values are commented in the interface doc comment block.
	GetElasticBeanstalkApplications(ctx context.Context, input *elasticbeanstalk.DescribeApplicationsInput) ([]*elasticbeanstalk.ApplicationDescription, error)

	// GetElasticsearchDomainNames returns a list of domainNames of Elasticsearch resources.
	// Returned values are commented in the interface doc comment block.
	GetElasticsearchDomainNames(ctx context.Context, input *elasticsearchservice.ListDomainNamesInput) ([]*elasticsearchservice.DomainInfo, error)

	// GetElasticsearchDomains returns a list of domains of Elasticsearch resources.
	// Returned values are commented in the interface doc comment block.
	GetElasticsearchDomains(ctx context.Context, input *elasticsearchservice.DescribeElasticsearchDomainsInput) ([]*elasticsearchservice.ElasticsearchDomainStatus, error)

	// GetLoadBalancerAttributes returns a list of Attributes based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancerAttributes(ctx context.Context, input *elb.DescribeLoadBalancerAttributesInput) ([]*elb.AdditionalAttribute, error)

	// GetLoadBalancers returns a list of ELB (v1) based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancers(ctx context.Context, input *elb.DescribeLoadBalancersInput) ([]*elb.LoadBalancerDescription, error)

	// GetLoadBalancerPolicies returns a list of Policies based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancerPolicies(ctx context.Context, input *elb.DescribeLoadBalancerPoliciesInput) ([]*elb.PolicyDescription, error)

	// GetLoadBalancersTags returns a list of Tags based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancersTags(ctx context.Context, input *elb.DescribeTagsInput) ([]*elb.TagDescription, error)

	// GetListenerCertificates returns a list of ListenerCertificates based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetListenerCertificates(ctx context.Context, input *elbv2.DescribeListenerCertificatesInput) ([]*elbv2.Certificate, error)

	// GetLoadBalancersV2Listeners returns a list of Listeners based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancersV2Listeners(ctx context.Context, input *elbv2.DescribeListenersInput) ([]*elbv2.Listener, error)

	// GetLoadBalancersV2 returns a list of ELB (v2) - also known as ALB - based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancersV2(ctx context.Context, input *elbv2.DescribeLoadBalancersInput) ([]*elbv2.LoadBalancer, error)

	// GetLoadBalancersV2Tags returns a list of Tags based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancersV2Tags(ctx context.Context, input *elbv2.DescribeTagsInput) ([]*elbv2.TagDescription, error)

	// GetLoadBalancersV2TargetGroupAttributes returns a list of TargetGroupAttributes based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancersV2TargetGroupAttributes(ctx context.Context, input *elbv2.DescribeTargetGroupAttributesInput) ([]*elbv2.TargetGroupAttribute, error)

	// GetLoadBalancersV2TargetGroups returns a list of TargetGroups based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancersV2TargetGroups(ctx context.Context, input *elbv2.DescribeTargetGroupsInput) ([]*elbv2.TargetGroup, error)

	// GetLoadBalancersV2TargetHealth returns a list of TargetHealth based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancersV2TargetHealth(ctx context.Context, input *elbv2.DescribeTargetHealthInput) ([]*elbv2.TargetHealthDescription, error)

	// GetLoadBalancersV2Rules returns a list of Rules based on the input from the different regions.
	// Returned values are commented in the interface doc comment block.
	GetLoadBalancersV2Rules(ctx context.Context, input *elbv2.DescribeRulesInput) ([]*elbv2.Rule, error)

	// GetEMRClusters returns the EMR Clusters on the given input
	// Returned values are commented in the interface doc comment block.
	GetEMRClusters(ctx context.Context, input *emr.ListClustersInput) ([]*emr.ClusterSummary, error)

	// GetFSXFileSystems returns the fsx filesystems arns on the given input
	// Returned values are commented in the interface doc comment block.
	GetFSXFileSystems(ctx context.Context, input *fsx.DescribeFileSystemsInput) ([]*fsx.FileSystem, error)

	// GetGlueDatabases returns the Glue databases on the given input
	// Returned values are commented in the interface doc comment block.
	GetGlueDatabases(ctx context.Context, input *glue.GetDatabasesInput) ([]*glue.Database, error)

	// GetGlueTables returns the Glue Tables on the given input
	// Returned values are commented in the interface doc comment block.
	GetGlueTables(ctx context.Context, input *glue.GetTablesInput) ([]*glue.TableData, error)

	// GetAccessKeys returns all the IAM AccessKeys on the given input
	// Returned values are commented in the interface doc comment block.
	GetAccessKeys(ctx context.Context, input *iam.ListAccessKeysInput) ([]*iam.AccessKeyMetadata, error)

	// GetAccountAliases returns all the IAM AccountAliases on the given input
	// Returned values are commented in the interface doc comment block.
	GetAccountAliases(ctx context.Context, input *iam.ListAccountAliasesInput) ([]*string, error)

	// GetAccountPasswordPolicy returns the IAM AccountPasswordPolicy on the given input
	// Returned values are commented in the interface doc comment block.
	GetAccountPasswordPolicy(ctx context.Context, input *iam.GetAccountPasswordPolicyInput) (*iam.PasswordPolicy, error)

	// GetAttachedGroupPolicies returns the IAM AttachedGroupPolicies on the given input
	// Returned values are commented in the interface doc comment block.
	GetAttachedGroupPolicies(ctx context.Context, input *iam.ListAttachedGroupPoliciesInput) ([]*iam.AttachedPolicy, error)

	// GetAttachedRolePolicies returns the IAM AttachedRolePolicies on the given input
	// Returned values are commented in the interface doc comment block.
	GetAttachedRolePolicies(ctx context.Context, input *iam.ListAttachedRolePoliciesInput) ([]*iam.AttachedPolicy, error)

	// GetAttachedUserPolicies returns the IAM AttachedUserPolicies on the given input
	// Returned values are commented in the interface doc comment block.
	GetAttachedUserPolicies(ctx context.Context, input *iam.ListAttachedUserPoliciesInput) ([]*iam.AttachedPolicy, error)

	// GetGroupUsers returns a list of IAM users that are in the specified IAM group
	// Returned values are commented in the interface doc comment block.
	GetGroupUsers(ctx context.Context, input *iam.GetGroupInput) ([]*iam.User, error)

	// GetGroupPolicies returns the IAM GroupPolicies on the given input
	// Returned values are commented in the interface doc comment block.
	GetGroupPolicies(ctx context.Context, input *iam.ListGroupPoliciesInput) ([]*string, error)

	// GetGroups returns the IAM Groups on the given input
	// Returned values are commented in the interface doc comment block.
	GetGroups(ctx context.Context, input *iam.ListGroupsInput) ([]*iam.Group, error)

	// GetGroupsForUser returns the IAM GroupsForUser on the given input
	// Returned values are commented in the interface doc comment block.
	GetGroupsForUser(ctx context.Context, input *iam.ListGroupsForUserInput) ([]*iam.Group, error)

	// GetIstanceProfiles returns the IAM InstanceProfiles on the given input
	// Returned values are commented in the interface doc comment block.
	GetInstanceProfiles(ctx context.Context, input *iam.ListInstanceProfilesInput) ([]*iam.InstanceProfile, error)

	// GetOpenIDConnectProviders returns the IAM OpenIDConnectProviders on the given input
	// Returned values are commented in the interface doc comment block.
	GetOpenIDConnectProviders(ctx context.Context, input *iam.ListOpenIDConnectProvidersInput) ([]*iam.OpenIDConnectProviderListEntry, error)

	// GetPolicies returns the IAM Policies on the given input
	// Returned values are commented in the interface doc comment block.
	GetPolicies(ctx context.Context, input *iam.ListPoliciesInput) ([]*iam.Policy, error)

	// GetRolePolicies returns the IAM RolePolicies on the given input
	// Returned values are commented in the interface doc comment block.
	GetRolePolicies(ctx context.Context, input *iam.ListRolePoliciesInput) ([]*string, error)

	// GetRoles returns the IAM Roles on the given input
	// Returned values are commented in the interface doc comment block.
	GetRoles(ctx context.Context, input *iam.ListRolesInput) ([]*iam.Role, error)

	// GetSAMLProviders returns the IAM SAMLProviders on the given input
	// Returned values are commented in the interface doc comment block.
	GetSAMLProviders(ctx context.Context, input *iam.ListSAMLProvidersInput) ([]*iam.SAMLProviderListEntry, error)

	// GetServerCertificates returns the IAM ServerCertificates on the given input
	// Returned values are commented in the interface doc comment block.
	GetServerCertificates(ctx context.Context, input *iam.ListServerCertificatesInput) ([]*iam.ServerCertificateMetadata, error)

	// GetSSHPublicKeys returns the IAM SSHPublicKeys on the given input
	// Returned values are commented in the interface doc comment block.
	GetSSHPublicKeys(ctx context.Context, input *iam.ListSSHPublicKeysInput) ([]*iam.SSHPublicKeyMetadata, error)

	// GetUserPolicies returns the IAM UserPolicies on the given input
	// Returned values are commented in the interface doc comment block.
	GetUserPolicies(ctx context.Context, input *iam.ListUserPoliciesInput) ([]*string, error)

	// GetUsers returns the IAM Users on the given input
	// Returned values are commented in the interface doc comment block.
	GetUsers(ctx context.Context, input *iam.ListUsersInput) ([]*iam.User, error)

	// GetKinesisStreams returns the Kinesis Streams on the given input
	// Returned values are commented in the interface doc comment block.
	GetKinesisStreams(ctx context.Context, input *kinesis.ListStreamsInput) ([]*string, error)

	// GetLambdaFunctions returns the lambda Functions on the given input
	// Returned values are commented in the interface doc comment block.
	GetLambdaFunctions(ctx context.Context, input *lambda.ListFunctionsInput) ([]*lambda.FunctionConfiguration, error)

	// GetLightsailInstances returns the Lightsail Instances on the given input
	// Returned values are commented in the interface doc comment block.
	GetLightsailInstances(ctx context.Context, input *lightsail.GetInstancesInput) ([]*lightsail.Instance, error)

	// GetMediastoreContainers returns the Mediastore Containers on the given input
	// Returned values are commented in the interface doc comment block.
	GetMediastoreContainers(ctx context.Context, input *mediastore.ListContainersInput) ([]*mediastore.Container, error)

	// GetMQBrokers returns the MQ Brokers on the given input
	// Returned values are commented in the interface doc comment block.
	GetMQBrokers(ctx context.Context, input *mq.ListBrokersInput) ([]*mq.BrokerSummary, error)

	// GetNeptuneDBClusters returns the Neptune DBClusters on the given input
	// Returned values are commented in the interface doc comment block.
	GetNeptuneDBClusters(ctx context.Context, input *neptune.DescribeDBClustersInput) ([]*neptune.DBCluster, error)

	// GetRDSDBClusters returns the RDS DB Clusters on the given input
	// Returned values are commented in the interface doc comment block.
	GetRDSDBClusters(ctx context.Context, input *rds.DescribeDBClustersInput) ([]*rds.DBCluster, error)

	// GetDBInstances returns all DB instances based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetDBInstances(ctx context.Context, input *rds.DescribeDBInstancesInput) ([]*rds.DBInstance, error)

	// GetDBParameterGroups returns all DB parameterGroups based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetDBParameterGroups(ctx context.Context, input *rds.DescribeDBParameterGroupsInput) ([]*rds.DBParameterGroup, error)

	// GetDBSubnetGroups returns all DB DBSubnetGroups based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetDBSubnetGroups(ctx context.Context, input *rds.DescribeDBSubnetGroupsInput) ([]*rds.DBSubnetGroup, error)

	// GetRDSGlobalClusters returns the RDS Global Clusters on the given input
	// Returned values are commented in the interface doc comment block.
	GetRDSGlobalClusters(ctx context.Context, input *rds.DescribeGlobalClustersInput) ([]*rds.GlobalCluster, error)

	// GetDBInstancesTags returns a list of tags from an ARN, extra filters for tags can also be provided.
	// Returned values are commented in the interface doc comment block.
	GetDBInstancesTags(ctx context.Context, input *rds.ListTagsForResourceInput) ([]*rds.Tag, error)

	// GetRedshiftClusters returns the Redshift Clusters on the given input
	// Returned values are commented in the interface doc comment block.
	GetRedshiftClusters(ctx context.Context, input *redshift.DescribeClustersInput) ([]*redshift.Cluster, error)

	// GetQueryLoggingConfigs returns the Route53 QueryLoggingConfigs on the given input
	// Returned values are commented in the interface doc comment block.
	GetQueryLoggingConfigs(ctx context.Context, input *route53.ListQueryLoggingConfigsInput) ([]*route53.QueryLoggingConfig, error)

	// GetHealthChecks returns the Route53 HealthChecks on the given input
	// Returned values are commented in the interface doc comment block.
	GetHealthChecks(ctx context.Context, input *route53.ListHealthChecksInput) ([]*route53.HealthCheck, error)

	// GetHostedZones returns the Route53 HostedZones on the given input
	// Returned values are commented in the interface doc comment block.
	GetHostedZones(ctx context.Context, input *route53.ListHostedZonesInput) ([]*route53.HostedZone, error)

	// GetResourceRecordSets returns the Route53 ResourceRecordSets on the given input
	// Returned values are commented in the interface doc comment block.
	GetResourceRecordSets(ctx context.Context, input *route53.ListResourceRecordSetsInput) ([]*route53.ResourceRecordSet, error)

	// GetReusableDelegationSets returns the Route53 ReusableDelegationSets on the given input
	// Returned values are commented in the interface doc comment block.
	GetReusableDelegationSets(ctx context.Context, input *route53.ListReusableDelegationSetsInput) ([]*route53.DelegationSet, error)

	// GetVPCAssociationAuthorizations returns the Route53 VPCAssociationAuthorizations on the given input
	// Returned values are commented in the interface doc comment block.
	GetVPCAssociationAuthorizations(ctx context.Context, input *route53.ListVPCAssociationAuthorizationsInput) ([]*route53.VPC, error)

	// GetResolverEndpoints returns the Route53Resolver ResolverEndpoints on the given input
	// Returned values are commented in the interface doc comment block.
	GetResolverEndpoints(ctx context.Context, input *route53resolver.ListResolverEndpointsInput) ([]*route53resolver.ResolverEndpoint, error)

	// GetResolverRuleAssociations returns the Route53Resolver ResolverRuleAssociations on the given input
	// Returned values are commented in the interface doc comment block.
	GetResolverRuleAssociations(ctx context.Context, input *route53resolver.ListResolverRuleAssociationsInput) ([]*route53resolver.ResolverRuleAssociation, error)

	// GetResolverRules returns the Route53Resolver ResolverRules on the given input
	// Returned values are commented in the interface doc comment block.
	GetResolverRules(ctx context.Context, input *route53resolver.ListResolverRulesInput) ([]*route53resolver.ResolverRule, error)

	// ListBuckets returns all S3 buckets based on the input given and specifically
	// filtering by Location as ListBuckets does not do it by itself
	// Returned values are commented in the interface doc comment block.
	ListBuckets(ctx context.Context, input *s3.ListBucketsInput) ([]*s3.Bucket, error)

	// GetBucketTags returns tags associated with S3 buckets based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetBucketTags(ctx context.Context, input *s3.GetBucketTaggingInput) ([]*s3.Tag, error)

	// ListObjects returns a list of all S3 objects in a bucket based on the input given.
	// Returned values are commented in the interface doc comment block.
	ListObjects(ctx context.Context, input *s3.ListObjectsInput) ([]*s3.Object, error)

	// GetObjectsTags returns tags associated with S3 objects based on the input given.
	// Returned values are commented in the interface doc comment block.
	GetObjectsTags(ctx context.Context, input *s3.GetObjectTaggingInput) ([]*s3.Tag, error)

	// GetActiveReceiptRuleSet returns the SES ActiveReceiptRuleSet on the given input
	// Returned values are commented in the interface doc comment block.
	GetActiveReceiptRuleSet(ctx context.Context, input *ses.DescribeActiveReceiptRuleSetInput) (*string, error)

	// GetActiveReceiptRulesSet returns the SES ActiveReceiptRuleSet on the given input
	// Returned values are commented in the interface doc comment block.
	GetActiveReceiptRulesSet(ctx context.Context, input *ses.DescribeActiveReceiptRuleSetInput) ([]*ses.ReceiptRule, error)

	// GetConfigurationSets returns the SES ConfigurationSets on the given input
	// Returned values are commented in the interface doc comment block.
	GetConfigurationSets(ctx context.Context, input *ses.ListConfigurationSetsInput) ([]*ses.ConfigurationSet, error)

	// GetIdentities returns the SES Identities on the given input
	// Returned values are commented in the interface doc comment block.
	GetIdentities(ctx context.Context, input *ses.ListIdentitiesInput) ([]*string, error)

	// GetIdentityNotificationAttributes returns the SES IdentityNotificationAttributes on the given input
	// Returned values are commented in the interface doc comment block.
	GetIdentityNotificationAttributes(ctx context.Context, input *ses.GetIdentityNotificationAttributesInput) (map[string]*ses.IdentityNotificationAttributes, error)

	// GetReceiptFilters returns the SES ReceiptFilters on the given input
	// Returned values are commented in the interface doc comment block.
	GetReceiptFilters(ctx context.Context, input *ses.ListReceiptFiltersInput) ([]*ses.ReceiptFilter, error)

	// GetTemplates returns the SES Templates on the given input
	// Returned values are commented in the interface doc comment block.
	GetTemplates(ctx context.Context, input *ses.ListTemplatesInput) ([]*ses.TemplateMetadata, error)

	// GetSQSQueues returns the SQS Queues on the given input
	// Returned values are commented in the interface doc comment block.
	GetSQSQueues(ctx context.Context, input *sqs.ListQueuesInput) ([]*string, error)

	// GetStorageGatewayGateways returns the StorageGateway Gateways on the given input
	// Returned values are commented in the interface doc comment block.
	GetStorageGatewayGateways(ctx context.Context, input *storagegateway.ListGatewaysInput) ([]*storagegateway.GatewayInfo, error)
}

func (c *connector) GetAPIGatewayDeployments(ctx context.Context, input *apigateway.GetDeploymentsInput) ([]*apigateway.Deployment, error) {
	if c.svc.apigateway == nil {
		c.svc.apigateway = apigateway.New(c.svc.session)
	}

	opt := make([]*apigateway.Deployment, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.apigateway.GetDeploymentsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Items == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &apigateway.GetDeploymentsInput{}
		}
		input.Position = o.Position
		hasNextToken = o.Position != nil

		opt = append(opt, o.Items...)

	}

	return opt, nil
}

func (c *connector) GetAPIGatewayResources(ctx context.Context, input *apigateway.GetResourcesInput) ([]*apigateway.Resource, error) {
	if c.svc.apigateway == nil {
		c.svc.apigateway = apigateway.New(c.svc.session)
	}

	opt := make([]*apigateway.Resource, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.apigateway.GetResourcesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Items == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &apigateway.GetResourcesInput{}
		}
		input.Position = o.Position
		hasNextToken = o.Position != nil

		opt = append(opt, o.Items...)

	}

	return opt, nil
}

func (c *connector) GetAPIGatewayRestAPIs(ctx context.Context, input *apigateway.GetRestApisInput) ([]*apigateway.RestApi, error) {
	if c.svc.apigateway == nil {
		c.svc.apigateway = apigateway.New(c.svc.session)
	}

	opt := make([]*apigateway.RestApi, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.apigateway.GetRestApisWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Items == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &apigateway.GetRestApisInput{}
		}
		input.Position = o.Position
		hasNextToken = o.Position != nil

		opt = append(opt, o.Items...)

	}

	return opt, nil
}

func (c *connector) GetAPIGatewayStages(ctx context.Context, input *apigateway.GetStagesInput) ([]*apigateway.Stage, error) {
	if c.svc.apigateway == nil {
		c.svc.apigateway = apigateway.New(c.svc.session)
	}

	opt := make([]*apigateway.Stage, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.apigateway.GetStagesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Item == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Item...)

	}

	return opt, nil
}

func (c *connector) GetAthenaWorkGroups(ctx context.Context, input *athena.ListWorkGroupsInput) ([]*athena.WorkGroupSummary, error) {
	if c.svc.athena == nil {
		c.svc.athena = athena.New(c.svc.session)
	}

	opt := make([]*athena.WorkGroupSummary, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.athena.ListWorkGroupsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.WorkGroups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &athena.ListWorkGroupsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.WorkGroups...)

	}

	return opt, nil
}

func (c *connector) GetAutoScalingGroups(ctx context.Context, input *autoscaling.DescribeAutoScalingGroupsInput) ([]*autoscaling.Group, error) {
	if c.svc.autoscaling == nil {
		c.svc.autoscaling = autoscaling.New(c.svc.session)
	}

	opt := make([]*autoscaling.Group, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.autoscaling.DescribeAutoScalingGroupsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.AutoScalingGroups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &autoscaling.DescribeAutoScalingGroupsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.AutoScalingGroups...)

	}

	return opt, nil
}

func (c *connector) GetLaunchConfigurations(ctx context.Context, input *autoscaling.DescribeLaunchConfigurationsInput) ([]*autoscaling.LaunchConfiguration, error) {
	if c.svc.autoscaling == nil {
		c.svc.autoscaling = autoscaling.New(c.svc.session)
	}

	opt := make([]*autoscaling.LaunchConfiguration, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.autoscaling.DescribeLaunchConfigurationsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.LaunchConfigurations == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &autoscaling.DescribeLaunchConfigurationsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.LaunchConfigurations...)

	}

	return opt, nil
}

func (c *connector) GetAutoScalingPolicies(ctx context.Context, input *autoscaling.DescribePoliciesInput) ([]*autoscaling.ScalingPolicy, error) {
	if c.svc.autoscaling == nil {
		c.svc.autoscaling = autoscaling.New(c.svc.session)
	}

	opt := make([]*autoscaling.ScalingPolicy, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.autoscaling.DescribePoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ScalingPolicies == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &autoscaling.DescribePoliciesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ScalingPolicies...)

	}

	return opt, nil
}

func (c *connector) GetAutoScalingScheduledActions(ctx context.Context, input *autoscaling.DescribeScheduledActionsInput) ([]*autoscaling.ScheduledUpdateGroupAction, error) {
	if c.svc.autoscaling == nil {
		c.svc.autoscaling = autoscaling.New(c.svc.session)
	}

	opt := make([]*autoscaling.ScheduledUpdateGroupAction, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.autoscaling.DescribeScheduledActionsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ScheduledUpdateGroupActions == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &autoscaling.DescribeScheduledActionsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ScheduledUpdateGroupActions...)

	}

	return opt, nil
}

func (c *connector) GetBatchJobDefinitions(ctx context.Context, input *batch.DescribeJobDefinitionsInput) ([]*batch.JobDefinition, error) {
	if c.svc.batch == nil {
		c.svc.batch = batch.New(c.svc.session)
	}

	opt := make([]*batch.JobDefinition, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.batch.DescribeJobDefinitionsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.JobDefinitions == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &batch.DescribeJobDefinitionsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.JobDefinitions...)

	}

	return opt, nil
}

func (c *connector) GetCloudFrontDistributions(ctx context.Context, input *cloudfront.ListDistributionsInput) ([]*cloudfront.DistributionSummary, error) {
	if c.svc.cloudfront == nil {
		c.svc.cloudfront = cloudfront.New(c.svc.session)
	}

	opt := make([]*cloudfront.DistributionSummary, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.cloudfront.ListDistributionsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DistributionList == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &cloudfront.ListDistributionsInput{}
		}
		input.Marker = o.DistributionList.NextMarker
		hasNextToken = o.DistributionList.NextMarker != nil

		opt = append(opt, o.DistributionList.Items...)

	}

	return opt, nil
}

func (c *connector) GetCloudFrontOriginAccessIdentities(ctx context.Context, input *cloudfront.ListCloudFrontOriginAccessIdentitiesInput) ([]*cloudfront.OriginAccessIdentitySummary, error) {
	if c.svc.cloudfront == nil {
		c.svc.cloudfront = cloudfront.New(c.svc.session)
	}

	opt := make([]*cloudfront.OriginAccessIdentitySummary, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.cloudfront.ListCloudFrontOriginAccessIdentitiesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.CloudFrontOriginAccessIdentityList == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &cloudfront.ListCloudFrontOriginAccessIdentitiesInput{}
		}
		input.Marker = o.CloudFrontOriginAccessIdentityList.NextMarker
		hasNextToken = o.CloudFrontOriginAccessIdentityList.NextMarker != nil

		opt = append(opt, o.CloudFrontOriginAccessIdentityList.Items...)

	}

	return opt, nil
}

func (c *connector) GetCloudFrontPublicKeys(ctx context.Context, input *cloudfront.ListPublicKeysInput) ([]*cloudfront.PublicKeySummary, error) {
	if c.svc.cloudfront == nil {
		c.svc.cloudfront = cloudfront.New(c.svc.session)
	}

	opt := make([]*cloudfront.PublicKeySummary, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.cloudfront.ListPublicKeysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.PublicKeyList == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &cloudfront.ListPublicKeysInput{}
		}
		input.Marker = o.PublicKeyList.NextMarker
		hasNextToken = o.PublicKeyList.NextMarker != nil

		opt = append(opt, o.PublicKeyList.Items...)

	}

	return opt, nil
}

func (c *connector) GetMetricAlarms(ctx context.Context, input *cloudwatch.DescribeAlarmsInput) ([]*cloudwatch.MetricAlarm, error) {
	if c.svc.cloudwatch == nil {
		c.svc.cloudwatch = cloudwatch.New(c.svc.session)
	}

	opt := make([]*cloudwatch.MetricAlarm, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.cloudwatch.DescribeAlarmsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.MetricAlarms == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &cloudwatch.DescribeAlarmsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.MetricAlarms...)

	}

	return opt, nil
}

func (c *connector) GetRecordedResourceCounts(ctx context.Context, input *configservice.GetDiscoveredResourceCountsInput) ([]*configservice.ResourceCount, error) {
	if c.svc.configservice == nil {
		c.svc.configservice = configservice.New(c.svc.session)
	}

	opt := make([]*configservice.ResourceCount, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.configservice.GetDiscoveredResourceCountsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ResourceCounts == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &configservice.GetDiscoveredResourceCountsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ResourceCounts...)

	}

	return opt, nil
}

func (c *connector) GetDAXClusters(ctx context.Context, input *dax.DescribeClustersInput) ([]*dax.Cluster, error) {
	if c.svc.dax == nil {
		c.svc.dax = dax.New(c.svc.session)
	}

	opt := make([]*dax.Cluster, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.dax.DescribeClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Clusters == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &dax.DescribeClustersInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Clusters...)

	}

	return opt, nil
}

func (c *connector) GetDirectConnectGateways(ctx context.Context, input *directconnect.DescribeDirectConnectGatewaysInput) ([]*directconnect.Gateway, error) {
	if c.svc.directconnect == nil {
		c.svc.directconnect = directconnect.New(c.svc.session)
	}

	opt := make([]*directconnect.Gateway, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.directconnect.DescribeDirectConnectGatewaysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DirectConnectGateways == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &directconnect.DescribeDirectConnectGatewaysInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.DirectConnectGateways...)

	}

	return opt, nil
}

func (c *connector) GetDirectoryServiceDirectories(ctx context.Context, input *directoryservice.DescribeDirectoriesInput) ([]*directoryservice.DirectoryDescription, error) {
	if c.svc.directoryservice == nil {
		c.svc.directoryservice = directoryservice.New(c.svc.session)
	}

	opt := make([]*directoryservice.DirectoryDescription, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.directoryservice.DescribeDirectoriesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DirectoryDescriptions == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &directoryservice.DescribeDirectoriesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.DirectoryDescriptions...)

	}

	return opt, nil
}

func (c *connector) GetDMSDescribeReplicationInstances(ctx context.Context, input *databasemigrationservice.DescribeReplicationInstancesInput) ([]*databasemigrationservice.ReplicationInstance, error) {
	if c.svc.databasemigrationservice == nil {
		c.svc.databasemigrationservice = databasemigrationservice.New(c.svc.session)
	}

	opt := make([]*databasemigrationservice.ReplicationInstance, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.databasemigrationservice.DescribeReplicationInstancesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ReplicationInstances == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &databasemigrationservice.DescribeReplicationInstancesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.ReplicationInstances...)

	}

	return opt, nil
}

func (c *connector) GetDynamodbGlobalTables(ctx context.Context, input *dynamodb.ListGlobalTablesInput) ([]*dynamodb.GlobalTable, error) {
	if c.svc.dynamodb == nil {
		c.svc.dynamodb = dynamodb.New(c.svc.session)
	}

	opt := make([]*dynamodb.GlobalTable, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.dynamodb.ListGlobalTablesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.GlobalTables == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &dynamodb.ListGlobalTablesInput{}
		}
		input.ExclusiveStartGlobalTableName = o.LastEvaluatedGlobalTableName
		hasNextToken = o.LastEvaluatedGlobalTableName != nil

		opt = append(opt, o.GlobalTables...)

	}

	return opt, nil
}

func (c *connector) GetDynamodbTables(ctx context.Context, input *dynamodb.ListTablesInput) ([]*string, error) {
	if c.svc.dynamodb == nil {
		c.svc.dynamodb = dynamodb.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.dynamodb.ListTablesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TableNames == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &dynamodb.ListTablesInput{}
		}
		input.ExclusiveStartTableName = o.LastEvaluatedTableName
		hasNextToken = o.LastEvaluatedTableName != nil

		opt = append(opt, o.TableNames...)

	}

	return opt, nil
}

func (c *connector) GetAddresses(ctx context.Context, input *ec2.DescribeAddressesInput) ([]*ec2.Address, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Address, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeAddressesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Addresses == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Addresses...)

	}

	return opt, nil
}

func (c *connector) GetImages(ctx context.Context, input *ec2.DescribeImagesInput) ([]*ec2.Image, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Image, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeImagesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Images == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Images...)

	}

	return opt, nil
}

func (c *connector) GetOwnImages(ctx context.Context, input *ec2.DescribeImagesInput) ([]*ec2.Image, error) {

	if input == nil {
		input = &ec2.DescribeImagesInput{}
	}
	input.Owners = append(input.Owners, c.accountID)
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Image, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeImagesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Images == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Images...)

	}

	return opt, nil
}

func (c *connector) GetInstances(ctx context.Context, input *ec2.DescribeInstancesInput) ([]*ec2.Instance, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Instance, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeInstancesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Reservations == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeInstancesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		for _, v := range o.Reservations {
			opt = append(opt, v.Instances...)
		}

	}

	return opt, nil
}

func (c *connector) GetEC2InternetGateways(ctx context.Context, input *ec2.DescribeInternetGatewaysInput) ([]*ec2.InternetGateway, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.InternetGateway, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeInternetGatewaysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.InternetGateways == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeInternetGatewaysInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.InternetGateways...)

	}

	return opt, nil
}

func (c *connector) GetKeyPairs(ctx context.Context, input *ec2.DescribeKeyPairsInput) ([]*ec2.KeyPairInfo, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.KeyPairInfo, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeKeyPairsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.KeyPairs == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.KeyPairs...)

	}

	return opt, nil
}

func (c *connector) GetLaunchTemplates(ctx context.Context, input *ec2.DescribeLaunchTemplatesInput) ([]*ec2.LaunchTemplate, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.LaunchTemplate, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeLaunchTemplatesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.LaunchTemplates == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeLaunchTemplatesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.LaunchTemplates...)

	}

	return opt, nil
}

func (c *connector) GetEC2NatGateways(ctx context.Context, input *ec2.DescribeNatGatewaysInput) ([]*ec2.NatGateway, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.NatGateway, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeNatGatewaysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.NatGateways == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeNatGatewaysInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.NatGateways...)

	}

	return opt, nil
}

func (c *connector) GetSecurityGroups(ctx context.Context, input *ec2.DescribeSecurityGroupsInput) ([]*ec2.SecurityGroup, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.SecurityGroup, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeSecurityGroupsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.SecurityGroups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeSecurityGroupsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.SecurityGroups...)

	}

	return opt, nil
}

func (c *connector) GetSnapshots(ctx context.Context, input *ec2.DescribeSnapshotsInput) ([]*ec2.Snapshot, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Snapshot, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeSnapshotsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Snapshots == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeSnapshotsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Snapshots...)

	}

	return opt, nil
}

func (c *connector) GetOwnSnapshots(ctx context.Context, input *ec2.DescribeSnapshotsInput) ([]*ec2.Snapshot, error) {

	if input == nil {
		input = &ec2.DescribeSnapshotsInput{}
	}
	input.OwnerIds = append(input.OwnerIds, c.accountID)
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Snapshot, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeSnapshotsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Snapshots == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeSnapshotsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Snapshots...)

	}

	return opt, nil
}

func (c *connector) GetSubnets(ctx context.Context, input *ec2.DescribeSubnetsInput) ([]*ec2.Subnet, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Subnet, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeSubnetsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Subnets == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeSubnetsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Subnets...)

	}

	return opt, nil
}

func (c *connector) GetVolumes(ctx context.Context, input *ec2.DescribeVolumesInput) ([]*ec2.Volume, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Volume, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeVolumesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Volumes == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeVolumesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Volumes...)

	}

	return opt, nil
}

func (c *connector) GetVpcEndpoints(ctx context.Context, input *ec2.DescribeVpcEndpointsInput) ([]*ec2.VpcEndpoint, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.VpcEndpoint, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeVpcEndpointsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.VpcEndpoints == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeVpcEndpointsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.VpcEndpoints...)

	}

	return opt, nil
}

func (c *connector) GetVpcs(ctx context.Context, input *ec2.DescribeVpcsInput) ([]*ec2.Vpc, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.Vpc, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeVpcsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Vpcs == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeVpcsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Vpcs...)

	}

	return opt, nil
}

func (c *connector) GetVpcPeeringConnections(ctx context.Context, input *ec2.DescribeVpcPeeringConnectionsInput) ([]*ec2.VpcPeeringConnection, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.VpcPeeringConnection, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeVpcPeeringConnectionsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.VpcPeeringConnections == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeVpcPeeringConnectionsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.VpcPeeringConnections...)

	}

	return opt, nil
}

func (c *connector) GetVPNGateways(ctx context.Context, input *ec2.DescribeVpnGatewaysInput) ([]*ec2.VpnGateway, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.VpnGateway, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeVpnGatewaysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.VpnGateways == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.VpnGateways...)

	}

	return opt, nil
}

func (c *connector) GetRouteTables(ctx context.Context, input *ec2.DescribeRouteTablesInput) ([]*ec2.RouteTable, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.RouteTable, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeRouteTablesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.RouteTables == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.RouteTables...)

	}

	return opt, nil
}

func (c *connector) GetTransitGateways(ctx context.Context, input *ec2.DescribeTransitGatewaysInput) ([]*ec2.TransitGateway, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGateway, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeTransitGatewaysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TransitGateways == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeTransitGatewaysInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TransitGateways...)

	}

	return opt, nil
}

func (c *connector) GetTransitGatewayVpcAttachments(ctx context.Context, input *ec2.DescribeTransitGatewayVpcAttachmentsInput) ([]*ec2.TransitGatewayVpcAttachment, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGatewayVpcAttachment, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeTransitGatewayVpcAttachmentsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TransitGatewayVpcAttachments == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeTransitGatewayVpcAttachmentsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TransitGatewayVpcAttachments...)

	}

	return opt, nil
}

func (c *connector) GetTransitGatewayRouteTables(ctx context.Context, input *ec2.DescribeTransitGatewayRouteTablesInput) ([]*ec2.TransitGatewayRouteTable, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGatewayRouteTable, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeTransitGatewayRouteTablesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TransitGatewayRouteTables == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeTransitGatewayRouteTablesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TransitGatewayRouteTables...)

	}

	return opt, nil
}

func (c *connector) GetTransitGatewayMulticast(ctx context.Context, input *ec2.DescribeTransitGatewayMulticastDomainsInput) ([]*ec2.TransitGatewayMulticastDomain, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGatewayMulticastDomain, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeTransitGatewayMulticastDomainsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TransitGatewayMulticastDomains == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeTransitGatewayMulticastDomainsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TransitGatewayMulticastDomains...)

	}

	return opt, nil
}

func (c *connector) GetTransitGatewayPeeringAttachments(ctx context.Context, input *ec2.DescribeTransitGatewayPeeringAttachmentsInput) ([]*ec2.TransitGatewayPeeringAttachment, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGatewayPeeringAttachment, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.DescribeTransitGatewayPeeringAttachmentsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TransitGatewayPeeringAttachments == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.DescribeTransitGatewayPeeringAttachmentsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TransitGatewayPeeringAttachments...)

	}

	return opt, nil
}

func (c *connector) GetTransitGatewayPrefixListReference(ctx context.Context, input *ec2.GetTransitGatewayPrefixListReferencesInput) ([]*ec2.TransitGatewayPrefixListReference, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGatewayPrefixListReference, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.GetTransitGatewayPrefixListReferencesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TransitGatewayPrefixListReferences == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.GetTransitGatewayPrefixListReferencesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TransitGatewayPrefixListReferences...)

	}

	return opt, nil
}

func (c *connector) GetTransitGatewayRoutes(ctx context.Context, input *ec2.SearchTransitGatewayRoutesInput) ([]*ec2.TransitGatewayRoute, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGatewayRoute, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.SearchTransitGatewayRoutesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Routes == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Routes...)

	}

	return opt, nil
}

func (c *connector) GetTransitGatewayRouteTableAssociations(ctx context.Context, input *ec2.GetTransitGatewayRouteTableAssociationsInput) ([]*ec2.TransitGatewayRouteTableAssociation, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGatewayRouteTableAssociation, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.GetTransitGatewayRouteTableAssociationsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Associations == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.GetTransitGatewayRouteTableAssociationsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Associations...)

	}

	return opt, nil
}

func (c *connector) GetTransitGatewayRouteTablePropagations(ctx context.Context, input *ec2.GetTransitGatewayRouteTablePropagationsInput) ([]*ec2.TransitGatewayRouteTablePropagation, error) {
	if c.svc.ec2 == nil {
		c.svc.ec2 = ec2.New(c.svc.session)
	}

	opt := make([]*ec2.TransitGatewayRouteTablePropagation, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ec2.GetTransitGatewayRouteTablePropagationsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TransitGatewayRouteTablePropagations == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ec2.GetTransitGatewayRouteTablePropagationsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TransitGatewayRouteTablePropagations...)

	}

	return opt, nil
}

func (c *connector) GetECSClustersArns(ctx context.Context, input *ecs.ListClustersInput) ([]*string, error) {
	if c.svc.ecs == nil {
		c.svc.ecs = ecs.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ecs.ListClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ClusterArns == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ecs.ListClustersInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ClusterArns...)

	}

	return opt, nil
}

func (c *connector) GetECSClusters(ctx context.Context, input *ecs.DescribeClustersInput) ([]*ecs.Cluster, error) {
	if c.svc.ecs == nil {
		c.svc.ecs = ecs.New(c.svc.session)
	}

	opt := make([]*ecs.Cluster, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ecs.DescribeClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Clusters == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Clusters...)

	}

	return opt, nil
}

func (c *connector) GetECSServicesArns(ctx context.Context, input *ecs.ListServicesInput) ([]*string, error) {
	if c.svc.ecs == nil {
		c.svc.ecs = ecs.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ecs.ListServicesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ServiceArns == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ecs.ListServicesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ServiceArns...)

	}

	return opt, nil
}

func (c *connector) GetECSServices(ctx context.Context, input *ecs.DescribeServicesInput) ([]*ecs.Service, error) {
	if c.svc.ecs == nil {
		c.svc.ecs = ecs.New(c.svc.session)
	}

	opt := make([]*ecs.Service, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ecs.DescribeServicesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Services == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Services...)

	}

	return opt, nil
}

func (c *connector) GetECSTaskDefinitionsArns(ctx context.Context, input *ecs.ListTaskDefinitionsInput) ([]*string, error) {
	if c.svc.ecs == nil {
		c.svc.ecs = ecs.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ecs.ListTaskDefinitionsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TaskDefinitionArns == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ecs.ListTaskDefinitionsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TaskDefinitionArns...)

	}

	return opt, nil
}

func (c *connector) GetEFSFileSystems(ctx context.Context, input *efs.DescribeFileSystemsInput) ([]*efs.FileSystemDescription, error) {
	if c.svc.efs == nil {
		c.svc.efs = efs.New(c.svc.session)
	}

	opt := make([]*efs.FileSystemDescription, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.efs.DescribeFileSystemsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.FileSystems == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &efs.DescribeFileSystemsInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.FileSystems...)

	}

	return opt, nil
}

func (c *connector) GetEKSCluster(ctx context.Context, input *eks.DescribeClusterInput) (*eks.Cluster, error) {
	if c.svc.eks == nil {
		c.svc.eks = eks.New(c.svc.session)
	}

	var opt *eks.Cluster

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.eks.DescribeClusterWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Cluster == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = o.Cluster

	}

	return opt, nil
}

func (c *connector) GetEKSClusters(ctx context.Context, input *eks.ListClustersInput) ([]*string, error) {
	if c.svc.eks == nil {
		c.svc.eks = eks.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.eks.ListClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Clusters == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &eks.ListClustersInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Clusters...)

	}

	return opt, nil
}

func (c *connector) GetElastiCacheClusters(ctx context.Context, input *elasticache.DescribeCacheClustersInput) ([]*elasticache.CacheCluster, error) {
	if c.svc.elasticache == nil {
		c.svc.elasticache = elasticache.New(c.svc.session)
	}

	opt := make([]*elasticache.CacheCluster, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elasticache.DescribeCacheClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.CacheClusters == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &elasticache.DescribeCacheClustersInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.CacheClusters...)

	}

	return opt, nil
}

func (c *connector) GetElastiCacheReplicationGroups(ctx context.Context, input *elasticache.DescribeReplicationGroupsInput) ([]*elasticache.ReplicationGroup, error) {
	if c.svc.elasticache == nil {
		c.svc.elasticache = elasticache.New(c.svc.session)
	}

	opt := make([]*elasticache.ReplicationGroup, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elasticache.DescribeReplicationGroupsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ReplicationGroups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &elasticache.DescribeReplicationGroupsInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.ReplicationGroups...)

	}

	return opt, nil
}

func (c *connector) GetElastiCacheTags(ctx context.Context, input *elasticache.ListTagsForResourceInput) ([]*elasticache.Tag, error) {
	if c.svc.elasticache == nil {
		c.svc.elasticache = elasticache.New(c.svc.session)
	}

	opt := make([]*elasticache.Tag, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elasticache.ListTagsForResourceWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TagList == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.TagList...)

	}

	return opt, nil
}

func (c *connector) GetElasticBeanstalkApplications(ctx context.Context, input *elasticbeanstalk.DescribeApplicationsInput) ([]*elasticbeanstalk.ApplicationDescription, error) {
	if c.svc.elasticbeanstalk == nil {
		c.svc.elasticbeanstalk = elasticbeanstalk.New(c.svc.session)
	}

	opt := make([]*elasticbeanstalk.ApplicationDescription, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elasticbeanstalk.DescribeApplicationsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Applications == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Applications...)

	}

	return opt, nil
}

func (c *connector) GetElasticsearchDomainNames(ctx context.Context, input *elasticsearchservice.ListDomainNamesInput) ([]*elasticsearchservice.DomainInfo, error) {
	if c.svc.elasticsearchservice == nil {
		c.svc.elasticsearchservice = elasticsearchservice.New(c.svc.session)
	}

	opt := make([]*elasticsearchservice.DomainInfo, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elasticsearchservice.ListDomainNamesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DomainNames == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.DomainNames...)

	}

	return opt, nil
}

func (c *connector) GetElasticsearchDomains(ctx context.Context, input *elasticsearchservice.DescribeElasticsearchDomainsInput) ([]*elasticsearchservice.ElasticsearchDomainStatus, error) {
	if c.svc.elasticsearchservice == nil {
		c.svc.elasticsearchservice = elasticsearchservice.New(c.svc.session)
	}

	opt := make([]*elasticsearchservice.ElasticsearchDomainStatus, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elasticsearchservice.DescribeElasticsearchDomainsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DomainStatusList == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.DomainStatusList...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancerAttributes(ctx context.Context, input *elb.DescribeLoadBalancerAttributesInput) ([]*elb.AdditionalAttribute, error) {
	if c.svc.elb == nil {
		c.svc.elb = elb.New(c.svc.session)
	}

	opt := make([]*elb.AdditionalAttribute, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elb.DescribeLoadBalancerAttributesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.LoadBalancerAttributes == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.LoadBalancerAttributes.AdditionalAttributes...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancers(ctx context.Context, input *elb.DescribeLoadBalancersInput) ([]*elb.LoadBalancerDescription, error) {
	if c.svc.elb == nil {
		c.svc.elb = elb.New(c.svc.session)
	}

	opt := make([]*elb.LoadBalancerDescription, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elb.DescribeLoadBalancersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.LoadBalancerDescriptions == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &elb.DescribeLoadBalancersInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.LoadBalancerDescriptions...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancerPolicies(ctx context.Context, input *elb.DescribeLoadBalancerPoliciesInput) ([]*elb.PolicyDescription, error) {
	if c.svc.elb == nil {
		c.svc.elb = elb.New(c.svc.session)
	}

	opt := make([]*elb.PolicyDescription, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elb.DescribeLoadBalancerPoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.PolicyDescriptions == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.PolicyDescriptions...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancersTags(ctx context.Context, input *elb.DescribeTagsInput) ([]*elb.TagDescription, error) {
	if c.svc.elb == nil {
		c.svc.elb = elb.New(c.svc.session)
	}

	opt := make([]*elb.TagDescription, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elb.DescribeTagsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TagDescriptions == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.TagDescriptions...)

	}

	return opt, nil
}

func (c *connector) GetListenerCertificates(ctx context.Context, input *elbv2.DescribeListenerCertificatesInput) ([]*elbv2.Certificate, error) {
	if c.svc.elbv2 == nil {
		c.svc.elbv2 = elbv2.New(c.svc.session)
	}

	opt := make([]*elbv2.Certificate, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elbv2.DescribeListenerCertificatesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Certificates == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &elbv2.DescribeListenerCertificatesInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.Certificates...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancersV2Listeners(ctx context.Context, input *elbv2.DescribeListenersInput) ([]*elbv2.Listener, error) {
	if c.svc.elbv2 == nil {
		c.svc.elbv2 = elbv2.New(c.svc.session)
	}

	opt := make([]*elbv2.Listener, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elbv2.DescribeListenersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Listeners == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &elbv2.DescribeListenersInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.Listeners...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancersV2(ctx context.Context, input *elbv2.DescribeLoadBalancersInput) ([]*elbv2.LoadBalancer, error) {
	if c.svc.elbv2 == nil {
		c.svc.elbv2 = elbv2.New(c.svc.session)
	}

	opt := make([]*elbv2.LoadBalancer, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elbv2.DescribeLoadBalancersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.LoadBalancers == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &elbv2.DescribeLoadBalancersInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.LoadBalancers...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancersV2Tags(ctx context.Context, input *elbv2.DescribeTagsInput) ([]*elbv2.TagDescription, error) {
	if c.svc.elbv2 == nil {
		c.svc.elbv2 = elbv2.New(c.svc.session)
	}

	opt := make([]*elbv2.TagDescription, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elbv2.DescribeTagsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TagDescriptions == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.TagDescriptions...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancersV2TargetGroupAttributes(ctx context.Context, input *elbv2.DescribeTargetGroupAttributesInput) ([]*elbv2.TargetGroupAttribute, error) {
	if c.svc.elbv2 == nil {
		c.svc.elbv2 = elbv2.New(c.svc.session)
	}

	opt := make([]*elbv2.TargetGroupAttribute, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elbv2.DescribeTargetGroupAttributesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Attributes == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Attributes...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancersV2TargetGroups(ctx context.Context, input *elbv2.DescribeTargetGroupsInput) ([]*elbv2.TargetGroup, error) {
	if c.svc.elbv2 == nil {
		c.svc.elbv2 = elbv2.New(c.svc.session)
	}

	opt := make([]*elbv2.TargetGroup, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elbv2.DescribeTargetGroupsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TargetGroups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &elbv2.DescribeTargetGroupsInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.TargetGroups...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancersV2TargetHealth(ctx context.Context, input *elbv2.DescribeTargetHealthInput) ([]*elbv2.TargetHealthDescription, error) {
	if c.svc.elbv2 == nil {
		c.svc.elbv2 = elbv2.New(c.svc.session)
	}

	opt := make([]*elbv2.TargetHealthDescription, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elbv2.DescribeTargetHealthWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TargetHealthDescriptions == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.TargetHealthDescriptions...)

	}

	return opt, nil
}

func (c *connector) GetLoadBalancersV2Rules(ctx context.Context, input *elbv2.DescribeRulesInput) ([]*elbv2.Rule, error) {
	if c.svc.elbv2 == nil {
		c.svc.elbv2 = elbv2.New(c.svc.session)
	}

	opt := make([]*elbv2.Rule, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.elbv2.DescribeRulesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Rules == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &elbv2.DescribeRulesInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.Rules...)

	}

	return opt, nil
}

func (c *connector) GetEMRClusters(ctx context.Context, input *emr.ListClustersInput) ([]*emr.ClusterSummary, error) {
	if c.svc.emr == nil {
		c.svc.emr = emr.New(c.svc.session)
	}

	opt := make([]*emr.ClusterSummary, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.emr.ListClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Clusters == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &emr.ListClustersInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Clusters...)

	}

	return opt, nil
}

func (c *connector) GetFSXFileSystems(ctx context.Context, input *fsx.DescribeFileSystemsInput) ([]*fsx.FileSystem, error) {
	if c.svc.fsx == nil {
		c.svc.fsx = fsx.New(c.svc.session)
	}

	opt := make([]*fsx.FileSystem, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.fsx.DescribeFileSystemsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.FileSystems == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &fsx.DescribeFileSystemsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.FileSystems...)

	}

	return opt, nil
}

func (c *connector) GetGlueDatabases(ctx context.Context, input *glue.GetDatabasesInput) ([]*glue.Database, error) {
	if c.svc.glue == nil {
		c.svc.glue = glue.New(c.svc.session)
	}

	opt := make([]*glue.Database, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.glue.GetDatabasesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DatabaseList == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &glue.GetDatabasesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.DatabaseList...)

	}

	return opt, nil
}

func (c *connector) GetGlueTables(ctx context.Context, input *glue.GetTablesInput) ([]*glue.TableData, error) {
	if c.svc.glue == nil {
		c.svc.glue = glue.New(c.svc.session)
	}

	opt := make([]*glue.TableData, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.glue.GetTablesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TableList == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &glue.GetTablesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TableList...)

	}

	return opt, nil
}

func (c *connector) GetAccessKeys(ctx context.Context, input *iam.ListAccessKeysInput) ([]*iam.AccessKeyMetadata, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.AccessKeyMetadata, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListAccessKeysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.AccessKeyMetadata == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListAccessKeysInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.AccessKeyMetadata...)

	}

	return opt, nil
}

func (c *connector) GetAccountAliases(ctx context.Context, input *iam.ListAccountAliasesInput) ([]*string, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListAccountAliasesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.AccountAliases == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListAccountAliasesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.AccountAliases...)

	}

	return opt, nil
}

func (c *connector) GetAccountPasswordPolicy(ctx context.Context, input *iam.GetAccountPasswordPolicyInput) (*iam.PasswordPolicy, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	var opt *iam.PasswordPolicy

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.GetAccountPasswordPolicyWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.PasswordPolicy == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = o.PasswordPolicy

	}

	return opt, nil
}

func (c *connector) GetAttachedGroupPolicies(ctx context.Context, input *iam.ListAttachedGroupPoliciesInput) ([]*iam.AttachedPolicy, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.AttachedPolicy, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListAttachedGroupPoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.AttachedPolicies == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListAttachedGroupPoliciesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.AttachedPolicies...)

	}

	return opt, nil
}

func (c *connector) GetAttachedRolePolicies(ctx context.Context, input *iam.ListAttachedRolePoliciesInput) ([]*iam.AttachedPolicy, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.AttachedPolicy, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListAttachedRolePoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.AttachedPolicies == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListAttachedRolePoliciesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.AttachedPolicies...)

	}

	return opt, nil
}

func (c *connector) GetAttachedUserPolicies(ctx context.Context, input *iam.ListAttachedUserPoliciesInput) ([]*iam.AttachedPolicy, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.AttachedPolicy, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListAttachedUserPoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.AttachedPolicies == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListAttachedUserPoliciesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.AttachedPolicies...)

	}

	return opt, nil
}

func (c *connector) GetGroupUsers(ctx context.Context, input *iam.GetGroupInput) ([]*iam.User, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.User, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.GetGroupWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Users == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.GetGroupInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Users...)

	}

	return opt, nil
}

func (c *connector) GetGroupPolicies(ctx context.Context, input *iam.ListGroupPoliciesInput) ([]*string, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListGroupPoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.PolicyNames == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListGroupPoliciesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.PolicyNames...)

	}

	return opt, nil
}

func (c *connector) GetGroups(ctx context.Context, input *iam.ListGroupsInput) ([]*iam.Group, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.Group, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListGroupsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Groups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListGroupsInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Groups...)

	}

	return opt, nil
}

func (c *connector) GetGroupsForUser(ctx context.Context, input *iam.ListGroupsForUserInput) ([]*iam.Group, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.Group, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListGroupsForUserWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Groups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListGroupsForUserInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Groups...)

	}

	return opt, nil
}

func (c *connector) GetInstanceProfiles(ctx context.Context, input *iam.ListInstanceProfilesInput) ([]*iam.InstanceProfile, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.InstanceProfile, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListInstanceProfilesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.InstanceProfiles == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListInstanceProfilesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.InstanceProfiles...)

	}

	return opt, nil
}

func (c *connector) GetOpenIDConnectProviders(ctx context.Context, input *iam.ListOpenIDConnectProvidersInput) ([]*iam.OpenIDConnectProviderListEntry, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.OpenIDConnectProviderListEntry, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListOpenIDConnectProvidersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.OpenIDConnectProviderList == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.OpenIDConnectProviderList...)

	}

	return opt, nil
}

func (c *connector) GetPolicies(ctx context.Context, input *iam.ListPoliciesInput) ([]*iam.Policy, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.Policy, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListPoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Policies == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListPoliciesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Policies...)

	}

	return opt, nil
}

func (c *connector) GetRolePolicies(ctx context.Context, input *iam.ListRolePoliciesInput) ([]*string, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListRolePoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.PolicyNames == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListRolePoliciesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.PolicyNames...)

	}

	return opt, nil
}

func (c *connector) GetRoles(ctx context.Context, input *iam.ListRolesInput) ([]*iam.Role, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.Role, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListRolesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Roles == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListRolesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Roles...)

	}

	return opt, nil
}

func (c *connector) GetSAMLProviders(ctx context.Context, input *iam.ListSAMLProvidersInput) ([]*iam.SAMLProviderListEntry, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.SAMLProviderListEntry, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListSAMLProvidersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.SAMLProviderList == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.SAMLProviderList...)

	}

	return opt, nil
}

func (c *connector) GetServerCertificates(ctx context.Context, input *iam.ListServerCertificatesInput) ([]*iam.ServerCertificateMetadata, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.ServerCertificateMetadata, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListServerCertificatesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ServerCertificateMetadataList == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListServerCertificatesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.ServerCertificateMetadataList...)

	}

	return opt, nil
}

func (c *connector) GetSSHPublicKeys(ctx context.Context, input *iam.ListSSHPublicKeysInput) ([]*iam.SSHPublicKeyMetadata, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.SSHPublicKeyMetadata, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListSSHPublicKeysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.SSHPublicKeys == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListSSHPublicKeysInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.SSHPublicKeys...)

	}

	return opt, nil
}

func (c *connector) GetUserPolicies(ctx context.Context, input *iam.ListUserPoliciesInput) ([]*string, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListUserPoliciesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.PolicyNames == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListUserPoliciesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.PolicyNames...)

	}

	return opt, nil
}

func (c *connector) GetUsers(ctx context.Context, input *iam.ListUsersInput) ([]*iam.User, error) {
	if c.svc.iam == nil {
		c.svc.iam = iam.New(c.svc.session)
	}

	opt := make([]*iam.User, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.iam.ListUsersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Users == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &iam.ListUsersInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Users...)

	}

	return opt, nil
}

func (c *connector) GetKinesisStreams(ctx context.Context, input *kinesis.ListStreamsInput) ([]*string, error) {
	if c.svc.kinesis == nil {
		c.svc.kinesis = kinesis.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.kinesis.ListStreamsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.StreamNames == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.StreamNames...)

	}

	return opt, nil
}

func (c *connector) GetLambdaFunctions(ctx context.Context, input *lambda.ListFunctionsInput) ([]*lambda.FunctionConfiguration, error) {
	if c.svc.lambda == nil {
		c.svc.lambda = lambda.New(c.svc.session)
	}

	opt := make([]*lambda.FunctionConfiguration, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.lambda.ListFunctionsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Functions == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &lambda.ListFunctionsInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.Functions...)

	}

	return opt, nil
}

func (c *connector) GetLightsailInstances(ctx context.Context, input *lightsail.GetInstancesInput) ([]*lightsail.Instance, error) {
	if c.svc.lightsail == nil {
		c.svc.lightsail = lightsail.New(c.svc.session)
	}

	opt := make([]*lightsail.Instance, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.lightsail.GetInstancesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Instances == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &lightsail.GetInstancesInput{}
		}
		input.PageToken = o.NextPageToken
		hasNextToken = o.NextPageToken != nil

		opt = append(opt, o.Instances...)

	}

	return opt, nil
}

func (c *connector) GetMediastoreContainers(ctx context.Context, input *mediastore.ListContainersInput) ([]*mediastore.Container, error) {
	if c.svc.mediastore == nil {
		c.svc.mediastore = mediastore.New(c.svc.session)
	}

	opt := make([]*mediastore.Container, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.mediastore.ListContainersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Containers == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &mediastore.ListContainersInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Containers...)

	}

	return opt, nil
}

func (c *connector) GetMQBrokers(ctx context.Context, input *mq.ListBrokersInput) ([]*mq.BrokerSummary, error) {
	if c.svc.mq == nil {
		c.svc.mq = mq.New(c.svc.session)
	}

	opt := make([]*mq.BrokerSummary, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.mq.ListBrokersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.BrokerSummaries == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &mq.ListBrokersInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.BrokerSummaries...)

	}

	return opt, nil
}

func (c *connector) GetNeptuneDBClusters(ctx context.Context, input *neptune.DescribeDBClustersInput) ([]*neptune.DBCluster, error) {
	if c.svc.neptune == nil {
		c.svc.neptune = neptune.New(c.svc.session)
	}

	opt := make([]*neptune.DBCluster, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.neptune.DescribeDBClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DBClusters == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &neptune.DescribeDBClustersInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.DBClusters...)

	}

	return opt, nil
}

func (c *connector) GetRDSDBClusters(ctx context.Context, input *rds.DescribeDBClustersInput) ([]*rds.DBCluster, error) {
	if c.svc.rds == nil {
		c.svc.rds = rds.New(c.svc.session)
	}

	opt := make([]*rds.DBCluster, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.rds.DescribeDBClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DBClusters == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &rds.DescribeDBClustersInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.DBClusters...)

	}

	return opt, nil
}

func (c *connector) GetDBInstances(ctx context.Context, input *rds.DescribeDBInstancesInput) ([]*rds.DBInstance, error) {
	if c.svc.rds == nil {
		c.svc.rds = rds.New(c.svc.session)
	}

	opt := make([]*rds.DBInstance, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.rds.DescribeDBInstancesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DBInstances == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &rds.DescribeDBInstancesInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.DBInstances...)

	}

	return opt, nil
}

func (c *connector) GetDBParameterGroups(ctx context.Context, input *rds.DescribeDBParameterGroupsInput) ([]*rds.DBParameterGroup, error) {
	if c.svc.rds == nil {
		c.svc.rds = rds.New(c.svc.session)
	}

	opt := make([]*rds.DBParameterGroup, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.rds.DescribeDBParameterGroupsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DBParameterGroups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &rds.DescribeDBParameterGroupsInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.DBParameterGroups...)

	}

	return opt, nil
}

func (c *connector) GetDBSubnetGroups(ctx context.Context, input *rds.DescribeDBSubnetGroupsInput) ([]*rds.DBSubnetGroup, error) {
	if c.svc.rds == nil {
		c.svc.rds = rds.New(c.svc.session)
	}

	opt := make([]*rds.DBSubnetGroup, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.rds.DescribeDBSubnetGroupsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DBSubnetGroups == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &rds.DescribeDBSubnetGroupsInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.DBSubnetGroups...)

	}

	return opt, nil
}

func (c *connector) GetRDSGlobalClusters(ctx context.Context, input *rds.DescribeGlobalClustersInput) ([]*rds.GlobalCluster, error) {
	if c.svc.rds == nil {
		c.svc.rds = rds.New(c.svc.session)
	}

	opt := make([]*rds.GlobalCluster, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.rds.DescribeGlobalClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.GlobalClusters == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &rds.DescribeGlobalClustersInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.GlobalClusters...)

	}

	return opt, nil
}

func (c *connector) GetDBInstancesTags(ctx context.Context, input *rds.ListTagsForResourceInput) ([]*rds.Tag, error) {
	if c.svc.rds == nil {
		c.svc.rds = rds.New(c.svc.session)
	}

	opt := make([]*rds.Tag, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.rds.ListTagsForResourceWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TagList == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.TagList...)

	}

	return opt, nil
}

func (c *connector) GetRedshiftClusters(ctx context.Context, input *redshift.DescribeClustersInput) ([]*redshift.Cluster, error) {
	if c.svc.redshift == nil {
		c.svc.redshift = redshift.New(c.svc.session)
	}

	opt := make([]*redshift.Cluster, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.redshift.DescribeClustersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Clusters == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &redshift.DescribeClustersInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Clusters...)

	}

	return opt, nil
}

func (c *connector) GetQueryLoggingConfigs(ctx context.Context, input *route53.ListQueryLoggingConfigsInput) ([]*route53.QueryLoggingConfig, error) {
	if c.svc.route53 == nil {
		c.svc.route53 = route53.New(c.svc.session)
	}

	opt := make([]*route53.QueryLoggingConfig, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53.ListQueryLoggingConfigsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.QueryLoggingConfigs == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53.ListQueryLoggingConfigsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.QueryLoggingConfigs...)

	}

	return opt, nil
}

func (c *connector) GetHealthChecks(ctx context.Context, input *route53.ListHealthChecksInput) ([]*route53.HealthCheck, error) {
	if c.svc.route53 == nil {
		c.svc.route53 = route53.New(c.svc.session)
	}

	opt := make([]*route53.HealthCheck, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53.ListHealthChecksWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.HealthChecks == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53.ListHealthChecksInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.HealthChecks...)

	}

	return opt, nil
}

func (c *connector) GetHostedZones(ctx context.Context, input *route53.ListHostedZonesInput) ([]*route53.HostedZone, error) {
	if c.svc.route53 == nil {
		c.svc.route53 = route53.New(c.svc.session)
	}

	opt := make([]*route53.HostedZone, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53.ListHostedZonesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.HostedZones == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53.ListHostedZonesInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.HostedZones...)

	}

	return opt, nil
}

func (c *connector) GetResourceRecordSets(ctx context.Context, input *route53.ListResourceRecordSetsInput) ([]*route53.ResourceRecordSet, error) {
	if c.svc.route53 == nil {
		c.svc.route53 = route53.New(c.svc.session)
	}

	opt := make([]*route53.ResourceRecordSet, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53.ListResourceRecordSetsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ResourceRecordSets == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53.ListResourceRecordSetsInput{}
		}
		input.StartRecordName = o.NextRecordName
		hasNextToken = o.NextRecordName != nil

		opt = append(opt, o.ResourceRecordSets...)

	}

	return opt, nil
}

func (c *connector) GetReusableDelegationSets(ctx context.Context, input *route53.ListReusableDelegationSetsInput) ([]*route53.DelegationSet, error) {
	if c.svc.route53 == nil {
		c.svc.route53 = route53.New(c.svc.session)
	}

	opt := make([]*route53.DelegationSet, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53.ListReusableDelegationSetsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.DelegationSets == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53.ListReusableDelegationSetsInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.DelegationSets...)

	}

	return opt, nil
}

func (c *connector) GetVPCAssociationAuthorizations(ctx context.Context, input *route53.ListVPCAssociationAuthorizationsInput) ([]*route53.VPC, error) {
	if c.svc.route53 == nil {
		c.svc.route53 = route53.New(c.svc.session)
	}

	opt := make([]*route53.VPC, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53.ListVPCAssociationAuthorizationsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.VPCs == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53.ListVPCAssociationAuthorizationsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.VPCs...)

	}

	return opt, nil
}

func (c *connector) GetResolverEndpoints(ctx context.Context, input *route53resolver.ListResolverEndpointsInput) ([]*route53resolver.ResolverEndpoint, error) {
	if c.svc.route53resolver == nil {
		c.svc.route53resolver = route53resolver.New(c.svc.session)
	}

	opt := make([]*route53resolver.ResolverEndpoint, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53resolver.ListResolverEndpointsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ResolverEndpoints == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53resolver.ListResolverEndpointsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ResolverEndpoints...)

	}

	return opt, nil
}

func (c *connector) GetResolverRuleAssociations(ctx context.Context, input *route53resolver.ListResolverRuleAssociationsInput) ([]*route53resolver.ResolverRuleAssociation, error) {
	if c.svc.route53resolver == nil {
		c.svc.route53resolver = route53resolver.New(c.svc.session)
	}

	opt := make([]*route53resolver.ResolverRuleAssociation, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53resolver.ListResolverRuleAssociationsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ResolverRuleAssociations == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53resolver.ListResolverRuleAssociationsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ResolverRuleAssociations...)

	}

	return opt, nil
}

func (c *connector) GetResolverRules(ctx context.Context, input *route53resolver.ListResolverRulesInput) ([]*route53resolver.ResolverRule, error) {
	if c.svc.route53resolver == nil {
		c.svc.route53resolver = route53resolver.New(c.svc.session)
	}

	opt := make([]*route53resolver.ResolverRule, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.route53resolver.ListResolverRulesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ResolverRules == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &route53resolver.ListResolverRulesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ResolverRules...)

	}

	return opt, nil
}

func (c *connector) GetBucketTags(ctx context.Context, input *s3.GetBucketTaggingInput) ([]*s3.Tag, error) {
	if c.svc.s3 == nil {
		c.svc.s3 = s3.New(c.svc.session)
	}

	opt := make([]*s3.Tag, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.s3.GetBucketTaggingWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TagSet == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.TagSet...)

	}

	return opt, nil
}

func (c *connector) ListObjects(ctx context.Context, input *s3.ListObjectsInput) ([]*s3.Object, error) {
	if c.svc.s3 == nil {
		c.svc.s3 = s3.New(c.svc.session)
	}

	opt := make([]*s3.Object, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.s3.ListObjectsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Contents == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &s3.ListObjectsInput{}
		}
		input.Marker = o.NextMarker
		hasNextToken = o.NextMarker != nil

		opt = append(opt, o.Contents...)

	}

	return opt, nil
}

func (c *connector) GetObjectsTags(ctx context.Context, input *s3.GetObjectTaggingInput) ([]*s3.Tag, error) {
	if c.svc.s3 == nil {
		c.svc.s3 = s3.New(c.svc.session)
	}

	opt := make([]*s3.Tag, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.s3.GetObjectTaggingWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TagSet == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.TagSet...)

	}

	return opt, nil
}

func (c *connector) GetActiveReceiptRuleSet(ctx context.Context, input *ses.DescribeActiveReceiptRuleSetInput) (*string, error) {
	if c.svc.ses == nil {
		c.svc.ses = ses.New(c.svc.session)
	}

	var opt *string

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ses.DescribeActiveReceiptRuleSetWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Metadata == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = o.Metadata.Name

	}

	return opt, nil
}

func (c *connector) GetActiveReceiptRulesSet(ctx context.Context, input *ses.DescribeActiveReceiptRuleSetInput) ([]*ses.ReceiptRule, error) {
	if c.svc.ses == nil {
		c.svc.ses = ses.New(c.svc.session)
	}

	opt := make([]*ses.ReceiptRule, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ses.DescribeActiveReceiptRuleSetWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Rules == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Rules...)

	}

	return opt, nil
}

func (c *connector) GetConfigurationSets(ctx context.Context, input *ses.ListConfigurationSetsInput) ([]*ses.ConfigurationSet, error) {
	if c.svc.ses == nil {
		c.svc.ses = ses.New(c.svc.session)
	}

	opt := make([]*ses.ConfigurationSet, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ses.ListConfigurationSetsWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.ConfigurationSets == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ses.ListConfigurationSetsInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.ConfigurationSets...)

	}

	return opt, nil
}

func (c *connector) GetIdentities(ctx context.Context, input *ses.ListIdentitiesInput) ([]*string, error) {
	if c.svc.ses == nil {
		c.svc.ses = ses.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ses.ListIdentitiesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Identities == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ses.ListIdentitiesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.Identities...)

	}

	return opt, nil
}

func (c *connector) GetIdentityNotificationAttributes(ctx context.Context, input *ses.GetIdentityNotificationAttributesInput) (map[string]*ses.IdentityNotificationAttributes, error) {
	if c.svc.ses == nil {
		c.svc.ses = ses.New(c.svc.session)
	}

	opt := make(map[string]*ses.IdentityNotificationAttributes, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ses.GetIdentityNotificationAttributesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.NotificationAttributes == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = o.NotificationAttributes

	}

	return opt, nil
}

func (c *connector) GetReceiptFilters(ctx context.Context, input *ses.ListReceiptFiltersInput) ([]*ses.ReceiptFilter, error) {
	if c.svc.ses == nil {
		c.svc.ses = ses.New(c.svc.session)
	}

	opt := make([]*ses.ReceiptFilter, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ses.ListReceiptFiltersWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Filters == nil {
			hasNextToken = false
			continue
		}

		hasNextToken = false

		opt = append(opt, o.Filters...)

	}

	return opt, nil
}

func (c *connector) GetTemplates(ctx context.Context, input *ses.ListTemplatesInput) ([]*ses.TemplateMetadata, error) {
	if c.svc.ses == nil {
		c.svc.ses = ses.New(c.svc.session)
	}

	opt := make([]*ses.TemplateMetadata, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.ses.ListTemplatesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.TemplatesMetadata == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &ses.ListTemplatesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.TemplatesMetadata...)

	}

	return opt, nil
}

func (c *connector) GetSQSQueues(ctx context.Context, input *sqs.ListQueuesInput) ([]*string, error) {
	if c.svc.sqs == nil {
		c.svc.sqs = sqs.New(c.svc.session)
	}

	opt := make([]*string, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.sqs.ListQueuesWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.QueueUrls == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &sqs.ListQueuesInput{}
		}
		input.NextToken = o.NextToken
		hasNextToken = o.NextToken != nil

		opt = append(opt, o.QueueUrls...)

	}

	return opt, nil
}

func (c *connector) GetStorageGatewayGateways(ctx context.Context, input *storagegateway.ListGatewaysInput) ([]*storagegateway.GatewayInfo, error) {
	if c.svc.storagegateway == nil {
		c.svc.storagegateway = storagegateway.New(c.svc.session)
	}

	opt := make([]*storagegateway.GatewayInfo, 0)

	hasNextToken := true
	for hasNextToken {
		o, err := c.svc.storagegateway.ListGatewaysWithContext(ctx, input)
		if err != nil {
			return nil, err
		}
		if o.Gateways == nil {
			hasNextToken = false
			continue
		}

		if input == nil {
			input = &storagegateway.ListGatewaysInput{}
		}
		input.Marker = o.Marker
		hasNextToken = o.Marker != nil

		opt = append(opt, o.Gateways...)

	}

	return opt, nil
}
