# Get SH\*T Done with Prompt Engineering and LangChain

Build real-world AI apps with ChatGPT/GPT-4 and LangChain in Python

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/curiousily/Get-Things-Done-with-Prompt-Engineering-and-LangChain/)
[![](https://dcbadge.vercel.app/api/server/UaNPxVD6tv?style=flat)](https://discord.gg/UaNPxVD6tv)
[![](https://img.shields.io/youtube/channel/subscribers/UCoW_WzQNJVAjxo4osNAxd_g?label=Watch%20on%20YouTube)](https://bit.ly/venelin-subscribe)
[![](https://img.shields.io/github/license/curiousily/Get-Things-Done-with-Prompt-Engineering-and-LangChain)](https://github.com/curiousily/Get-Things-Done-with-Prompt-Engineering-and-LangChain/blob/master/LICENSE)

## 🍿 Watch on YouTube

- [Getting Started with LangChain and Llama 2 in 15 Minutes](https://www.youtube.com/watch?v=7VAGe32YptI)
- [Fine-tuning Llama 2 on Your Own Dataset](https://www.youtube.com/watch?v=MDA3LUKNl1E)
- [Deploy LLM to Production on Single GPU](https://www.youtube.com/watch?v=HI3cYN0c9ZU)
- [Chat with Multiple PDFs using Llama 2 and LangChain](https://www.youtube.com/watch?v=QshWJ77Sktc)
- [AutoGen - Build Powerful AI Agents with ChatGPT/GPT-4](https://www.youtube.com/watch?v=mJfHMlKL7Qc)

## 📖 Read the Tutorials

### LangChain

- [LangChain QuickStart with Llama 2](https://www.mlexpert.io/prompt-engineering/langchain-quickstart-with-llama-2)
- [Load Custom Data with Loaders](https://www.mlexpert.io/prompt-engineering/loaders)
- [Add AI with Models](https://www.mlexpert.io/prompt-engineering/models)
- [Make LLMs Useful with Chains](https://www.mlexpert.io/prompt-engineering/chains)
- [Build Chatbots with Memory](https://www.mlexpert.io/prompt-engineering/memory)
- [Complex Tasks with Agents](https://www.mlexpert.io/prompt-engineering/agents)

### Models

- [StableVicuna - Open Source RLHF LLM Chatbot](https://www.mlexpert.io/prompt-engineering/stable-vicuna)
- [OpenLLaMa - An Open Reproduction of LLaMA](https://www.mlexpert.io/prompt-engineering/open-llama)
- [XGen-7B: Long Sequence Modeling with (up to) 8K Tokens](https://www.youtube.com/watch?v=6YMOCaXGUDA)
- [Falcon 180B](https://www.mlexpert.io/prompt-engineering/falcon-180b)

### Projects

- [Fine-tuning Llama 2 on a Custom Dataset](https://www.mlexpert.io/prompt-engineering/fine-tuning-llama-2-on-custom-dataset)
- [Chat with Multiple PDFs using Llama 2 and LangChain](https://www.mlexpert.io/prompt-engineering/chat-with-multiple-pdfs-using-llama-2-and-langchain)
- [Chatbot with Local LLM (Falcon 7B) and LangChain](https://www.mlexpert.io/prompt-engineering/chatbot-with-local-llm-using-langchain)
- [Private GPT4All: Chat with PDF Files Using Free LLM](https://www.mlexpert.io/prompt-engineering/private-gpt4all)
- [CryptoGPT: Crypto Twitter Sentiment Analysis](https://www.mlexpert.io/prompt-engineering/cryptogpt)
- [Fine-tuning LLM (Falcon 7b) on a Custom Dataset with QLoRA](https://www.mlexpert.io/prompt-engineering/fine-tuning-llm-on-custom-dataset-with-qlora)
- [Deploy LLM to Production with HuggingFace Inference Endpoints](https://www.mlexpert.io/prompt-engineering/deploy-llm-to-production)
- [Support Chatbot using Custom Knowledge Base with LangChain and Open LLM](https://www.mlexpert.io/prompt-engineering/support-chatbot-using-custom-knowledge-base-with-langchain)
- [Deploy Your Private Llama 2 Model to Production with RunPod](https://www.mlexpert.io/prompt-engineering/deploy-llama-2-on-runpod)
- [AutoGen - Build Powerful AI Agents with ChatGPT/GPT-4](https://www.mlexpert.io/prompt-engineering/autogen-build-ai-agents)
