
module.exports = function convert(feature) {
        let scenerios = feature.elements || [];
        let hasFailed;
        let failLocation;
        scenerios.forEach((scene) => {
            let failed = null;
            if (scene && scene.steps && scene.steps.length > 0) {
                for (let i = 0; i < scene.steps.length; i++) {
                    if(scene.steps[i].result && scene.steps[i].result.status === "failed") {
                        failed = scene.steps[i];
                    }
                    if (scene.steps[i].result) {
                        scene.steps[i].result.duration = Math.floor(
                                scene.steps[i].result.duration * 1000000000
                            );
                    }
                }
            }
            if (failed) {
                hasFailed = true;
                console.log(`fail scene --- ${scene.location ? scene.location : ""} ===`);
                if (failed.result && failed.result.error_message
                    && failed.result.error_message.constructor === Array) {
                    let error_message_str = "";
                    for (let i = 0; i < failed.result.error_message.length; i++) {
                        error_message_str =
                            error_message_str + failed.result.error_message[i] + "\n";
                    }
                    failed.result.error_message = error_message_str;
                }
            }
            if (scene.description && scene.description.constructor === Array) {
                let description = ""
                for (let i = 0; i < scene.description.length; i++) {
                    description = description + scene.description[i] + "\n";
                }
                scene.description = description;
            }
            if(failed){
                const findLocation = scene.description.includes('location:');
                failLocation = findLocation ? scene.description.split('location:')[1] : null;
            }
        });

        if(hasFailed){
            const curFeature = feature.location? feature.location.replace(/(.*\/)*([^.]+).*/ig,"$2") + '.feature':null;
            console.log('failed feature', feature.name, 'feature.location', feature.location, 'hasFailed', hasFailed, 'failLocation', failLocation, 'curFeature', curFeature);
            feature.name = curFeature ? feature.name + '（' + curFeature + '）': feature.name ;
        }

}