# 页面元素
在前端软件中（ios，android，h5），一个按钮是一个元素，一个文本框是一个元素，一张卡片，一个列表也是这个页面上的元素。元素与元素之间关系是一棵树，可能并列也可能包含。

我们可以这样理解前端软件测试：

在限定的数据环境下，对一部分页面元素进行交互，验证另一部分页面元素是否符合需求预期表现。

限定数据环境可通过mock服务报文等方式实现，元素能响应手指的点击也能响应操作系统传递的指令，剩下需要我们关注的点是元素的识别和元素是否符合预期表现。

元素的识别在手工测试中，是通过人眼对于元素的位置，颜色，文案等特性判断的。

在UI自动化测试平台中，一个元素拥有位置(xPath)，文案，id，无障碍标签等属性，一个简短且唯一的属性适合用于识别元素。 推荐使用文案和无障碍标签。

判断元素是否符合预期表现则需要视具体情况而定： 判断文案是否符合预期则通过获取元素文案与预期值做比对； 判断元素是否展示在了列表第二项，则固定列表第二项的无障碍标签，通过获取第二项的其他属性来识别是否为目标属性完成验证。

坦诚讲，肯定存在只有手工测试而自动化测试无法验证的用例，但是如果大部分用例能使用自动化测试，我们也能缓解目前所面临的问题并从中受益。

# 怎样查找元素属性
**移动端**
1.  安装airtest官方提供的IDE编辑器：[下载地址](https://airtest.netease.com/) 
2.  [IDE使用帮助](https://airtest.doc.io.netease.com/IDEdocs/3.1getting_started/AirtestIDE_install/)

**web端**
1. 元素选择器：[Selectors](https://playwright.dev/python/docs/selectors)