# Behave语法
为了让 Behave 理解这些场景，他们必须遵循一些基本的语法规则，称为 Gherkin.

## 功能文件
功能文件具有描述特征以及预期结果的代表性示例的自然语言格式。它们是纯文本（以 UTF-8 编码），看起来像：
```
功能:航班列表页
功能描述:检查价格元素、筛选浮层元素
需求方案：
1、验证价格元素是否正确
2、验证筛选浮层元素展示是否正确

场景:单程_仅看直飞
    当   连接设备[10.21.37.128:5555]
    当   跳转到[单程列表页]
    而且 等待[5]秒
    那么 存在[机票价格]的元素
    那么 不存在[text=机票列表筛选浮层]的元素
    而且 返回上一页
```
这里的“当”、“而且”和“那么”部分构成了行为在测试系统时将采取的实际步骤。这些映射到Python步骤实现。
您还可以包含“And”或“But”作为一个步骤 - 这些被行为重命名 以采用其前一步骤的名称，因此：

## 场景大纲
有时，一个场景应该与多个变量一起运行，给出一组已知状态、要采取的行动和预期结果，所有这些都使用相同的基本行动。您可以使用场景大纲来实现这一点：
```
场景大纲:单程_元素检查
    当   跳转到[列表页]
    而且 等待[5]秒
    那么 存在<元素A>的元素
    那么 不存在<元素B>的元素
    而且 返回上一页

   | 元素A       | 元素B       |
   | 机票价格    | 筛选按钮     |
   | 出发机场    | 退改签浮层   |
   | 到达机场    | 退改签价格   |

```
行为将为示例数据表中出现的每个（非标题）行运行一次场景。

访问 [Behave](https://github.com/behave/behave), 了解更多Behave语法。

[Visual Studio Code](https://code.visualstudio.com/) 是适用于 Windows、Linux 和 macOS 的代码编辑器IDE。

你可以在IDE中使用 [Gherkin 插件](https://marketplace.visualstudio.com/items?itemName=alexkrechik.cucumberautocomplete).
