/*
 *
 * University of Luxembourg
 * Laboratory of Algorithmics, Cryptology and Security (LACS)
 *
 * arm_v7m_leakage simulator
 *
 * Copyright (C) 2017 University of Luxembourg
 *
 * Written in 2017 by Yann Le Corre <yann.lecorre@uni.lu>
 *
 * This simulator is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * It is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

/******************************************************************************
 *
 * utilities
 *
 ******************************************************************************/

#include <cstdint>
#include <cstdio>
#include <cstdlib>

#define USE_ASM_POPCNT

unsigned int bit_count(uint32_t x)
{
#ifdef USE_ASM_POPCNT
	unsigned int count;

	asm("popcnt %1,%0" : "=r"(count) : "rm"(x) : "cc");
	return count;
#else
	#warning("Using C version of popcount")
    unsigned int h = 0;
    uint32_t u = x;
    while (u > 0)
    {
        h += (u & 1);
        u >>= 1;
    }
    return h;
#endif
}
