/*
 * Copyright (C) 2014 RoboVM AB
 *
 * Licensed under the Apache License, version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.objc.block;


/**
 * Block which takes 4 generic arguments and returns no value.
 */
public interface VoidBlock4<A, B, C, D> {

    /**
     * Invokes this block.
     *
     * @param a block argument number 1.
     * @param b block argument number 2.
     * @param c block argument number 3.
     * @param d block argument number 4.
     */
    void invoke(A a, B b, C c, D d);
}
