/*
 * (c) 2023 by Panayotis Katsaloulis
 *
 * SPDX-License-Identifier: LGPL-3.0-only
 */

package org.crossmobile.backend.cat;

import com.panayotis.appenh.Enhancer;
import com.panayotis.appenh.EnhancerManager;

import javax.swing.*;
import java.awt.*;

public class ApplicationPresentation extends javax.swing.JFrame {

    private final IconHolder icons;

    /**
     * Creates new form ApplicationPresentation
     *
     * @throws java.lang.Exception
     */
    @SuppressWarnings("OverridableMethodCallInConstructor")
    public ApplicationPresentation() throws Exception {
        initComponents();

        icons = new IconHolder();
        baseP.add(icons, BorderLayout.CENTER);
        pack();
        setLocationRelativeTo(null);

        icons.addIconListener(new IconSelectionListener() {
            @Override
            public void iconSelected(MobileApp app) {
                if (icons.isEditable()) {
                    if (JOptionPane.showConfirmDialog(ApplicationPresentation.this, "Please confirm that you would like to remove application " + app.name(), "Remove application " + app.name(), JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
                        icons.removeApp(app);
                } else
                    app.open();
            }

            @Override
            public void iconInfo(MobileApp app) {
                locationL.setText(app == null ? "" : app.info());
            }
        });
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        baseP = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        editB = new javax.swing.JButton();
        locationL = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("CrossMobile Applications");
        setResizable(false);

        baseP.setBackground(new java.awt.Color(64, 64, 64));
        baseP.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 12, 12, 12));
        baseP.setLayout(new BorderLayout());

        jPanel3.setOpaque(false);
        jPanel3.setLayout(new BorderLayout());

        jPanel4.setOpaque(false);

        editB.setText("Edit");
        editB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editBActionPerformed(evt);
            }
        });
        jPanel4.add(editB);

        jPanel3.add(jPanel4, BorderLayout.EAST);

        locationL.setEditable(false);
        locationL.setBackground(new java.awt.Color(64, 64, 64));
        locationL.setForeground(new java.awt.Color(255, 255, 255));
        locationL.setBorder(null);
        jPanel3.add(locationL, BorderLayout.CENTER);

        baseP.add(jPanel3, BorderLayout.NORTH);

        getContentPane().add(baseP, BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void editBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editBActionPerformed
        icons.setEditable(!icons.isEditable());
        editB.setText(icons.isEditable() ? "Done" : "Edit");
    }//GEN-LAST:event_editBActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        Enhancer enhancer = EnhancerManager.getDefault();
        enhancer.setDefaultLookAndFeel();
        enhancer.registerAbout(() -> {
            System.out.println("about!");
        });
        enhancer.registerPreferences(() -> {
            System.out.println("prefs");
        });

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(() -> {
            try {
                ApplicationPresentation app = new ApplicationPresentation();
                app.setVisible(true);
            } catch (Exception err) {
                JOptionPane.showMessageDialog(null, "No valid CrossMobile applications found", "CrossMobile Menu", JOptionPane.WARNING_MESSAGE);
                System.exit(1);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel baseP;
    private javax.swing.JButton editB;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JTextField locationL;
    // End of variables declaration//GEN-END:variables
}
