/*
 * (c) 2023 by Panayotis Katsaloulis
 *
 * SPDX-License-Identifier: LGPL-3.0-only
 */

package crossmobile.ios.foundation;

import org.crossmobile.bridge.ann.CMEnum;

@CMEnum
public final class NSNotificationName {

    public static final String AVAudioEngineConfigurationChange = "AVAudioEngineConfigurationChange";
    public static final String AVAudioSessionInterruption = "AVAudioSessionInterruption";
    public static final String AVAudioSessionMediaServicesWereLost = "AVAudioSessionMediaServicesWereLost";
    public static final String AVAudioSessionMediaServicesWereReset = "AVAudioSessionMediaServicesWereReset";
    public static final String AVAudioSessionRouteChange = "AVAudioSessionRouteChange";
    public static final String AVAudioSessionSilenceSecondaryAudioHint = "AVAudioSessionSilenceSecondaryAudioHint";
    public static final String AVAudioUnitComponentTagsDidChange = "AVAudioUnitComponentTagsDidChange";
    public static final String CKAccountChanged = "CKAccountChanged";
    public static final String CLKComplicationServerActiveComplicationsDidChange = "CLKComplicationServerActiveComplicationsDidChange";
    public static final String CNContactStoreDidChange = "CNContactStoreDidChange";
    public static final String EKEventStoreChanged = "EKEventStoreChanged";
    public static final String HKUserPreferencesDidChange = "HKUserPreferencesDidChange";
    public static final String HMCharacteristicPropertySupportsEvent = "HMCharacteristicPropertySupportsEvent";
    public static final String NSBundleResourceRequestLowDiskSpace = "NSBundleResourceRequestLowDiskSpace";
    public static final String NSCalendarDayChanged = "NSCalendarDayChanged";
    public static final String NSDidBecomeSingleThreaded = "NSDidBecomeSingleThreaded";
    public static final String NSExtensionHostDidBecomeActive = "NSExtensionHostDidBecomeActive";
    public static final String NSExtensionHostDidEnterBackground = "NSExtensionHostDidEnterBackground";
    public static final String NSExtensionHostWillEnterForeground = "NSExtensionHostWillEnterForeground";
    public static final String NSExtensionHostWillResignActive = "NSExtensionHostWillResignActive";
    public static final String NSFileHandleConnectionAccepted = "NSFileHandleConnectionAccepted";
    public static final String NSFileHandleDataAvailable = "NSFileHandleDataAvailable";
    public static final String NSFileHandleReadToEndOfFileCompletion = "NSFileHandleReadToEndOfFileCompletion";
    public static final String NSHTTPCookieManagerAcceptPolicyChanged = "NSHTTPCookieManagerAcceptPolicyChanged";
    public static final String NSHTTPCookieManagerCookiesChanged = "NSHTTPCookieManagerCookiesChanged";
    public static final String NSManagedObjectContextDidSave = "NSManagedObjectContextDidSave";
    public static final String NSManagedObjectContextObjectsDidChange = "NSManagedObjectContextObjectsDidChange";
    public static final String NSManagedObjectContextWillSave = "NSManagedObjectContextWillSave";
    public static final String NSMetadataQueryDidFinishGathering = "NSMetadataQueryDidFinishGathering";
    public static final String NSMetadataQueryDidStartGathering = "NSMetadataQueryDidStartGathering";
    public static final String NSMetadataQueryDidUpdate = "NSMetadataQueryDidUpdate";
    public static final String NSMetadataQueryGatheringProgress = "NSMetadataQueryGatheringProgress";
    public static final String NSPersistentStoreCoordinatorStoresDidChange = "NSPersistentStoreCoordinatorStoresDidChange";
    public static final String NSPersistentStoreCoordinatorStoresWillChange = "NSPersistentStoreCoordinatorStoresWillChange";
    public static final String NSPersistentStoreCoordinatorWillRemoveStore = "NSPersistentStoreCoordinatorWillRemoveStore";
    public static final String NSProcessInfoPowerStateDidChange = "NSProcessInfoPowerStateDidChange";
    public static final String NSSystemClockDidChange = "NSSystemClockDidChange";
    public static final String NSSystemTimeZoneDidChange = "NSSystemTimeZoneDidChange";
    public static final String NSThreadWillExit = "NSThreadWillExit";
    public static final String NSURLCredentialStorageChanged = "NSURLCredentialStorageChanged";
    public static final String NSUbiquityIdentityDidChange = "NSUbiquityIdentityDidChange";
    public static final String NSUndoManagerCheckpoint = "NSUndoManagerCheckpoint";
    public static final String NSUndoManagerDidCloseUndoGroup = "NSUndoManagerDidCloseUndoGroup";
    public static final String NSUndoManagerDidOpenUndoGroup = "NSUndoManagerDidOpenUndoGroup";
    public static final String NSUndoManagerDidRedoChange = "NSUndoManagerDidRedoChange";
    public static final String NSUndoManagerDidUndoChange = "NSUndoManagerDidUndoChange";
    public static final String NSUndoManagerWillCloseUndoGroup = "NSUndoManagerWillCloseUndoGroup";
    public static final String NSUndoManagerWillRedoChange = "NSUndoManagerWillRedoChange";
    public static final String NSUndoManagerWillUndoChange = "NSUndoManagerWillUndoChange";
    public static final String NSWillBecomeMultiThreaded = "NSWillBecomeMultiThreaded";
    public static final String PKPassLibraryDidChange = "PKPassLibraryDidChange";
    public static final String PKPassLibraryRemotePaymentPassesDidChange = "PKPassLibraryRemotePaymentPassesDidChange";
    public static final String UIAccessibilityAnnouncementDidFinish = "UIAccessibilityAnnouncementDidFinish";
    public static final String UIAccessibilityElementFocused = "UIAccessibilityElementFocused";
    public static final String WKAudioFilePlayerItemDidPlayToEndTime = "WKAudioFilePlayerItemDidPlayToEndTime";
    public static final String WKAudioFilePlayerItemFailedToPlayToEndTime = "WKAudioFilePlayerItemFailedToPlayToEndTime";
    public static final String WKAudioFilePlayerItemTimeJumped = "WKAudioFilePlayerItemTimeJumped";
    public static final String ABPeoplePickerDisplayedPropertyDidChange = "ABPeoplePickerDisplayedPropertyDidChange";
    public static final String ABPeoplePickerGroupSelectionDidChange = "ABPeoplePickerGroupSelectionDidChange";
    public static final String ABPeoplePickerNameSelectionDidChange = "ABPeoplePickerNameSelectionDidChange";
    public static final String ABPeoplePickerValueSelectionDidChange = "ABPeoplePickerValueSelectionDidChange";
    public static final String ACAccountStoreDidChange = "ACAccountStoreDidChange";
    public static final String AVAssetChapterMetadataGroupsDidChange = "AVAssetChapterMetadataGroupsDidChange";
    public static final String AVAssetContainsFragmentsDidChange = "AVAssetContainsFragmentsDidChange";
    public static final String AVAssetDurationDidChange = "AVAssetDurationDidChange";
    public static final String AVAssetMediaSelectionGroupsDidChange = "AVAssetMediaSelectionGroupsDidChange";
    public static final String AVAssetTrackSegmentsDidChange = "AVAssetTrackSegmentsDidChange";
    public static final String AVAssetTrackTimeRangeDidChange = "AVAssetTrackTimeRangeDidChange";
    public static final String AVAssetTrackTrackAssociationsDidChange = "AVAssetTrackTrackAssociationsDidChange";
    public static final String AVAssetWasDefragmented = "AVAssetWasDefragmented";
    public static final String AVCaptureDeviceWasConnected = "AVCaptureDeviceWasConnected";
    public static final String AVCaptureDeviceWasDisconnected = "AVCaptureDeviceWasDisconnected";
    public static final String AVCaptureInputPortFormatDescriptionDidChange = "AVCaptureInputPortFormatDescriptionDidChange";
    public static final String AVCaptureSessionDidStartRunning = "AVCaptureSessionDidStartRunning";
    public static final String AVCaptureSessionDidStopRunning = "AVCaptureSessionDidStopRunning";
    public static final String AVCaptureSessionRuntimeError = "AVCaptureSessionRuntimeError";
    public static final String AVFragmentedMovieContainsMovieFragmentsDidChange = "AVFragmentedMovieContainsMovieFragmentsDidChange";
    public static final String AVFragmentedMovieDurationDidChange = "AVFragmentedMovieDurationDidChange";
    public static final String AVFragmentedMovieTrackSegmentsDidChange = "AVFragmentedMovieTrackSegmentsDidChange";
    public static final String AVFragmentedMovieTrackTimeRangeDidChange = "AVFragmentedMovieTrackTimeRangeDidChange";
    public static final String AVFragmentedMovieTrackTotalSampleDataLengthDidChange = "AVFragmentedMovieTrackTotalSampleDataLengthDidChange";
    public static final String AVFragmentedMovieWasDefragmented = "AVFragmentedMovieWasDefragmented";
    public static final String AVPlayerItemDidPlayToEndTime = "AVPlayerItemDidPlayToEndTime";
    public static final String AVPlayerItemFailedToPlayToEndTime = "AVPlayerItemFailedToPlayToEndTime";
    public static final String AVPlayerItemNewAccessLogEntry = "AVPlayerItemNewAccessLogEntry";
    public static final String AVPlayerItemNewErrorLogEntry = "AVPlayerItemNewErrorLogEntry";
    public static final String AVPlayerItemPlaybackStalled = "AVPlayerItemPlaybackStalled";
    public static final String AVPlayerItemTimeJumped = "AVPlayerItemTimeJumped";
    public static final String AVSampleBufferDisplayLayerFailedToDecode = "AVSampleBufferDisplayLayerFailedToDecode";
    public static final String CWBSSIDDidChange = "CWBSSIDDidChange";
    public static final String CWCountryCodeDidChange = "CWCountryCodeDidChange";
    public static final String CWLinkDidChange = "CWLinkDidChange";
    public static final String CWLinkQualityDidChange = "CWLinkQualityDidChange";
    public static final String CWModeDidChange = "CWModeDidChange";
    public static final String CWPowerDidChange = "CWPowerDidChange";
    public static final String CWSSIDDidChange = "CWSSIDDidChange";
    public static final String CWScanCacheDidUpdate = "CWScanCacheDidUpdate";
    public static final String GCControllerDidConnect = "GCControllerDidConnect";
    public static final String GCControllerDidDisconnect = "GCControllerDidDisconnect";
    public static final String IKFilterBrowserFilterDoubleClick = "IKFilterBrowserFilterDoubleClick";
    public static final String IKFilterBrowserFilterSelected = "IKFilterBrowserFilterSelected";
    public static final String IKFilterBrowserWillPreviewFilter = "IKFilterBrowserWillPreviewFilter";
    public static final String IOBluetoothHostControllerPoweredOff = "IOBluetoothHostControllerPoweredOff";
    public static final String IOBluetoothHostControllerPoweredOn = "IOBluetoothHostControllerPoweredOn";
    public static final String IOBluetoothL2CAPChannelPublished = "IOBluetoothL2CAPChannelPublished";
    public static final String IOBluetoothL2CAPChannelTerminated = "IOBluetoothL2CAPChannelTerminated";
    public static final String MKAnnotationCalloutInfoDidChange = "MKAnnotationCalloutInfoDidChange";
    public static final String NEFilterConfigurationDidChange = "NEFilterConfigurationDidChange";
    public static final String NEVPNConfigurationChange = "NEVPNConfigurationChange";
    public static final String NEVPNStatusDidChange = "NEVPNStatusDidChange";
    public static final String NSAnimationProgressMark = "NSAnimationProgressMark";
    public static final String NSAntialiasThresholdChanged = "NSAntialiasThresholdChanged";
    public static final String NSAppleEventManagerWillProcessFirstEvent = "NSAppleEventManagerWillProcessFirstEvent";
    public static final String NSApplicationDidBecomeActive = "NSApplicationDidBecomeActive";
    public static final String NSApplicationDidChangeOcclusionState = "NSApplicationDidChangeOcclusionState";
    public static final String NSApplicationDidChangeScreenParameters = "NSApplicationDidChangeScreenParameters";
    public static final String NSApplicationDidFinishLaunching = "NSApplicationDidFinishLaunching";
    public static final String NSApplicationDidFinishRestoringWindows = "NSApplicationDidFinishRestoringWindows";
    public static final String NSApplicationDidHide = "NSApplicationDidHide";
    public static final String NSApplicationDidResignActive = "NSApplicationDidResignActive";
    public static final String NSApplicationDidUnhide = "NSApplicationDidUnhide";
    public static final String NSApplicationDidUpdate = "NSApplicationDidUpdate";
    public static final String NSApplicationWillBecomeActive = "NSApplicationWillBecomeActive";
    public static final String NSApplicationWillFinishLaunching = "NSApplicationWillFinishLaunching";
    public static final String NSApplicationWillHide = "NSApplicationWillHide";
    public static final String NSApplicationWillResignActive = "NSApplicationWillResignActive";
    public static final String NSApplicationWillTerminate = "NSApplicationWillTerminate";
    public static final String NSApplicationWillUnhide = "NSApplicationWillUnhide";
    public static final String NSApplicationWillUpdate = "NSApplicationWillUpdate";
    public static final String NSBrowserColumnConfigurationDidChange = "NSBrowserColumnConfigurationDidChange";
    public static final String NSClassDescriptionNeededForClass = "NSClassDescriptionNeededForClass";
    public static final String NSColorListDidChange = "NSColorListDidChange";
    public static final String NSColorPanelColorDidChange = "NSColorPanelColorDidChange";
    public static final String NSComboBoxSelectionDidChange = "NSComboBoxSelectionDidChange";
    public static final String NSComboBoxSelectionIsChanging = "NSComboBoxSelectionIsChanging";
    public static final String NSComboBoxWillDismiss = "NSComboBoxWillDismiss";
    public static final String NSComboBoxWillPopUp = "NSComboBoxWillPopUp";
    public static final String NSContextHelpModeDidActivate = "NSContextHelpModeDidActivate";
    public static final String NSContextHelpModeDidDeactivate = "NSContextHelpModeDidDeactivate";
    public static final String NSControlTextDidBeginEditing = "NSControlTextDidBeginEditing";
    public static final String NSControlTextDidChange = "NSControlTextDidChange";
    public static final String NSControlTextDidEndEditing = "NSControlTextDidEndEditing";
    public static final String NSControlTintDidChange = "NSControlTintDidChange";
    public static final String NSDrawerDidClose = "NSDrawerDidClose";
    public static final String NSDrawerDidOpen = "NSDrawerDidOpen";
    public static final String NSDrawerWillClose = "NSDrawerWillClose";
    public static final String NSDrawerWillOpen = "NSDrawerWillOpen";
    public static final String NSFontCollectionDidChange = "NSFontCollectionDidChange";
    public static final String NSFontSetChanged = "NSFontSetChanged";
    public static final String NSImageRepRegistryDidChange = "NSImageRepRegistryDidChange";
    public static final String NSMenuDidAddItem = "NSMenuDidAddItem";
    public static final String NSMenuDidBeginTracking = "NSMenuDidBeginTracking";
    public static final String NSMenuDidChangeItem = "NSMenuDidChangeItem";
    public static final String NSMenuDidEndTracking = "NSMenuDidEndTracking";
    public static final String NSMenuDidRemoveItem = "NSMenuDidRemoveItem";
    public static final String NSMenuDidSendAction = "NSMenuDidSendAction";
    public static final String NSMenuWillSendAction = "NSMenuWillSendAction";
    public static final String NSOutlineViewColumnDidMove = "NSOutlineViewColumnDidMove";
    public static final String NSOutlineViewColumnDidResize = "NSOutlineViewColumnDidResize";
    public static final String NSOutlineViewItemDidCollapse = "NSOutlineViewItemDidCollapse";
    public static final String NSOutlineViewItemDidExpand = "NSOutlineViewItemDidExpand";
    public static final String NSOutlineViewItemWillCollapse = "NSOutlineViewItemWillCollapse";
    public static final String NSOutlineViewItemWillExpand = "NSOutlineViewItemWillExpand";
    public static final String NSOutlineViewSelectionDidChange = "NSOutlineViewSelectionDidChange";
    public static final String NSOutlineViewSelectionIsChanging = "NSOutlineViewSelectionIsChanging";
    public static final String NSPersistentStoreDidImportUbiquitousContentChanges = "NSPersistentStoreDidImportUbiquitousContentChanges";
    public static final String NSPopUpButtonCellWillPopUp = "NSPopUpButtonCellWillPopUp";
    public static final String NSPopUpButtonWillPopUp = "NSPopUpButtonWillPopUp";
    public static final String NSPopoverDidClose = "NSPopoverDidClose";
    public static final String NSPopoverDidShow = "NSPopoverDidShow";
    public static final String NSPopoverWillClose = "NSPopoverWillClose";
    public static final String NSPopoverWillShow = "NSPopoverWillShow";
    public static final String NSPreferredScrollerStyleDidChange = "NSPreferredScrollerStyleDidChange";
    public static final String NSRuleEditorRowsDidChange = "NSRuleEditorRowsDidChange";
    public static final String NSScreenColorSpaceDidChange = "NSScreenColorSpaceDidChange";
    public static final String NSScrollViewDidEndLiveMagnify = "NSScrollViewDidEndLiveMagnify";
    public static final String NSScrollViewDidEndLiveScroll = "NSScrollViewDidEndLiveScroll";
    public static final String NSScrollViewDidLiveScroll = "NSScrollViewDidLiveScroll";
    public static final String NSScrollViewWillStartLiveMagnify = "NSScrollViewWillStartLiveMagnify";
    public static final String NSScrollViewWillStartLiveScroll = "NSScrollViewWillStartLiveScroll";
    public static final String NSSpellCheckerDidChangeAutomaticCapitalization = "NSSpellCheckerDidChangeAutomaticCapitalization";
    public static final String NSSpellCheckerDidChangeAutomaticDashSubstitution = "NSSpellCheckerDidChangeAutomaticDashSubstitution";
    public static final String NSSpellCheckerDidChangeAutomaticPeriodSubstitution = "NSSpellCheckerDidChangeAutomaticPeriodSubstitution";
    public static final String NSSpellCheckerDidChangeAutomaticQuoteSubstitution = "NSSpellCheckerDidChangeAutomaticQuoteSubstitution";
    public static final String NSSpellCheckerDidChangeAutomaticSpellingCorrection = "NSSpellCheckerDidChangeAutomaticSpellingCorrection";
    public static final String NSSpellCheckerDidChangeAutomaticTextReplacement = "NSSpellCheckerDidChangeAutomaticTextReplacement";
    public static final String NSSplitViewDidResizeSubviews = "NSSplitViewDidResizeSubviews";
    public static final String NSSplitViewWillResizeSubviews = "NSSplitViewWillResizeSubviews";
    public static final String NSSystemColorsDidChange = "NSSystemColorsDidChange";
    public static final String NSTableViewColumnDidMove = "NSTableViewColumnDidMove";
    public static final String NSTableViewColumnDidResize = "NSTableViewColumnDidResize";
    public static final String NSTableViewSelectionDidChange = "NSTableViewSelectionDidChange";
    public static final String NSTableViewSelectionIsChanging = "NSTableViewSelectionIsChanging";
    public static final String NSTextAlternativesSelectedAlternativeString = "NSTextAlternativesSelectedAlternativeString";
    public static final String NSTextDidBeginEditing = "NSTextDidBeginEditing";
    public static final String NSTextDidChange = "NSTextDidChange";
    public static final String NSTextDidEndEditing = "NSTextDidEndEditing";
    public static final String NSTextInputContextKeyboardSelectionDidChange = "NSTextInputContextKeyboardSelectionDidChange";
    public static final String NSTextStorageDidProcessEditing = "NSTextStorageDidProcessEditing";
    public static final String NSTextStorageWillProcessEditing = "NSTextStorageWillProcessEditing";
    public static final String NSTextViewDidChangeSelection = "NSTextViewDidChangeSelection";
    public static final String NSTextViewDidChangeTypingAttributes = "NSTextViewDidChangeTypingAttributes";
    public static final String NSTextViewWillChangeNotifyingTextView = "NSTextViewWillChangeNotifyingTextView";
    public static final String NSToolbarDidRemoveItem = "NSToolbarDidRemoveItem";
    public static final String NSToolbarWillAddItem = "NSToolbarWillAddItem";
    public static final String NSViewBoundsDidChange = "NSViewBoundsDidChange";
    public static final String NSViewDidUpdateTrackingAreas = "NSViewDidUpdateTrackingAreas";
    public static final String NSViewFocusDidChange = "NSViewFocusDidChange";
    public static final String NSViewFrameDidChange = "NSViewFrameDidChange";
    public static final String NSViewGlobalFrameDidChange = "NSViewGlobalFrameDidChange";
    public static final String NSWindowDidBecomeKey = "NSWindowDidBecomeKey";
    public static final String NSWindowDidBecomeMain = "NSWindowDidBecomeMain";
    public static final String NSWindowDidChangeBackingProperties = "NSWindowDidChangeBackingProperties";
    public static final String NSWindowDidChangeOcclusionState = "NSWindowDidChangeOcclusionState";
    public static final String NSWindowDidChangeScreen = "NSWindowDidChangeScreen";
    public static final String NSWindowDidChangeScreenProfile = "NSWindowDidChangeScreenProfile";
    public static final String NSWindowDidDeminiaturize = "NSWindowDidDeminiaturize";
    public static final String NSWindowDidEndLiveResize = "NSWindowDidEndLiveResize";
    public static final String NSWindowDidEndSheet = "NSWindowDidEndSheet";
    public static final String NSWindowDidEnterFullScreen = "NSWindowDidEnterFullScreen";
    public static final String NSWindowDidEnterVersionBrowser = "NSWindowDidEnterVersionBrowser";
    public static final String NSWindowDidExitFullScreen = "NSWindowDidExitFullScreen";
    public static final String NSWindowDidExitVersionBrowser = "NSWindowDidExitVersionBrowser";
    public static final String NSWindowDidExpose = "NSWindowDidExpose";
    public static final String NSWindowDidMiniaturize = "NSWindowDidMiniaturize";
    public static final String NSWindowDidMove = "NSWindowDidMove";
    public static final String NSWindowDidResignKey = "NSWindowDidResignKey";
    public static final String NSWindowDidResignMain = "NSWindowDidResignMain";
    public static final String NSWindowDidResize = "NSWindowDidResize";
    public static final String NSWindowDidUpdate = "NSWindowDidUpdate";
    public static final String NSWindowWillBeginSheet = "NSWindowWillBeginSheet";
    public static final String NSWindowWillClose = "NSWindowWillClose";
    public static final String NSWindowWillEnterFullScreen = "NSWindowWillEnterFullScreen";
    public static final String NSWindowWillEnterVersionBrowser = "NSWindowWillEnterVersionBrowser";
    public static final String NSWindowWillExitFullScreen = "NSWindowWillExitFullScreen";
    public static final String NSWindowWillExitVersionBrowser = "NSWindowWillExitVersionBrowser";
    public static final String NSWindowWillMiniaturize = "NSWindowWillMiniaturize";
    public static final String NSWindowWillMove = "NSWindowWillMove";
    public static final String NSWindowWillStartLiveResize = "NSWindowWillStartLiveResize";
    public static final String NSWorkspaceAccessibilityDisplayOptionsDidChange = "NSWorkspaceAccessibilityDisplayOptionsDidChange";
    public static final String NSWorkspaceActiveSpaceDidChange = "NSWorkspaceActiveSpaceDidChange";
    public static final String NSWorkspaceDidActivateApplication = "NSWorkspaceDidActivateApplication";
    public static final String NSWorkspaceDidChangeFileLabels = "NSWorkspaceDidChangeFileLabels";
    public static final String NSWorkspaceDidDeactivateApplication = "NSWorkspaceDidDeactivateApplication";
    public static final String NSWorkspaceDidHideApplication = "NSWorkspaceDidHideApplication";
    public static final String NSWorkspaceDidLaunchApplication = "NSWorkspaceDidLaunchApplication";
    public static final String NSWorkspaceDidMount = "NSWorkspaceDidMount";
    public static final String NSWorkspaceDidPerformFileOperation = "NSWorkspaceDidPerformFileOperation";
    public static final String NSWorkspaceDidRenameVolume = "NSWorkspaceDidRenameVolume";
    public static final String NSWorkspaceDidTerminateApplication = "NSWorkspaceDidTerminateApplication";
    public static final String NSWorkspaceDidUnhideApplication = "NSWorkspaceDidUnhideApplication";
    public static final String NSWorkspaceDidUnmount = "NSWorkspaceDidUnmount";
    public static final String NSWorkspaceDidWake = "NSWorkspaceDidWake";
    public static final String NSWorkspaceScreensDidSleep = "NSWorkspaceScreensDidSleep";
    public static final String NSWorkspaceScreensDidWake = "NSWorkspaceScreensDidWake";
    public static final String NSWorkspaceSessionDidBecomeActive = "NSWorkspaceSessionDidBecomeActive";
    public static final String NSWorkspaceSessionDidResignActive = "NSWorkspaceSessionDidResignActive";
    public static final String NSWorkspaceWillLaunchApplication = "NSWorkspaceWillLaunchApplication";
    public static final String NSWorkspaceWillPowerOff = "NSWorkspaceWillPowerOff";
    public static final String NSWorkspaceWillSleep = "NSWorkspaceWillSleep";
    public static final String NSWorkspaceWillUnmount = "NSWorkspaceWillUnmount";
    public static final String PDFDocumentDidBeginFind = "PDFDocumentDidBeginFind";
    public static final String PDFDocumentDidBeginPageFind = "PDFDocumentDidBeginPageFind";
    public static final String PDFDocumentDidBeginPageWrite = "PDFDocumentDidBeginPageWrite";
    public static final String PDFDocumentDidBeginWrite = "PDFDocumentDidBeginWrite";
    public static final String PDFDocumentDidEndFind = "PDFDocumentDidEndFind";
    public static final String PDFDocumentDidEndPageFind = "PDFDocumentDidEndPageFind";
    public static final String PDFDocumentDidEndPageWrite = "PDFDocumentDidEndPageWrite";
    public static final String PDFDocumentDidEndWrite = "PDFDocumentDidEndWrite";
    public static final String PDFDocumentDidFindMatch = "PDFDocumentDidFindMatch";
    public static final String PDFDocumentDidUnlock = "PDFDocumentDidUnlock";
    public static final String PDFThumbnailViewDocumentEdited = "PDFThumbnailViewDocumentEdited";
    public static final String PDFViewAnnotationHit = "PDFViewAnnotationHit";
    public static final String PDFViewAnnotationWillHit = "PDFViewAnnotationWillHit";
    public static final String PDFViewChangedHistory = "PDFViewChangedHistory";
    public static final String PDFViewCopyPermission = "PDFViewCopyPermission";
    public static final String PDFViewDisplayBoxChanged = "PDFViewDisplayBoxChanged";
    public static final String PDFViewDisplayModeChanged = "PDFViewDisplayModeChanged";
    public static final String PDFViewDocumentChanged = "PDFViewDocumentChanged";
    public static final String PDFViewPageChanged = "PDFViewPageChanged";
    public static final String PDFViewPrintPermission = "PDFViewPrintPermission";
    public static final String PDFViewScaleChanged = "PDFViewScaleChanged";
    public static final String PDFViewSelectionChanged = "PDFViewSelectionChanged";
    public static final String PDFViewVisiblePagesChanged = "PDFViewVisiblePagesChanged";
    public static final String QCCompositionPickerPanelDidSelectComposition = "QCCompositionPickerPanelDidSelectComposition";
    public static final String QCCompositionPickerViewDidSelectComposition = "QCCompositionPickerViewDidSelectComposition";
    public static final String QCCompositionRepositoryDidUpdate = "QCCompositionRepositoryDidUpdate";
    public static final String QCViewDidStartRendering = "QCViewDidStartRendering";
    public static final String QCViewDidStopRendering = "QCViewDidStopRendering";
    public static final String WebHistoryAllItemsRemoved = "WebHistoryAllItemsRemoved";
    public static final String WebHistoryItemChanged = "WebHistoryItemChanged";
    public static final String WebHistoryItemsAdded = "WebHistoryItemsAdded";
    public static final String WebHistoryItemsRemoved = "WebHistoryItemsRemoved";
    public static final String WebHistoryLoaded = "WebHistoryLoaded";
    public static final String WebHistorySaved = "WebHistorySaved";
    public static final String WebPreferencesChanged = "WebPreferencesChanged";
    public static final String WebViewDidBeginEditing = "WebViewDidBeginEditing";
    public static final String WebViewDidChange = "WebViewDidChange";
    public static final String WebViewDidChangeSelection = "WebViewDidChangeSelection";
    public static final String WebViewDidChangeTypingStyle = "WebViewDidChangeTypingStyle";
    public static final String WebViewDidEndEditing = "WebViewDidEndEditing";
    public static final String WebViewProgressEstimateChanged = "WebViewProgressEstimateChanged";
    public static final String WebViewProgressFinished = "WebViewProgressFinished";
    public static final String WebViewProgressStarted = "WebViewProgressStarted";
    public static final String abDatabaseChanged = "abDatabaseChanged";
    public static final String abDatabaseChangedExternally = "abDatabaseChangedExternally";
    public static final String quartzFilterManagerDidAddFilter = "quartzFilterManagerDidAddFilter";
    public static final String quartzFilterManagerDidModifyFilter = "quartzFilterManagerDidModifyFilter";
    public static final String quartzFilterManagerDidRemoveFilter = "quartzFilterManagerDidRemoveFilter";
    public static final String quartzFilterManagerDidSelectFilter = "quartzFilterManagerDidSelectFilter";
    public static final String EAAccessoryDidConnect = "EAAccessoryDidConnect";
    public static final String EAAccessoryDidDisconnect = "EAAccessoryDidDisconnect";
    public static final String MPMovieDurationAvailable = "MPMovieDurationAvailable";
    public static final String MPMovieMediaTypesAvailable = "MPMovieMediaTypesAvailable";
    public static final String MPMovieNaturalSizeAvailable = "MPMovieNaturalSizeAvailable";
    public static final String MPMoviePlayerDidEnterFullscreen = "MPMoviePlayerDidEnterFullscreen";
    public static final String MPMoviePlayerDidExitFullscreen = "MPMoviePlayerDidExitFullscreen";
    public static final String MPMoviePlayerIsAirPlayVideoActiveDidChange = "MPMoviePlayerIsAirPlayVideoActiveDidChange";
    public static final String MPMoviePlayerLoadStateDidChange = "MPMoviePlayerLoadStateDidChange";
    public static final String MPMoviePlayerNowPlayingMovieDidChange = "MPMoviePlayerNowPlayingMovieDidChange";
    public static final String MPMoviePlayerPlaybackDidFinish = "MPMoviePlayerPlaybackDidFinish";
    public static final String MPMoviePlayerPlaybackStateDidChange = "MPMoviePlayerPlaybackStateDidChange";
    public static final String MPMoviePlayerReadyForDisplayDidChange = "MPMoviePlayerReadyForDisplayDidChange";
    public static final String MPMoviePlayerScalingModeDidChange = "MPMoviePlayerScalingModeDidChange";
    public static final String MPMoviePlayerThumbnailImageRequestDidFinish = "MPMoviePlayerThumbnailImageRequestDidFinish";
    public static final String MPMoviePlayerTimedMetadataUpdated = "MPMoviePlayerTimedMetadataUpdated";
    public static final String MPMoviePlayerWillEnterFullscreen = "MPMoviePlayerWillEnterFullscreen";
    public static final String MPMoviePlayerWillExitFullscreen = "MPMoviePlayerWillExitFullscreen";
    public static final String MPMovieSourceTypeAvailable = "MPMovieSourceTypeAvailable";
    public static final String SKCloudServiceCapabilitiesDidChange = "SKCloudServiceCapabilitiesDidChange";
    public static final String SKStorefrontIdentifierDidChange = "SKStorefrontIdentifierDidChange";
    public static final String TVTopShelfItemsDidChange = "TVTopShelfItemsDidChange";
    public static final String UIAccessibilityAssistiveTouchStatusDidChange = "UIAccessibilityAssistiveTouchStatusDidChange";
    public static final String UIAccessibilityBoldTextStatusDidChange = "UIAccessibilityBoldTextStatusDidChange";
    public static final String UIAccessibilityClosedCaptioningStatusDidChange = "UIAccessibilityClosedCaptioningStatusDidChange";
    public static final String UIAccessibilityDarkerSystemColorsStatusDidChange = "UIAccessibilityDarkerSystemColorsStatusDidChange";
    public static final String UIAccessibilityGrayscaleStatusDidChange = "UIAccessibilityGrayscaleStatusDidChange";
    public static final String UIAccessibilityGuidedAccessStatusDidChange = "UIAccessibilityGuidedAccessStatusDidChange";
    public static final String UIAccessibilityHearingDevicePairedEarDidChange = "UIAccessibilityHearingDevicePairedEarDidChange";
    public static final String UIAccessibilityInvertColorsStatusDidChange = "UIAccessibilityInvertColorsStatusDidChange";
    public static final String UIAccessibilityMonoAudioStatusDidChange = "UIAccessibilityMonoAudioStatusDidChange";
    public static final String UIAccessibilityReduceMotionStatusDidChange = "UIAccessibilityReduceMotionStatusDidChange";
    public static final String UIAccessibilityReduceTransparencyStatusDidChange = "UIAccessibilityReduceTransparencyStatusDidChange";
    public static final String UIAccessibilityShakeToUndoDidChange = "UIAccessibilityShakeToUndoDidChange";
    public static final String UIAccessibilitySpeakScreenStatusDidChange = "UIAccessibilitySpeakScreenStatusDidChange";
    public static final String UIAccessibilitySpeakSelectionStatusDidChange = "UIAccessibilitySpeakSelectionStatusDidChange";
    public static final String UIAccessibilitySwitchControlStatusDidChange = "UIAccessibilitySwitchControlStatusDidChange";
    public static final String UIApplicationDidBecomeActive = "UIApplicationDidBecomeActive";
    public static final String UIApplicationDidEnterBackground = "UIApplicationDidEnterBackground";
    public static final String UIApplicationDidFinishLaunching = "UIApplicationDidFinishLaunching";
    public static final String UIApplicationDidReceiveMemoryWarning = "UIApplicationDidReceiveMemoryWarning";
    public static final String UIApplicationSignificantTimeChange = "UIApplicationSignificantTimeChange";
    public static final String UIApplicationUserDidTakeScreenshot = "UIApplicationUserDidTakeScreenshot";
    public static final String UIApplicationWillEnterForeground = "UIApplicationWillEnterForeground";
    public static final String UIApplicationWillResignActive = "UIApplicationWillResignActive";
    public static final String UIApplicationWillTerminate = "UIApplicationWillTerminate";
    public static final String UIContentSizeCategoryDidChange = "UIContentSizeCategoryDidChange";
    public static final String UIDeviceProximityStateDidChange = "UIDeviceProximityStateDidChange";
    public static final String UIScreenBrightnessDidChange = "UIScreenBrightnessDidChange";
    public static final String UIScreenDidConnect = "UIScreenDidConnect";
    public static final String UIScreenDidDisconnect = "UIScreenDidDisconnect";
    public static final String UIScreenModeDidChange = "UIScreenModeDidChange";
    public static final String UITableViewSelectionDidChange = "UITableViewSelectionDidChange";
    public static final String UITextFieldTextDidBeginEditing = "UITextFieldTextDidBeginEditing";
    public static final String UITextFieldTextDidChange = "UITextFieldTextDidChange";
    public static final String UITextFieldTextDidEndEditing = "UITextFieldTextDidEndEditing";
    public static final String UITextInputCurrentInputModeDidChange = "UITextInputCurrentInputModeDidChange";
    public static final String UITextViewTextDidBeginEditing = "UITextViewTextDidBeginEditing";
    public static final String UITextViewTextDidChange = "UITextViewTextDidChange";
    public static final String UITextViewTextDidEndEditing = "UITextViewTextDidEndEditing";
    public static final String UIViewControllerShowDetailTargetDidChange = "UIViewControllerShowDetailTargetDidChange";
    public static final String UIWindowDidBecomeHidden = "UIWindowDidBecomeHidden";
    public static final String UIWindowDidBecomeKey = "UIWindowDidBecomeKey";
    public static final String UIWindowDidBecomeVisible = "UIWindowDidBecomeVisible";
    public static final String UIWindowDidResignKey = "UIWindowDidResignKey";
    public static final String ALAssetsLibraryChanged = "ALAssetsLibraryChanged";
    public static final String AVCaptureDeviceSubjectAreaDidChange = "AVCaptureDeviceSubjectAreaDidChange";
    public static final String AVCaptureSessionInterruptionEnded = "AVCaptureSessionInterruptionEnded";
    public static final String AVCaptureSessionWasInterrupted = "AVCaptureSessionWasInterrupted";
    public static final String CTRadioAccessTechnologyDidChange = "CTRadioAccessTechnologyDidChange";
    public static final String MFMessageComposeViewControllerTextMessageAvailabilityDidChange = "MFMessageComposeViewControllerTextMessageAvailabilityDidChange";
    public static final String MPMediaLibraryDidChange = "MPMediaLibraryDidChange";
    public static final String MPMediaPlaybackIsPreparedToPlayDidChange = "MPMediaPlaybackIsPreparedToPlayDidChange";
    public static final String MPMusicPlayerControllerNowPlayingItemDidChange = "MPMusicPlayerControllerNowPlayingItemDidChange";
    public static final String MPMusicPlayerControllerPlaybackStateDidChange = "MPMusicPlayerControllerPlaybackStateDidChange";
    public static final String MPMusicPlayerControllerVolumeDidChange = "MPMusicPlayerControllerVolumeDidChange";
    public static final String MPVolumeViewWirelessRouteActiveDidChange = "MPVolumeViewWirelessRouteActiveDidChange";
    public static final String MPVolumeViewWirelessRoutesAvailableDidChange = "MPVolumeViewWirelessRoutesAvailableDidChange";
    public static final String NKIssueDownloadCompleted = "NKIssueDownloadCompleted";
    public static final String UIApplicationBackgroundRefreshStatusDidChange = "UIApplicationBackgroundRefreshStatusDidChange";
    public static final String UIApplicationDidChangeStatusBarFrame = "UIApplicationDidChangeStatusBarFrame";
    public static final String UIApplicationDidChangeStatusBarOrientation = "UIApplicationDidChangeStatusBarOrientation";
    public static final String UIApplicationWillChangeStatusBarFrame = "UIApplicationWillChangeStatusBarFrame";
    public static final String UIApplicationWillChangeStatusBarOrientation = "UIApplicationWillChangeStatusBarOrientation";
    public static final String UIDeviceBatteryLevelDidChange = "UIDeviceBatteryLevelDidChange";
    public static final String UIDeviceBatteryStateDidChange = "UIDeviceBatteryStateDidChange";
    public static final String UIDeviceOrientationDidChange = "UIDeviceOrientationDidChange";
    public static final String UIDocumentStateChanged = "UIDocumentStateChanged";
    public static final String UIKeyboardDidChangeFrame = "UIKeyboardDidChangeFrame";
    public static final String UIKeyboardDidHide = "UIKeyboardDidHide";
    public static final String UIKeyboardDidShow = "UIKeyboardDidShow";
    public static final String UIKeyboardWillChangeFrame = "UIKeyboardWillChangeFrame";
    public static final String UIKeyboardWillHide = "UIKeyboardWillHide";
    public static final String UIKeyboardWillShow = "UIKeyboardWillShow";
    public static final String UIMenuControllerDidHideMenu = "UIMenuControllerDidHideMenu";
    public static final String UIMenuControllerDidShowMenu = "UIMenuControllerDidShowMenu";
    public static final String UIMenuControllerMenuFrameDidChange = "UIMenuControllerMenuFrameDidChange";
    public static final String UIMenuControllerWillHideMenu = "UIMenuControllerWillHideMenu";
    public static final String UIMenuControllerWillShowMenu = "UIMenuControllerWillShowMenu";
    public static final String UIPasteboardChanged = "UIPasteboardChanged";
    public static final String UIPasteboardRemoved = "UIPasteboardRemoved";
    public static final String UIApplicationProtectedDataDidBecomeAvailable = "UIApplicationProtectedDataDidBecomeAvailable";
    public static final String UIApplicationProtectedDataWillBecomeUnavailable = "UIApplicationProtectedDataWillBecomeUnavailable";
    public static final String NSSpellCheckerDidChangeAutomaticTextCompletion = "NSSpellCheckerDidChangeAutomaticTextCompletion";

    private NSNotificationName() {
    }

}
