# [Vue White Dashboard](https://demos.creative-tim.com/vue-white-dashboard) [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social&logo=twitter)](https://twitter.com/share?url=https%3A%2F%2Fdemos.creative-tim.com%2Fvue-white-dashboard&text=Vue%20White%20Dashboard%20by%20Creative%20Tim&via=CreativeTim&hashtags=vuejs%20%23white%20%23dashboard)

![version](https://img.shields.io/badge/version-1.1.0-blue.svg) ![license](https://img.shields.io/badge/license-MIT-blue.svg) [![GitHub issues open](https://img.shields.io/github/issues/creativetimofficial/white-dashboard/issues.svg?maxAge=2592000)](https://github.com/creativetimofficial/vue-white-dashboard/issues/issues?q=is%3Aopen+is%3Aissue) [![GitHub issues closed](https://img.shields.io/github/issues-closed-raw/creativetimofficial/vue-white-dashboard/issues.svg?maxAge=2592000)](https://github.com/creativetimofficial/vue-white-dashboard/issues/issues?q=is%3Aissue+is%3Aclosed) [![Join the chat at https://gitter.im/NIT-dgp/General](https://badges.gitter.im/NIT-dgp/General.svg)](https://gitter.im/creative-tim-general/Lobby) [![Chat](https://img.shields.io/badge/chat-on%20discord-7289da.svg)](https://discord.gg/E4aHAQy)

![Product Gif](https://github.com/creativetimofficial/vue-white-dashboard/blob/live-demo/src/assets/demo/product-gif.gif?raw=true)

**Vue White Dashboard** is a beautiful Bootstrap 4 Admin Dashboard with a huge number of components built to fit together and look amazing. If you are looking for a tool to manage and visualize data about your business, this dashboard is the thing for you. It combines colors that are easy on the eye, spacious cards, beautiful typography, and graphics.

**Vue White Dashboard** comes packed with all plugins that you might need inside a project and documentation on how to get started. It is light and easy to use, and also very powerful.

Vue White Dashboard features over 16 individual components, giving you the freedom of choosing and combining. This means that there are thousands of possible combinations. All components can take variations in color, that you can easily modify using SASS files. You will save a lot of time going from prototyping to full-functional code because all elements are implemented.
We thought about everything, so this dashboard comes with 2 versions, Dark Mode and Light Mode.

We are very excited to share this dashboard with you and we look forward to hearing your feedback!

## Table of Contents

- [Versions](#versions)
- [Demo](#demo)
- [Quick Start](#quick-start)
- [Deploy](#deploy)
- [Documentation](#documentation)
- [File Structure](#file-structure)
- [Browser Support](#browser-support)
- [Resources](#resources)
- [Reporting Issues](#reporting-issues)
- [Licensing](#licensing)
- [Useful Links](#useful-links)

## Versions

[<img src="https://github.com/creativetimofficial/public-assets/blob/master/logos/vue-logo.jpg?raw=true" width="60" height="60" />](https://www.creative-tim.com/product/vue-white-dashboard)
[<img src="https://github.com/creativetimofficial/public-assets/blob/master/logos/laravel_logo.png?raw=true" width="60" height="60" />](https://www.creative-tim.com/product/white-dashboard-laravel)

| Vue                                                                                                                                                                                                        | Laravel                                                                                                                                                                                                                   |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Vue White Dashboard ](https://github.com/creativetimofficial/public-assets/blob/master/vue-white-dashboard/vue-white-dashboard.jpg?raw=true)](https://www.creative-tim.com/product/vue-white-dashboard) | [![White Dashboard Laravel](https://github.com/creativetimofficial/public-assets/blob/master/white-dashboard-laravel/white-dashboard-laravel.jpg?raw=true)](https://www.creative-tim.com/product/white-dashboard-laravel) |

## Demo

- [Start page](https://demos.creative-tim.com/vue-white-dashboard)
- [User profile page](https://demos.creative-tim.com/vue-white-dashboard/#/user)
- [Tables page ](https://demos.creative-tim.com/vue-white-dashboard/#/table)
- [Maps Page](https://demos.creative-tim.com/vue-white-dashboard/#/maps)
- [Notifications page](https://demos.creative-tim.com//vue-white-dashboard/#/notifications)

| Start page                                                                                                                                                                        | User profile page                                                                                                                                                                                 | Tables page                                                                                                                                                                                  |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Start page](https://github.com/creativetimofficial/public-assets/blob/master/vue-white-dashboard/start-page.png?raw=true)](https://demos.creative-tim.com/vue-white-dashboard) | [![User profile page](https://github.com/creativetimofficial/public-assets/blob/master/vue-white-dashboard/profile-page.png?raw=true)](https://demos.creative-tim.com/vue-white-dashboard/#/user) | [![Tables pages](https://github.com/creativetimofficial/public-assets/blob/master/vue-white-dashboard/tables-page.png?raw=true)](https://demos.creative-tim.com/vue-white-dashboard/#/table) |

| Maps page                                                                                                                                                                              | Notifications page                                                                                                                                                                                                | RTL page                                                                                                                                                                                                 |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Maps page](https://github.com/creativetimofficial/public-assets/blob/master/vue-white-dashboard/maps-page.png?raw=true)](https://demos.creative-tim.com/vue-white-dashboard/#/maps) | [![Notifications page](https://github.com/creativetimofficial/public-assets/blob/master/vue-white-dashboard/notifications-page.png?raw=true)](https://demos.creative-tim.com/vue-white-dashboard/#/notifications) | [![RTL page](https://github.com/creativetimofficial/public-assets/blob/master/vue-white-dashboard/rtl-page.png?raw=true)](https://demos.creative-tim.com/vue-white-dashboard/#/dashboard?enableRTL=true) |

## Quick start

- Clone the repo: `git clone https://github.com/creativetimofficial/vue-white-dashboard.git`.
- [Download from Github](https://github.com/creativetimofficial/vue-white-dashboard/archive/master.zip).
- [Download from Creative Tim](https://www.creative-tim.com/product/vue-white-dashboard).

## Deploy

:rocket: You can deploy your own version of the template to Genezio with one click:

[![Deploy to Genezio](https://raw.githubusercontent.com/Genez-io/graphics/main/svg/deploy-button.svg)](https://app.genez.io/start/deploy?repository=https://github.com/creativetimofficial/vue-white-dashboard&utm_source=github&utm_medium=referral&utm_campaign=github-creativetim&utm_term=deploy-project&utm_content=button-head)

## Documentation

The documentation for the Vue White Dashboard is hosted at our [website](https://demos.creative-tim.com/vue-white-dashboard/documentation).

## File Structure

Within the download you'll find the following directories and files:

```
|-- Vue White Dashboard
    ├── CHANGELOG.md
    ├── README.md
    ├── babel.config.js
    ├── package.json
    ├── postcss.config.js
    ├── public
    └── src
    ├── App.vue
    ├── RTLPlugin.js
    ├── assets
    │   ├── css
    │   ├── demo
    │   ├── fonts
    │   ├── img
    │   └── scss
    │       ├── white-dashboard
    │       │   ├── bootstrap
    │       │   ├── custom
    │       │   └── plugins
    │       └── white-dashboard.scss
    ├── components
    │   ├── BaseAlert.vue
    │   ├── BaseButton.vue
    │   ├── BaseCheckbox.vue
    │   ├── BaseNav.vue
    │   ├── BaseRadio.vue
    │   ├── BaseTable.vue
    │   ├── Cards
    │   ├── Charts
    │   ├── CloseButton.vue
    │   ├── Dropdown.vue
    │   ├── HelloWorld.vue
    │   ├── Inputs
    │   ├── Modal.vue
    │   ├── NavbarToggleButton.vue
    │   ├── NotificationPlugin
    │   ├── SidebarPlugin
    │   └── index.js
    ├── config.js
    ├── globalComponents.js
    ├── globalDirectives.js
    ├── i18n.js
    ├── locales
    ├── main.js
    ├── pages
    │   ├── Dashboard
    │   ├── Dashboard.vue
    │   ├── Icons.vue
    │   ├── Layout
    │   ├── Maps.vue
    │   ├── Notifications
    │   ├── Notifications.vue
    │   ├── Profile
    │   ├── TableList.vue
    │   ├── Typography.vue
    │   ├── UpgradeToPRO.vue
    │   └── UserProfile.vue
    └── router.js

```## Browser Support

At present, we officially aim to support the last two versions of the following browsers:

<img src="https://github.com/creativetimofficial/public-assets/blob/master/logos/chrome-logo.png?raw=true" width="64" height="64"> <img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/firefox-logo.png" width="64" height="64"> <img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/edge-logo.png" width="64" height="64"> <img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/safari-logo.png" width="64" height="64"> <img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/opera-logo.png" width="64" height="64">

## Resources

- Demo: <https://demos.creative-tim.com/vue-white-dashboard/#/dashboard>
- Download Page: <https://www.creative-tim.com/product/vue-white-dashboard>
- Documentation: <https://demos.creative-tim.com/vue-white-dashboard/documentation>
- License Agreement: <https://www.creative-tim.com/license>
- Support: <https://www.creative-tim.com/contact-us>
- Issues: [Github Issues Page](https://github.com/creativetimofficial/vue-white-dashboard/issues)

## Reporting Issues

We use GitHub Issues as the official bug tracker for the Vue White Dashboard. Here are some advices for our users that want to report an issue:

1. Make sure that you are using the latest version of the Vue White Dashboard. Check the CHANGELOG from your dashboard on our [website](https://www.creative-tim.com/).
2. Providing us reproducible steps for the issue will shorten the time it takes for it to be fixed.
3. Some issues may be browser specific, so specifying in what browser you encountered the issue might help.

## Licensing

- Copyright 2023 Creative Tim (https://www.creative-tim.com/)

- Licensed under MIT (https://github.com/creativetimofficial/vue-white-dashboard/issues/blob/master/LICENSE.md)

## Useful Links

- [Tutorials](https://www.youtube.com/channel/UCVyTG4sCw-rOvB9oHkzZD1w)
- [Affiliate Program](https://www.creative-tim.com/affiliates/new?ref=mk-github-readme) (earn money)
- [Blog Creative Tim](http://blog.creative-tim.com/)
- [Free Products](https://www.creative-tim.com/bootstrap-themes/free?ref=mk-github-readme) from Creative Tim
- [Premium Products](https://www.creative-tim.com/bootstrap-themes/premium?ref=mk-github-readme) from Creative Tim
- [React Products](https://www.creative-tim.com/bootstrap-themes/react-themes?ref=mk-github-readme) from Creative Tim
- [Angular Products](https://www.creative-tim.com/bootstrap-themes/angular-themes?ref=mk-github-readme) from Creative Tim
- [VueJS Products](https://www.creative-tim.com/bootstrap-themes/vuejs-themes?ref=mk-github-readme) from Creative Tim
- [More products](https://www.creative-tim.com/bootstrap-themes?ref=mk-github-readme) from Creative Tim
- Check our Bundles [here](https://www.creative-tim.com/bundles?ref=mk-github-readme)

### Social Media

Twitter: <https://twitter.com/CreativeTim>

Facebook: <https://www.facebook.com/CreativeTim>

Dribbble: <https://dribbble.com/creativetim>

Instagram: <https://www.instagram.com/CreativeTimOfficial>
