# [Material Dashboard React](https://demos.creative-tim.com/nextjs-material-dashboard/dashboard) [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social&logo=twitter)](https://twitter.com/intent/tweet?url=https%3A%2F%2Fcreativetimofficial.github.io%2Fnextjs-material-dashboard&text=NextJS%20Material%20Dashboard%20-%20Free%20NextJS%20Admin%20Template&original_referer=https%3A%2F%2Fdemos.creative-tim.com%2Fnextjs-material-dashboard%2F%3F_ga%3D2.10428917.198078103.1532329372-1803433978.1528781151&via=creativetim&hashtags=react%2Cmaterial-ui)

![version](https://img.shields.io/badge/version-1.1.0-blue.svg) ![license](https://img.shields.io/badge/license-MIT-blue.svg) [![GitHub issues open](https://img.shields.io/github/issues/creativetimofficial/nextjs-material-dashboard.svg?maxAge=2592000)]() [![GitHub issues closed](https://img.shields.io/github/issues-closed-raw/creativetimofficial/nextjs-material-dashboard.svg?maxAge=2592000)]() [![Join the chat at https://gitter.im/NIT-dgp/General](https://badges.gitter.im/NIT-dgp/General.svg)](https://gitter.im/creative-tim/material-dashboard?utm_source=share-link&utm_medium=link&utm_campaign=share-link) [![Chat](https://img.shields.io/badge/chat-on%20discord-7289da.svg)](https://discord.gg/E4aHAQy)

![Product Image](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/nextjs-material-dashboard/opt_md_nextjs_thumbnail.jpg)

NextJS Material Dashboard is a free Material-UI, NextJS and React Admin with a fresh, new design inspired by Google's Material Design. We are very excited to introduce our take on the material concepts through an easy to use and beautiful set of components. NextJS Material Dashboard was built over the popular Material-UI, NextJS and React frameworks.

NextJS Material Dashboard makes use of light, surface and movement. The general layout resembles sheets of paper following multiple different layers, so that the depth and order is obvious. The navigation stays mainly on the left sidebar and the content is on the right inside the main panel.

NextJS Material Dashboard comes with 5 color filter choices for both the sidebar and the card headers (blue, green, orange, red and purple) and an option to have a background image on the sidebar.

NextJS Material Dashboard was created using [NextJS](https://nextjs.org/?ref=creativetim) and it uses a framework built by our friend [Olivier - Material-UI](https://github.com/mui-org/material-ui?ref=creativetim), who did an amazing job creating the backbone for the material effects, animations, ripples and transitions. Big thanks to his team for the effort and forward thinking they put into it.

We are very excited to share this dashboard with you and we look forward to hearing your feedback!

It is open source, and it's Github Repo can be found [here](https://github.com/creativetimofficial/nextjs-material-dashboard).

Special thanks go to:

- [Nepcha Analytics](https://nepcha.com?ref=readme) for the analytics tool. Nepcha is already integrated with Next.js Material Dashboard. You can use it to gain insights into your sources of traffic.

## Table of Contents

- [Versions](#versions)
- [Demo](#demo)
- [Quick Start](#quick-start)
- [Documentation](#documentation)
- [File Structure](#file-structure)
- [Browser Support](#browser-support)
- [Resources](#resources)
- [Kit Versions](#kit-versions)
- [Pro Versions](#pro-versions)
- [Pro Kit Versions](#pro-kit-versions)
- [Reporting Issues](#reporting-issues)
- [Technical Support or Questions](#technical-support-or-questions)
- [Licensing](#licensing)
- [Useful Links](#useful-links)

## Versions

[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/nextjs.jpg" width="60" height="60" />](https://www.creative-tim.com/product/nextjs-material-dashboard)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/nodejs-logo.jpg" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard-react-nodejs)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/laravel_logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard-laravel)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/bootstrap-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/react-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard-react)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/vue-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/vue-material-dashboard)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/angular-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard-angular2)

| NextJS                                                                                                                                                                                                                             | NodeJS                                                                                                                                                                                                                                                  | Laravel                                                                                                                                                                                                                                 | Vue & Laravel                                                                                                                                                                                                                                        | Vuetify                                                                                                                                                                                                                                 |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![ NextJS Material Dashboard ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/nextjs-material-dashboard/opt_md_nextjs_thumbnail.jpg)](https://www.creative-tim.com/product/nextjs-material-dashboard) | [![Material Dashboard React NodeJS ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-react-nodejs/opt_md_react_node_thumbnail.jpg)](https://www.creative-tim.com/product/material-dashboard-react-nodejs) | [![Material Dashboard Laravel ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-laravel/material-dashboard-laravel.jpg)](https://www.creative-tim.com/product/material-dashboard-laravel) | [![Vue Material Dashboard Laravel ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/vue-material-dashboard-laravel/opt_md_vuelaravel_thumbnail.jpg)](https://www.creative-tim.com/product/vue-material-dashboard-laravel) | [![Vuetify Material Dashboard ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-vuetify/material-dashboard-vuetify.jpg)](https://www.creative-tim.com/product/vuetify-material-dashboard) |

| HTML Dark                                                                                                                                                                                                                          | HTML                                                                                                                                                                                                             | React                                                                                                                                                                                                                          | Vue                                                                                                                                                                                                                     | Angular                                                                                                                                                                                                                                 |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Material Dashboard Dark Edition](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-dark/material-dashboard-dark.jpg)](https://www.creative-tim.com/product/material-dashboard-dark) | [![Material Dashboard HTML](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-html/material-dashboard.jpg)](https://www.creative-tim.com/product/material-dashboard) | [![Material Dashboard React](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-react/material-dashboard-react.jpg)](https://www.creative-tim.com/product/material-dashboard-react) | [![Vue Material Dashboard ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/vue-material-dashboard/vue-material-dashboard.jpg)](https://www.creative-tim.com/product/vue-material-dashboard) | [![Material Dashboard Angular](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-angular/material-dashboard-angular.jpg)](https://www.creative-tim.com/product/material-dashboard-angular2) |

## Demo

- [Start page](https://demos.creative-tim.com/nextjs-material-dashboard/admin/dashboard)
- [User profile page](https://demos.creative-tim.com/nextjs-material-dashboard/admin/user-profile)
- [Tables page ](https://demos.creative-tim.com/nextjs-material-dashboard-pro/admin/table-list)
- [Maps Page](https://demos.creative-tim.com/nextjs-material-dashboard-pro/admin/maps)
- [Notifications page](https://demos.creative-tim.com/nextjs-material-dashboard-pro/admin/notifications)

[View More](https://demos.creative-tim.com/nextjs-material-dashboard-pro/admin/dashboard).

## Quick start

Quick start options:

- `npm i nextjs-material-dashboard`
- Clone the repo: `git clone https://github.com/creativetimofficial/nextjs-material-dashboard.git`.
- [Download from Github](https://github.com/creativetimofficial/nextjs-material-dashboard/archive/master.zip).
- [Download from Creative Tim](https://www.creative-tim.com/product/nextjs-material-dashboard).

## Documentation

The documentation for the Material Dashboard React is hosted at our [website](https://www.creative-tim.com/learning-lab/nextjs/overview/material-dashboard).

## File Structure

Within the download you'll find the following directories and files:

```
nextjs-material-dashboard
.
├── CHANGELOG.md
├── ISSUE_TEMPLATE.md
├── LICENSE.md
├── README.md
├── assets
│   ├── css
│   │   └── nextjs-material-dashboard.css
│   ├── github
│   │   ├── md-react.gif
│   │   └── react.svg
│   ├── img
│   │   └── faces
│   └── jss
│       ├── nextjs-material-dashboard
│       │   ├── cardImagesStyles.js
│       │   ├── checkboxAdnRadioStyle.js
│       │   ├── components
│       │   │   ├── buttonStyle.js
│       │   │   ├── cardAvatarStyle.js
│       │   │   ├── cardBodyStyle.js
│       │   │   ├── cardFooterStyle.js
│       │   │   ├── cardHeaderStyle.js
│       │   │   ├── cardIconStyle.js
│       │   │   ├── cardStyle.js
│       │   │   ├── customInputStyle.js
│       │   │   ├── customTabsStyle.js
│       │   │   ├── footerStyle.js
│       │   │   ├── headerLinksStyle.js
│       │   │   ├── headerStyle.js
│       │   │   ├── rtlHeaderLinksStyle.js
│       │   │   ├── sidebarStyle.js
│       │   │   ├── snackbarContentStyle.js
│       │   │   ├── tableStyle.js
│       │   │   ├── tasksStyle.js
│       │   │   └── typographyStyle.js
│       │   ├── dropdownStyle.js
│       │   ├── layouts
│       │   │   ├── adminStyle.js
│       │   │   └── rtlStyle.js
│       │   ├── tooltipStyle.js
│       │   └── views
│       │       ├── dashboardStyle.js
│       │       ├── iconsStyle.js
│       │       └── rtlStyle.js
│       └── nextjs-material-dashboard.js
├── components
│   ├── Card
│   │   ├── Card.js
│   │   ├── CardAvatar.js
│   │   ├── CardBody.js
│   │   ├── CardFooter.js
│   │   ├── CardHeader.js
│   │   └── CardIcon.js
│   ├── CustomButtons
│   │   └── Button.js
│   ├── CustomInput
│   │   └── CustomInput.js
│   ├── CustomTabs
│   │   └── CustomTabs.js
│   ├── FixedPlugin
│   │   └── FixedPlugin.js
│   ├── Footer
│   │   └── Footer.js
│   ├── Grid
│   │   ├── GridContainer.js
│   │   └── GridItem.js
│   ├── Navbars
│   │   ├── AdminNavbarLinks.js
│   │   ├── Navbar.js
│   │   └── RTLNavbarLinks.js
│   ├── PageChange
│   │   └── PageChange.js
│   ├── Sidebar
│   │   └── Sidebar.js
│   ├── Snackbar
│   │   ├── Snackbar.js
│   │   └── SnackbarContent.js
│   ├── Table
│   │   └── Table.js
│   ├── Tasks
│   │   └── Tasks.js
│   └── Typography
│       ├── Danger.js
│       ├── Info.js
│       ├── Muted.js
│       ├── Primary.js
│       ├── Quote.js
│       ├── Success.js
│       └── Warning.js
├── documentation
│   ├── assets
│   │   ├── css
│   │   │   ├── bootstrap.min.css
│   │   │   ├── demo-documentation.css
│   │   │   └── material-dashboard.css
│   │   ├── img
│   │   │   └── faces
│   │   └── js
│   │       ├── bootstrap.min.js
│   │       └── jquery-3.2.1.min.js
│   └── tutorial-components.html
├── layouts
│   ├── Admin.js
│   └── RTL.js
├── next.config.js
├── package.json
├── pages
│   ├── _app.js
│   ├── _document.js
│   ├── _error.js
│   ├── admin
│   │   ├── dashboard.js
│   │   ├── icons.js
│   │   ├── maps.js
│   │   ├── notifications.js
│   │   ├── table-list.js
│   │   ├── typography.js
│   │   ├── upgrade-to-pro.js
│   │   └── user-profile.js
│   ├── index.js
│   └── rtl
│       └── rtl-page.js
├── routes.js
└── variables
    ├── charts.js
    └── general.js
```

## Browser Support

At present, we officially aim to support the last two versions of the following browsers:

<img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/chrome.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/firefox.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/edge.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/safari.png" width="64" height="64"> <img src="https://s3.amazonaws.com/creativetim_bucket/github/browser/opera.png" width="64" height="64">

## Resources

- Demo: https://demos.creative-tim.com/nextjs-material-dashboard
- Download Page: https://www.creative-tim.com/product/nextjs-material-dashboard
- Documentation: https://www.creative-tim.com/learning-lab/nextjs/overview/material-dashboard
- License Agreement: https://www.creative-tim.com/license
- Support: https://www.creative-tim.com/contact-us
- Issues: [Github Issues Page](https://github.com/creativetimofficial/nextjs-material-dashboard/issues)
- [Nepcha Analytics](https://nepcha.com?ref=readme) - Analytics tool for your website

### Kit Versions

[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/nextjs.jpg" width="60" height="60" />](https://www.creative-tim.com/product/nextjs-material-kit)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/react-native-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-kit-react-native)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/icon-ghost.png" width="60" height="60" />](https://www.creative-tim.com/product/material-kit-ghots)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/bootstrap-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-kit)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/react-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-kit-react)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/vue-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/vue-material-kit)

| NextJS                                                                                                                                                                                                       | React Native                                                                                                                                                                                                                 | Vue                                                                                                                                                                                            | Ghost                                                                                                                                                                                                            |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![ NextJS Material Kit ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/nextjs-material-kit/nextjs-material-kit.jpg)](https://www.creative-tim.com/product/nextjs-material-kit) | [![Material Kit React Native ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-kit-react-native/opt_mkrn_thumbnail.jpg)](https://www.creative-tim.com/product/material-kit-react-native) | [![Vue Material Kit](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/vue-material-kit/vue-material-kit.jpg)](https://www.creative-tim.com/product/vue-material-kit) | [![Material Kit Ghots](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-kit-ghost/opt_mk_ghost_thumbnail.jpg)](https://www.creative-tim.com/product/material-dashboard-react) |

| HTML                                                                                                                                                                                 | React                                                                                                                                                                                                    |
| ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Material Kit HTML](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-kit/material-kit.jpeg)](https://www.creative-tim.com/product/material-kit) | [![Material Kit React ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-kit-react/material-kit-react.jpeg)](https://www.creative-tim.com/product/material-kit-react) |

### Pro Versions

[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/nextjs.jpg" width="60" height="60" />](https://www.creative-tim.com/product/nextjs-material-dashboard-pro)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/laravel_logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard-pro-laravel)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/bootstrap-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard-pro)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/react-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard-pro-react)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/vue-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/vue-material-dashboard-pro)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/angular-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-dashboard-pro-angular2)

| NextJS                                                                                                                                                                                                                                               | Laravel                                                                                                                                                                                                                                                 | Vue & Laravel                                                                                                                                                                                                                                                           | Vuetify                                                                                                                                                                                                                                                 |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![ NextJS Material Dashboard PRO ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/nextjs-material-dashboard-pro/nextjs-material-dashboard-pro.jpg)](https://www.creative-tim.com/product/nextjs-material-dashboard-pro) | [![Material Dashboard PRO Laravel ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-pro-laravel/material-dashboard-pro-laravel.jpg)](https://www.creative-tim.com/product/material-dashboard-pro-laravel) | [![Vue Material Dashboard PRO Laravel ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/vue-material-dashboard-pro-laravel/vue-material-dashboard-pro-laravel.jpg)](https://www.creative-tim.com/product/vue-material-dashboard-laravel-pro) | [![Vuetify Material Dashboard PRO ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/vuetify-material-dashboard-pro/vuetify-material-dashboard-pro.jpg)](https://www.creative-tim.com/product/vuetify-material-dashboard-pro) |

| HTML                                                                                                                                                                                                                        | React                                                                                                                                                                                                                                          | Vue                                                                                                                                                                                                                                     | Angular                                                                                                                                                                                                                                                 |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Material Dashboard PRO HTML](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-pro-html/opt_mdp_thumbnail.jpg)](https://www.creative-tim.com/product/material-dashboard-pro) | [![Material Dashboard PRO React](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-pro-react/material-dashboard-pro-react.jpg)](https://www.creative-tim.com/product/material-dashboard-pro-react) | [![Vue Material Dashboard PRO ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/vue-material-dashboard-pro/vue-material-dashboard-pro.jpg)](https://www.creative-tim.com/product/vue-material-dashboard-pro) | [![Material Dashboard PRO Angular](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-dashboard-pro-angular/material-dashboard-pro-angular.jpg)](https://www.creative-tim.com/product/material-dashboard-pro-angular2) |

### Pro Kit Versions

[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/nextjs.jpg" width="60" height="60" />](https://www.creative-tim.com/product/nextjs-material-kit-pro)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/react-native-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-kit-pro-react-native)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/laravel_logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-blog-pro-laravel)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/bootstrap-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-kit-pro)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/react-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/material-kit-pro-react)
[<img src="https://raw.githubusercontent.com/creativetimofficial/public-assets/master/logos/vue-logo.png" width="60" height="60" />](https://www.creative-tim.com/product/vue-material-kit-pro)

| NextJS                                                                                                                                                                                                                       | React Native                                                                                                                                                                                                                                        | Vue                                                                                                                                                                                                            | Laravel                                                                                                                                                                                                                            |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![ NextJS Material Kit PRO ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/nextjs-material-kit-pro/nextjs-material-kit-pro.jpg)](https://www.creative-tim.com/product/nextjs-material-kit-pro) | [![Material Kit PRO React Native ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-kit-pro-react-native/material-kit-pro-react-native.jpg)](https://www.creative-tim.com/product/material-kit-pro-react-native) | [![Vue Material Kit PRO](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/vue-material-kit-pro/vue-material-kit-pro.jpg)](https://www.creative-tim.com/product/vue-material-kit-pro) | [![Material Blog PRO Laravel](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-blog-pro-laravel/material-blog-pro-laravel.jpg)](https://www.creative-tim.com/product/material-blog-pro-laravel) |

| HTML                                                                                                                                                                                                      | React                                                                                                                                                                                                                   |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [![Material Kit PRO HTML](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-kit-pro-html/opt_mkp_thumbnail.jpg)](https://www.creative-tim.com/product/material-kit-pro) | [![Material Kit PRO React ](https://raw.githubusercontent.com/creativetimofficial/public-assets/master/material-kit-pro-react/material-kit-pro-react.jpg)](https://www.creative-tim.com/product/material-kit-pro-react) |

## Reporting Issues

We use GitHub Issues as the official bug tracker for the Material Dashboard React. Here are some advices for our users that want to report an issue:

1. Make sure that you are using the latest version of the Material Dashboard React. Check the CHANGELOG from your dashboard on our [website](https://www.creative-tim.com/).
2. Providing us reproducible steps for the issue will shorten the time it takes for it to be fixed.
3. Some issues may be browser specific, so specifying in what browser you encountered the issue might help.

## Technical Support or Questions

If you have questions or need help integrating the product please [contact us](https://www.creative-tim.com/contact-us) instead of opening an issue.

## Licensing

- Copyright 2021 Creative Tim (https://www.creative-tim.com)
- Licensed under MIT (https://github.com/creativetimofficial/nextjs-material-dashboard/blob/master/LICENSE.md)

## Useful Links

More products from Creative Tim: <https://www.creative-tim.com/products>

Tutorials: <https://www.youtube.com/channel/UCVyTG4sCw-rOvB9oHkzZD1w>

Freebies: <https://www.creative-tim.com/products>

Affiliate Program (earn money): <https://www.creative-tim.com/affiliates/new>

Social Media:

Twitter: <https://twitter.com/CreativeTim>

Facebook: <https://www.facebook.com/CreativeTim>

Dribbble: <https://dribbble.com/creativetim>

Google+: <https://plus.google.com/+CreativetimPage>

Instagram: <https://instagram.com/creativetimofficial>
