// SnedFile.cpp : ʵļ
//

#include "stdafx.h"
#include "Ucom.h"
#include "SendFile.h"
#include "afxdialogex.h"


// CSnedFile Ի

IMPLEMENT_DYNAMIC(CSendFile, CDialog)

CSendFile::CSendFile(CWnd* pParent, UcomBase** mbase)
	: CDialog(CSendFile::IDD, pParent)
{
	uuBase = mbase;
}

CSendFile::~CSendFile()
{
}

void CSendFile::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BOOL CSendFile::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetWindowText(_T("ļ"));
	strFilePath = "";

	CProgressCtrl* pProgress = (CProgressCtrl*)GetDlgItem(IDC_PrgSend);
	pProgress->SetStep(1);
	pProgress->SetRange(0, 10);

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣:  OCX ҳӦ FALSE
}

BEGIN_MESSAGE_MAP(CSendFile, CDialog)
	ON_BN_CLICKED(IDC_BtnLoad, &CSendFile::OnBnClickedBtnload)
	ON_BN_CLICKED(IDC_BtnSendFile, &CSendFile::OnBnClickedBtnsendfile)
END_MESSAGE_MAP()


// CSendFile Ϣ
void CSendFile::AppendLog(CString str)
{
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EdbFileLog);
	pEdit->SetSel(-1, -1);
	pEdit->ReplaceSel(str);
}

void CSendFile::OnBnClickedBtnload()
{
	CFileDialog fDlg(
		true, // FALSEΪ洢ļ
		NULL, // Ĭչ
		NULL, // Ĭļ
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, // ֻѡͿɸд
		_T("ıļ(*.txt)|*.txt|All Files (*.*)|*.*||"), // ׺
		NULL);

	CProgressCtrl* pProgress = (CProgressCtrl*)GetDlgItem(IDC_PrgSend);
	pProgress->SetPos(0);

	if (IDOK == fDlg.DoModal())
	{
		strFilePath = fDlg.GetPathName();
		CString strtmp;
		strtmp += ">> "+fDlg.GetFileName()+" ɹ\r\n";
		AppendLog(strtmp);
	}
}

#define MAX_PIC_Bytes 1024
void CSendFile::OnBnClickedBtnsendfile()
{
	CString strtmp;
	if (strFilePath.IsEmpty())
	{
		strtmp += ">> Errorļ\r\n";
		AppendLog(strtmp);
	}
	else
	{
		CFile mFile;
		if (mFile.Open(strFilePath, CFile::modeRead | CFile::typeBinary))
		{
			ULONGLONG lBytes=mFile.GetLength();
			UINT nBytes = (UINT)lBytes;
			UINT nCnt = nBytes / MAX_PIC_Bytes;
			UINT rBytes = nBytes % MAX_PIC_Bytes;
			CProgressCtrl* pProgress = (CProgressCtrl*)GetDlgItem(IDC_PrgSend);

			char buf[MAX_PIC_Bytes + 1];
			if (nBytes > MAXUINT)
			{
				strtmp+=">> Errorļ\r\n";
				AppendLog(strtmp);
				return;
			}
			strtmp.Format(">> ļС%d B\r\n<< ڷ...\r\n",nBytes);
			AppendLog(strtmp);

			if (nBytes < MAX_PIC_Bytes)
			{
				pProgress->SetRange(0, 1);
				pProgress->SetPos(0);

				mFile.Read(buf, nBytes);
				UnblockSend(buf, nBytes);
				
				pProgress->SetPos(1);
			}
			else
			{
				pProgress->SetRange(0, nCnt);
				pProgress->SetPos(0);
				TRACE("loop:%d\n", nCnt);

				for (UINT i = 0; i < nCnt; i++)
				{
					mFile.Read(buf, MAX_PIC_Bytes);
					pProgress->SetPos(i);
					UnblockSend(buf, MAX_PIC_Bytes);
				}
				if (rBytes != 0)
				{
					mFile.Read(buf, rBytes);
					UnblockSend(buf, rBytes);
					pProgress->SetPos(nCnt);
				}
			}
			strtmp=">> ͳɹ\r\n--------------------Ƿָ--------------------\r\n";
			AppendLog(strtmp);
			mFile.Close();
		}
	}
}

int CSendFile::UnblockSend(const char*pBuff, UINT len)
{
	CString str(pBuff, len);
	return (*uuBase)->AsyncSend(str);
}


void CSendFile::OnOK()
{
}
