#include "stdafx.h"
#include "iUart.h"

#include "DeConsole.h"

#define XON 0x11
#define XOFF 0x13

iUart::~iUart()
{
	if (isConnected()) CloseHandle(hUartCom);
}


// ļʽ򿪴
bool iUart::OpenCom(bool isBlockMode){
	HANDLE hCom;

	// 10ϵĴ
	ComName = "\\\\.\\" + ComName;
	if (isBlockMode)
	{
		hCom = CreateFile(ComName,// COM
			GENERIC_READ | GENERIC_WRITE, // д
			0, // ռʽ
			NULL,
			OPEN_EXISTING, // 򿪶Ǵ
			FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED, // OVERLAPPED 첽ʽ
			NULL);

		// ÷Ƕ
		memset(&m_osRead, 0, sizeof(OVERLAPPED));
		m_osRead.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);

		// ÷Ƕ
		memset(&m_osWrite, 0, sizeof(OVERLAPPED));
		m_osWrite.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	}
	else
	{
		hCom = CreateFile(ComName,// COM
			GENERIC_READ | GENERIC_WRITE, // д
			0, // ռʽ
			NULL,
			OPEN_EXISTING, // 򿪶Ǵ
			0, // ͬʽ
			NULL);
	}


	// ȡʧ
	if (hCom == INVALID_HANDLE_VALUE)
	{
		TRACE("Open %s Fail\n",ComName);
		return false;
	}
	// ¼
	SetCommMask(hCom, EV_RXCHAR | EV_TXEMPTY | EV_CTS | EV_DSR);
	SetupComm(hCom, IUART_BUFF_MAX, IUART_BUFF_MAX); // 뻺ĴС1024

	COMMTIMEOUTS TimeOuts;
	// 趨ʱ
	TimeOuts.ReadIntervalTimeout = MAXDWORD;
	TimeOuts.ReadTotalTimeoutMultiplier = 0;
	TimeOuts.ReadTotalTimeoutConstant = 0;
	// ڶһ뻺ݺأ
	// ǷҪַ
	// 趨дʱ
	TimeOuts.WriteTotalTimeoutMultiplier = 100;
	TimeOuts.WriteTotalTimeoutConstant = 500;
	SetCommTimeouts(hCom, &TimeOuts); // óʱ
	hUartCom=hCom;

	/* ýṹ */
	DCB dcb;
	GetCommState(hCom, &dcb);
	// ο DCB ڽṹ
	dcb.BaudRate = uartConfig.BaudRate;
	dcb.ByteSize = uartConfig.ByteSize;
	dcb.Parity = uartConfig.Parity;
	dcb.StopBits = uartConfig.StopBits;

	TRACE("open: baud:%d, size:%d, stop:%d, ecc:%d\n", uartConfig.BaudRate,
		uartConfig.ByteSize, uartConfig.StopBits, uartConfig.Parity);

	// Ƿ CTS(clear-to-send) ź
	// Ϊ true ʱ  CTS Ϊ͵ƽݷͽֱCTSΪ
	dcb.fOutxCtsFlow = false;

	//  DSR <- Է DTR
	//  DTR -> Է DSR
	//  RTS -> Է CTS
	//  CTS <- Է RTS
	// RTS_CONTROL_DISABLE/ENABLE 豸ʱRTSźΪʲôƽ
	// Ե EscapeCommFunction ıRTSߵƽ״̬
	// RTS_CONTROL_HANDSHAKE  RTS ź֣ʱӦóܵ EscapeCommFunction 
	// пռʱ RTS ΪԽգõ
	// RTS_CONTROL_TOGGLE ֽҪʱ RTS ߣлֽѱϺRTS 
	dcb.fRtsControl = RTS_CONTROL_DISABLE;
	// RTS ĸıӰԷ CTS
	// Ϊ true ʱ CTS Ϊ͵ƽ(Է RTS )ݷͽֱ CTS Ϊ
	dcb.fOutxCtsFlow = false;

	// DTR -> Է DSRʹú RTS  RTS һ
	dcb.fDtrControl = DTR_CONTROL_DISABLE;
	dcb.fOutxDsrFlow = false;

	// ź SETRTS,CLRRTS,SETDTR,CLRDTR
	// EscapeCommFunction(mUart.GetHandle(), SETRTS);
	// ȡҪ GetCommMask ãȻ WaitCommEvent ȴҪһ߳


	// ָǷģʽWin32 API ַ֧Ƕģʽ䣬Ӧ true
	dcb.fBinary = true;
	// 0ַΪ true ʱʱԶȥգ0ֵֽ
	dcb.fNull = false;

	// ص XON/XOFF 
	dcb.fInX = false;
	dcb.fOutX = false;
	// dcb.XonChar = XON; // ָ XONͷʱַ 0x11
	// dcb.XoffChar = XOFF; // ָ XOFFͷֹͣʱַ 0x13
	// dcb.XonLim = 50;
	// dcb.XoffLim = 50;

	if (SetCommState(hUartCom, &dcb) == 0)
	{
		TRACE("Com Config fail\n");
		ClosePort();
		return false;
	}

	// պͷͻ
	PurgeComm(hUartCom, PURGE_TXCLEAR | PURGE_RXCLEAR);
	return true;
}

bool iUart::ConfigUart(CString comName,DCB mConfig)
{
	ComName = comName;

	uartConfig.BaudRate = mConfig.BaudRate;
	uartConfig.ByteSize = mConfig.ByteSize;
	uartConfig.Parity = mConfig.Parity;
	uartConfig.StopBits = mConfig.StopBits;

	return true;
}

// ȡббؼ
void iUart::GetComList(CComboBox *cblist)
{
	HKEY hKey;
	int   i = 0;
	TCHAR   portName[256], commName[256];
	DWORD   dwLong, dwSize;
	// עˢ
	// 򿪴ע
	int rtn = ::RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Hardware\\DeviceMap\\SerialComm", NULL, KEY_READ, &hKey);
	if (rtn == ERROR_SUCCESS)
	{
		while (TRUE)
		{
			dwLong = dwSize = sizeof(portName);
			memset(portName, 0, sizeof(portName));
			memset(commName, 0, sizeof(commName));

			rtn = RegEnumValue(hKey, i, portName, &dwLong, NULL, NULL, (PUCHAR)commName, &dwSize);
			// öٴ
			if (rtn == ERROR_NO_MORE_ITEMS)
				break;
			// б
			cblist->AddString(commName);
			i++;
		}

		RegCloseKey(hKey);
	}
	// ˢ´ѡ
	cblist->AddString("ˢ´");
}

int iUart::WriteCString(const CString &cBuffer)
{
	unsigned long dwBytesWrite;
	BOOL bWriteStat;

	if (!isConnected())
		return false;

	bWriteStat = WriteFile(hUartCom, cBuffer, cBuffer.GetAllocLength(), &dwBytesWrite, NULL);
	// 󷵻 -1
	if (!bWriteStat)
		return -1;
	// طֽ
	return dwBytesWrite;
}


CString iUart::ReadCString(void)
{
	unsigned long dwBytesRead;
	BOOL bReadStat;
	COMSTAT ComStat;
	DWORD dwErrorFlags;

	CString dataStr;
	dataStr.Empty();

	if (!isConnected())
	{
		TRACE("Read:no connect\n");
		return dataStr;
	}

	ClearCommError(hUartCom, &dwErrorFlags, &ComStat);
	// cbInQue ڴеַ
	dwBytesRead = ComStat.cbInQue;

	if (dwBytesRead == 0)
	{
		TRACE("Read:no data\n");
		return dataStr;
	}

	dataStr.GetBufferSetLength(dwBytesRead);
	bReadStat = ReadFile(hUartCom, dataStr.GetBuffer(0), dwBytesRead, &dwBytesRead, NULL);
	if (!bReadStat)
	{
		TRACE("Read:read failed\n");
		dataStr.Empty();
		return dataStr;
	}

	PurgeComm(hUartCom, PURGE_RXABORT | PURGE_RXCLEAR);
	return dataStr;
}

// ڼ̣߳ݷϢ֪ͨȡ״̬仯Ϣ
UINT RxThreadFunc(LPVOID mThreadPara)
{
	OVERLAPPED os;
	DWORD dwMask, dwTrans;
	DWORD CommEvent;
	COMSTAT ComStat;
	DWORD dwErrorFlags;

	ThreadPara *pPara = (ThreadPara *)mThreadPara;
	HANDLE hComm = *(pPara->commHandle);
	HWND hwParent = pPara->hwParent;
	HWND hwTopParent = pPara->hwTopParent;
	if (hComm == NULL)
	{
		TRACE("Handle not correct\n");
		return -1;
	}

	memset(&os, 0, sizeof(OVERLAPPED));
	os.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);

	if (os.hEvent == NULL)
	{
		TRACE("hEvent Failed\n");
		return (UINT)-1;
	}
	TRACE("Rx Listenner Thread Start\n");

	while (1)
	{
		ClearCommError(hComm, &dwErrorFlags, &ComStat);

		if (ComStat.cbInQue)
		{
			// ݷϢUI߳
			// Ϣд߳˳?
			::PostMessage(hwTopParent, WM_MYONRECVMSG, W_UART_RECV, 0);
		}

		dwMask = 0;
		// ȴ¼
		if (!WaitCommEvent(hComm, &dwMask, &os))
		{
			if (GetLastError() == ERROR_IO_PENDING)
			{
				GetOverlappedResult(hComm, &os, &dwTrans, TRUE);
			}
			else
			{
				CloseHandle(os.hEvent);
				return(UINT)-1;
			}
		}
		// ض¼ʱ
		if (dwMask&EV_CTS&EV_DSR)
		{
			//  UartDlg Ʊ仯Ϣ
			GetCommModemStatus(hComm, &CommEvent);
			::SendMessage(hwParent, WM_UARTDLG_MSG, dwMask, CommEvent);
		}
		// GetCommMask(hComm, &CommEvent);
	}
	CloseHandle(os.hEvent);
	TRACE("Rx Listenner Thread Stop\n");
	return EXIT_SUCCESS;
}


// ̷߳ʽĶȡ
int iUart::UnblockRead(CString &dataStr)
{
	COMSTAT ComStat;
	DWORD dwErrorFlags;
	DWORD dwBytesRead;
	BOOL bReadStatus;

	ClearCommError(hUartCom, &dwErrorFlags, &ComStat);

	// cbInQueڴеַ
	dwBytesRead = ComStat.cbInQue;
	/* رʱһζȡ ޷dwBytesReadرGetBufferSetLengthֲ*/
	if ((int)dwBytesRead <= 0) return 0;

	dataStr.GetBufferSetLength(dwBytesRead);
	//ȡ
	bReadStatus = ReadFile(hUartCom, dataStr.GetBuffer(0), dwBytesRead, &dwBytesRead, &m_osRead);
	if (!bReadStatus)
	{
		//صδ,ȴֱ
		if (GetLastError() == ERROR_IO_PENDING)
		{
			GetOverlappedResult(hUartCom, &m_osRead, &dwBytesRead, TRUE);
			m_osRead.Offset = 0;
		}
		else
		{
			dwBytesRead = 0;
		}
	}
	//ضȡ
	return dwBytesRead;
}

int iUart::UnblockSend(const CString &dataStr)
{
	BOOL bWriteStatus;
	COMSTAT ComStat;
	DWORD dwErrorFlags, dwLength;

	ClearCommError(hUartCom, &dwErrorFlags, &ComStat);
	if (dwErrorFlags>0)
	{
		TRACE("Unblock Write Failed\n");
		PurgeComm(hUartCom, PURGE_TXABORT | PURGE_TXCLEAR);
		return 0;
	}
	m_osWrite.Offset = 0;

	//dwLength = dataStr.GetAllocLength();
	//appendʽӾ͵GetLengthܵĳȷGetAllocLengthbugGetLength'\0'
	dwLength = dataStr.GetLength();
	bWriteStatus = WriteFile(hUartCom, (LPCTSTR)dataStr, dwLength, &dwLength, &m_osWrite);

	if (!bWriteStatus)
	{
		if (GetLastError() == ERROR_IO_PENDING)
		{
			//صδ,ȴֱ
			GetOverlappedResult(hUartCom, &m_osWrite, &dwLength, TRUE);
		}
		else
			dwLength = 0;
	}
	return dwLength;
}
