# Ucom

Ucom 是一个基于 MFC 的高效串口、网络调试工具，单可执行文件运行无需依赖动态链接库，支持多开和多种扩展功能。

![ucom](https://i.loli.net/2019/03/02/5c7a0fa8ad36b.png)

Ucom 中串口读写使用 [Serial-Communications-in-Win32](https://docs.microsoft.com/en-us/previous-versions/ms810467(v=mdn.10))，网络使用 [CAsyncSocket](https://docs.microsoft.com/en-us/cpp/mfc/reference/casyncsocket-class?view=vs-2017)，图表扩展功能使用了 [High-speed-Charting-Control](https://www.codeproject.com/Articles/14075/High-speed-Charting-Control)。

工程建议使用 VS2017 打开，需要提前安装 C++ MFC 组件，可以直接在 [releases](https://github.com/creaink/ucom/releases) 页面下载已编译文件，技术交流 QQ 群：560901616。

## 功能

已下的功能都针对最新的版本来说，其他版本参考 [Changelog](https://github.com/creaink/ucom/blob/master/CHANGELOG.md)。

- **多数据源**，提供串口和网络两个数据源，切换数据源，不影响软件的其他功能
- **配置保存功能**，当关闭软件时候会自动保存串口、网络配置里的信息和用户设定的背景色和字体色等配置
- **自定义接收区主题**，可以定制接收框的主题样式
- **扩展工具面板**，点击 `探索>>` 按钮可以在窗口右侧扩展出接收图表、编码解码、接收监视、发送助手等工具面板
- **动态刷新串口**，当有新设备接入时，点击串口号，在下拉菜单里选择刷新串口可以扫描端口变动
- **多编码支持**，完全支持接收区以 UTF-8 和 Unicode 的编码显示
- **透明传输**，不会阻碍 0x00, 0x11 等字节的发送接收
- **支持常用串口流控制**
- **支持文件发送**，建议不要发送太大的文件
- **支持 AT 模式**，回车发送数据(数据包含回车)，发送的数据同时以特殊显示格式（红色字体）添到接收显示的新行中，上下方向键调用历史命令(数据)，输入框内按 Tab 在开头补上 `AT+`
- **支持面板的拖动**，支持横向、纵向窗口大小调整和发送接收纵向窗口调整
- 提供数据统计和实时传输速率数据显示，快速清空等功能
- 提供 HEX 接收显示和 HEX 模式发送，并对不规范输入进行提醒
- `Ctrl + Enter` 快速发送

### 数据源面板

点击串口或者网络标签可以切换数据源，**切换面板不影响连接**；数据源面板的信息都会在软件关闭时候保存；点击左侧的开关图标能够切换串口连接状态。

#### 串口数据源

- 串口号下拉列表如果选择刷新串口可以动态扫描刷新串口列表
- 关于流控制

    ```txt
    本机 DSR <- 对方 DTR
    本机 DTR -> 对方 DSR
    本机 RTS -> 对方 CTS
    本机 CTS <- 对方 RTS
    ```

#### 网络数据源

- 使用网络数据源首先选择协议
- `TCP Client` 模式用于连接 TCP Server，此时的目的IP、目的端口为 Server 的IP、端口，本地 Client 端口随机分配暂不可指定
- `TCP Server` 模式用于建立 TCP Server，此时目的端口为在本机上建立 Server 的端口；连接按钮代表创建 Server，如有客户端连接到服务器，客户端列表会动态增添所有连接到本 Server 的 IP和端口。Server 发送数据需要指定特定的客户端或者选择**所有连接**发送给所有客户端，接收的客户端的数据会以 `【From: IP:Port】` 开始加以分别。
- `UDP` 模式不分 Server 和 Client 模式，此时本地端口为本地监听的端口，目的端口和目的IP为对方 UDP 的监听地址和端口，可以在建立 UDP 信息之后更改

### 主面板

- **满收清空**，当勾选此项时候，当接区达到毗邻的数值输入框的设定值(Byte)时会自动清空
- **快速启动**，可以快速调用常用的工具和系统设置项
- **间隔发送**，当勾选此项时候，当接区达到毗邻的数值输入框的设定值(  ms)时会自动发送
- **发帧换行**，当勾选此项时候，自动为发送框的数据末尾添加回车换行符
- **暂停接收**，暂停数据的显示，但是数据依然在后台接收，只是不显示
- **保存接收**，用于保存当前接收框里的文本信息为TXT文件
- 背景色、字体色、字体样式，可以定制接收框的样式，字体样式信息不会保存

### 面板调整

可以通过拖拽窗口右侧和底侧边框改变收、发框的大小，通过拖动收、发框之间右侧的按钮（发送计数旁按钮）可以改变其布局。

### 接收图表

接收图表，支持指定格式数值分拣、图形化显示，格式:`空格+通道(0-5)+':'+数据+换行`，如: `printf(" 0:%d 1:%f\n", ...)`，最多支持六通道。

- 点击**开始**按钮开始从接收区分析绘制数据，**清除**按钮清空图表
- **导出数据**按钮可以保存当前绘制的图表的数据，该数据文件可以用 Excel 打开后另存为表格方便后续分析
- 在**数据列表**选择曲线，在右侧的曲线框调整该曲线的线宽、线色等属性
- **坐标轴**框内选择纵、横坐标轴之后后可以分别调整其属性；轴范围上大下小，当光标失焦时候确定；一条曲线默认只缓存最近 512 个点，建议帧间隔大于 20ms
- **外挂**按钮点击之后弹出的外挂窗口可任意调整大小
- **背景色**按钮可以更改图表的背景颜色
- 在波形图上向右下角拉选取框：放大，反之是还原，右键平移

### 编码解码

- 编码查询，提供三种常用的字符编码的 16 进制编码查询、可变换显示风格
- HEX 解码，从提供的 HEX 字符串尝试解码到三种编码的字符串

### 接收监视

监视注释，能够以监视数据帧（以 MFC 接收的帧间隔为准）分析数据帧的时间关系，序号大的数据会插入第一行，时间戳精确到毫秒。

- **开始监视**开始监控数据帧
- **HEX记录**将接收的数据帧以 HEX 字符的方式显示
- **最大记录**勾选之后，记录的数据帧数到达最大记录之后会自动清空数
- 由于列表空间有限，点击数据帧条目之后，在下方的框内会详细显示数据帧的数据

### 发送助手

发送助手，支持最大十个条目发送，可时间触发轮发或者使用键盘触发某一行发送，也支持使用单独按钮发送。支持自动换行、HEX 模式。

- 当需要发送的数据较大（或包含回车时）时候可以在下方的输入框输入数据，然后在**传送**按钮旁选择需要传送的条目，之后按下传送按钮可以将输入框内的内容传输至条目当中
- 可以点击每个条目旁的按钮触发单条发送，也可以勾选上方的**键盘触发**之后将光标放到下方输入框，使用英文输入法输入对应按钮上的字母触发发送
- 设置好轮发时间勾选**定时轮发**，会根据时间间隔轮发 10 条记录

## 写在最后

谨以此小工具感谢长春理工大学电子学会，和在学会里一起努力的小伙伴们，以及那些奋斗日夜。
