<img src="assets/logo.png" alt="ddns-route53" width="128px" style="display: block; margin-left: auto; margin-right: auto"/>

<p align="center">
  <a href="https://github.com/crazy-max/WindowsSpyBlocker/releases/latest"><img src="https://img.shields.io/github/release/crazy-max/WindowsSpyBlocker.svg?style=flat-square" alt="GitHub release"></a>
  <a href="https://chocolatey.org/packages/windowsspyblocker"><img src="https://img.shields.io/chocolatey/v/windowsspyblocker?style=flat-square" alt="Chocolatey Package"></a>
  <a href="https://github.com/crazy-max/WindowsSpyBlocker/releases/latest"><img src="https://img.shields.io/github/downloads/crazy-max/WindowsSpyBlocker/total.svg?style=flat-square" alt="Total downloads"></a>
  <a href="https://github.com/crazy-max/WindowsSpyBlocker/actions?workflow=build"><img src="https://img.shields.io/github/actions/workflow/status/crazy-max/WindowsSpyBlocker/build.yml?branch=master&label=build&logo=github&style=flat-square" alt="Build Status"></a>
  <br /><a href="https://goreportcard.com/report/github.com/crazy-max/WindowsSpyBlocker"><img src="https://goreportcard.com/badge/github.com/crazy-max/WindowsSpyBlocker?style=flat-square" alt="Go Report"></a>
  <a href="https://github.com/sponsors/crazy-max"><img src="https://img.shields.io/badge/sponsor-crazy--max-181717.svg?logo=github&style=flat-square" alt="Become a sponsor"></a>
  <a href="https://www.paypal.me/crazyws"><img src="https://img.shields.io/badge/donate-paypal-00457c.svg?logo=paypal&style=flat-square" alt="Donate Paypal"></a>
</p>

---

## What is WindowsSpyBlocker?

**WindowsSpyBlocker** :shield: is an application written in [Go](https://golang.org/) and delivered as a
[single executable]({{ config.repo_url }}releases/latest) to block spying and tracking on Windows systems.

The approach of this project is to capture and interpret network traffic based on a set of tools. Depending on the
interactions between services and source or destination of traffic, rules are created and sorted by assignment.

## Projects using WindowsSpyBlocker

* [BlackArch Linux](https://www.blackarch.org/): an Arch Linux-based penetration testing distribution for penetration testers and security researchers.
* [Blackweb](https://github.com/maravento/blackweb): URLs Blacklist for Squid.
* [BlahDNS](https://blahdns.com/): A small hobby ads block dns project with doh, dot, dnscrypt support.
* [DNSCrypt Proxy](https://dnscrypt.info/): A flexible DNS proxy, with support for encrypted DNS protocols.
* [Energized Protection](https://energized.pro/): Let's make an annoyance free, better open internet, altogether!
* [FilterLists](https://filterlists.com/): An independent, comprehensive directory of filter and host lists for advertisements, trackers, malware, and annoyances.
* [LEDE Project](https://lede-project.org/): A Linux operating system based on OpenWrt.
* [Mikrotik hosts parser](https://github.com/tarampampam/mikrotik-hosts-parser): An application that blocks "advertising" for routers based on RouterOS.
* [NextDNS](https://github.com/nextdns): Block ads, trackers, malware and phishing websites, cryptominers and more.  
* [OpenWrt adblock package](https://github.com/openwrt/packages/tree/master/net/adblock/files): DNS based ad/abuse domain blocking.
* [OPNsense](https://opnsense.org): An open source, easy-to-use and easy-to-build HardenedBSD based firewall and routing platform.
* [pi-hole](https://pi-hole.net/): A black hole for Internet advertisements (designed for Raspberry Pi).
* [privatezilla](https://github.com/builtbybel/privatezilla): Performs a privacy & security check of Windows 10.
* [simplewall](https://github.com/henrypp/simplewall): Simple tool to configure Windows Filtering Platform (WFP).
* [void-zones-tools](https://github.com/cyclaero/void-zones-tools): A list of void zones that can be readily feed into Unbound on FreeBSD.
* [WPD](https://getwpd.com/): Customize Group Policy, Services and Tasks, responsible for data collection and sending, as you like.

## License

This project is licensed under the terms of the MIT license.

Icon credit to [Icons8](https://icons8.com/).
