from typing import Any, Optional

class TreeBuilderRegistry:
    builders_for_feature: Any = ...
    builders: Any = ...
    def __init__(self) -> None: ...
    def register(self, treebuilder_class: Any) -> None: ...
    def lookup(self, *features: Any): ...

class TreeBuilder:
    NAME: str = ...
    ALTERNATE_NAMES: Any = ...
    features: Any = ...
    is_xml: bool = ...
    picklable: bool = ...
    empty_element_tags: Any = ...
    DEFAULT_CDATA_LIST_ATTRIBUTES: Any = ...
    DEFAULT_PRESERVE_WHITESPACE_TAGS: Any = ...
    USE_DEFAULT: Any = ...
    TRACKS_LINE_NUMBERS: bool = ...
    soup: Any = ...
    cdata_list_attributes: Any = ...
    preserve_whitespace_tags: Any = ...
    store_line_numbers: Any = ...
    def __init__(self, multi_valued_attributes: Any = ..., preserve_whitespace_tags: Any = ..., store_line_numbers: Any = ...) -> None: ...
    def initialize_soup(self, soup: Any) -> None: ...
    def reset(self) -> None: ...
    def can_be_empty_element(self, tag_name: Any): ...
    def feed(self, markup: Any) -> None: ...
    def prepare_markup(self, markup: Any, user_specified_encoding: Optional[Any] = ..., document_declared_encoding: Optional[Any] = ..., exclude_encodings: Optional[Any] = ...) -> None: ...
    def test_fragment_to_document(self, fragment: Any): ...
    def set_up_substitutions(self, tag: Any): ...

class SAXTreeBuilder(TreeBuilder):
    def feed(self, markup: Any) -> None: ...
    def close(self) -> None: ...
    def startElement(self, name: Any, attrs: Any) -> None: ...
    def endElement(self, name: Any) -> None: ...
    def startElementNS(self, nsTuple: Any, nodeName: Any, attrs: Any) -> None: ...
    def endElementNS(self, nsTuple: Any, nodeName: Any) -> None: ...
    def startPrefixMapping(self, prefix: Any, nodeValue: Any) -> None: ...
    def endPrefixMapping(self, prefix: Any) -> None: ...
    def characters(self, content: Any) -> None: ...
    def startDocument(self) -> None: ...
    def endDocument(self) -> None: ...

class HTMLTreeBuilder(TreeBuilder):
    empty_element_tags: Any = ...
    block_elements: Any = ...
    DEFAULT_CDATA_LIST_ATTRIBUTES: Any = ...
    DEFAULT_PRESERVE_WHITESPACE_TAGS: Any = ...
    def set_up_substitutions(self, tag: Any): ...

class ParserRejectedMarkup(Exception):
    def __init__(self, message_or_exception: Any) -> None: ...

# Names in __all__ with no definition:
#   HTMLParserTreeBuilder
