# The Defiant Manifesto

**Defiant** is a plugin-based Node.js framework that is created to help users quickly develop websites and services.  Our goals are as follows:

1. Security

  Defiant should be secure by design.  Its default behavior should implement the latest security practices so that any function built using its APIs inherits these best practices.  Any security issue should be resolved quickly and publicly so that any affected project may be properly updated.

2. Privacy

  Defiant should try to support most of the common development needs natively.  Although 3rd party services may easily be supported (and they are not discouraged, either), the Defiant developer should want to not outsource the privacy of the site owner nor the site user, if it can be avoided.

3. Flexibility

  Defiant should be easy to extend using a plugin-based development system.  If an objective cannot be achieved without altering Defiant's source code, then this should be interpreted as a fault, and a bug request should be filed in the appropriate bug tracking system.

4. Practicality

  Defiant should "just work", out of the box, for the most common use cases.  For the end user, the UI should be intuitive.  For the developer, the APIs should be powerful.

5. Efficiency

  Defiant should be fast and lightweight.  Even a small VMs should be able to host the average website several times over.

6. Portability

  Defiant should support a number of back end data stores to meet the needs of a wide variety of sites.  Plugins should allow all settings to be imported and exported so that appropriate backups and recoveries can be made.

7. Community

  Defiant should welcome those with opposing viewpoints.  They challenge us, make us stronger, and together we create a better product.  You are welcome to join us.  **Be Defiant!**
