var wasap = (function () {
var RE_SELECTOR = /([.#]?[^\s#.]+)/;

var WHATSAPP_API_PROTOCOL = 'whatsapp://send';
var WHATSAPP_API_URL = 'https://api.whatsapp.com/api/send';

var defaults = {
  enableIf: /android|iphone|ipad/i,
  protocolIf: /android|iphone|ipad/i,
  uaString: window.navigator.userAgent,
  openCallback: null,
  elementCallback: null,
  newNodeSelector: 'a.whatsapp-link',
};

function checkIfCallback(value, config) {
  if (value instanceof RegExp) {
    return value.test(config.uaString);
  }

  if (typeof value === 'function') {
    return value();
  }

  return !!value;
}

function assign(target) {
  var arguments$1 = arguments;

  var loop = function ( i ) {
    if (arguments$1[i]) {
      Object.keys(arguments$1[i]).forEach(function (key) {
        target[key] = arguments$1[i][key];
      });
    }
  };

  for (var i = 1; i < arguments.length; i += 1) loop( i );

  return target;
}

function buildLink(config, baseURI) {
  var params = [];

  Object.keys(config).forEach(function (prop) {
    if (config[prop]) {
      params.push((prop + "=" + (encodeURIComponent(config[prop]))));
    }
  });

  return ("" + baseURI + (params.length ? ("?" + (params.join('&'))) : ''));
}

function setupLink(node, newEl, config) {
  var baseURI = checkIfCallback(config.protocolIf, config)
    ? WHATSAPP_API_PROTOCOL
    : WHATSAPP_API_URL;

  var options = {
    text: node.dataset.whatsappMessage,
    phone: node.dataset.whatsapp,
  };

  if (newEl.tagName === 'A') {
    newEl.href = buildLink(options, baseURI);
  }

  if (typeof config.elementCallback === 'function') {
    config.elementCallback(node, function (params) {
      if (typeof params === 'string') {
        params = { text: params };
      }

      var url = buildLink(assign({}, options, params), baseURI);
      var open = config.openCallback || window.open;

      open(url);
    });
  }
}

function makeEl(config) {
  var parts = config.newNodeSelector
    .split(RE_SELECTOR)
    .filter(Boolean);

  var target = document.createElement(parts[0]);

  for (var i = 1; i < parts.length; i += 1) {
    if (parts[i]) {
      if (parts[i].charAt() === '.') {
        target.classList.add(parts[i].substr(1));
      }

      if (parts[i].charAt() === '#') {
        target.id = parts[i].substr(1);
      }
    }
  }

  return target;
}

function append(node, config) {
  var newEl = makeEl(config);
  var body = node.innerHTML;

  node.innerHTML = '';
  node.appendChild(newEl);

  newEl.innerHTML = body;

  setupLink(node, newEl, config);
}

function init(options) {
  var config = assign({}, defaults, options);
  var isEnabled = checkIfCallback(config.enableIf, config);

  if (isEnabled) {
    var matchedElements = document.querySelectorAll('[data-whatsapp]');

    for (var i = 0; i < matchedElements.length; i += 1) {
      append(matchedElements[i], config);
    }
  }
}

var wasap = {
  init: init,
};

return wasap;

}());

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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