// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/owner/v1/user_service.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_owner_v1_organization_pb = require('../../../../buf/registry/owner/v1/organization_pb.js');
goog.object.extend(proto, buf_registry_owner_v1_organization_pb);
var buf_registry_owner_v1_user_pb = require('../../../../buf/registry/owner/v1/user_pb.js');
goog.object.extend(proto, buf_registry_owner_v1_user_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.owner.v1.CreateUsersRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.CreateUsersRequest.Value', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.CreateUsersResponse', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.DeleteUsersRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.DeleteUsersResponse', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.GetUsersRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.GetUsersResponse', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.ListUsersRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.ListUsersRequest.Order', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.ListUsersResponse', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.UpdateUsersRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.UpdateUsersRequest.Value', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.UpdateUsersResponse', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.GetUsersRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.GetUsersRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.GetUsersRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.GetUsersRequest.displayName = 'proto.buf.registry.owner.v1.GetUsersRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.GetUsersResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.GetUsersResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.GetUsersResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.GetUsersResponse.displayName = 'proto.buf.registry.owner.v1.GetUsersResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.ListUsersRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.ListUsersRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.ListUsersRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.ListUsersRequest.displayName = 'proto.buf.registry.owner.v1.ListUsersRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.ListUsersResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.ListUsersResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.ListUsersResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.ListUsersResponse.displayName = 'proto.buf.registry.owner.v1.ListUsersResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.CreateUsersRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.CreateUsersRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.CreateUsersRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.CreateUsersRequest.displayName = 'proto.buf.registry.owner.v1.CreateUsersRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.owner.v1.CreateUsersRequest.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.CreateUsersRequest.Value.displayName = 'proto.buf.registry.owner.v1.CreateUsersRequest.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.CreateUsersResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.CreateUsersResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.CreateUsersResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.CreateUsersResponse.displayName = 'proto.buf.registry.owner.v1.CreateUsersResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.UpdateUsersRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.UpdateUsersRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.UpdateUsersRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.UpdateUsersRequest.displayName = 'proto.buf.registry.owner.v1.UpdateUsersRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.owner.v1.UpdateUsersRequest.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.UpdateUsersRequest.Value.displayName = 'proto.buf.registry.owner.v1.UpdateUsersRequest.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.UpdateUsersResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.UpdateUsersResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.UpdateUsersResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.UpdateUsersResponse.displayName = 'proto.buf.registry.owner.v1.UpdateUsersResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.DeleteUsersRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.DeleteUsersRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.DeleteUsersRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.DeleteUsersRequest.displayName = 'proto.buf.registry.owner.v1.DeleteUsersRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.DeleteUsersResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.owner.v1.DeleteUsersResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.DeleteUsersResponse.displayName = 'proto.buf.registry.owner.v1.DeleteUsersResponse';
}

/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.GetUsersRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.GetUsersRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.GetUsersRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.GetUsersRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.GetUsersRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
userRefsList: jspb.Message.toObjectList(msg.getUserRefsList(),
    buf_registry_owner_v1_user_pb.UserRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.GetUsersRequest}
 */
proto.buf.registry.owner.v1.GetUsersRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.GetUsersRequest;
  return proto.buf.registry.owner.v1.GetUsersRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.GetUsersRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.GetUsersRequest}
 */
proto.buf.registry.owner.v1.GetUsersRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_user_pb.UserRef;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.UserRef.deserializeBinaryFromReader);
      msg.addUserRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.GetUsersRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.GetUsersRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.GetUsersRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.GetUsersRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUserRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_user_pb.UserRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated UserRef user_refs = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.UserRef>}
 */
proto.buf.registry.owner.v1.GetUsersRequest.prototype.getUserRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.UserRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_user_pb.UserRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.UserRef>} value
 * @return {!proto.buf.registry.owner.v1.GetUsersRequest} returns this
*/
proto.buf.registry.owner.v1.GetUsersRequest.prototype.setUserRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.UserRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.UserRef}
 */
proto.buf.registry.owner.v1.GetUsersRequest.prototype.addUserRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.UserRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.GetUsersRequest} returns this
 */
proto.buf.registry.owner.v1.GetUsersRequest.prototype.clearUserRefsList = function() {
  return this.setUserRefsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.GetUsersResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.GetUsersResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.GetUsersResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.GetUsersResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.GetUsersResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
usersList: jspb.Message.toObjectList(msg.getUsersList(),
    buf_registry_owner_v1_user_pb.User.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.GetUsersResponse}
 */
proto.buf.registry.owner.v1.GetUsersResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.GetUsersResponse;
  return proto.buf.registry.owner.v1.GetUsersResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.GetUsersResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.GetUsersResponse}
 */
proto.buf.registry.owner.v1.GetUsersResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_user_pb.User;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.User.deserializeBinaryFromReader);
      msg.addUsers(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.GetUsersResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.GetUsersResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.GetUsersResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.GetUsersResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUsersList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_user_pb.User.serializeBinaryToWriter
    );
  }
};


/**
 * repeated User users = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.User>}
 */
proto.buf.registry.owner.v1.GetUsersResponse.prototype.getUsersList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.User>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_user_pb.User, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.User>} value
 * @return {!proto.buf.registry.owner.v1.GetUsersResponse} returns this
*/
proto.buf.registry.owner.v1.GetUsersResponse.prototype.setUsersList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.User=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.User}
 */
proto.buf.registry.owner.v1.GetUsersResponse.prototype.addUsers = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.User, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.GetUsersResponse} returns this
 */
proto.buf.registry.owner.v1.GetUsersResponse.prototype.clearUsersList = function() {
  return this.setUsersList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.ListUsersRequest.repeatedFields_ = [3,5,6];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.ListUsersRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.ListUsersRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.ListUsersRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
pageSize: jspb.Message.getFieldWithDefault(msg, 1, 0),
pageToken: jspb.Message.getFieldWithDefault(msg, 2, ""),
organizationRefsList: jspb.Message.toObjectList(msg.getOrganizationRefsList(),
    buf_registry_owner_v1_organization_pb.OrganizationRef.toObject, includeInstance),
order: jspb.Message.getFieldWithDefault(msg, 4, 0),
hasTypesList: (f = jspb.Message.getRepeatedField(msg, 5)) == null ? undefined : f,
hasStatesList: (f = jspb.Message.getRepeatedField(msg, 6)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest}
 */
proto.buf.registry.owner.v1.ListUsersRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.ListUsersRequest;
  return proto.buf.registry.owner.v1.ListUsersRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.ListUsersRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest}
 */
proto.buf.registry.owner.v1.ListUsersRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setPageSize(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setPageToken(value);
      break;
    case 3:
      var value = new buf_registry_owner_v1_organization_pb.OrganizationRef;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.OrganizationRef.deserializeBinaryFromReader);
      msg.addOrganizationRefs(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.owner.v1.ListUsersRequest.Order} */ (reader.readEnum());
      msg.setOrder(value);
      break;
    case 5:
      var values = /** @type {!Array<!proto.buf.registry.owner.v1.UserType>} */ (reader.isDelimited() ? reader.readPackedEnum() : [reader.readEnum()]);
      for (var i = 0; i < values.length; i++) {
        msg.addHasTypes(values[i]);
      }
      break;
    case 6:
      var values = /** @type {!Array<!proto.buf.registry.owner.v1.UserState>} */ (reader.isDelimited() ? reader.readPackedEnum() : [reader.readEnum()]);
      for (var i = 0; i < values.length; i++) {
        msg.addHasStates(values[i]);
      }
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.ListUsersRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.ListUsersRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.ListUsersRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPageSize();
  if (f !== 0) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = message.getPageToken();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getOrganizationRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      3,
      f,
      buf_registry_owner_v1_organization_pb.OrganizationRef.serializeBinaryToWriter
    );
  }
  f = message.getOrder();
  if (f !== 0.0) {
    writer.writeEnum(
      4,
      f
    );
  }
  f = message.getHasTypesList();
  if (f.length > 0) {
    writer.writePackedEnum(
      5,
      f
    );
  }
  f = message.getHasStatesList();
  if (f.length > 0) {
    writer.writePackedEnum(
      6,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.buf.registry.owner.v1.ListUsersRequest.Order = {
  ORDER_UNSPECIFIED: 0,
  ORDER_CREATE_TIME_DESC: 1,
  ORDER_CREATE_TIME_ASC: 2
};

/**
 * optional uint32 page_size = 1;
 * @return {number}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.getPageSize = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.setPageSize = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string page_token = 2;
 * @return {string}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.getPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.setPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * repeated OrganizationRef organization_refs = 3;
 * @return {!Array<!proto.buf.registry.owner.v1.OrganizationRef>}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.getOrganizationRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.OrganizationRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_organization_pb.OrganizationRef, 3));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.OrganizationRef>} value
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
*/
proto.buf.registry.owner.v1.ListUsersRequest.prototype.setOrganizationRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 3, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.OrganizationRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.OrganizationRef}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.addOrganizationRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 3, opt_value, proto.buf.registry.owner.v1.OrganizationRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.clearOrganizationRefsList = function() {
  return this.setOrganizationRefsList([]);
};


/**
 * optional Order order = 4;
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest.Order}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.getOrder = function() {
  return /** @type {!proto.buf.registry.owner.v1.ListUsersRequest.Order} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.owner.v1.ListUsersRequest.Order} value
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.setOrder = function(value) {
  return jspb.Message.setProto3EnumField(this, 4, value);
};


/**
 * repeated UserType has_types = 5;
 * @return {!Array<!proto.buf.registry.owner.v1.UserType>}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.getHasTypesList = function() {
  return /** @type {!Array<!proto.buf.registry.owner.v1.UserType>} */ (jspb.Message.getRepeatedField(this, 5));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.UserType>} value
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.setHasTypesList = function(value) {
  return jspb.Message.setField(this, 5, value || []);
};


/**
 * @param {!proto.buf.registry.owner.v1.UserType} value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.addHasTypes = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 5, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.clearHasTypesList = function() {
  return this.setHasTypesList([]);
};


/**
 * repeated UserState has_states = 6;
 * @return {!Array<!proto.buf.registry.owner.v1.UserState>}
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.getHasStatesList = function() {
  return /** @type {!Array<!proto.buf.registry.owner.v1.UserState>} */ (jspb.Message.getRepeatedField(this, 6));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.UserState>} value
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.setHasStatesList = function(value) {
  return jspb.Message.setField(this, 6, value || []);
};


/**
 * @param {!proto.buf.registry.owner.v1.UserState} value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.addHasStates = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 6, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.ListUsersRequest} returns this
 */
proto.buf.registry.owner.v1.ListUsersRequest.prototype.clearHasStatesList = function() {
  return this.setHasStatesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.ListUsersResponse.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.ListUsersResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.ListUsersResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.ListUsersResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.ListUsersResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
nextPageToken: jspb.Message.getFieldWithDefault(msg, 1, ""),
usersList: jspb.Message.toObjectList(msg.getUsersList(),
    buf_registry_owner_v1_user_pb.User.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.ListUsersResponse}
 */
proto.buf.registry.owner.v1.ListUsersResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.ListUsersResponse;
  return proto.buf.registry.owner.v1.ListUsersResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.ListUsersResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.ListUsersResponse}
 */
proto.buf.registry.owner.v1.ListUsersResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setNextPageToken(value);
      break;
    case 2:
      var value = new buf_registry_owner_v1_user_pb.User;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.User.deserializeBinaryFromReader);
      msg.addUsers(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.ListUsersResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.ListUsersResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.ListUsersResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.ListUsersResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getNextPageToken();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getUsersList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      buf_registry_owner_v1_user_pb.User.serializeBinaryToWriter
    );
  }
};


/**
 * optional string next_page_token = 1;
 * @return {string}
 */
proto.buf.registry.owner.v1.ListUsersResponse.prototype.getNextPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.ListUsersResponse} returns this
 */
proto.buf.registry.owner.v1.ListUsersResponse.prototype.setNextPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * repeated User users = 2;
 * @return {!Array<!proto.buf.registry.owner.v1.User>}
 */
proto.buf.registry.owner.v1.ListUsersResponse.prototype.getUsersList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.User>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_user_pb.User, 2));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.User>} value
 * @return {!proto.buf.registry.owner.v1.ListUsersResponse} returns this
*/
proto.buf.registry.owner.v1.ListUsersResponse.prototype.setUsersList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.User=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.User}
 */
proto.buf.registry.owner.v1.ListUsersResponse.prototype.addUsers = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.buf.registry.owner.v1.User, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.ListUsersResponse} returns this
 */
proto.buf.registry.owner.v1.ListUsersResponse.prototype.clearUsersList = function() {
  return this.setUsersList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.CreateUsersRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.CreateUsersRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateUsersRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.owner.v1.CreateUsersRequest.Value.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.CreateUsersRequest;
  return proto.buf.registry.owner.v1.CreateUsersRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.owner.v1.CreateUsersRequest.Value;
      reader.readMessage(value,proto.buf.registry.owner.v1.CreateUsersRequest.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.CreateUsersRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateUsersRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.owner.v1.CreateUsersRequest.Value.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.CreateUsersRequest.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
name: jspb.Message.getFieldWithDefault(msg, 1, ""),
type: jspb.Message.getFieldWithDefault(msg, 2, 0),
description: jspb.Message.getFieldWithDefault(msg, 3, ""),
url: jspb.Message.getFieldWithDefault(msg, 4, ""),
verificationStatus: jspb.Message.getFieldWithDefault(msg, 5, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest.Value}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.CreateUsersRequest.Value;
  return proto.buf.registry.owner.v1.CreateUsersRequest.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest.Value}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setName(value);
      break;
    case 2:
      var value = /** @type {!proto.buf.registry.owner.v1.UserType} */ (reader.readEnum());
      msg.setType(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setDescription(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    case 5:
      var value = /** @type {!proto.buf.registry.owner.v1.UserVerificationStatus} */ (reader.readEnum());
      msg.setVerificationStatus(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.CreateUsersRequest.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getName();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getType();
  if (f !== 0.0) {
    writer.writeEnum(
      2,
      f
    );
  }
  f = message.getDescription();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getUrl();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getVerificationStatus();
  if (f !== 0.0) {
    writer.writeEnum(
      5,
      f
    );
  }
};


/**
 * optional string name = 1;
 * @return {string}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.getName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.setName = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional UserType type = 2;
 * @return {!proto.buf.registry.owner.v1.UserType}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.getType = function() {
  return /** @type {!proto.buf.registry.owner.v1.UserType} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {!proto.buf.registry.owner.v1.UserType} value
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.setType = function(value) {
  return jspb.Message.setProto3EnumField(this, 2, value);
};


/**
 * optional string description = 3;
 * @return {string}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.getDescription = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.setDescription = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string url = 4;
 * @return {string}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.setUrl = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional UserVerificationStatus verification_status = 5;
 * @return {!proto.buf.registry.owner.v1.UserVerificationStatus}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.getVerificationStatus = function() {
  return /** @type {!proto.buf.registry.owner.v1.UserVerificationStatus} */ (jspb.Message.getFieldWithDefault(this, 5, 0));
};


/**
 * @param {!proto.buf.registry.owner.v1.UserVerificationStatus} value
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateUsersRequest.Value.prototype.setVerificationStatus = function(value) {
  return jspb.Message.setProto3EnumField(this, 5, value);
};


/**
 * repeated Value values = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.CreateUsersRequest.Value>}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.CreateUsersRequest.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.owner.v1.CreateUsersRequest.Value, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.CreateUsersRequest.Value>} value
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest} returns this
*/
proto.buf.registry.owner.v1.CreateUsersRequest.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest.Value}
 */
proto.buf.registry.owner.v1.CreateUsersRequest.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.CreateUsersRequest.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.CreateUsersRequest} returns this
 */
proto.buf.registry.owner.v1.CreateUsersRequest.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.CreateUsersResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.CreateUsersResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.CreateUsersResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.CreateUsersResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateUsersResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
usersList: jspb.Message.toObjectList(msg.getUsersList(),
    buf_registry_owner_v1_user_pb.User.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.CreateUsersResponse}
 */
proto.buf.registry.owner.v1.CreateUsersResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.CreateUsersResponse;
  return proto.buf.registry.owner.v1.CreateUsersResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.CreateUsersResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.CreateUsersResponse}
 */
proto.buf.registry.owner.v1.CreateUsersResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_user_pb.User;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.User.deserializeBinaryFromReader);
      msg.addUsers(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.CreateUsersResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.CreateUsersResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.CreateUsersResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateUsersResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUsersList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_user_pb.User.serializeBinaryToWriter
    );
  }
};


/**
 * repeated User users = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.User>}
 */
proto.buf.registry.owner.v1.CreateUsersResponse.prototype.getUsersList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.User>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_user_pb.User, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.User>} value
 * @return {!proto.buf.registry.owner.v1.CreateUsersResponse} returns this
*/
proto.buf.registry.owner.v1.CreateUsersResponse.prototype.setUsersList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.User=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.User}
 */
proto.buf.registry.owner.v1.CreateUsersResponse.prototype.addUsers = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.User, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.CreateUsersResponse} returns this
 */
proto.buf.registry.owner.v1.CreateUsersResponse.prototype.clearUsersList = function() {
  return this.setUsersList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.UpdateUsersRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.owner.v1.UpdateUsersRequest.Value.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.UpdateUsersRequest;
  return proto.buf.registry.owner.v1.UpdateUsersRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.owner.v1.UpdateUsersRequest.Value;
      reader.readMessage(value,proto.buf.registry.owner.v1.UpdateUsersRequest.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.UpdateUsersRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.owner.v1.UpdateUsersRequest.Value.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.UpdateUsersRequest.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
userRef: (f = msg.getUserRef()) && buf_registry_owner_v1_user_pb.UserRef.toObject(includeInstance, f),
state: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f,
description: (f = jspb.Message.getField(msg, 3)) == null ? undefined : f,
url: (f = jspb.Message.getField(msg, 4)) == null ? undefined : f,
verificationStatus: (f = jspb.Message.getField(msg, 5)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.UpdateUsersRequest.Value;
  return proto.buf.registry.owner.v1.UpdateUsersRequest.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_user_pb.UserRef;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.UserRef.deserializeBinaryFromReader);
      msg.setUserRef(value);
      break;
    case 2:
      var value = /** @type {!proto.buf.registry.owner.v1.UserState} */ (reader.readEnum());
      msg.setState(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setDescription(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    case 5:
      var value = /** @type {!proto.buf.registry.owner.v1.UserVerificationStatus} */ (reader.readEnum());
      msg.setVerificationStatus(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.UpdateUsersRequest.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUserRef();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_owner_v1_user_pb.UserRef.serializeBinaryToWriter
    );
  }
  f = /** @type {!proto.buf.registry.owner.v1.UserState} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeEnum(
      2,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeString(
      3,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 4));
  if (f != null) {
    writer.writeString(
      4,
      f
    );
  }
  f = /** @type {!proto.buf.registry.owner.v1.UserVerificationStatus} */ (jspb.Message.getField(message, 5));
  if (f != null) {
    writer.writeEnum(
      5,
      f
    );
  }
};


/**
 * optional UserRef user_ref = 1;
 * @return {?proto.buf.registry.owner.v1.UserRef}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.getUserRef = function() {
  return /** @type{?proto.buf.registry.owner.v1.UserRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_owner_v1_user_pb.UserRef, 1));
};


/**
 * @param {?proto.buf.registry.owner.v1.UserRef|undefined} value
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
*/
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.setUserRef = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.clearUserRef = function() {
  return this.setUserRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.hasUserRef = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional UserState state = 2;
 * @return {!proto.buf.registry.owner.v1.UserState}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.getState = function() {
  return /** @type {!proto.buf.registry.owner.v1.UserState} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {!proto.buf.registry.owner.v1.UserState} value
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.setState = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.clearState = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.hasState = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional string description = 3;
 * @return {string}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.getDescription = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.setDescription = function(value) {
  return jspb.Message.setField(this, 3, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.clearDescription = function() {
  return jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.hasDescription = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional string url = 4;
 * @return {string}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.setUrl = function(value) {
  return jspb.Message.setField(this, 4, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.clearUrl = function() {
  return jspb.Message.setField(this, 4, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.hasUrl = function() {
  return jspb.Message.getField(this, 4) != null;
};


/**
 * optional UserVerificationStatus verification_status = 5;
 * @return {!proto.buf.registry.owner.v1.UserVerificationStatus}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.getVerificationStatus = function() {
  return /** @type {!proto.buf.registry.owner.v1.UserVerificationStatus} */ (jspb.Message.getFieldWithDefault(this, 5, 0));
};


/**
 * @param {!proto.buf.registry.owner.v1.UserVerificationStatus} value
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.setVerificationStatus = function(value) {
  return jspb.Message.setField(this, 5, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.clearVerificationStatus = function() {
  return jspb.Message.setField(this, 5, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.Value.prototype.hasVerificationStatus = function() {
  return jspb.Message.getField(this, 5) != null;
};


/**
 * repeated Value values = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.UpdateUsersRequest.Value>}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.UpdateUsersRequest.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.owner.v1.UpdateUsersRequest.Value, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.UpdateUsersRequest.Value>} value
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest} returns this
*/
proto.buf.registry.owner.v1.UpdateUsersRequest.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest.Value}
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.UpdateUsersRequest.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersRequest} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersRequest.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.UpdateUsersResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.UpdateUsersResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
usersList: jspb.Message.toObjectList(msg.getUsersList(),
    buf_registry_owner_v1_user_pb.User.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersResponse}
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.UpdateUsersResponse;
  return proto.buf.registry.owner.v1.UpdateUsersResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.UpdateUsersResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersResponse}
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_user_pb.User;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.User.deserializeBinaryFromReader);
      msg.addUsers(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.UpdateUsersResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.UpdateUsersResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUsersList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_user_pb.User.serializeBinaryToWriter
    );
  }
};


/**
 * repeated User users = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.User>}
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.prototype.getUsersList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.User>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_user_pb.User, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.User>} value
 * @return {!proto.buf.registry.owner.v1.UpdateUsersResponse} returns this
*/
proto.buf.registry.owner.v1.UpdateUsersResponse.prototype.setUsersList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.User=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.User}
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.prototype.addUsers = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.User, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.UpdateUsersResponse} returns this
 */
proto.buf.registry.owner.v1.UpdateUsersResponse.prototype.clearUsersList = function() {
  return this.setUsersList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.DeleteUsersRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.DeleteUsersRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
userRefsList: jspb.Message.toObjectList(msg.getUserRefsList(),
    buf_registry_owner_v1_user_pb.UserRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.DeleteUsersRequest}
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.DeleteUsersRequest;
  return proto.buf.registry.owner.v1.DeleteUsersRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.DeleteUsersRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.DeleteUsersRequest}
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_user_pb.UserRef;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.UserRef.deserializeBinaryFromReader);
      msg.addUserRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.DeleteUsersRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.DeleteUsersRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUserRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_user_pb.UserRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated UserRef user_refs = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.UserRef>}
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.prototype.getUserRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.UserRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_user_pb.UserRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.UserRef>} value
 * @return {!proto.buf.registry.owner.v1.DeleteUsersRequest} returns this
*/
proto.buf.registry.owner.v1.DeleteUsersRequest.prototype.setUserRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.UserRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.UserRef}
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.prototype.addUserRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.UserRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.DeleteUsersRequest} returns this
 */
proto.buf.registry.owner.v1.DeleteUsersRequest.prototype.clearUserRefsList = function() {
  return this.setUserRefsList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.DeleteUsersResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.DeleteUsersResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.DeleteUsersResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.DeleteUsersResponse.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.DeleteUsersResponse}
 */
proto.buf.registry.owner.v1.DeleteUsersResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.DeleteUsersResponse;
  return proto.buf.registry.owner.v1.DeleteUsersResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.DeleteUsersResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.DeleteUsersResponse}
 */
proto.buf.registry.owner.v1.DeleteUsersResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.DeleteUsersResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.DeleteUsersResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.DeleteUsersResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.DeleteUsersResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};


goog.object.extend(exports, proto.buf.registry.owner.v1);
