// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview gRPC-Web generated client stub for buf.registry.owner.v1
 * @enhanceable
 * @public
 */

// Code generated by protoc-gen-grpc-web. DO NOT EDIT.
// versions:
// 	protoc-gen-grpc-web v1.5.0
// 	protoc              v0.0.0
// source: buf/registry/owner/v1/user_service.proto


/* eslint-disable */
// @ts-nocheck



const grpc = {};
grpc.web = require('grpc-web');


var buf_registry_owner_v1_organization_pb = require('../../../../buf/registry/owner/v1/organization_pb.js')

var buf_registry_owner_v1_user_pb = require('../../../../buf/registry/owner/v1/user_pb.js')

var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js')
const proto = {};
proto.buf = {};
proto.buf.registry = {};
proto.buf.registry.owner = {};
proto.buf.registry.owner.v1 = require('./user_service_pb.js');

/**
 * @param {string} hostname
 * @param {?Object} credentials
 * @param {?grpc.web.ClientOptions} options
 * @constructor
 * @struct
 * @final
 */
proto.buf.registry.owner.v1.UserServiceClient =
    function(hostname, credentials, options) {
  if (!options) options = {};
  options.format = 'binary';

  /**
   * @private @const {!grpc.web.GrpcWebClientBase} The client
   */
  this.client_ = new grpc.web.GrpcWebClientBase(options);

  /**
   * @private @const {string} The hostname
   */
  this.hostname_ = hostname.replace(/\/+$/, '');

};


/**
 * @param {string} hostname
 * @param {?Object} credentials
 * @param {?grpc.web.ClientOptions} options
 * @constructor
 * @struct
 * @final
 */
proto.buf.registry.owner.v1.UserServicePromiseClient =
    function(hostname, credentials, options) {
  if (!options) options = {};
  options.format = 'binary';

  /**
   * @private @const {!grpc.web.GrpcWebClientBase} The client
   */
  this.client_ = new grpc.web.GrpcWebClientBase(options);

  /**
   * @private @const {string} The hostname
   */
  this.hostname_ = hostname.replace(/\/+$/, '');

};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.GetUsersRequest,
 *   !proto.buf.registry.owner.v1.GetUsersResponse>}
 */
const methodDescriptor_UserService_GetUsers = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.UserService/GetUsers',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.GetUsersRequest,
  proto.buf.registry.owner.v1.GetUsersResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.GetUsersRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.GetUsersResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.GetUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.GetUsersResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.GetUsersResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.UserServiceClient.prototype.getUsers =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/GetUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_GetUsers,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.GetUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.GetUsersResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.UserServicePromiseClient.prototype.getUsers =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/GetUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_GetUsers);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.ListUsersRequest,
 *   !proto.buf.registry.owner.v1.ListUsersResponse>}
 */
const methodDescriptor_UserService_ListUsers = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.UserService/ListUsers',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.ListUsersRequest,
  proto.buf.registry.owner.v1.ListUsersResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.ListUsersRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.ListUsersResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.ListUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.ListUsersResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.ListUsersResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.UserServiceClient.prototype.listUsers =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/ListUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_ListUsers,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.ListUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.ListUsersResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.UserServicePromiseClient.prototype.listUsers =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/ListUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_ListUsers);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.CreateUsersRequest,
 *   !proto.buf.registry.owner.v1.CreateUsersResponse>}
 */
const methodDescriptor_UserService_CreateUsers = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.UserService/CreateUsers',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.CreateUsersRequest,
  proto.buf.registry.owner.v1.CreateUsersResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.CreateUsersRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.CreateUsersResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.CreateUsersResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.CreateUsersResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.UserServiceClient.prototype.createUsers =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/CreateUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_CreateUsers,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.CreateUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.CreateUsersResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.UserServicePromiseClient.prototype.createUsers =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/CreateUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_CreateUsers);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.UpdateUsersRequest,
 *   !proto.buf.registry.owner.v1.UpdateUsersResponse>}
 */
const methodDescriptor_UserService_UpdateUsers = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.UserService/UpdateUsers',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.UpdateUsersRequest,
  proto.buf.registry.owner.v1.UpdateUsersResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.UpdateUsersResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.UpdateUsersResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.UpdateUsersResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.UserServiceClient.prototype.updateUsers =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/UpdateUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_UpdateUsers,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.UpdateUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.UpdateUsersResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.UserServicePromiseClient.prototype.updateUsers =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/UpdateUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_UpdateUsers);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.DeleteUsersRequest,
 *   !proto.buf.registry.owner.v1.DeleteUsersResponse>}
 */
const methodDescriptor_UserService_DeleteUsers = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.UserService/DeleteUsers',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.DeleteUsersRequest,
  proto.buf.registry.owner.v1.DeleteUsersResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.DeleteUsersRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.DeleteUsersResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.DeleteUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.DeleteUsersResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.DeleteUsersResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.UserServiceClient.prototype.deleteUsers =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/DeleteUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_DeleteUsers,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.DeleteUsersRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.DeleteUsersResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.UserServicePromiseClient.prototype.deleteUsers =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.UserService/DeleteUsers',
      request,
      metadata || {},
      methodDescriptor_UserService_DeleteUsers);
};


module.exports = proto.buf.registry.owner.v1;

