// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/owner/v1/owner.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_owner_v1_organization_pb = require('../../../../buf/registry/owner/v1/organization_pb.js');
goog.object.extend(proto, buf_registry_owner_v1_organization_pb);
var buf_registry_owner_v1_user_pb = require('../../../../buf/registry/owner/v1/user_pb.js');
goog.object.extend(proto, buf_registry_owner_v1_user_pb);
var buf_registry_priv_extension_v1beta1_extension_pb = require('../../../../buf/registry/priv/extension/v1beta1/extension_pb.js');
goog.object.extend(proto, buf_registry_priv_extension_v1beta1_extension_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.owner.v1.Owner', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.Owner.ValueCase', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.OwnerRef', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.OwnerRef.ValueCase', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.Owner = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, proto.buf.registry.owner.v1.Owner.oneofGroups_);
};
goog.inherits(proto.buf.registry.owner.v1.Owner, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.Owner.displayName = 'proto.buf.registry.owner.v1.Owner';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.OwnerRef = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, proto.buf.registry.owner.v1.OwnerRef.oneofGroups_);
};
goog.inherits(proto.buf.registry.owner.v1.OwnerRef, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.OwnerRef.displayName = 'proto.buf.registry.owner.v1.OwnerRef';
}

/**
 * Oneof group definitions for this message. Each group defines the field
 * numbers belonging to that group. When of these fields' value is set, all
 * other fields in the group are cleared. During deserialization, if multiple
 * fields are encountered for a group, only the last value seen will be kept.
 * @private {!Array<!Array<number>>}
 * @const
 */
proto.buf.registry.owner.v1.Owner.oneofGroups_ = [[1,2]];

/**
 * @enum {number}
 */
proto.buf.registry.owner.v1.Owner.ValueCase = {
  VALUE_NOT_SET: 0,
  USER: 1,
  ORGANIZATION: 2
};

/**
 * @return {proto.buf.registry.owner.v1.Owner.ValueCase}
 */
proto.buf.registry.owner.v1.Owner.prototype.getValueCase = function() {
  return /** @type {proto.buf.registry.owner.v1.Owner.ValueCase} */(jspb.Message.computeOneofCase(this, proto.buf.registry.owner.v1.Owner.oneofGroups_[0]));
};



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.Owner.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.Owner.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.Owner} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.Owner.toObject = function(includeInstance, msg) {
  var f, obj = {
user: (f = msg.getUser()) && buf_registry_owner_v1_user_pb.User.toObject(includeInstance, f),
organization: (f = msg.getOrganization()) && buf_registry_owner_v1_organization_pb.Organization.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.Owner}
 */
proto.buf.registry.owner.v1.Owner.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.Owner;
  return proto.buf.registry.owner.v1.Owner.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.Owner} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.Owner}
 */
proto.buf.registry.owner.v1.Owner.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_user_pb.User;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.User.deserializeBinaryFromReader);
      msg.setUser(value);
      break;
    case 2:
      var value = new buf_registry_owner_v1_organization_pb.Organization;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.Organization.deserializeBinaryFromReader);
      msg.setOrganization(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.Owner.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.Owner.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.Owner} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.Owner.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUser();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_owner_v1_user_pb.User.serializeBinaryToWriter
    );
  }
  f = message.getOrganization();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      buf_registry_owner_v1_organization_pb.Organization.serializeBinaryToWriter
    );
  }
};


/**
 * optional User user = 1;
 * @return {?proto.buf.registry.owner.v1.User}
 */
proto.buf.registry.owner.v1.Owner.prototype.getUser = function() {
  return /** @type{?proto.buf.registry.owner.v1.User} */ (
    jspb.Message.getWrapperField(this, buf_registry_owner_v1_user_pb.User, 1));
};


/**
 * @param {?proto.buf.registry.owner.v1.User|undefined} value
 * @return {!proto.buf.registry.owner.v1.Owner} returns this
*/
proto.buf.registry.owner.v1.Owner.prototype.setUser = function(value) {
  return jspb.Message.setOneofWrapperField(this, 1, proto.buf.registry.owner.v1.Owner.oneofGroups_[0], value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.owner.v1.Owner} returns this
 */
proto.buf.registry.owner.v1.Owner.prototype.clearUser = function() {
  return this.setUser(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.Owner.prototype.hasUser = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional Organization organization = 2;
 * @return {?proto.buf.registry.owner.v1.Organization}
 */
proto.buf.registry.owner.v1.Owner.prototype.getOrganization = function() {
  return /** @type{?proto.buf.registry.owner.v1.Organization} */ (
    jspb.Message.getWrapperField(this, buf_registry_owner_v1_organization_pb.Organization, 2));
};


/**
 * @param {?proto.buf.registry.owner.v1.Organization|undefined} value
 * @return {!proto.buf.registry.owner.v1.Owner} returns this
*/
proto.buf.registry.owner.v1.Owner.prototype.setOrganization = function(value) {
  return jspb.Message.setOneofWrapperField(this, 2, proto.buf.registry.owner.v1.Owner.oneofGroups_[0], value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.owner.v1.Owner} returns this
 */
proto.buf.registry.owner.v1.Owner.prototype.clearOrganization = function() {
  return this.setOrganization(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.Owner.prototype.hasOrganization = function() {
  return jspb.Message.getField(this, 2) != null;
};



/**
 * Oneof group definitions for this message. Each group defines the field
 * numbers belonging to that group. When of these fields' value is set, all
 * other fields in the group are cleared. During deserialization, if multiple
 * fields are encountered for a group, only the last value seen will be kept.
 * @private {!Array<!Array<number>>}
 * @const
 */
proto.buf.registry.owner.v1.OwnerRef.oneofGroups_ = [[1,2]];

/**
 * @enum {number}
 */
proto.buf.registry.owner.v1.OwnerRef.ValueCase = {
  VALUE_NOT_SET: 0,
  ID: 1,
  NAME: 2
};

/**
 * @return {proto.buf.registry.owner.v1.OwnerRef.ValueCase}
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.getValueCase = function() {
  return /** @type {proto.buf.registry.owner.v1.OwnerRef.ValueCase} */(jspb.Message.computeOneofCase(this, proto.buf.registry.owner.v1.OwnerRef.oneofGroups_[0]));
};



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.OwnerRef.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.OwnerRef} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.OwnerRef.toObject = function(includeInstance, msg) {
  var f, obj = {
id: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
name: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.OwnerRef}
 */
proto.buf.registry.owner.v1.OwnerRef.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.OwnerRef;
  return proto.buf.registry.owner.v1.OwnerRef.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.OwnerRef} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.OwnerRef}
 */
proto.buf.registry.owner.v1.OwnerRef.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setName(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.OwnerRef.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.OwnerRef} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.OwnerRef.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {string} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeString(
      1,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string id = 1;
 * @return {string}
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.getId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.OwnerRef} returns this
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.setId = function(value) {
  return jspb.Message.setOneofField(this, 1, proto.buf.registry.owner.v1.OwnerRef.oneofGroups_[0], value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.OwnerRef} returns this
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.clearId = function() {
  return jspb.Message.setOneofField(this, 1, proto.buf.registry.owner.v1.OwnerRef.oneofGroups_[0], undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.hasId = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional string name = 2;
 * @return {string}
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.getName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.OwnerRef} returns this
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.setName = function(value) {
  return jspb.Message.setOneofField(this, 2, proto.buf.registry.owner.v1.OwnerRef.oneofGroups_[0], value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.OwnerRef} returns this
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.clearName = function() {
  return jspb.Message.setOneofField(this, 2, proto.buf.registry.owner.v1.OwnerRef.oneofGroups_[0], undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.OwnerRef.prototype.hasName = function() {
  return jspb.Message.getField(this, 2) != null;
};


goog.object.extend(exports, proto.buf.registry.owner.v1);
