// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/owner/v1/organization_service.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_owner_v1_organization_pb = require('../../../../buf/registry/owner/v1/organization_pb.js');
goog.object.extend(proto, buf_registry_owner_v1_organization_pb);
var buf_registry_owner_v1_user_pb = require('../../../../buf/registry/owner/v1/user_pb.js');
goog.object.extend(proto, buf_registry_owner_v1_user_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.owner.v1.CreateOrganizationsRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.CreateOrganizationsResponse', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.DeleteOrganizationsRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.DeleteOrganizationsResponse', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.GetOrganizationsRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.GetOrganizationsResponse', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.ListOrganizationsRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.ListOrganizationsRequest.Order', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.ListOrganizationsResponse', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.UpdateOrganizationsRequest', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value', null, global);
goog.exportSymbol('proto.buf.registry.owner.v1.UpdateOrganizationsResponse', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.GetOrganizationsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.GetOrganizationsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.GetOrganizationsRequest.displayName = 'proto.buf.registry.owner.v1.GetOrganizationsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.GetOrganizationsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.GetOrganizationsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.GetOrganizationsResponse.displayName = 'proto.buf.registry.owner.v1.GetOrganizationsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.ListOrganizationsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.ListOrganizationsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.ListOrganizationsRequest.displayName = 'proto.buf.registry.owner.v1.ListOrganizationsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.ListOrganizationsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.ListOrganizationsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.ListOrganizationsResponse.displayName = 'proto.buf.registry.owner.v1.ListOrganizationsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.CreateOrganizationsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.CreateOrganizationsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.CreateOrganizationsRequest.displayName = 'proto.buf.registry.owner.v1.CreateOrganizationsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.displayName = 'proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.CreateOrganizationsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.CreateOrganizationsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.CreateOrganizationsResponse.displayName = 'proto.buf.registry.owner.v1.CreateOrganizationsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.UpdateOrganizationsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.UpdateOrganizationsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.UpdateOrganizationsRequest.displayName = 'proto.buf.registry.owner.v1.UpdateOrganizationsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.displayName = 'proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.UpdateOrganizationsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.UpdateOrganizationsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.UpdateOrganizationsResponse.displayName = 'proto.buf.registry.owner.v1.UpdateOrganizationsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.owner.v1.DeleteOrganizationsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.owner.v1.DeleteOrganizationsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.DeleteOrganizationsRequest.displayName = 'proto.buf.registry.owner.v1.DeleteOrganizationsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.owner.v1.DeleteOrganizationsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.owner.v1.DeleteOrganizationsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.owner.v1.DeleteOrganizationsResponse.displayName = 'proto.buf.registry.owner.v1.DeleteOrganizationsResponse';
}

/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.GetOrganizationsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.GetOrganizationsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
organizationRefsList: jspb.Message.toObjectList(msg.getOrganizationRefsList(),
    buf_registry_owner_v1_organization_pb.OrganizationRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.GetOrganizationsRequest}
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.GetOrganizationsRequest;
  return proto.buf.registry.owner.v1.GetOrganizationsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.GetOrganizationsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.GetOrganizationsRequest}
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_organization_pb.OrganizationRef;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.OrganizationRef.deserializeBinaryFromReader);
      msg.addOrganizationRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.GetOrganizationsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.GetOrganizationsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOrganizationRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_organization_pb.OrganizationRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated OrganizationRef organization_refs = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.OrganizationRef>}
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.prototype.getOrganizationRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.OrganizationRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_organization_pb.OrganizationRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.OrganizationRef>} value
 * @return {!proto.buf.registry.owner.v1.GetOrganizationsRequest} returns this
*/
proto.buf.registry.owner.v1.GetOrganizationsRequest.prototype.setOrganizationRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.OrganizationRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.OrganizationRef}
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.prototype.addOrganizationRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.OrganizationRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.GetOrganizationsRequest} returns this
 */
proto.buf.registry.owner.v1.GetOrganizationsRequest.prototype.clearOrganizationRefsList = function() {
  return this.setOrganizationRefsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.GetOrganizationsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.GetOrganizationsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
organizationsList: jspb.Message.toObjectList(msg.getOrganizationsList(),
    buf_registry_owner_v1_organization_pb.Organization.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.GetOrganizationsResponse}
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.GetOrganizationsResponse;
  return proto.buf.registry.owner.v1.GetOrganizationsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.GetOrganizationsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.GetOrganizationsResponse}
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_organization_pb.Organization;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.Organization.deserializeBinaryFromReader);
      msg.addOrganizations(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.GetOrganizationsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.GetOrganizationsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOrganizationsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_organization_pb.Organization.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Organization organizations = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.Organization>}
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.prototype.getOrganizationsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.Organization>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_organization_pb.Organization, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.Organization>} value
 * @return {!proto.buf.registry.owner.v1.GetOrganizationsResponse} returns this
*/
proto.buf.registry.owner.v1.GetOrganizationsResponse.prototype.setOrganizationsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.Organization=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.Organization}
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.prototype.addOrganizations = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.Organization, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.GetOrganizationsResponse} returns this
 */
proto.buf.registry.owner.v1.GetOrganizationsResponse.prototype.clearOrganizationsList = function() {
  return this.setOrganizationsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.repeatedFields_ = [3];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.ListOrganizationsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
pageSize: jspb.Message.getFieldWithDefault(msg, 1, 0),
pageToken: jspb.Message.getFieldWithDefault(msg, 2, ""),
userRefsList: jspb.Message.toObjectList(msg.getUserRefsList(),
    buf_registry_owner_v1_user_pb.UserRef.toObject, includeInstance),
order: jspb.Message.getFieldWithDefault(msg, 4, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsRequest}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.ListOrganizationsRequest;
  return proto.buf.registry.owner.v1.ListOrganizationsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsRequest}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setPageSize(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setPageToken(value);
      break;
    case 3:
      var value = new buf_registry_owner_v1_user_pb.UserRef;
      reader.readMessage(value,buf_registry_owner_v1_user_pb.UserRef.deserializeBinaryFromReader);
      msg.addUserRefs(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.owner.v1.ListOrganizationsRequest.Order} */ (reader.readEnum());
      msg.setOrder(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.ListOrganizationsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPageSize();
  if (f !== 0) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = message.getPageToken();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getUserRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      3,
      f,
      buf_registry_owner_v1_user_pb.UserRef.serializeBinaryToWriter
    );
  }
  f = message.getOrder();
  if (f !== 0.0) {
    writer.writeEnum(
      4,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.Order = {
  ORDER_UNSPECIFIED: 0,
  ORDER_CREATE_TIME_DESC: 1,
  ORDER_CREATE_TIME_ASC: 2
};

/**
 * optional uint32 page_size = 1;
 * @return {number}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.getPageSize = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsRequest} returns this
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.setPageSize = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string page_token = 2;
 * @return {string}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.getPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsRequest} returns this
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.setPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * repeated UserRef user_refs = 3;
 * @return {!Array<!proto.buf.registry.owner.v1.UserRef>}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.getUserRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.UserRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_user_pb.UserRef, 3));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.UserRef>} value
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsRequest} returns this
*/
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.setUserRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 3, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.UserRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.UserRef}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.addUserRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 3, opt_value, proto.buf.registry.owner.v1.UserRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsRequest} returns this
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.clearUserRefsList = function() {
  return this.setUserRefsList([]);
};


/**
 * optional Order order = 4;
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsRequest.Order}
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.getOrder = function() {
  return /** @type {!proto.buf.registry.owner.v1.ListOrganizationsRequest.Order} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsRequest.Order} value
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsRequest} returns this
 */
proto.buf.registry.owner.v1.ListOrganizationsRequest.prototype.setOrder = function(value) {
  return jspb.Message.setProto3EnumField(this, 4, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.ListOrganizationsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
nextPageToken: jspb.Message.getFieldWithDefault(msg, 1, ""),
organizationsList: jspb.Message.toObjectList(msg.getOrganizationsList(),
    buf_registry_owner_v1_organization_pb.Organization.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsResponse}
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.ListOrganizationsResponse;
  return proto.buf.registry.owner.v1.ListOrganizationsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsResponse}
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setNextPageToken(value);
      break;
    case 2:
      var value = new buf_registry_owner_v1_organization_pb.Organization;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.Organization.deserializeBinaryFromReader);
      msg.addOrganizations(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.ListOrganizationsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getNextPageToken();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getOrganizationsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      buf_registry_owner_v1_organization_pb.Organization.serializeBinaryToWriter
    );
  }
};


/**
 * optional string next_page_token = 1;
 * @return {string}
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.prototype.getNextPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsResponse} returns this
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.prototype.setNextPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * repeated Organization organizations = 2;
 * @return {!Array<!proto.buf.registry.owner.v1.Organization>}
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.prototype.getOrganizationsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.Organization>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_organization_pb.Organization, 2));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.Organization>} value
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsResponse} returns this
*/
proto.buf.registry.owner.v1.ListOrganizationsResponse.prototype.setOrganizationsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.Organization=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.Organization}
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.prototype.addOrganizations = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.buf.registry.owner.v1.Organization, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.ListOrganizationsResponse} returns this
 */
proto.buf.registry.owner.v1.ListOrganizationsResponse.prototype.clearOrganizationsList = function() {
  return this.setOrganizationsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.CreateOrganizationsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.CreateOrganizationsRequest;
  return proto.buf.registry.owner.v1.CreateOrganizationsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value;
      reader.readMessage(value,proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.CreateOrganizationsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
name: jspb.Message.getFieldWithDefault(msg, 1, ""),
description: jspb.Message.getFieldWithDefault(msg, 2, ""),
url: jspb.Message.getFieldWithDefault(msg, 3, ""),
verificationStatus: jspb.Message.getFieldWithDefault(msg, 4, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value;
  return proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setName(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setDescription(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.owner.v1.OrganizationVerificationStatus} */ (reader.readEnum());
      msg.setVerificationStatus(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getName();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getDescription();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getUrl();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getVerificationStatus();
  if (f !== 0.0) {
    writer.writeEnum(
      4,
      f
    );
  }
};


/**
 * optional string name = 1;
 * @return {string}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.getName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.setName = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string description = 2;
 * @return {string}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.getDescription = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.setDescription = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string url = 3;
 * @return {string}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.setUrl = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional OrganizationVerificationStatus verification_status = 4;
 * @return {!proto.buf.registry.owner.v1.OrganizationVerificationStatus}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.getVerificationStatus = function() {
  return /** @type {!proto.buf.registry.owner.v1.OrganizationVerificationStatus} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.owner.v1.OrganizationVerificationStatus} value
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value.prototype.setVerificationStatus = function(value) {
  return jspb.Message.setProto3EnumField(this, 4, value);
};


/**
 * repeated Value values = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value>}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value>} value
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest} returns this
*/
proto.buf.registry.owner.v1.CreateOrganizationsRequest.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value}
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.CreateOrganizationsRequest.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsRequest} returns this
 */
proto.buf.registry.owner.v1.CreateOrganizationsRequest.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.CreateOrganizationsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
organizationsList: jspb.Message.toObjectList(msg.getOrganizationsList(),
    buf_registry_owner_v1_organization_pb.Organization.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsResponse}
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.CreateOrganizationsResponse;
  return proto.buf.registry.owner.v1.CreateOrganizationsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsResponse}
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_organization_pb.Organization;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.Organization.deserializeBinaryFromReader);
      msg.addOrganizations(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.CreateOrganizationsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOrganizationsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_organization_pb.Organization.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Organization organizations = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.Organization>}
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.prototype.getOrganizationsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.Organization>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_organization_pb.Organization, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.Organization>} value
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsResponse} returns this
*/
proto.buf.registry.owner.v1.CreateOrganizationsResponse.prototype.setOrganizationsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.Organization=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.Organization}
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.prototype.addOrganizations = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.Organization, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.CreateOrganizationsResponse} returns this
 */
proto.buf.registry.owner.v1.CreateOrganizationsResponse.prototype.clearOrganizationsList = function() {
  return this.setOrganizationsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.UpdateOrganizationsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.UpdateOrganizationsRequest;
  return proto.buf.registry.owner.v1.UpdateOrganizationsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value;
      reader.readMessage(value,proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.UpdateOrganizationsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
organizationRef: (f = msg.getOrganizationRef()) && buf_registry_owner_v1_organization_pb.OrganizationRef.toObject(includeInstance, f),
description: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f,
url: (f = jspb.Message.getField(msg, 3)) == null ? undefined : f,
verificationStatus: (f = jspb.Message.getField(msg, 4)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value;
  return proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_organization_pb.OrganizationRef;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.OrganizationRef.deserializeBinaryFromReader);
      msg.setOrganizationRef(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setDescription(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.owner.v1.OrganizationVerificationStatus} */ (reader.readEnum());
      msg.setVerificationStatus(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOrganizationRef();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_owner_v1_organization_pb.OrganizationRef.serializeBinaryToWriter
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeString(
      2,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeString(
      3,
      f
    );
  }
  f = /** @type {!proto.buf.registry.owner.v1.OrganizationVerificationStatus} */ (jspb.Message.getField(message, 4));
  if (f != null) {
    writer.writeEnum(
      4,
      f
    );
  }
};


/**
 * optional OrganizationRef organization_ref = 1;
 * @return {?proto.buf.registry.owner.v1.OrganizationRef}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.getOrganizationRef = function() {
  return /** @type{?proto.buf.registry.owner.v1.OrganizationRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_owner_v1_organization_pb.OrganizationRef, 1));
};


/**
 * @param {?proto.buf.registry.owner.v1.OrganizationRef|undefined} value
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} returns this
*/
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.setOrganizationRef = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.clearOrganizationRef = function() {
  return this.setOrganizationRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.hasOrganizationRef = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional string description = 2;
 * @return {string}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.getDescription = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.setDescription = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.clearDescription = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.hasDescription = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional string url = 3;
 * @return {string}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.setUrl = function(value) {
  return jspb.Message.setField(this, 3, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.clearUrl = function() {
  return jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.hasUrl = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional OrganizationVerificationStatus verification_status = 4;
 * @return {!proto.buf.registry.owner.v1.OrganizationVerificationStatus}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.getVerificationStatus = function() {
  return /** @type {!proto.buf.registry.owner.v1.OrganizationVerificationStatus} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.owner.v1.OrganizationVerificationStatus} value
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.setVerificationStatus = function(value) {
  return jspb.Message.setField(this, 4, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.clearVerificationStatus = function() {
  return jspb.Message.setField(this, 4, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value.prototype.hasVerificationStatus = function() {
  return jspb.Message.getField(this, 4) != null;
};


/**
 * repeated Value values = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value>}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value>} value
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest} returns this
*/
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.UpdateOrganizationsRequest.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsRequest.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.UpdateOrganizationsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
organizationsList: jspb.Message.toObjectList(msg.getOrganizationsList(),
    buf_registry_owner_v1_organization_pb.Organization.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsResponse}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.UpdateOrganizationsResponse;
  return proto.buf.registry.owner.v1.UpdateOrganizationsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsResponse}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_organization_pb.Organization;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.Organization.deserializeBinaryFromReader);
      msg.addOrganizations(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.UpdateOrganizationsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOrganizationsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_organization_pb.Organization.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Organization organizations = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.Organization>}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.prototype.getOrganizationsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.Organization>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_organization_pb.Organization, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.Organization>} value
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsResponse} returns this
*/
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.prototype.setOrganizationsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.Organization=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.Organization}
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.prototype.addOrganizations = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.Organization, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.UpdateOrganizationsResponse} returns this
 */
proto.buf.registry.owner.v1.UpdateOrganizationsResponse.prototype.clearOrganizationsList = function() {
  return this.setOrganizationsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.DeleteOrganizationsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
organizationRefsList: jspb.Message.toObjectList(msg.getOrganizationRefsList(),
    buf_registry_owner_v1_organization_pb.OrganizationRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.DeleteOrganizationsRequest;
  return proto.buf.registry.owner.v1.DeleteOrganizationsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_organization_pb.OrganizationRef;
      reader.readMessage(value,buf_registry_owner_v1_organization_pb.OrganizationRef.deserializeBinaryFromReader);
      msg.addOrganizationRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.DeleteOrganizationsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOrganizationRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_owner_v1_organization_pb.OrganizationRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated OrganizationRef organization_refs = 1;
 * @return {!Array<!proto.buf.registry.owner.v1.OrganizationRef>}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.prototype.getOrganizationRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.OrganizationRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_organization_pb.OrganizationRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.OrganizationRef>} value
 * @return {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest} returns this
*/
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.prototype.setOrganizationRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.OrganizationRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.OrganizationRef}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.prototype.addOrganizationRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.owner.v1.OrganizationRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest} returns this
 */
proto.buf.registry.owner.v1.DeleteOrganizationsRequest.prototype.clearOrganizationRefsList = function() {
  return this.setOrganizationRefsList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.owner.v1.DeleteOrganizationsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.DeleteOrganizationsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.owner.v1.DeleteOrganizationsResponse}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.owner.v1.DeleteOrganizationsResponse;
  return proto.buf.registry.owner.v1.DeleteOrganizationsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.owner.v1.DeleteOrganizationsResponse}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.owner.v1.DeleteOrganizationsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.owner.v1.DeleteOrganizationsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.owner.v1.DeleteOrganizationsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};


goog.object.extend(exports, proto.buf.registry.owner.v1);
