// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview gRPC-Web generated client stub for buf.registry.owner.v1
 * @enhanceable
 * @public
 */

// Code generated by protoc-gen-grpc-web. DO NOT EDIT.
// versions:
// 	protoc-gen-grpc-web v1.5.0
// 	protoc              v0.0.0
// source: buf/registry/owner/v1/organization_service.proto


/* eslint-disable */
// @ts-nocheck



const grpc = {};
grpc.web = require('grpc-web');


var buf_registry_owner_v1_organization_pb = require('../../../../buf/registry/owner/v1/organization_pb.js')

var buf_registry_owner_v1_user_pb = require('../../../../buf/registry/owner/v1/user_pb.js')

var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js')
const proto = {};
proto.buf = {};
proto.buf.registry = {};
proto.buf.registry.owner = {};
proto.buf.registry.owner.v1 = require('./organization_service_pb.js');

/**
 * @param {string} hostname
 * @param {?Object} credentials
 * @param {?grpc.web.ClientOptions} options
 * @constructor
 * @struct
 * @final
 */
proto.buf.registry.owner.v1.OrganizationServiceClient =
    function(hostname, credentials, options) {
  if (!options) options = {};
  options.format = 'binary';

  /**
   * @private @const {!grpc.web.GrpcWebClientBase} The client
   */
  this.client_ = new grpc.web.GrpcWebClientBase(options);

  /**
   * @private @const {string} The hostname
   */
  this.hostname_ = hostname.replace(/\/+$/, '');

};


/**
 * @param {string} hostname
 * @param {?Object} credentials
 * @param {?grpc.web.ClientOptions} options
 * @constructor
 * @struct
 * @final
 */
proto.buf.registry.owner.v1.OrganizationServicePromiseClient =
    function(hostname, credentials, options) {
  if (!options) options = {};
  options.format = 'binary';

  /**
   * @private @const {!grpc.web.GrpcWebClientBase} The client
   */
  this.client_ = new grpc.web.GrpcWebClientBase(options);

  /**
   * @private @const {string} The hostname
   */
  this.hostname_ = hostname.replace(/\/+$/, '');

};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.GetOrganizationsRequest,
 *   !proto.buf.registry.owner.v1.GetOrganizationsResponse>}
 */
const methodDescriptor_OrganizationService_GetOrganizations = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.OrganizationService/GetOrganizations',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.GetOrganizationsRequest,
  proto.buf.registry.owner.v1.GetOrganizationsResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.GetOrganizationsRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.GetOrganizationsResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.GetOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.GetOrganizationsResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.GetOrganizationsResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.OrganizationServiceClient.prototype.getOrganizations =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/GetOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_GetOrganizations,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.GetOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.GetOrganizationsResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.OrganizationServicePromiseClient.prototype.getOrganizations =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/GetOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_GetOrganizations);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.ListOrganizationsRequest,
 *   !proto.buf.registry.owner.v1.ListOrganizationsResponse>}
 */
const methodDescriptor_OrganizationService_ListOrganizations = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.OrganizationService/ListOrganizations',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.ListOrganizationsRequest,
  proto.buf.registry.owner.v1.ListOrganizationsResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.ListOrganizationsRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.ListOrganizationsResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.ListOrganizationsResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.ListOrganizationsResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.OrganizationServiceClient.prototype.listOrganizations =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/ListOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_ListOrganizations,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.ListOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.ListOrganizationsResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.OrganizationServicePromiseClient.prototype.listOrganizations =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/ListOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_ListOrganizations);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.CreateOrganizationsRequest,
 *   !proto.buf.registry.owner.v1.CreateOrganizationsResponse>}
 */
const methodDescriptor_OrganizationService_CreateOrganizations = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.OrganizationService/CreateOrganizations',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.CreateOrganizationsRequest,
  proto.buf.registry.owner.v1.CreateOrganizationsResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.CreateOrganizationsResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.CreateOrganizationsResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.CreateOrganizationsResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.OrganizationServiceClient.prototype.createOrganizations =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/CreateOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_CreateOrganizations,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.CreateOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.CreateOrganizationsResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.OrganizationServicePromiseClient.prototype.createOrganizations =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/CreateOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_CreateOrganizations);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.UpdateOrganizationsRequest,
 *   !proto.buf.registry.owner.v1.UpdateOrganizationsResponse>}
 */
const methodDescriptor_OrganizationService_UpdateOrganizations = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.OrganizationService/UpdateOrganizations',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.UpdateOrganizationsRequest,
  proto.buf.registry.owner.v1.UpdateOrganizationsResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.UpdateOrganizationsResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.UpdateOrganizationsResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.UpdateOrganizationsResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.OrganizationServiceClient.prototype.updateOrganizations =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/UpdateOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_UpdateOrganizations,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.UpdateOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.UpdateOrganizationsResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.OrganizationServicePromiseClient.prototype.updateOrganizations =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/UpdateOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_UpdateOrganizations);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.owner.v1.DeleteOrganizationsRequest,
 *   !proto.buf.registry.owner.v1.DeleteOrganizationsResponse>}
 */
const methodDescriptor_OrganizationService_DeleteOrganizations = new grpc.web.MethodDescriptor(
  '/buf.registry.owner.v1.OrganizationService/DeleteOrganizations',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.owner.v1.DeleteOrganizationsRequest,
  proto.buf.registry.owner.v1.DeleteOrganizationsResponse,
  /**
   * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.owner.v1.DeleteOrganizationsResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.owner.v1.DeleteOrganizationsResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.owner.v1.DeleteOrganizationsResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.owner.v1.OrganizationServiceClient.prototype.deleteOrganizations =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/DeleteOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_DeleteOrganizations,
      callback);
};


/**
 * @param {!proto.buf.registry.owner.v1.DeleteOrganizationsRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.owner.v1.DeleteOrganizationsResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.owner.v1.OrganizationServicePromiseClient.prototype.deleteOrganizations =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.owner.v1.OrganizationService/DeleteOrganizations',
      request,
      metadata || {},
      methodDescriptor_OrganizationService_DeleteOrganizations);
};


module.exports = proto.buf.registry.owner.v1;

