// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview gRPC-Web generated client stub for buf.registry.module.v1beta1
 * @enhanceable
 * @public
 */

// Code generated by protoc-gen-grpc-web. DO NOT EDIT.
// versions:
// 	protoc-gen-grpc-web v1.5.0
// 	protoc              v0.0.0
// source: buf/registry/module/v1beta1/module_service.proto


/* eslint-disable */
// @ts-nocheck



const grpc = {};
grpc.web = require('grpc-web');


var buf_registry_module_v1beta1_module_pb = require('../../../../buf/registry/module/v1beta1/module_pb.js')

var buf_registry_owner_v1_owner_pb = require('../../../../buf/registry/owner/v1/owner_pb.js')

var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js')
const proto = {};
proto.buf = {};
proto.buf.registry = {};
proto.buf.registry.module = {};
proto.buf.registry.module.v1beta1 = require('./module_service_pb.js');

/**
 * @param {string} hostname
 * @param {?Object} credentials
 * @param {?grpc.web.ClientOptions} options
 * @constructor
 * @struct
 * @final
 */
proto.buf.registry.module.v1beta1.ModuleServiceClient =
    function(hostname, credentials, options) {
  if (!options) options = {};
  options.format = 'binary';

  /**
   * @private @const {!grpc.web.GrpcWebClientBase} The client
   */
  this.client_ = new grpc.web.GrpcWebClientBase(options);

  /**
   * @private @const {string} The hostname
   */
  this.hostname_ = hostname.replace(/\/+$/, '');

};


/**
 * @param {string} hostname
 * @param {?Object} credentials
 * @param {?grpc.web.ClientOptions} options
 * @constructor
 * @struct
 * @final
 */
proto.buf.registry.module.v1beta1.ModuleServicePromiseClient =
    function(hostname, credentials, options) {
  if (!options) options = {};
  options.format = 'binary';

  /**
   * @private @const {!grpc.web.GrpcWebClientBase} The client
   */
  this.client_ = new grpc.web.GrpcWebClientBase(options);

  /**
   * @private @const {string} The hostname
   */
  this.hostname_ = hostname.replace(/\/+$/, '');

};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.module.v1beta1.GetModulesRequest,
 *   !proto.buf.registry.module.v1beta1.GetModulesResponse>}
 */
const methodDescriptor_ModuleService_GetModules = new grpc.web.MethodDescriptor(
  '/buf.registry.module.v1beta1.ModuleService/GetModules',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.module.v1beta1.GetModulesRequest,
  proto.buf.registry.module.v1beta1.GetModulesResponse,
  /**
   * @param {!proto.buf.registry.module.v1beta1.GetModulesRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.module.v1beta1.GetModulesResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.module.v1beta1.GetModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.module.v1beta1.GetModulesResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.module.v1beta1.GetModulesResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.module.v1beta1.ModuleServiceClient.prototype.getModules =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/GetModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_GetModules,
      callback);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.GetModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.module.v1beta1.GetModulesResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.module.v1beta1.ModuleServicePromiseClient.prototype.getModules =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/GetModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_GetModules);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.module.v1beta1.ListModulesRequest,
 *   !proto.buf.registry.module.v1beta1.ListModulesResponse>}
 */
const methodDescriptor_ModuleService_ListModules = new grpc.web.MethodDescriptor(
  '/buf.registry.module.v1beta1.ModuleService/ListModules',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.module.v1beta1.ListModulesRequest,
  proto.buf.registry.module.v1beta1.ListModulesResponse,
  /**
   * @param {!proto.buf.registry.module.v1beta1.ListModulesRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.module.v1beta1.ListModulesResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.module.v1beta1.ListModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.module.v1beta1.ListModulesResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.module.v1beta1.ListModulesResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.module.v1beta1.ModuleServiceClient.prototype.listModules =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/ListModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_ListModules,
      callback);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.ListModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.module.v1beta1.ListModulesResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.module.v1beta1.ModuleServicePromiseClient.prototype.listModules =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/ListModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_ListModules);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.module.v1beta1.CreateModulesRequest,
 *   !proto.buf.registry.module.v1beta1.CreateModulesResponse>}
 */
const methodDescriptor_ModuleService_CreateModules = new grpc.web.MethodDescriptor(
  '/buf.registry.module.v1beta1.ModuleService/CreateModules',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.module.v1beta1.CreateModulesRequest,
  proto.buf.registry.module.v1beta1.CreateModulesResponse,
  /**
   * @param {!proto.buf.registry.module.v1beta1.CreateModulesRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.module.v1beta1.CreateModulesResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.module.v1beta1.CreateModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.module.v1beta1.CreateModulesResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.module.v1beta1.CreateModulesResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.module.v1beta1.ModuleServiceClient.prototype.createModules =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/CreateModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_CreateModules,
      callback);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.CreateModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.module.v1beta1.CreateModulesResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.module.v1beta1.ModuleServicePromiseClient.prototype.createModules =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/CreateModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_CreateModules);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.module.v1beta1.UpdateModulesRequest,
 *   !proto.buf.registry.module.v1beta1.UpdateModulesResponse>}
 */
const methodDescriptor_ModuleService_UpdateModules = new grpc.web.MethodDescriptor(
  '/buf.registry.module.v1beta1.ModuleService/UpdateModules',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.module.v1beta1.UpdateModulesRequest,
  proto.buf.registry.module.v1beta1.UpdateModulesResponse,
  /**
   * @param {!proto.buf.registry.module.v1beta1.UpdateModulesRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.module.v1beta1.UpdateModulesResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.module.v1beta1.UpdateModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.module.v1beta1.UpdateModulesResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.module.v1beta1.UpdateModulesResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.module.v1beta1.ModuleServiceClient.prototype.updateModules =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/UpdateModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_UpdateModules,
      callback);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.UpdateModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.module.v1beta1.UpdateModulesResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.module.v1beta1.ModuleServicePromiseClient.prototype.updateModules =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/UpdateModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_UpdateModules);
};


/**
 * @const
 * @type {!grpc.web.MethodDescriptor<
 *   !proto.buf.registry.module.v1beta1.DeleteModulesRequest,
 *   !proto.buf.registry.module.v1beta1.DeleteModulesResponse>}
 */
const methodDescriptor_ModuleService_DeleteModules = new grpc.web.MethodDescriptor(
  '/buf.registry.module.v1beta1.ModuleService/DeleteModules',
  grpc.web.MethodType.UNARY,
  proto.buf.registry.module.v1beta1.DeleteModulesRequest,
  proto.buf.registry.module.v1beta1.DeleteModulesResponse,
  /**
   * @param {!proto.buf.registry.module.v1beta1.DeleteModulesRequest} request
   * @return {!Uint8Array}
   */
  function(request) {
    return request.serializeBinary();
  },
  proto.buf.registry.module.v1beta1.DeleteModulesResponse.deserializeBinary
);


/**
 * @param {!proto.buf.registry.module.v1beta1.DeleteModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>} metadata User defined
 *     call metadata
 * @param {function(?grpc.web.RpcError, ?proto.buf.registry.module.v1beta1.DeleteModulesResponse)}
 *     callback The callback function(error, response)
 * @return {!grpc.web.ClientReadableStream<!proto.buf.registry.module.v1beta1.DeleteModulesResponse>|undefined}
 *     The XHR Node Readable Stream
 */
proto.buf.registry.module.v1beta1.ModuleServiceClient.prototype.deleteModules =
    function(request, metadata, callback) {
  return this.client_.rpcCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/DeleteModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_DeleteModules,
      callback);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.DeleteModulesRequest} request The
 *     request proto
 * @param {?Object<string, string>=} metadata User defined
 *     call metadata
 * @return {!Promise<!proto.buf.registry.module.v1beta1.DeleteModulesResponse>}
 *     Promise that resolves to the response
 */
proto.buf.registry.module.v1beta1.ModuleServicePromiseClient.prototype.deleteModules =
    function(request, metadata) {
  return this.client_.unaryCall(this.hostname_ +
      '/buf.registry.module.v1beta1.ModuleService/DeleteModules',
      request,
      metadata || {},
      methodDescriptor_ModuleService_DeleteModules);
};


module.exports = proto.buf.registry.module.v1beta1;

