// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import * as grpcWeb from 'grpc-web';

import * as buf_registry_module_v1beta1_module_service_pb from '../../../../buf/registry/module/v1beta1/module_service_pb'; // proto import: "buf/registry/module/v1beta1/module_service.proto"


export class ModuleServiceClient {
  constructor (hostname: string,
               credentials?: null | { [index: string]: string; },
               options?: null | { [index: string]: any; });

  getModules(
    request: buf_registry_module_v1beta1_module_service_pb.GetModulesRequest,
    metadata: grpcWeb.Metadata | undefined,
    callback: (err: grpcWeb.RpcError,
               response: buf_registry_module_v1beta1_module_service_pb.GetModulesResponse) => void
  ): grpcWeb.ClientReadableStream<buf_registry_module_v1beta1_module_service_pb.GetModulesResponse>;

  listModules(
    request: buf_registry_module_v1beta1_module_service_pb.ListModulesRequest,
    metadata: grpcWeb.Metadata | undefined,
    callback: (err: grpcWeb.RpcError,
               response: buf_registry_module_v1beta1_module_service_pb.ListModulesResponse) => void
  ): grpcWeb.ClientReadableStream<buf_registry_module_v1beta1_module_service_pb.ListModulesResponse>;

  createModules(
    request: buf_registry_module_v1beta1_module_service_pb.CreateModulesRequest,
    metadata: grpcWeb.Metadata | undefined,
    callback: (err: grpcWeb.RpcError,
               response: buf_registry_module_v1beta1_module_service_pb.CreateModulesResponse) => void
  ): grpcWeb.ClientReadableStream<buf_registry_module_v1beta1_module_service_pb.CreateModulesResponse>;

  updateModules(
    request: buf_registry_module_v1beta1_module_service_pb.UpdateModulesRequest,
    metadata: grpcWeb.Metadata | undefined,
    callback: (err: grpcWeb.RpcError,
               response: buf_registry_module_v1beta1_module_service_pb.UpdateModulesResponse) => void
  ): grpcWeb.ClientReadableStream<buf_registry_module_v1beta1_module_service_pb.UpdateModulesResponse>;

  deleteModules(
    request: buf_registry_module_v1beta1_module_service_pb.DeleteModulesRequest,
    metadata: grpcWeb.Metadata | undefined,
    callback: (err: grpcWeb.RpcError,
               response: buf_registry_module_v1beta1_module_service_pb.DeleteModulesResponse) => void
  ): grpcWeb.ClientReadableStream<buf_registry_module_v1beta1_module_service_pb.DeleteModulesResponse>;

}

export class ModuleServicePromiseClient {
  constructor (hostname: string,
               credentials?: null | { [index: string]: string; },
               options?: null | { [index: string]: any; });

  getModules(
    request: buf_registry_module_v1beta1_module_service_pb.GetModulesRequest,
    metadata?: grpcWeb.Metadata
  ): Promise<buf_registry_module_v1beta1_module_service_pb.GetModulesResponse>;

  listModules(
    request: buf_registry_module_v1beta1_module_service_pb.ListModulesRequest,
    metadata?: grpcWeb.Metadata
  ): Promise<buf_registry_module_v1beta1_module_service_pb.ListModulesResponse>;

  createModules(
    request: buf_registry_module_v1beta1_module_service_pb.CreateModulesRequest,
    metadata?: grpcWeb.Metadata
  ): Promise<buf_registry_module_v1beta1_module_service_pb.CreateModulesResponse>;

  updateModules(
    request: buf_registry_module_v1beta1_module_service_pb.UpdateModulesRequest,
    metadata?: grpcWeb.Metadata
  ): Promise<buf_registry_module_v1beta1_module_service_pb.UpdateModulesResponse>;

  deleteModules(
    request: buf_registry_module_v1beta1_module_service_pb.DeleteModulesRequest,
    metadata?: grpcWeb.Metadata
  ): Promise<buf_registry_module_v1beta1_module_service_pb.DeleteModulesResponse>;

}

