// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/module/v1beta1/label_service.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_module_v1beta1_commit_pb = require('../../../../buf/registry/module/v1beta1/commit_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_commit_pb);
var buf_registry_module_v1beta1_digest_pb = require('../../../../buf/registry/module/v1beta1/digest_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_digest_pb);
var buf_registry_module_v1beta1_label_pb = require('../../../../buf/registry/module/v1beta1/label_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_label_pb);
var buf_registry_module_v1beta1_resource_pb = require('../../../../buf/registry/module/v1beta1/resource_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_resource_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ArchiveLabelsRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ArchiveLabelsResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.GetLabelsRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.GetLabelsResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListLabelHistoryRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.Order', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListLabelHistoryResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListLabelsRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListLabelsRequest.ArchiveFilter', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListLabelsRequest.Order', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListLabelsResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.GetLabelsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.GetLabelsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.GetLabelsRequest.displayName = 'proto.buf.registry.module.v1beta1.GetLabelsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.GetLabelsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.GetLabelsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.GetLabelsResponse.displayName = 'proto.buf.registry.module.v1beta1.GetLabelsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.ListLabelsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ListLabelsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ListLabelsRequest.displayName = 'proto.buf.registry.module.v1beta1.ListLabelsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.ListLabelsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ListLabelsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ListLabelsResponse.displayName = 'proto.buf.registry.module.v1beta1.ListLabelsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ListLabelHistoryRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.displayName = 'proto.buf.registry.module.v1beta1.ListLabelHistoryRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ListLabelHistoryResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.displayName = 'proto.buf.registry.module.v1beta1.ListLabelHistoryResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.displayName = 'proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.displayName = 'proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.displayName = 'proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.displayName = 'proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ArchiveLabelsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.displayName = 'proto.buf.registry.module.v1beta1.ArchiveLabelsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ArchiveLabelsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.displayName = 'proto.buf.registry.module.v1beta1.ArchiveLabelsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.displayName = 'proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.displayName = 'proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse';
}

/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.GetLabelsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.GetLabelsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
labelRefsList: jspb.Message.toObjectList(msg.getLabelRefsList(),
    buf_registry_module_v1beta1_label_pb.LabelRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.GetLabelsRequest}
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.GetLabelsRequest;
  return proto.buf.registry.module.v1beta1.GetLabelsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.GetLabelsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.GetLabelsRequest}
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_label_pb.LabelRef;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.LabelRef.deserializeBinaryFromReader);
      msg.addLabelRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.GetLabelsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.GetLabelsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLabelRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1beta1_label_pb.LabelRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated LabelRef label_refs = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.LabelRef>}
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.prototype.getLabelRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.LabelRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_label_pb.LabelRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.LabelRef>} value
 * @return {!proto.buf.registry.module.v1beta1.GetLabelsRequest} returns this
*/
proto.buf.registry.module.v1beta1.GetLabelsRequest.prototype.setLabelRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.LabelRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.LabelRef}
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.prototype.addLabelRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.LabelRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.GetLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.GetLabelsRequest.prototype.clearLabelRefsList = function() {
  return this.setLabelRefsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.GetLabelsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.GetLabelsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
labelsList: jspb.Message.toObjectList(msg.getLabelsList(),
    buf_registry_module_v1beta1_label_pb.Label.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.GetLabelsResponse}
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.GetLabelsResponse;
  return proto.buf.registry.module.v1beta1.GetLabelsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.GetLabelsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.GetLabelsResponse}
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_label_pb.Label;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.Label.deserializeBinaryFromReader);
      msg.addLabels(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.GetLabelsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.GetLabelsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLabelsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1beta1_label_pb.Label.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Label labels = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.Label>}
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.prototype.getLabelsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.Label>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_label_pb.Label, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.Label>} value
 * @return {!proto.buf.registry.module.v1beta1.GetLabelsResponse} returns this
*/
proto.buf.registry.module.v1beta1.GetLabelsResponse.prototype.setLabelsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.Label=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.Label}
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.prototype.addLabels = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.Label, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.GetLabelsResponse} returns this
 */
proto.buf.registry.module.v1beta1.GetLabelsResponse.prototype.clearLabelsList = function() {
  return this.setLabelsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.repeatedFields_ = [5];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ListLabelsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ListLabelsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
pageSize: jspb.Message.getFieldWithDefault(msg, 1, 0),
pageToken: jspb.Message.getFieldWithDefault(msg, 2, ""),
resourceRef: (f = msg.getResourceRef()) && buf_registry_module_v1beta1_resource_pb.ResourceRef.toObject(includeInstance, f),
order: jspb.Message.getFieldWithDefault(msg, 4, 0),
commitCheckStatusesList: (f = jspb.Message.getRepeatedField(msg, 5)) == null ? undefined : f,
nameQuery: jspb.Message.getFieldWithDefault(msg, 6, ""),
archiveFilter: jspb.Message.getFieldWithDefault(msg, 7, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ListLabelsRequest;
  return proto.buf.registry.module.v1beta1.ListLabelsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setPageSize(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setPageToken(value);
      break;
    case 3:
      var value = new buf_registry_module_v1beta1_resource_pb.ResourceRef;
      reader.readMessage(value,buf_registry_module_v1beta1_resource_pb.ResourceRef.deserializeBinaryFromReader);
      msg.setResourceRef(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.module.v1beta1.ListLabelsRequest.Order} */ (reader.readEnum());
      msg.setOrder(value);
      break;
    case 5:
      var values = /** @type {!Array<!proto.buf.registry.module.v1beta1.CommitCheckStatus>} */ (reader.isDelimited() ? reader.readPackedEnum() : [reader.readEnum()]);
      for (var i = 0; i < values.length; i++) {
        msg.addCommitCheckStatuses(values[i]);
      }
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setNameQuery(value);
      break;
    case 7:
      var value = /** @type {!proto.buf.registry.module.v1beta1.ListLabelsRequest.ArchiveFilter} */ (reader.readEnum());
      msg.setArchiveFilter(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ListLabelsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPageSize();
  if (f !== 0) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = message.getPageToken();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getResourceRef();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      buf_registry_module_v1beta1_resource_pb.ResourceRef.serializeBinaryToWriter
    );
  }
  f = message.getOrder();
  if (f !== 0.0) {
    writer.writeEnum(
      4,
      f
    );
  }
  f = message.getCommitCheckStatusesList();
  if (f.length > 0) {
    writer.writePackedEnum(
      5,
      f
    );
  }
  f = message.getNameQuery();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getArchiveFilter();
  if (f !== 0.0) {
    writer.writeEnum(
      7,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.Order = {
  ORDER_UNSPECIFIED: 0,
  ORDER_CREATE_TIME_DESC: 1,
  ORDER_CREATE_TIME_ASC: 2,
  ORDER_UPDATE_TIME_DESC: 3,
  ORDER_UPDATE_TIME_ASC: 4
};

/**
 * @enum {number}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.ArchiveFilter = {
  ARCHIVE_FILTER_UNSPECIFIED: 0,
  ARCHIVE_FILTER_UNARCHIVED_ONLY: 1,
  ARCHIVE_FILTER_ARCHIVED_ONLY: 2,
  ARCHIVE_FILTER_ALL: 3
};

/**
 * optional uint32 page_size = 1;
 * @return {number}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.getPageSize = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.setPageSize = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string page_token = 2;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.getPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.setPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional ResourceRef resource_ref = 3;
 * @return {?proto.buf.registry.module.v1beta1.ResourceRef}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.getResourceRef = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.ResourceRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_resource_pb.ResourceRef, 3));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.ResourceRef|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
*/
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.setResourceRef = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.clearResourceRef = function() {
  return this.setResourceRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.hasResourceRef = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional Order order = 4;
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest.Order}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.getOrder = function() {
  return /** @type {!proto.buf.registry.module.v1beta1.ListLabelsRequest.Order} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.module.v1beta1.ListLabelsRequest.Order} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.setOrder = function(value) {
  return jspb.Message.setProto3EnumField(this, 4, value);
};


/**
 * repeated CommitCheckStatus commit_check_statuses = 5;
 * @return {!Array<!proto.buf.registry.module.v1beta1.CommitCheckStatus>}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.getCommitCheckStatusesList = function() {
  return /** @type {!Array<!proto.buf.registry.module.v1beta1.CommitCheckStatus>} */ (jspb.Message.getRepeatedField(this, 5));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.CommitCheckStatus>} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.setCommitCheckStatusesList = function(value) {
  return jspb.Message.setField(this, 5, value || []);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.CommitCheckStatus} value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.addCommitCheckStatuses = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 5, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.clearCommitCheckStatusesList = function() {
  return this.setCommitCheckStatusesList([]);
};


/**
 * optional string name_query = 6;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.getNameQuery = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.setNameQuery = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional ArchiveFilter archive_filter = 7;
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest.ArchiveFilter}
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.getArchiveFilter = function() {
  return /** @type {!proto.buf.registry.module.v1beta1.ListLabelsRequest.ArchiveFilter} */ (jspb.Message.getFieldWithDefault(this, 7, 0));
};


/**
 * @param {!proto.buf.registry.module.v1beta1.ListLabelsRequest.ArchiveFilter} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsRequest.prototype.setArchiveFilter = function(value) {
  return jspb.Message.setProto3EnumField(this, 7, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ListLabelsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ListLabelsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
nextPageToken: jspb.Message.getFieldWithDefault(msg, 1, ""),
labelsList: jspb.Message.toObjectList(msg.getLabelsList(),
    buf_registry_module_v1beta1_label_pb.Label.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsResponse}
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ListLabelsResponse;
  return proto.buf.registry.module.v1beta1.ListLabelsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsResponse}
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setNextPageToken(value);
      break;
    case 2:
      var value = new buf_registry_module_v1beta1_label_pb.Label;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.Label.deserializeBinaryFromReader);
      msg.addLabels(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ListLabelsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getNextPageToken();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getLabelsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      buf_registry_module_v1beta1_label_pb.Label.serializeBinaryToWriter
    );
  }
};


/**
 * optional string next_page_token = 1;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.prototype.getNextPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsResponse} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.prototype.setNextPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * repeated Label labels = 2;
 * @return {!Array<!proto.buf.registry.module.v1beta1.Label>}
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.prototype.getLabelsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.Label>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_label_pb.Label, 2));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.Label>} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsResponse} returns this
*/
proto.buf.registry.module.v1beta1.ListLabelsResponse.prototype.setLabelsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.Label=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.Label}
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.prototype.addLabels = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.buf.registry.module.v1beta1.Label, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelsResponse} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelsResponse.prototype.clearLabelsList = function() {
  return this.setLabelsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.repeatedFields_ = [6];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
pageSize: jspb.Message.getFieldWithDefault(msg, 1, 0),
pageToken: jspb.Message.getFieldWithDefault(msg, 2, ""),
labelRef: (f = msg.getLabelRef()) && buf_registry_module_v1beta1_label_pb.LabelRef.toObject(includeInstance, f),
order: jspb.Message.getFieldWithDefault(msg, 4, 0),
digestType: jspb.Message.getFieldWithDefault(msg, 5, 0),
commitCheckStatusesList: (f = jspb.Message.getRepeatedField(msg, 6)) == null ? undefined : f,
startCommitId: jspb.Message.getFieldWithDefault(msg, 7, ""),
onlyCommitsWithChangedDigests: jspb.Message.getBooleanFieldWithDefault(msg, 8, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ListLabelHistoryRequest;
  return proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setPageSize(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setPageToken(value);
      break;
    case 3:
      var value = new buf_registry_module_v1beta1_label_pb.LabelRef;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.LabelRef.deserializeBinaryFromReader);
      msg.setLabelRef(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.Order} */ (reader.readEnum());
      msg.setOrder(value);
      break;
    case 5:
      var value = /** @type {!proto.buf.registry.module.v1beta1.DigestType} */ (reader.readEnum());
      msg.setDigestType(value);
      break;
    case 6:
      var values = /** @type {!Array<!proto.buf.registry.module.v1beta1.CommitCheckStatus>} */ (reader.isDelimited() ? reader.readPackedEnum() : [reader.readEnum()]);
      for (var i = 0; i < values.length; i++) {
        msg.addCommitCheckStatuses(values[i]);
      }
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.setStartCommitId(value);
      break;
    case 8:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setOnlyCommitsWithChangedDigests(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPageSize();
  if (f !== 0) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = message.getPageToken();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getLabelRef();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      buf_registry_module_v1beta1_label_pb.LabelRef.serializeBinaryToWriter
    );
  }
  f = message.getOrder();
  if (f !== 0.0) {
    writer.writeEnum(
      4,
      f
    );
  }
  f = message.getDigestType();
  if (f !== 0.0) {
    writer.writeEnum(
      5,
      f
    );
  }
  f = message.getCommitCheckStatusesList();
  if (f.length > 0) {
    writer.writePackedEnum(
      6,
      f
    );
  }
  f = message.getStartCommitId();
  if (f.length > 0) {
    writer.writeString(
      7,
      f
    );
  }
  f = message.getOnlyCommitsWithChangedDigests();
  if (f) {
    writer.writeBool(
      8,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.Order = {
  ORDER_UNSPECIFIED: 0,
  ORDER_DESC: 1,
  ORDER_ASC: 2
};

/**
 * optional uint32 page_size = 1;
 * @return {number}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.getPageSize = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.setPageSize = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string page_token = 2;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.getPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.setPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional LabelRef label_ref = 3;
 * @return {?proto.buf.registry.module.v1beta1.LabelRef}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.getLabelRef = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.LabelRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_label_pb.LabelRef, 3));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.LabelRef|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
*/
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.setLabelRef = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.clearLabelRef = function() {
  return this.setLabelRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.hasLabelRef = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional Order order = 4;
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.Order}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.getOrder = function() {
  return /** @type {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.Order} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.Order} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.setOrder = function(value) {
  return jspb.Message.setProto3EnumField(this, 4, value);
};


/**
 * optional DigestType digest_type = 5;
 * @return {!proto.buf.registry.module.v1beta1.DigestType}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.getDigestType = function() {
  return /** @type {!proto.buf.registry.module.v1beta1.DigestType} */ (jspb.Message.getFieldWithDefault(this, 5, 0));
};


/**
 * @param {!proto.buf.registry.module.v1beta1.DigestType} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.setDigestType = function(value) {
  return jspb.Message.setProto3EnumField(this, 5, value);
};


/**
 * repeated CommitCheckStatus commit_check_statuses = 6;
 * @return {!Array<!proto.buf.registry.module.v1beta1.CommitCheckStatus>}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.getCommitCheckStatusesList = function() {
  return /** @type {!Array<!proto.buf.registry.module.v1beta1.CommitCheckStatus>} */ (jspb.Message.getRepeatedField(this, 6));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.CommitCheckStatus>} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.setCommitCheckStatusesList = function(value) {
  return jspb.Message.setField(this, 6, value || []);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.CommitCheckStatus} value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.addCommitCheckStatuses = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 6, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.clearCommitCheckStatusesList = function() {
  return this.setCommitCheckStatusesList([]);
};


/**
 * optional string start_commit_id = 7;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.getStartCommitId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.setStartCommitId = function(value) {
  return jspb.Message.setProto3StringField(this, 7, value);
};


/**
 * optional bool only_commits_with_changed_digests = 8;
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.getOnlyCommitsWithChangedDigests = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 8, false));
};


/**
 * @param {boolean} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryRequest.prototype.setOnlyCommitsWithChangedDigests = function(value) {
  return jspb.Message.setProto3BooleanField(this, 8, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
nextPageToken: jspb.Message.getFieldWithDefault(msg, 1, ""),
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ListLabelHistoryResponse;
  return proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setNextPageToken(value);
      break;
    case 2:
      var value = new proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value;
      reader.readMessage(value,proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getNextPageToken();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
commit: (f = msg.getCommit()) && buf_registry_module_v1beta1_commit_pb.Commit.toObject(includeInstance, f),
commitCheckState: (f = msg.getCommitCheckState()) && buf_registry_module_v1beta1_label_pb.CommitCheckState.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value;
  return proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_commit_pb.Commit;
      reader.readMessage(value,buf_registry_module_v1beta1_commit_pb.Commit.deserializeBinaryFromReader);
      msg.setCommit(value);
      break;
    case 2:
      var value = new buf_registry_module_v1beta1_label_pb.CommitCheckState;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.CommitCheckState.deserializeBinaryFromReader);
      msg.setCommitCheckState(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCommit();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_module_v1beta1_commit_pb.Commit.serializeBinaryToWriter
    );
  }
  f = message.getCommitCheckState();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      buf_registry_module_v1beta1_label_pb.CommitCheckState.serializeBinaryToWriter
    );
  }
};


/**
 * optional Commit commit = 1;
 * @return {?proto.buf.registry.module.v1beta1.Commit}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.getCommit = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.Commit} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_commit_pb.Commit, 1));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.Commit|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value} returns this
*/
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.setCommit = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.clearCommit = function() {
  return this.setCommit(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.hasCommit = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional CommitCheckState commit_check_state = 2;
 * @return {?proto.buf.registry.module.v1beta1.CommitCheckState}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.getCommitCheckState = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.CommitCheckState} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_label_pb.CommitCheckState, 2));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.CommitCheckState|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value} returns this
*/
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.setCommitCheckState = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.clearCommitCheckState = function() {
  return this.setCommitCheckState(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value.prototype.hasCommitCheckState = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional string next_page_token = 1;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.prototype.getNextPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.prototype.setNextPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * repeated Value values = 2;
 * @return {!Array<!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value>}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value, 2));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value>} value
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse} returns this
*/
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value}
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.ListLabelHistoryResponse} returns this
 */
proto.buf.registry.module.v1beta1.ListLabelHistoryResponse.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest;
  return proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value;
      reader.readMessage(value,proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
labelRef: (f = msg.getLabelRef()) && buf_registry_module_v1beta1_label_pb.LabelRef.toObject(includeInstance, f),
commitId: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value;
  return proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_label_pb.LabelRef;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.LabelRef.deserializeBinaryFromReader);
      msg.setLabelRef(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setCommitId(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLabelRef();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_module_v1beta1_label_pb.LabelRef.serializeBinaryToWriter
    );
  }
  f = message.getCommitId();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional LabelRef label_ref = 1;
 * @return {?proto.buf.registry.module.v1beta1.LabelRef}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.prototype.getLabelRef = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.LabelRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_label_pb.LabelRef, 1));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.LabelRef|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value} returns this
*/
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.prototype.setLabelRef = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.prototype.clearLabelRef = function() {
  return this.setLabelRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.prototype.hasLabelRef = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional string commit_id = 2;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.prototype.getCommitId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value.prototype.setCommitId = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * repeated Value values = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value>}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value>} value
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest} returns this
*/
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsRequest.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
labelsList: jspb.Message.toObjectList(msg.getLabelsList(),
    buf_registry_module_v1beta1_label_pb.Label.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse;
  return proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_label_pb.Label;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.Label.deserializeBinaryFromReader);
      msg.addLabels(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLabelsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1beta1_label_pb.Label.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Label labels = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.Label>}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.prototype.getLabelsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.Label>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_label_pb.Label, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.Label>} value
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse} returns this
*/
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.prototype.setLabelsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.Label=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.Label}
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.prototype.addLabels = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.Label, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse} returns this
 */
proto.buf.registry.module.v1beta1.CreateOrUpdateLabelsResponse.prototype.clearLabelsList = function() {
  return this.setLabelsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ArchiveLabelsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
labelRefsList: jspb.Message.toObjectList(msg.getLabelRefsList(),
    buf_registry_module_v1beta1_label_pb.LabelRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ArchiveLabelsRequest}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ArchiveLabelsRequest;
  return proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ArchiveLabelsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ArchiveLabelsRequest}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_label_pb.LabelRef;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.LabelRef.deserializeBinaryFromReader);
      msg.addLabelRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ArchiveLabelsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLabelRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1beta1_label_pb.LabelRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated LabelRef label_refs = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.LabelRef>}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.prototype.getLabelRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.LabelRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_label_pb.LabelRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.LabelRef>} value
 * @return {!proto.buf.registry.module.v1beta1.ArchiveLabelsRequest} returns this
*/
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.prototype.setLabelRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.LabelRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.LabelRef}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.prototype.addLabelRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.LabelRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.ArchiveLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsRequest.prototype.clearLabelRefsList = function() {
  return this.setLabelRefsList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ArchiveLabelsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ArchiveLabelsResponse}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ArchiveLabelsResponse;
  return proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ArchiveLabelsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ArchiveLabelsResponse}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ArchiveLabelsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ArchiveLabelsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
labelRefsList: jspb.Message.toObjectList(msg.getLabelRefsList(),
    buf_registry_module_v1beta1_label_pb.LabelRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest;
  return proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_label_pb.LabelRef;
      reader.readMessage(value,buf_registry_module_v1beta1_label_pb.LabelRef.deserializeBinaryFromReader);
      msg.addLabelRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLabelRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1beta1_label_pb.LabelRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated LabelRef label_refs = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.LabelRef>}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.prototype.getLabelRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.LabelRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_label_pb.LabelRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.LabelRef>} value
 * @return {!proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest} returns this
*/
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.prototype.setLabelRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.LabelRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.LabelRef}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.prototype.addLabelRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.LabelRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest} returns this
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsRequest.prototype.clearLabelRefsList = function() {
  return this.setLabelRefsList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse;
  return proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.UnarchiveLabelsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};


goog.object.extend(exports, proto.buf.registry.module.v1beta1);
