// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/module/v1beta1/graph.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_module_v1beta1_commit_pb = require('../../../../buf/registry/module/v1beta1/commit_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_commit_pb);
var buf_registry_priv_extension_v1beta1_extension_pb = require('../../../../buf/registry/priv/extension/v1beta1/extension_pb.js');
goog.object.extend(proto, buf_registry_priv_extension_v1beta1_extension_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.module.v1beta1.Graph', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.Graph.Commit', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.Graph.Edge', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.Graph.Node', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.Graph = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.Graph.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.Graph, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.Graph.displayName = 'proto.buf.registry.module.v1beta1.Graph';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.Graph.Commit = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.Graph.Commit, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.Graph.Commit.displayName = 'proto.buf.registry.module.v1beta1.Graph.Commit';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.Graph.Node = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.Graph.Node, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.Graph.Node.displayName = 'proto.buf.registry.module.v1beta1.Graph.Node';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.Graph.Edge = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.Graph.Edge, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.Graph.Edge.displayName = 'proto.buf.registry.module.v1beta1.Graph.Edge';
}

/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.Graph.repeatedFields_ = [1,2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.Graph.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.Graph.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.Graph} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.Graph.toObject = function(includeInstance, msg) {
  var f, obj = {
commitsList: jspb.Message.toObjectList(msg.getCommitsList(),
    proto.buf.registry.module.v1beta1.Graph.Commit.toObject, includeInstance),
edgesList: jspb.Message.toObjectList(msg.getEdgesList(),
    proto.buf.registry.module.v1beta1.Graph.Edge.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.Graph}
 */
proto.buf.registry.module.v1beta1.Graph.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.Graph;
  return proto.buf.registry.module.v1beta1.Graph.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.Graph} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.Graph}
 */
proto.buf.registry.module.v1beta1.Graph.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.module.v1beta1.Graph.Commit;
      reader.readMessage(value,proto.buf.registry.module.v1beta1.Graph.Commit.deserializeBinaryFromReader);
      msg.addCommits(value);
      break;
    case 2:
      var value = new proto.buf.registry.module.v1beta1.Graph.Edge;
      reader.readMessage(value,proto.buf.registry.module.v1beta1.Graph.Edge.deserializeBinaryFromReader);
      msg.addEdges(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.Graph.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.Graph.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.Graph} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.Graph.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCommitsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.module.v1beta1.Graph.Commit.serializeBinaryToWriter
    );
  }
  f = message.getEdgesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      proto.buf.registry.module.v1beta1.Graph.Edge.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.Graph.Commit.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.Graph.Commit.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.Graph.Commit} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.Graph.Commit.toObject = function(includeInstance, msg) {
  var f, obj = {
commit: (f = msg.getCommit()) && buf_registry_module_v1beta1_commit_pb.Commit.toObject(includeInstance, f),
registry: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Commit}
 */
proto.buf.registry.module.v1beta1.Graph.Commit.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.Graph.Commit;
  return proto.buf.registry.module.v1beta1.Graph.Commit.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.Graph.Commit} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Commit}
 */
proto.buf.registry.module.v1beta1.Graph.Commit.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_commit_pb.Commit;
      reader.readMessage(value,buf_registry_module_v1beta1_commit_pb.Commit.deserializeBinaryFromReader);
      msg.setCommit(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setRegistry(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.Graph.Commit.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.Graph.Commit.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.Graph.Commit} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.Graph.Commit.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCommit();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_module_v1beta1_commit_pb.Commit.serializeBinaryToWriter
    );
  }
  f = message.getRegistry();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional Commit commit = 1;
 * @return {?proto.buf.registry.module.v1beta1.Commit}
 */
proto.buf.registry.module.v1beta1.Graph.Commit.prototype.getCommit = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.Commit} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_commit_pb.Commit, 1));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.Commit|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.Graph.Commit} returns this
*/
proto.buf.registry.module.v1beta1.Graph.Commit.prototype.setCommit = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Commit} returns this
 */
proto.buf.registry.module.v1beta1.Graph.Commit.prototype.clearCommit = function() {
  return this.setCommit(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.Graph.Commit.prototype.hasCommit = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional string registry = 2;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.Graph.Commit.prototype.getRegistry = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.Graph.Commit} returns this
 */
proto.buf.registry.module.v1beta1.Graph.Commit.prototype.setRegistry = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.Graph.Node.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.Graph.Node.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.Graph.Node} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.Graph.Node.toObject = function(includeInstance, msg) {
  var f, obj = {
commitId: jspb.Message.getFieldWithDefault(msg, 1, ""),
registry: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Node}
 */
proto.buf.registry.module.v1beta1.Graph.Node.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.Graph.Node;
  return proto.buf.registry.module.v1beta1.Graph.Node.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.Graph.Node} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Node}
 */
proto.buf.registry.module.v1beta1.Graph.Node.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setCommitId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setRegistry(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.Graph.Node.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.Graph.Node.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.Graph.Node} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.Graph.Node.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCommitId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getRegistry();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string commit_id = 1;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.Graph.Node.prototype.getCommitId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.Graph.Node} returns this
 */
proto.buf.registry.module.v1beta1.Graph.Node.prototype.setCommitId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string registry = 2;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.Graph.Node.prototype.getRegistry = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.Graph.Node} returns this
 */
proto.buf.registry.module.v1beta1.Graph.Node.prototype.setRegistry = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.Graph.Edge.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.Graph.Edge} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.Graph.Edge.toObject = function(includeInstance, msg) {
  var f, obj = {
fromNode: (f = msg.getFromNode()) && proto.buf.registry.module.v1beta1.Graph.Node.toObject(includeInstance, f),
toNode: (f = msg.getToNode()) && proto.buf.registry.module.v1beta1.Graph.Node.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Edge}
 */
proto.buf.registry.module.v1beta1.Graph.Edge.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.Graph.Edge;
  return proto.buf.registry.module.v1beta1.Graph.Edge.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.Graph.Edge} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Edge}
 */
proto.buf.registry.module.v1beta1.Graph.Edge.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.module.v1beta1.Graph.Node;
      reader.readMessage(value,proto.buf.registry.module.v1beta1.Graph.Node.deserializeBinaryFromReader);
      msg.setFromNode(value);
      break;
    case 2:
      var value = new proto.buf.registry.module.v1beta1.Graph.Node;
      reader.readMessage(value,proto.buf.registry.module.v1beta1.Graph.Node.deserializeBinaryFromReader);
      msg.setToNode(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.Graph.Edge.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.Graph.Edge} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.Graph.Edge.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getFromNode();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      proto.buf.registry.module.v1beta1.Graph.Node.serializeBinaryToWriter
    );
  }
  f = message.getToNode();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      proto.buf.registry.module.v1beta1.Graph.Node.serializeBinaryToWriter
    );
  }
};


/**
 * optional Node from_node = 1;
 * @return {?proto.buf.registry.module.v1beta1.Graph.Node}
 */
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.getFromNode = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.Graph.Node} */ (
    jspb.Message.getWrapperField(this, proto.buf.registry.module.v1beta1.Graph.Node, 1));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.Graph.Node|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.Graph.Edge} returns this
*/
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.setFromNode = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Edge} returns this
 */
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.clearFromNode = function() {
  return this.setFromNode(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.hasFromNode = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional Node to_node = 2;
 * @return {?proto.buf.registry.module.v1beta1.Graph.Node}
 */
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.getToNode = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.Graph.Node} */ (
    jspb.Message.getWrapperField(this, proto.buf.registry.module.v1beta1.Graph.Node, 2));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.Graph.Node|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.Graph.Edge} returns this
*/
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.setToNode = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.Graph.Edge} returns this
 */
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.clearToNode = function() {
  return this.setToNode(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.Graph.Edge.prototype.hasToNode = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * repeated Commit commits = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.Graph.Commit>}
 */
proto.buf.registry.module.v1beta1.Graph.prototype.getCommitsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.Graph.Commit>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.module.v1beta1.Graph.Commit, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.Graph.Commit>} value
 * @return {!proto.buf.registry.module.v1beta1.Graph} returns this
*/
proto.buf.registry.module.v1beta1.Graph.prototype.setCommitsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.Graph.Commit=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.Graph.Commit}
 */
proto.buf.registry.module.v1beta1.Graph.prototype.addCommits = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.Graph.Commit, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.Graph} returns this
 */
proto.buf.registry.module.v1beta1.Graph.prototype.clearCommitsList = function() {
  return this.setCommitsList([]);
};


/**
 * repeated Edge edges = 2;
 * @return {!Array<!proto.buf.registry.module.v1beta1.Graph.Edge>}
 */
proto.buf.registry.module.v1beta1.Graph.prototype.getEdgesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.Graph.Edge>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.module.v1beta1.Graph.Edge, 2));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.Graph.Edge>} value
 * @return {!proto.buf.registry.module.v1beta1.Graph} returns this
*/
proto.buf.registry.module.v1beta1.Graph.prototype.setEdgesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.Graph.Edge=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.Graph.Edge}
 */
proto.buf.registry.module.v1beta1.Graph.prototype.addEdges = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.buf.registry.module.v1beta1.Graph.Edge, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.Graph} returns this
 */
proto.buf.registry.module.v1beta1.Graph.prototype.clearEdgesList = function() {
  return this.setEdgesList([]);
};


goog.object.extend(exports, proto.buf.registry.module.v1beta1);
