// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/module/v1beta1/download_service.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_module_v1beta1_commit_pb = require('../../../../buf/registry/module/v1beta1/commit_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_commit_pb);
var buf_registry_module_v1beta1_digest_pb = require('../../../../buf/registry/module/v1beta1/digest_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_digest_pb);
var buf_registry_module_v1beta1_file_pb = require('../../../../buf/registry/module/v1beta1/file_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_file_pb);
var buf_registry_module_v1beta1_resource_pb = require('../../../../buf/registry/module/v1beta1/resource_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_resource_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.module.v1beta1.DownloadRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.DownloadRequest.Value', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.DownloadResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.DownloadResponse.Content', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.DownloadRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.DownloadRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.DownloadRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.DownloadRequest.displayName = 'proto.buf.registry.module.v1beta1.DownloadRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.DownloadRequest.Value.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.DownloadRequest.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.DownloadRequest.Value.displayName = 'proto.buf.registry.module.v1beta1.DownloadRequest.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.DownloadResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.DownloadResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.DownloadResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.DownloadResponse.displayName = 'proto.buf.registry.module.v1beta1.DownloadResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.DownloadResponse.Content.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.DownloadResponse.Content, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.DownloadResponse.Content.displayName = 'proto.buf.registry.module.v1beta1.DownloadResponse.Content';
}

/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.DownloadRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.DownloadRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.DownloadRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.DownloadRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.module.v1beta1.DownloadRequest.Value.toObject, includeInstance),
digestType: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.DownloadRequest;
  return proto.buf.registry.module.v1beta1.DownloadRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.DownloadRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.module.v1beta1.DownloadRequest.Value;
      reader.readMessage(value,proto.buf.registry.module.v1beta1.DownloadRequest.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    case 2:
      var value = /** @type {!proto.buf.registry.module.v1beta1.DigestType} */ (reader.readEnum());
      msg.setDigestType(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.DownloadRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.DownloadRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.DownloadRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.module.v1beta1.DownloadRequest.Value.serializeBinaryToWriter
    );
  }
  f = message.getDigestType();
  if (f !== 0.0) {
    writer.writeEnum(
      2,
      f
    );
  }
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.repeatedFields_ = [2,3];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.DownloadRequest.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
resourceRef: (f = msg.getResourceRef()) && buf_registry_module_v1beta1_resource_pb.ResourceRef.toObject(includeInstance, f),
fileTypesList: (f = jspb.Message.getRepeatedField(msg, 2)) == null ? undefined : f,
pathsList: (f = jspb.Message.getRepeatedField(msg, 3)) == null ? undefined : f,
pathsAllowNotExist: jspb.Message.getBooleanFieldWithDefault(msg, 4, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.DownloadRequest.Value;
  return proto.buf.registry.module.v1beta1.DownloadRequest.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_resource_pb.ResourceRef;
      reader.readMessage(value,buf_registry_module_v1beta1_resource_pb.ResourceRef.deserializeBinaryFromReader);
      msg.setResourceRef(value);
      break;
    case 2:
      var values = /** @type {!Array<!proto.buf.registry.module.v1beta1.FileType>} */ (reader.isDelimited() ? reader.readPackedEnum() : [reader.readEnum()]);
      for (var i = 0; i < values.length; i++) {
        msg.addFileTypes(values[i]);
      }
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.addPaths(value);
      break;
    case 4:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setPathsAllowNotExist(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.DownloadRequest.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getResourceRef();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_module_v1beta1_resource_pb.ResourceRef.serializeBinaryToWriter
    );
  }
  f = message.getFileTypesList();
  if (f.length > 0) {
    writer.writePackedEnum(
      2,
      f
    );
  }
  f = message.getPathsList();
  if (f.length > 0) {
    writer.writeRepeatedString(
      3,
      f
    );
  }
  f = message.getPathsAllowNotExist();
  if (f) {
    writer.writeBool(
      4,
      f
    );
  }
};


/**
 * optional ResourceRef resource_ref = 1;
 * @return {?proto.buf.registry.module.v1beta1.ResourceRef}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.getResourceRef = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.ResourceRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_resource_pb.ResourceRef, 1));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.ResourceRef|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
*/
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.setResourceRef = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.clearResourceRef = function() {
  return this.setResourceRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.hasResourceRef = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * repeated FileType file_types = 2;
 * @return {!Array<!proto.buf.registry.module.v1beta1.FileType>}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.getFileTypesList = function() {
  return /** @type {!Array<!proto.buf.registry.module.v1beta1.FileType>} */ (jspb.Message.getRepeatedField(this, 2));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.FileType>} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.setFileTypesList = function(value) {
  return jspb.Message.setField(this, 2, value || []);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.FileType} value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.addFileTypes = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 2, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.clearFileTypesList = function() {
  return this.setFileTypesList([]);
};


/**
 * repeated string paths = 3;
 * @return {!Array<string>}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.getPathsList = function() {
  return /** @type {!Array<string>} */ (jspb.Message.getRepeatedField(this, 3));
};


/**
 * @param {!Array<string>} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.setPathsList = function(value) {
  return jspb.Message.setField(this, 3, value || []);
};


/**
 * @param {string} value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.addPaths = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 3, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.clearPathsList = function() {
  return this.setPathsList([]);
};


/**
 * optional bool paths_allow_not_exist = 4;
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.getPathsAllowNotExist = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 4, false));
};


/**
 * @param {boolean} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.Value.prototype.setPathsAllowNotExist = function(value) {
  return jspb.Message.setProto3BooleanField(this, 4, value);
};


/**
 * repeated Value values = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.DownloadRequest.Value>}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.DownloadRequest.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.module.v1beta1.DownloadRequest.Value, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.DownloadRequest.Value>} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest} returns this
*/
proto.buf.registry.module.v1beta1.DownloadRequest.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.DownloadRequest.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest.Value}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.DownloadRequest.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};


/**
 * optional DigestType digest_type = 2;
 * @return {!proto.buf.registry.module.v1beta1.DigestType}
 */
proto.buf.registry.module.v1beta1.DownloadRequest.prototype.getDigestType = function() {
  return /** @type {!proto.buf.registry.module.v1beta1.DigestType} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {!proto.buf.registry.module.v1beta1.DigestType} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadRequest} returns this
 */
proto.buf.registry.module.v1beta1.DownloadRequest.prototype.setDigestType = function(value) {
  return jspb.Message.setProto3EnumField(this, 2, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.DownloadResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.DownloadResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.DownloadResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.DownloadResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
contentsList: jspb.Message.toObjectList(msg.getContentsList(),
    proto.buf.registry.module.v1beta1.DownloadResponse.Content.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.DownloadResponse;
  return proto.buf.registry.module.v1beta1.DownloadResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.DownloadResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.module.v1beta1.DownloadResponse.Content;
      reader.readMessage(value,proto.buf.registry.module.v1beta1.DownloadResponse.Content.deserializeBinaryFromReader);
      msg.addContents(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.DownloadResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.DownloadResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.DownloadResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getContentsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.module.v1beta1.DownloadResponse.Content.serializeBinaryToWriter
    );
  }
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.DownloadResponse.Content.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.toObject = function(includeInstance, msg) {
  var f, obj = {
commit: (f = msg.getCommit()) && buf_registry_module_v1beta1_commit_pb.Commit.toObject(includeInstance, f),
filesList: jspb.Message.toObjectList(msg.getFilesList(),
    buf_registry_module_v1beta1_file_pb.File.toObject, includeInstance),
v1BufYamlFile: (f = msg.getV1BufYamlFile()) && buf_registry_module_v1beta1_file_pb.File.toObject(includeInstance, f),
v1BufLockFile: (f = msg.getV1BufLockFile()) && buf_registry_module_v1beta1_file_pb.File.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.DownloadResponse.Content;
  return proto.buf.registry.module.v1beta1.DownloadResponse.Content.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_commit_pb.Commit;
      reader.readMessage(value,buf_registry_module_v1beta1_commit_pb.Commit.deserializeBinaryFromReader);
      msg.setCommit(value);
      break;
    case 2:
      var value = new buf_registry_module_v1beta1_file_pb.File;
      reader.readMessage(value,buf_registry_module_v1beta1_file_pb.File.deserializeBinaryFromReader);
      msg.addFiles(value);
      break;
    case 3:
      var value = new buf_registry_module_v1beta1_file_pb.File;
      reader.readMessage(value,buf_registry_module_v1beta1_file_pb.File.deserializeBinaryFromReader);
      msg.setV1BufYamlFile(value);
      break;
    case 4:
      var value = new buf_registry_module_v1beta1_file_pb.File;
      reader.readMessage(value,buf_registry_module_v1beta1_file_pb.File.deserializeBinaryFromReader);
      msg.setV1BufLockFile(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.DownloadResponse.Content.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCommit();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_module_v1beta1_commit_pb.Commit.serializeBinaryToWriter
    );
  }
  f = message.getFilesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      buf_registry_module_v1beta1_file_pb.File.serializeBinaryToWriter
    );
  }
  f = message.getV1BufYamlFile();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      buf_registry_module_v1beta1_file_pb.File.serializeBinaryToWriter
    );
  }
  f = message.getV1BufLockFile();
  if (f != null) {
    writer.writeMessage(
      4,
      f,
      buf_registry_module_v1beta1_file_pb.File.serializeBinaryToWriter
    );
  }
};


/**
 * optional Commit commit = 1;
 * @return {?proto.buf.registry.module.v1beta1.Commit}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.getCommit = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.Commit} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_commit_pb.Commit, 1));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.Commit|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} returns this
*/
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.setCommit = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} returns this
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.clearCommit = function() {
  return this.setCommit(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.hasCommit = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * repeated File files = 2;
 * @return {!Array<!proto.buf.registry.module.v1beta1.File>}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.getFilesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.File>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_file_pb.File, 2));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.File>} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} returns this
*/
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.setFilesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.File=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.File}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.addFiles = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.buf.registry.module.v1beta1.File, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} returns this
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.clearFilesList = function() {
  return this.setFilesList([]);
};


/**
 * optional File v1_buf_yaml_file = 3;
 * @return {?proto.buf.registry.module.v1beta1.File}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.getV1BufYamlFile = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.File} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_file_pb.File, 3));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.File|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} returns this
*/
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.setV1BufYamlFile = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} returns this
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.clearV1BufYamlFile = function() {
  return this.setV1BufYamlFile(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.hasV1BufYamlFile = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional File v1_buf_lock_file = 4;
 * @return {?proto.buf.registry.module.v1beta1.File}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.getV1BufLockFile = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.File} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_file_pb.File, 4));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.File|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} returns this
*/
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.setV1BufLockFile = function(value) {
  return jspb.Message.setWrapperField(this, 4, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content} returns this
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.clearV1BufLockFile = function() {
  return this.setV1BufLockFile(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.Content.prototype.hasV1BufLockFile = function() {
  return jspb.Message.getField(this, 4) != null;
};


/**
 * repeated Content contents = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.DownloadResponse.Content>}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.prototype.getContentsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.DownloadResponse.Content>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.module.v1beta1.DownloadResponse.Content, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.DownloadResponse.Content>} value
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse} returns this
*/
proto.buf.registry.module.v1beta1.DownloadResponse.prototype.setContentsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.DownloadResponse.Content=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse.Content}
 */
proto.buf.registry.module.v1beta1.DownloadResponse.prototype.addContents = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.DownloadResponse.Content, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.DownloadResponse} returns this
 */
proto.buf.registry.module.v1beta1.DownloadResponse.prototype.clearContentsList = function() {
  return this.setContentsList([]);
};


goog.object.extend(exports, proto.buf.registry.module.v1beta1);
