// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/module/v1beta1/commit_service.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_module_v1beta1_commit_pb = require('../../../../buf/registry/module/v1beta1/commit_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_commit_pb);
var buf_registry_module_v1beta1_digest_pb = require('../../../../buf/registry/module/v1beta1/digest_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_digest_pb);
var buf_registry_module_v1beta1_resource_pb = require('../../../../buf/registry/module/v1beta1/resource_pb.js');
goog.object.extend(proto, buf_registry_module_v1beta1_resource_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.module.v1beta1.GetCommitsRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.GetCommitsResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListCommitsRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListCommitsRequest.Order', null, global);
goog.exportSymbol('proto.buf.registry.module.v1beta1.ListCommitsResponse', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.GetCommitsRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.GetCommitsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.GetCommitsRequest.displayName = 'proto.buf.registry.module.v1beta1.GetCommitsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.GetCommitsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.GetCommitsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.GetCommitsResponse.displayName = 'proto.buf.registry.module.v1beta1.GetCommitsResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ListCommitsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ListCommitsRequest.displayName = 'proto.buf.registry.module.v1beta1.ListCommitsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1beta1.ListCommitsResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1beta1.ListCommitsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1beta1.ListCommitsResponse.displayName = 'proto.buf.registry.module.v1beta1.ListCommitsResponse';
}

/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.GetCommitsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.GetCommitsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
resourceRefsList: jspb.Message.toObjectList(msg.getResourceRefsList(),
    buf_registry_module_v1beta1_resource_pb.ResourceRef.toObject, includeInstance),
digestType: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsRequest}
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.GetCommitsRequest;
  return proto.buf.registry.module.v1beta1.GetCommitsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.GetCommitsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsRequest}
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_resource_pb.ResourceRef;
      reader.readMessage(value,buf_registry_module_v1beta1_resource_pb.ResourceRef.deserializeBinaryFromReader);
      msg.addResourceRefs(value);
      break;
    case 2:
      var value = /** @type {!proto.buf.registry.module.v1beta1.DigestType} */ (reader.readEnum());
      msg.setDigestType(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.GetCommitsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.GetCommitsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getResourceRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1beta1_resource_pb.ResourceRef.serializeBinaryToWriter
    );
  }
  f = message.getDigestType();
  if (f !== 0.0) {
    writer.writeEnum(
      2,
      f
    );
  }
};


/**
 * repeated ResourceRef resource_refs = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.ResourceRef>}
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.prototype.getResourceRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.ResourceRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_resource_pb.ResourceRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.ResourceRef>} value
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsRequest} returns this
*/
proto.buf.registry.module.v1beta1.GetCommitsRequest.prototype.setResourceRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.ResourceRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.ResourceRef}
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.prototype.addResourceRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.ResourceRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsRequest} returns this
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.prototype.clearResourceRefsList = function() {
  return this.setResourceRefsList([]);
};


/**
 * optional DigestType digest_type = 2;
 * @return {!proto.buf.registry.module.v1beta1.DigestType}
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.prototype.getDigestType = function() {
  return /** @type {!proto.buf.registry.module.v1beta1.DigestType} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {!proto.buf.registry.module.v1beta1.DigestType} value
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsRequest} returns this
 */
proto.buf.registry.module.v1beta1.GetCommitsRequest.prototype.setDigestType = function(value) {
  return jspb.Message.setProto3EnumField(this, 2, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.GetCommitsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.GetCommitsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
commitsList: jspb.Message.toObjectList(msg.getCommitsList(),
    buf_registry_module_v1beta1_commit_pb.Commit.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsResponse}
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.GetCommitsResponse;
  return proto.buf.registry.module.v1beta1.GetCommitsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.GetCommitsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsResponse}
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1beta1_commit_pb.Commit;
      reader.readMessage(value,buf_registry_module_v1beta1_commit_pb.Commit.deserializeBinaryFromReader);
      msg.addCommits(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.GetCommitsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.GetCommitsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getCommitsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1beta1_commit_pb.Commit.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Commit commits = 1;
 * @return {!Array<!proto.buf.registry.module.v1beta1.Commit>}
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.prototype.getCommitsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.Commit>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_commit_pb.Commit, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.Commit>} value
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsResponse} returns this
*/
proto.buf.registry.module.v1beta1.GetCommitsResponse.prototype.setCommitsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.Commit=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.Commit}
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.prototype.addCommits = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1beta1.Commit, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.GetCommitsResponse} returns this
 */
proto.buf.registry.module.v1beta1.GetCommitsResponse.prototype.clearCommitsList = function() {
  return this.setCommitsList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ListCommitsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ListCommitsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
pageSize: jspb.Message.getFieldWithDefault(msg, 1, 0),
pageToken: jspb.Message.getFieldWithDefault(msg, 2, ""),
resourceRef: (f = msg.getResourceRef()) && buf_registry_module_v1beta1_resource_pb.ResourceRef.toObject(includeInstance, f),
order: jspb.Message.getFieldWithDefault(msg, 4, 0),
digestType: jspb.Message.getFieldWithDefault(msg, 5, 0),
idQuery: jspb.Message.getFieldWithDefault(msg, 6, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ListCommitsRequest;
  return proto.buf.registry.module.v1beta1.ListCommitsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ListCommitsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setPageSize(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setPageToken(value);
      break;
    case 3:
      var value = new buf_registry_module_v1beta1_resource_pb.ResourceRef;
      reader.readMessage(value,buf_registry_module_v1beta1_resource_pb.ResourceRef.deserializeBinaryFromReader);
      msg.setResourceRef(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.module.v1beta1.ListCommitsRequest.Order} */ (reader.readEnum());
      msg.setOrder(value);
      break;
    case 5:
      var value = /** @type {!proto.buf.registry.module.v1beta1.DigestType} */ (reader.readEnum());
      msg.setDigestType(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setIdQuery(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ListCommitsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ListCommitsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPageSize();
  if (f !== 0) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = message.getPageToken();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getResourceRef();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      buf_registry_module_v1beta1_resource_pb.ResourceRef.serializeBinaryToWriter
    );
  }
  f = message.getOrder();
  if (f !== 0.0) {
    writer.writeEnum(
      4,
      f
    );
  }
  f = message.getDigestType();
  if (f !== 0.0) {
    writer.writeEnum(
      5,
      f
    );
  }
  f = message.getIdQuery();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.Order = {
  ORDER_UNSPECIFIED: 0,
  ORDER_CREATE_TIME_DESC: 1,
  ORDER_CREATE_TIME_ASC: 2
};

/**
 * optional uint32 page_size = 1;
 * @return {number}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.getPageSize = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.setPageSize = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string page_token = 2;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.getPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.setPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional ResourceRef resource_ref = 3;
 * @return {?proto.buf.registry.module.v1beta1.ResourceRef}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.getResourceRef = function() {
  return /** @type{?proto.buf.registry.module.v1beta1.ResourceRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1beta1_resource_pb.ResourceRef, 3));
};


/**
 * @param {?proto.buf.registry.module.v1beta1.ResourceRef|undefined} value
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest} returns this
*/
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.setResourceRef = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.clearResourceRef = function() {
  return this.setResourceRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.hasResourceRef = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional Order order = 4;
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest.Order}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.getOrder = function() {
  return /** @type {!proto.buf.registry.module.v1beta1.ListCommitsRequest.Order} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.module.v1beta1.ListCommitsRequest.Order} value
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.setOrder = function(value) {
  return jspb.Message.setProto3EnumField(this, 4, value);
};


/**
 * optional DigestType digest_type = 5;
 * @return {!proto.buf.registry.module.v1beta1.DigestType}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.getDigestType = function() {
  return /** @type {!proto.buf.registry.module.v1beta1.DigestType} */ (jspb.Message.getFieldWithDefault(this, 5, 0));
};


/**
 * @param {!proto.buf.registry.module.v1beta1.DigestType} value
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.setDigestType = function(value) {
  return jspb.Message.setProto3EnumField(this, 5, value);
};


/**
 * optional string id_query = 6;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.getIdQuery = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsRequest} returns this
 */
proto.buf.registry.module.v1beta1.ListCommitsRequest.prototype.setIdQuery = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1beta1.ListCommitsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1beta1.ListCommitsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
nextPageToken: jspb.Message.getFieldWithDefault(msg, 1, ""),
commitsList: jspb.Message.toObjectList(msg.getCommitsList(),
    buf_registry_module_v1beta1_commit_pb.Commit.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsResponse}
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1beta1.ListCommitsResponse;
  return proto.buf.registry.module.v1beta1.ListCommitsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1beta1.ListCommitsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsResponse}
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setNextPageToken(value);
      break;
    case 2:
      var value = new buf_registry_module_v1beta1_commit_pb.Commit;
      reader.readMessage(value,buf_registry_module_v1beta1_commit_pb.Commit.deserializeBinaryFromReader);
      msg.addCommits(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1beta1.ListCommitsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1beta1.ListCommitsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getNextPageToken();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getCommitsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      buf_registry_module_v1beta1_commit_pb.Commit.serializeBinaryToWriter
    );
  }
};


/**
 * optional string next_page_token = 1;
 * @return {string}
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.prototype.getNextPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsResponse} returns this
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.prototype.setNextPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * repeated Commit commits = 2;
 * @return {!Array<!proto.buf.registry.module.v1beta1.Commit>}
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.prototype.getCommitsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1beta1.Commit>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1beta1_commit_pb.Commit, 2));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1beta1.Commit>} value
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsResponse} returns this
*/
proto.buf.registry.module.v1beta1.ListCommitsResponse.prototype.setCommitsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.buf.registry.module.v1beta1.Commit=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1beta1.Commit}
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.prototype.addCommits = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.buf.registry.module.v1beta1.Commit, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1beta1.ListCommitsResponse} returns this
 */
proto.buf.registry.module.v1beta1.ListCommitsResponse.prototype.clearCommitsList = function() {
  return this.setCommitsList([]);
};


goog.object.extend(exports, proto.buf.registry.module.v1beta1);
