// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// source: buf/registry/module/v1/module_service.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {missingRequire} reports error on implicit type usages.
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!
/* eslint-disable */
// @ts-nocheck

var jspb = require('google-protobuf');
var goog = jspb;
var global =
    (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof window !== 'undefined' && window) ||
    (typeof global !== 'undefined' && global) ||
    (typeof self !== 'undefined' && self) ||
    (function () { return this; }).call(null) ||
    Function('return this')();

var buf_registry_module_v1_module_pb = require('../../../../buf/registry/module/v1/module_pb.js');
goog.object.extend(proto, buf_registry_module_v1_module_pb);
var buf_registry_owner_v1_owner_pb = require('../../../../buf/registry/owner/v1/owner_pb.js');
goog.object.extend(proto, buf_registry_owner_v1_owner_pb);
var buf_validate_validate_pb = require('../../../../buf/validate/validate_pb.js');
goog.object.extend(proto, buf_validate_validate_pb);
goog.exportSymbol('proto.buf.registry.module.v1.CreateModulesRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.CreateModulesRequest.Value', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.CreateModulesResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.DeleteModulesRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.DeleteModulesResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.GetModulesRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.GetModulesResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.ListModulesRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.ListModulesRequest.Order', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.ListModulesResponse', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.UpdateModulesRequest', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.UpdateModulesRequest.Value', null, global);
goog.exportSymbol('proto.buf.registry.module.v1.UpdateModulesResponse', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.GetModulesRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.GetModulesRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.GetModulesRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.GetModulesRequest.displayName = 'proto.buf.registry.module.v1.GetModulesRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.GetModulesResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.GetModulesResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.GetModulesResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.GetModulesResponse.displayName = 'proto.buf.registry.module.v1.GetModulesResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.ListModulesRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.ListModulesRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.ListModulesRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.ListModulesRequest.displayName = 'proto.buf.registry.module.v1.ListModulesRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.ListModulesResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.ListModulesResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.ListModulesResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.ListModulesResponse.displayName = 'proto.buf.registry.module.v1.ListModulesResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.CreateModulesRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.CreateModulesRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.CreateModulesRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.CreateModulesRequest.displayName = 'proto.buf.registry.module.v1.CreateModulesRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1.CreateModulesRequest.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.CreateModulesRequest.Value.displayName = 'proto.buf.registry.module.v1.CreateModulesRequest.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.CreateModulesResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.CreateModulesResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.CreateModulesResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.CreateModulesResponse.displayName = 'proto.buf.registry.module.v1.CreateModulesResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.UpdateModulesRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.UpdateModulesRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.UpdateModulesRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.UpdateModulesRequest.displayName = 'proto.buf.registry.module.v1.UpdateModulesRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1.UpdateModulesRequest.Value, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.UpdateModulesRequest.Value.displayName = 'proto.buf.registry.module.v1.UpdateModulesRequest.Value';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.UpdateModulesResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.UpdateModulesResponse.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.UpdateModulesResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.UpdateModulesResponse.displayName = 'proto.buf.registry.module.v1.UpdateModulesResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.DeleteModulesRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.buf.registry.module.v1.DeleteModulesRequest.repeatedFields_, null);
};
goog.inherits(proto.buf.registry.module.v1.DeleteModulesRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.DeleteModulesRequest.displayName = 'proto.buf.registry.module.v1.DeleteModulesRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.buf.registry.module.v1.DeleteModulesResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.buf.registry.module.v1.DeleteModulesResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.buf.registry.module.v1.DeleteModulesResponse.displayName = 'proto.buf.registry.module.v1.DeleteModulesResponse';
}

/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.GetModulesRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.GetModulesRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.GetModulesRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.GetModulesRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.GetModulesRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
moduleRefsList: jspb.Message.toObjectList(msg.getModuleRefsList(),
    buf_registry_module_v1_module_pb.ModuleRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.GetModulesRequest}
 */
proto.buf.registry.module.v1.GetModulesRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.GetModulesRequest;
  return proto.buf.registry.module.v1.GetModulesRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.GetModulesRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.GetModulesRequest}
 */
proto.buf.registry.module.v1.GetModulesRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1_module_pb.ModuleRef;
      reader.readMessage(value,buf_registry_module_v1_module_pb.ModuleRef.deserializeBinaryFromReader);
      msg.addModuleRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.GetModulesRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.GetModulesRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.GetModulesRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.GetModulesRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getModuleRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1_module_pb.ModuleRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated ModuleRef module_refs = 1;
 * @return {!Array<!proto.buf.registry.module.v1.ModuleRef>}
 */
proto.buf.registry.module.v1.GetModulesRequest.prototype.getModuleRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.ModuleRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1_module_pb.ModuleRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.ModuleRef>} value
 * @return {!proto.buf.registry.module.v1.GetModulesRequest} returns this
*/
proto.buf.registry.module.v1.GetModulesRequest.prototype.setModuleRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1.ModuleRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.ModuleRef}
 */
proto.buf.registry.module.v1.GetModulesRequest.prototype.addModuleRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1.ModuleRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.GetModulesRequest} returns this
 */
proto.buf.registry.module.v1.GetModulesRequest.prototype.clearModuleRefsList = function() {
  return this.setModuleRefsList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.GetModulesResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.GetModulesResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.GetModulesResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.GetModulesResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.GetModulesResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
modulesList: jspb.Message.toObjectList(msg.getModulesList(),
    buf_registry_module_v1_module_pb.Module.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.GetModulesResponse}
 */
proto.buf.registry.module.v1.GetModulesResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.GetModulesResponse;
  return proto.buf.registry.module.v1.GetModulesResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.GetModulesResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.GetModulesResponse}
 */
proto.buf.registry.module.v1.GetModulesResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1_module_pb.Module;
      reader.readMessage(value,buf_registry_module_v1_module_pb.Module.deserializeBinaryFromReader);
      msg.addModules(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.GetModulesResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.GetModulesResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.GetModulesResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.GetModulesResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getModulesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1_module_pb.Module.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Module modules = 1;
 * @return {!Array<!proto.buf.registry.module.v1.Module>}
 */
proto.buf.registry.module.v1.GetModulesResponse.prototype.getModulesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.Module>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1_module_pb.Module, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.Module>} value
 * @return {!proto.buf.registry.module.v1.GetModulesResponse} returns this
*/
proto.buf.registry.module.v1.GetModulesResponse.prototype.setModulesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1.Module=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.Module}
 */
proto.buf.registry.module.v1.GetModulesResponse.prototype.addModules = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1.Module, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.GetModulesResponse} returns this
 */
proto.buf.registry.module.v1.GetModulesResponse.prototype.clearModulesList = function() {
  return this.setModulesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.ListModulesRequest.repeatedFields_ = [3];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.ListModulesRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.ListModulesRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.ListModulesRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
pageSize: jspb.Message.getFieldWithDefault(msg, 1, 0),
pageToken: jspb.Message.getFieldWithDefault(msg, 2, ""),
ownerRefsList: jspb.Message.toObjectList(msg.getOwnerRefsList(),
    buf_registry_owner_v1_owner_pb.OwnerRef.toObject, includeInstance),
order: jspb.Message.getFieldWithDefault(msg, 4, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.ListModulesRequest}
 */
proto.buf.registry.module.v1.ListModulesRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.ListModulesRequest;
  return proto.buf.registry.module.v1.ListModulesRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.ListModulesRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.ListModulesRequest}
 */
proto.buf.registry.module.v1.ListModulesRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setPageSize(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setPageToken(value);
      break;
    case 3:
      var value = new buf_registry_owner_v1_owner_pb.OwnerRef;
      reader.readMessage(value,buf_registry_owner_v1_owner_pb.OwnerRef.deserializeBinaryFromReader);
      msg.addOwnerRefs(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.module.v1.ListModulesRequest.Order} */ (reader.readEnum());
      msg.setOrder(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.ListModulesRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.ListModulesRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.ListModulesRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPageSize();
  if (f !== 0) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = message.getPageToken();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getOwnerRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      3,
      f,
      buf_registry_owner_v1_owner_pb.OwnerRef.serializeBinaryToWriter
    );
  }
  f = message.getOrder();
  if (f !== 0.0) {
    writer.writeEnum(
      4,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.buf.registry.module.v1.ListModulesRequest.Order = {
  ORDER_UNSPECIFIED: 0,
  ORDER_CREATE_TIME_DESC: 1,
  ORDER_CREATE_TIME_ASC: 2
};

/**
 * optional uint32 page_size = 1;
 * @return {number}
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.getPageSize = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.buf.registry.module.v1.ListModulesRequest} returns this
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.setPageSize = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional string page_token = 2;
 * @return {string}
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.getPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.ListModulesRequest} returns this
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.setPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * repeated buf.registry.owner.v1.OwnerRef owner_refs = 3;
 * @return {!Array<!proto.buf.registry.owner.v1.OwnerRef>}
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.getOwnerRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.owner.v1.OwnerRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_owner_v1_owner_pb.OwnerRef, 3));
};


/**
 * @param {!Array<!proto.buf.registry.owner.v1.OwnerRef>} value
 * @return {!proto.buf.registry.module.v1.ListModulesRequest} returns this
*/
proto.buf.registry.module.v1.ListModulesRequest.prototype.setOwnerRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 3, value);
};


/**
 * @param {!proto.buf.registry.owner.v1.OwnerRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.owner.v1.OwnerRef}
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.addOwnerRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 3, opt_value, proto.buf.registry.owner.v1.OwnerRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.ListModulesRequest} returns this
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.clearOwnerRefsList = function() {
  return this.setOwnerRefsList([]);
};


/**
 * optional Order order = 4;
 * @return {!proto.buf.registry.module.v1.ListModulesRequest.Order}
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.getOrder = function() {
  return /** @type {!proto.buf.registry.module.v1.ListModulesRequest.Order} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.module.v1.ListModulesRequest.Order} value
 * @return {!proto.buf.registry.module.v1.ListModulesRequest} returns this
 */
proto.buf.registry.module.v1.ListModulesRequest.prototype.setOrder = function(value) {
  return jspb.Message.setProto3EnumField(this, 4, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.ListModulesResponse.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.ListModulesResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.ListModulesResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.ListModulesResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.ListModulesResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
nextPageToken: jspb.Message.getFieldWithDefault(msg, 1, ""),
modulesList: jspb.Message.toObjectList(msg.getModulesList(),
    buf_registry_module_v1_module_pb.Module.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.ListModulesResponse}
 */
proto.buf.registry.module.v1.ListModulesResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.ListModulesResponse;
  return proto.buf.registry.module.v1.ListModulesResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.ListModulesResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.ListModulesResponse}
 */
proto.buf.registry.module.v1.ListModulesResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setNextPageToken(value);
      break;
    case 2:
      var value = new buf_registry_module_v1_module_pb.Module;
      reader.readMessage(value,buf_registry_module_v1_module_pb.Module.deserializeBinaryFromReader);
      msg.addModules(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.ListModulesResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.ListModulesResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.ListModulesResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.ListModulesResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getNextPageToken();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getModulesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      buf_registry_module_v1_module_pb.Module.serializeBinaryToWriter
    );
  }
};


/**
 * optional string next_page_token = 1;
 * @return {string}
 */
proto.buf.registry.module.v1.ListModulesResponse.prototype.getNextPageToken = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.ListModulesResponse} returns this
 */
proto.buf.registry.module.v1.ListModulesResponse.prototype.setNextPageToken = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * repeated Module modules = 2;
 * @return {!Array<!proto.buf.registry.module.v1.Module>}
 */
proto.buf.registry.module.v1.ListModulesResponse.prototype.getModulesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.Module>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1_module_pb.Module, 2));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.Module>} value
 * @return {!proto.buf.registry.module.v1.ListModulesResponse} returns this
*/
proto.buf.registry.module.v1.ListModulesResponse.prototype.setModulesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.buf.registry.module.v1.Module=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.Module}
 */
proto.buf.registry.module.v1.ListModulesResponse.prototype.addModules = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.buf.registry.module.v1.Module, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.ListModulesResponse} returns this
 */
proto.buf.registry.module.v1.ListModulesResponse.prototype.clearModulesList = function() {
  return this.setModulesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.CreateModulesRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.CreateModulesRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.CreateModulesRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.CreateModulesRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.CreateModulesRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.module.v1.CreateModulesRequest.Value.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest}
 */
proto.buf.registry.module.v1.CreateModulesRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.CreateModulesRequest;
  return proto.buf.registry.module.v1.CreateModulesRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.CreateModulesRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest}
 */
proto.buf.registry.module.v1.CreateModulesRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.module.v1.CreateModulesRequest.Value;
      reader.readMessage(value,proto.buf.registry.module.v1.CreateModulesRequest.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.CreateModulesRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.CreateModulesRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.CreateModulesRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.CreateModulesRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.module.v1.CreateModulesRequest.Value.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.CreateModulesRequest.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.CreateModulesRequest.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
ownerRef: (f = msg.getOwnerRef()) && buf_registry_owner_v1_owner_pb.OwnerRef.toObject(includeInstance, f),
name: jspb.Message.getFieldWithDefault(msg, 2, ""),
visibility: jspb.Message.getFieldWithDefault(msg, 3, 0),
description: jspb.Message.getFieldWithDefault(msg, 4, ""),
url: jspb.Message.getFieldWithDefault(msg, 5, ""),
defaultLabelName: jspb.Message.getFieldWithDefault(msg, 6, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.CreateModulesRequest.Value;
  return proto.buf.registry.module.v1.CreateModulesRequest.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.CreateModulesRequest.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_owner_v1_owner_pb.OwnerRef;
      reader.readMessage(value,buf_registry_owner_v1_owner_pb.OwnerRef.deserializeBinaryFromReader);
      msg.setOwnerRef(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setName(value);
      break;
    case 3:
      var value = /** @type {!proto.buf.registry.module.v1.ModuleVisibility} */ (reader.readEnum());
      msg.setVisibility(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setDescription(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setDefaultLabelName(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.CreateModulesRequest.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.CreateModulesRequest.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getOwnerRef();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_owner_v1_owner_pb.OwnerRef.serializeBinaryToWriter
    );
  }
  f = message.getName();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getVisibility();
  if (f !== 0.0) {
    writer.writeEnum(
      3,
      f
    );
  }
  f = message.getDescription();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getUrl();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getDefaultLabelName();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
};


/**
 * optional buf.registry.owner.v1.OwnerRef owner_ref = 1;
 * @return {?proto.buf.registry.owner.v1.OwnerRef}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.getOwnerRef = function() {
  return /** @type{?proto.buf.registry.owner.v1.OwnerRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_owner_v1_owner_pb.OwnerRef, 1));
};


/**
 * @param {?proto.buf.registry.owner.v1.OwnerRef|undefined} value
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value} returns this
*/
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.setOwnerRef = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.clearOwnerRef = function() {
  return this.setOwnerRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.hasOwnerRef = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional string name = 2;
 * @return {string}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.getName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.setName = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional ModuleVisibility visibility = 3;
 * @return {!proto.buf.registry.module.v1.ModuleVisibility}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.getVisibility = function() {
  return /** @type {!proto.buf.registry.module.v1.ModuleVisibility} */ (jspb.Message.getFieldWithDefault(this, 3, 0));
};


/**
 * @param {!proto.buf.registry.module.v1.ModuleVisibility} value
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.setVisibility = function(value) {
  return jspb.Message.setProto3EnumField(this, 3, value);
};


/**
 * optional string description = 4;
 * @return {string}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.getDescription = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.setDescription = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional string url = 5;
 * @return {string}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.setUrl = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string default_label_name = 6;
 * @return {string}
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.getDefaultLabelName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.CreateModulesRequest.Value.prototype.setDefaultLabelName = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * repeated Value values = 1;
 * @return {!Array<!proto.buf.registry.module.v1.CreateModulesRequest.Value>}
 */
proto.buf.registry.module.v1.CreateModulesRequest.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.CreateModulesRequest.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.module.v1.CreateModulesRequest.Value, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.CreateModulesRequest.Value>} value
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest} returns this
*/
proto.buf.registry.module.v1.CreateModulesRequest.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1.CreateModulesRequest.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest.Value}
 */
proto.buf.registry.module.v1.CreateModulesRequest.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1.CreateModulesRequest.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.CreateModulesRequest} returns this
 */
proto.buf.registry.module.v1.CreateModulesRequest.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.CreateModulesResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.CreateModulesResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.CreateModulesResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.CreateModulesResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.CreateModulesResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
modulesList: jspb.Message.toObjectList(msg.getModulesList(),
    buf_registry_module_v1_module_pb.Module.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.CreateModulesResponse}
 */
proto.buf.registry.module.v1.CreateModulesResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.CreateModulesResponse;
  return proto.buf.registry.module.v1.CreateModulesResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.CreateModulesResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.CreateModulesResponse}
 */
proto.buf.registry.module.v1.CreateModulesResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1_module_pb.Module;
      reader.readMessage(value,buf_registry_module_v1_module_pb.Module.deserializeBinaryFromReader);
      msg.addModules(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.CreateModulesResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.CreateModulesResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.CreateModulesResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.CreateModulesResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getModulesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1_module_pb.Module.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Module modules = 1;
 * @return {!Array<!proto.buf.registry.module.v1.Module>}
 */
proto.buf.registry.module.v1.CreateModulesResponse.prototype.getModulesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.Module>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1_module_pb.Module, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.Module>} value
 * @return {!proto.buf.registry.module.v1.CreateModulesResponse} returns this
*/
proto.buf.registry.module.v1.CreateModulesResponse.prototype.setModulesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1.Module=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.Module}
 */
proto.buf.registry.module.v1.CreateModulesResponse.prototype.addModules = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1.Module, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.CreateModulesResponse} returns this
 */
proto.buf.registry.module.v1.CreateModulesResponse.prototype.clearModulesList = function() {
  return this.setModulesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.UpdateModulesRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.UpdateModulesRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.UpdateModulesRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.UpdateModulesRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
valuesList: jspb.Message.toObjectList(msg.getValuesList(),
    proto.buf.registry.module.v1.UpdateModulesRequest.Value.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.UpdateModulesRequest;
  return proto.buf.registry.module.v1.UpdateModulesRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.UpdateModulesRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.buf.registry.module.v1.UpdateModulesRequest.Value;
      reader.readMessage(value,proto.buf.registry.module.v1.UpdateModulesRequest.Value.deserializeBinaryFromReader);
      msg.addValues(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.UpdateModulesRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.UpdateModulesRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.UpdateModulesRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValuesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.buf.registry.module.v1.UpdateModulesRequest.Value.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.UpdateModulesRequest.Value.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.toObject = function(includeInstance, msg) {
  var f, obj = {
moduleRef: (f = msg.getModuleRef()) && buf_registry_module_v1_module_pb.ModuleRef.toObject(includeInstance, f),
visibility: (f = jspb.Message.getField(msg, 3)) == null ? undefined : f,
state: (f = jspb.Message.getField(msg, 4)) == null ? undefined : f,
description: (f = jspb.Message.getField(msg, 5)) == null ? undefined : f,
url: (f = jspb.Message.getField(msg, 6)) == null ? undefined : f,
defaultLabelName: (f = jspb.Message.getField(msg, 7)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.UpdateModulesRequest.Value;
  return proto.buf.registry.module.v1.UpdateModulesRequest.Value.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1_module_pb.ModuleRef;
      reader.readMessage(value,buf_registry_module_v1_module_pb.ModuleRef.deserializeBinaryFromReader);
      msg.setModuleRef(value);
      break;
    case 3:
      var value = /** @type {!proto.buf.registry.module.v1.ModuleVisibility} */ (reader.readEnum());
      msg.setVisibility(value);
      break;
    case 4:
      var value = /** @type {!proto.buf.registry.module.v1.ModuleState} */ (reader.readEnum());
      msg.setState(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setDescription(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.setDefaultLabelName(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.UpdateModulesRequest.Value.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getModuleRef();
  if (f != null) {
    writer.writeMessage(
      1,
      f,
      buf_registry_module_v1_module_pb.ModuleRef.serializeBinaryToWriter
    );
  }
  f = /** @type {!proto.buf.registry.module.v1.ModuleVisibility} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeEnum(
      3,
      f
    );
  }
  f = /** @type {!proto.buf.registry.module.v1.ModuleState} */ (jspb.Message.getField(message, 4));
  if (f != null) {
    writer.writeEnum(
      4,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 5));
  if (f != null) {
    writer.writeString(
      5,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 6));
  if (f != null) {
    writer.writeString(
      6,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 7));
  if (f != null) {
    writer.writeString(
      7,
      f
    );
  }
};


/**
 * optional ModuleRef module_ref = 1;
 * @return {?proto.buf.registry.module.v1.ModuleRef}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.getModuleRef = function() {
  return /** @type{?proto.buf.registry.module.v1.ModuleRef} */ (
    jspb.Message.getWrapperField(this, buf_registry_module_v1_module_pb.ModuleRef, 1));
};


/**
 * @param {?proto.buf.registry.module.v1.ModuleRef|undefined} value
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
*/
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.setModuleRef = function(value) {
  return jspb.Message.setWrapperField(this, 1, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.clearModuleRef = function() {
  return this.setModuleRef(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.hasModuleRef = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional ModuleVisibility visibility = 3;
 * @return {!proto.buf.registry.module.v1.ModuleVisibility}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.getVisibility = function() {
  return /** @type {!proto.buf.registry.module.v1.ModuleVisibility} */ (jspb.Message.getFieldWithDefault(this, 3, 0));
};


/**
 * @param {!proto.buf.registry.module.v1.ModuleVisibility} value
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.setVisibility = function(value) {
  return jspb.Message.setField(this, 3, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.clearVisibility = function() {
  return jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.hasVisibility = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional ModuleState state = 4;
 * @return {!proto.buf.registry.module.v1.ModuleState}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.getState = function() {
  return /** @type {!proto.buf.registry.module.v1.ModuleState} */ (jspb.Message.getFieldWithDefault(this, 4, 0));
};


/**
 * @param {!proto.buf.registry.module.v1.ModuleState} value
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.setState = function(value) {
  return jspb.Message.setField(this, 4, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.clearState = function() {
  return jspb.Message.setField(this, 4, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.hasState = function() {
  return jspb.Message.getField(this, 4) != null;
};


/**
 * optional string description = 5;
 * @return {string}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.getDescription = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.setDescription = function(value) {
  return jspb.Message.setField(this, 5, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.clearDescription = function() {
  return jspb.Message.setField(this, 5, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.hasDescription = function() {
  return jspb.Message.getField(this, 5) != null;
};


/**
 * optional string url = 6;
 * @return {string}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.setUrl = function(value) {
  return jspb.Message.setField(this, 6, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.clearUrl = function() {
  return jspb.Message.setField(this, 6, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.hasUrl = function() {
  return jspb.Message.getField(this, 6) != null;
};


/**
 * optional string default_label_name = 7;
 * @return {string}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.getDefaultLabelName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * @param {string} value
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.setDefaultLabelName = function(value) {
  return jspb.Message.setField(this, 7, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.clearDefaultLabelName = function() {
  return jspb.Message.setField(this, 7, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.Value.prototype.hasDefaultLabelName = function() {
  return jspb.Message.getField(this, 7) != null;
};


/**
 * repeated Value values = 1;
 * @return {!Array<!proto.buf.registry.module.v1.UpdateModulesRequest.Value>}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.prototype.getValuesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.UpdateModulesRequest.Value>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.buf.registry.module.v1.UpdateModulesRequest.Value, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.UpdateModulesRequest.Value>} value
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest} returns this
*/
proto.buf.registry.module.v1.UpdateModulesRequest.prototype.setValuesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1.UpdateModulesRequest.Value=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest.Value}
 */
proto.buf.registry.module.v1.UpdateModulesRequest.prototype.addValues = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1.UpdateModulesRequest.Value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.UpdateModulesRequest} returns this
 */
proto.buf.registry.module.v1.UpdateModulesRequest.prototype.clearValuesList = function() {
  return this.setValuesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.UpdateModulesResponse.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.UpdateModulesResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.UpdateModulesResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.UpdateModulesResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.UpdateModulesResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
modulesList: jspb.Message.toObjectList(msg.getModulesList(),
    buf_registry_module_v1_module_pb.Module.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.UpdateModulesResponse}
 */
proto.buf.registry.module.v1.UpdateModulesResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.UpdateModulesResponse;
  return proto.buf.registry.module.v1.UpdateModulesResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.UpdateModulesResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.UpdateModulesResponse}
 */
proto.buf.registry.module.v1.UpdateModulesResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1_module_pb.Module;
      reader.readMessage(value,buf_registry_module_v1_module_pb.Module.deserializeBinaryFromReader);
      msg.addModules(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.UpdateModulesResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.UpdateModulesResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.UpdateModulesResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.UpdateModulesResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getModulesList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1_module_pb.Module.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Module modules = 1;
 * @return {!Array<!proto.buf.registry.module.v1.Module>}
 */
proto.buf.registry.module.v1.UpdateModulesResponse.prototype.getModulesList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.Module>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1_module_pb.Module, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.Module>} value
 * @return {!proto.buf.registry.module.v1.UpdateModulesResponse} returns this
*/
proto.buf.registry.module.v1.UpdateModulesResponse.prototype.setModulesList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1.Module=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.Module}
 */
proto.buf.registry.module.v1.UpdateModulesResponse.prototype.addModules = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1.Module, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.UpdateModulesResponse} returns this
 */
proto.buf.registry.module.v1.UpdateModulesResponse.prototype.clearModulesList = function() {
  return this.setModulesList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.buf.registry.module.v1.DeleteModulesRequest.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.DeleteModulesRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.DeleteModulesRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.DeleteModulesRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.DeleteModulesRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
moduleRefsList: jspb.Message.toObjectList(msg.getModuleRefsList(),
    buf_registry_module_v1_module_pb.ModuleRef.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.DeleteModulesRequest}
 */
proto.buf.registry.module.v1.DeleteModulesRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.DeleteModulesRequest;
  return proto.buf.registry.module.v1.DeleteModulesRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.DeleteModulesRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.DeleteModulesRequest}
 */
proto.buf.registry.module.v1.DeleteModulesRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new buf_registry_module_v1_module_pb.ModuleRef;
      reader.readMessage(value,buf_registry_module_v1_module_pb.ModuleRef.deserializeBinaryFromReader);
      msg.addModuleRefs(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.DeleteModulesRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.DeleteModulesRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.DeleteModulesRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.DeleteModulesRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getModuleRefsList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      buf_registry_module_v1_module_pb.ModuleRef.serializeBinaryToWriter
    );
  }
};


/**
 * repeated ModuleRef module_refs = 1;
 * @return {!Array<!proto.buf.registry.module.v1.ModuleRef>}
 */
proto.buf.registry.module.v1.DeleteModulesRequest.prototype.getModuleRefsList = function() {
  return /** @type{!Array<!proto.buf.registry.module.v1.ModuleRef>} */ (
    jspb.Message.getRepeatedWrapperField(this, buf_registry_module_v1_module_pb.ModuleRef, 1));
};


/**
 * @param {!Array<!proto.buf.registry.module.v1.ModuleRef>} value
 * @return {!proto.buf.registry.module.v1.DeleteModulesRequest} returns this
*/
proto.buf.registry.module.v1.DeleteModulesRequest.prototype.setModuleRefsList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.buf.registry.module.v1.ModuleRef=} opt_value
 * @param {number=} opt_index
 * @return {!proto.buf.registry.module.v1.ModuleRef}
 */
proto.buf.registry.module.v1.DeleteModulesRequest.prototype.addModuleRefs = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.buf.registry.module.v1.ModuleRef, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.buf.registry.module.v1.DeleteModulesRequest} returns this
 */
proto.buf.registry.module.v1.DeleteModulesRequest.prototype.clearModuleRefsList = function() {
  return this.setModuleRefsList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.buf.registry.module.v1.DeleteModulesResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.buf.registry.module.v1.DeleteModulesResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.buf.registry.module.v1.DeleteModulesResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.DeleteModulesResponse.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.buf.registry.module.v1.DeleteModulesResponse}
 */
proto.buf.registry.module.v1.DeleteModulesResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.buf.registry.module.v1.DeleteModulesResponse;
  return proto.buf.registry.module.v1.DeleteModulesResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.buf.registry.module.v1.DeleteModulesResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.buf.registry.module.v1.DeleteModulesResponse}
 */
proto.buf.registry.module.v1.DeleteModulesResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.buf.registry.module.v1.DeleteModulesResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.buf.registry.module.v1.DeleteModulesResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.buf.registry.module.v1.DeleteModulesResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.buf.registry.module.v1.DeleteModulesResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};


goog.object.extend(exports, proto.buf.registry.module.v1);
